/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;
import java.util.Vector;

public class NetworkBandwidthTest
extends EgSnmpTest {
    private String s_operable = "1";
    private String s_upoperable = "up";
    private double MbTob = 1048576.0;
    private String nwIfdevOid = ".1.3.6.1.2.1.2.2.1.1";
    private String nwIfdevnameOid = ".1.3.6.1.2.1.2.2.1.2";
    private String nwIfdevOperStatOid = ".1.3.6.1.2.1.2.2.1.8";
    private String nwIfdevSpeedOid = ".1.3.6.1.2.1.2.2.1.5";
    private String nwIfdevInoctOid = ".1.3.6.1.2.1.2.2.1.10";
    private String nwIfdevOutoctOid = ".1.3.6.1.2.1.2.2.1.16";
    private int inputRateIndex = 0;
    private int outputRateIndex = 1;
    private int pctBandwidthIndex = 2;
    private int reRun = 12;
    private int reDiscoveryCount = 12;
    private Vector v_idOfInterfaces = new Vector();
    private Hashtable h_name = new Hashtable();
    private Hashtable h_speed = new Hashtable();
    private Hashtable h_previnOcts = new Hashtable();
    private Hashtable h_prevoutOcts = new Hashtable();
    private Hashtable h_inOcts = new Hashtable();
    private Hashtable h_outOcts = new Hashtable();
    long l_inocts = 0L;
    long l_outocts = 0L;
    long l_speed = 0L;
    double d_pctbwidth = 0.0;
    Long L_inocts = new Long(0L);
    Long L_outocts = new Long(0L);
    Long L_speed = new Long(0L);
    String s_if_id = "";
    String s_if_name = "";
    String index = "";

    public NetworkBandwidthTest(String[] stringArray) {
        super(stringArray);
        int n;
        this.numOutputFields = 3;
        if (stringArray.length < 2 || !stringArray[0].equalsIgnoreCase("-host")) {
            System.err.println("Usage: NetworkBandwidthTest -host <targetHost> -snmpPort <snmpPort> -snmpCommunity <community>");
            System.exit(-1);
        }
        this.targetHost = new String(stringArray[1]);
        if (stringArray.length > 2) {
            for (n = 2; n < stringArray.length; ++n) {
                if (stringArray[n].equalsIgnoreCase("-snmpPort")) {
                    if (++n < stringArray.length) {
                        this.snmpPortNo = new String(stringArray[n]);
                        continue;
                    }
                    System.err.println("Usage:NetworkBandwidthTest -host <targetHost> -snmpPort <snmpPort> -snmpCommunity <community>");
                    return;
                }
                if (!stringArray[n].equalsIgnoreCase("-snmpCommunity")) continue;
                if (++n < stringArray.length) {
                    this.community = new String(stringArray[n]);
                    continue;
                }
                System.err.println("Usage:NetworkBandwidthTest -host <targetHost> -snmpPort <snmpPort> -snmpCommunity <community>");
                return;
            }
        }
        n = this.discNetworkInterfaces() ? 1 : 0;
    }

    public static void main(String[] stringArray) {
        NetworkBandwidthTest networkBandwidthTest = new NetworkBandwidthTest(stringArray);
        for (int i = 0; i < networkBandwidthTest.lhs.length; ++i) {
        }
        networkBandwidthTest.executeTest();
        networkBandwidthTest.executeTest();
        networkBandwidthTest.executeTest();
        networkBandwidthTest.executeTest();
        networkBandwidthTest.executeTest();
    }

    private boolean discNetworkInterfaces() {
        boolean bl = this.runSnmpCmdForOid(this.nwIfdevOperStatOid);
        if (bl && this.lhs.length > 0) {
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < this.lhs.length; ++i) {
                if (!this.rhs[i].equals(this.s_operable) && !this.rhs[i].equalsIgnoreCase(this.s_upoperable)) continue;
                vector.addElement(this.lhs[i]);
            }
            if (this.v_idOfInterfaces.size() == 0 || !vector.equals(this.v_idOfInterfaces)) {
                this.v_idOfInterfaces = (Vector)vector.clone();
                this.results = new Hashtable();
                this.initHashtables("Prev");
            }
            if (this.v_idOfInterfaces.size() > 0) {
                return this.getSpeed();
            }
            return false;
        }
        return false;
    }

    public boolean executeTest() {
        int n;
        this.initTest();
        if (this.reRun <= 0) {
            if (this.discNetworkInterfaces()) {
                this.reRun = this.reDiscoveryCount;
            } else {
                this.updateAllResultSets();
                this.reRun = 2;
                return true;
            }
        }
        --this.reRun;
        if (this.v_idOfInterfaces.size() < 1) {
            this.updateAllResultSets();
            this.reRun = 0;
            return true;
        }
        this.h_inOcts.clear();
        this.h_outOcts.clear();
        this.initHashtables("Curr");
        boolean bl = this.runSnmpCmdForOid(this.nwIfdevInoctOid);
        if (!bl || this.lhs.length <= 0) {
            this.initHashtables("Prev");
            this.updateAllResultSets();
            return true;
        }
        boolean bl2 = true;
        boolean bl3 = false;
        if (this.h_previnOcts.size() > 0) {
            for (n = 0; n < this.lhs.length; ++n) {
                if (!this.v_idOfInterfaces.contains(this.lhs[n])) continue;
                this.L_inocts = (Long)this.h_previnOcts.get(this.lhs[n]);
                if (this.L_inocts == null) {
                    bl2 = false;
                    break;
                }
                this.l_inocts = this.L_inocts;
                if (this.l_inocts == -1L) {
                    bl2 = false;
                    break;
                }
                this.l_inocts = new Long(this.rhs[n]) - this.l_inocts;
                if (this.l_inocts < 0L) {
                    bl2 = false;
                    break;
                }
                this.h_previnOcts.put(this.lhs[n], new Long(this.rhs[n]));
                this.h_inOcts.put(this.lhs[n], new Long(this.l_inocts));
            }
        } else {
            bl2 = false;
        }
        if (!bl2) {
            for (n = 0; n < this.lhs.length; ++n) {
                this.h_previnOcts.put(this.lhs[n], new Long(this.rhs[n]));
            }
            this.initHashtables("Curr");
            bl3 = true;
        }
        bl2 = true;
        bl = this.runSnmpCmdForOid(this.nwIfdevOutoctOid);
        if (!bl || this.lhs.length <= 0) {
            this.initHashtables("Prev");
            this.updateAllResultSets();
            return true;
        }
        if (this.h_prevoutOcts.size() > 0) {
            for (n = 0; n < this.lhs.length; ++n) {
                if (!this.v_idOfInterfaces.contains(this.lhs[n])) continue;
                this.L_outocts = (Long)this.h_prevoutOcts.get(this.lhs[n]);
                if (this.L_outocts == null) {
                    bl2 = false;
                    break;
                }
                this.l_outocts = this.L_outocts;
                if (this.l_outocts == -1L) {
                    bl2 = false;
                    break;
                }
                this.l_outocts = new Long(this.rhs[n]) - this.l_outocts;
                if (this.l_outocts < 0L) {
                    bl2 = false;
                    break;
                }
                this.h_prevoutOcts.put(this.lhs[n], new Long(this.rhs[n]));
                this.h_outOcts.put(this.lhs[n], new Long(this.l_outocts));
            }
        } else {
            bl2 = false;
        }
        if (!bl2 || bl3) {
            for (n = 0; n < this.lhs.length; ++n) {
                this.h_prevoutOcts.put(this.lhs[n], new Long(this.rhs[n]));
            }
            this.initHashtables("Curr");
            this.updateAllResultSets();
            return true;
        }
        this.index = this.siteName + siteAndInfoSeparator + infoFieldSeparator;
        for (n = 0; n < this.v_idOfInterfaces.size(); ++n) {
            this.s_if_id = (String)this.v_idOfInterfaces.elementAt(n);
            if (this.s_if_id == null) continue;
            this.L_speed = (Long)this.h_speed.get(this.s_if_id);
            if (this.L_speed == null || this.L_speed == 0L) continue;
            this.s_if_name = (String)this.h_name.get(this.s_if_id);
            if (this.s_if_name == null) continue;
            this.s_if_name = this.s_if_name.trim();
            this.L_inocts = (Long)this.h_inOcts.get(this.s_if_id);
            this.L_outocts = (Long)this.h_outOcts.get(this.s_if_id);
            if (this.s_if_id == null || this.L_inocts == null || this.L_outocts == null || this.L_speed == null) {
                System.out.println("ERROR in NETWORK BANDWIDTH TEST " + this.s_if_id + " " + this.L_inocts + " " + this.L_outocts + " " + this.L_speed);
                System.out.println("\tDebugging ...");
                for (int i = 0; i < this.v_idOfInterfaces.size(); ++i) {
                    String string = (String)this.v_idOfInterfaces.elementAt(i);
                    System.out.println("\tIf[" + i + "]=" + string);
                    System.out.println("\t\t" + (Long)this.h_inOcts.get(string));
                    System.out.println("\t\t" + (Long)this.h_outOcts.get(string));
                    System.out.println("\t\t" + (Long)this.h_speed.get(string));
                }
                continue;
            }
            double d = this.L_inocts.doubleValue();
            double d2 = this.L_outocts.doubleValue();
            double d3 = this.L_speed.doubleValue() / this.MbTob;
            if (d3 > 0.0 && d >= 0.0 && d2 >= 0.0 && this.timeSinceLastTest > 0.0) {
                d = d * 8.0 / this.timeSinceLastTest / this.MbTob;
                d2 = d2 * 8.0 / this.timeSinceLastTest / this.MbTob;
                this.d_pctbwidth = (d + d2) * 100.0 / d3;
                if (this.d_pctbwidth < 0.0) {
                    this.d_pctbwidth = 0.0;
                } else if (this.d_pctbwidth > 100.0) {
                    this.d_pctbwidth = 100.0;
                }
            } else {
                this.initHashtables("Prev");
                this.d_pctbwidth = -5.0;
                d2 = -5.0;
                d = -5.0;
            }
            this.addValueToResultSet(this.index + this.s_if_name, this.outputRateIndex, d2);
            this.addValueToResultSet(this.index + this.s_if_name, this.inputRateIndex, d);
            this.addValueToResultSet(this.index + this.s_if_name, this.pctBandwidthIndex, this.d_pctbwidth);
        }
        this.updateAllResultSets();
        return true;
    }

    public boolean getSpeed() {
        int n;
        this.h_speed.clear();
        if (this.runSnmpCmdForOid(this.nwIfdevSpeedOid)) {
            for (n = 0; n < this.lhs.length; ++n) {
                if (!this.v_idOfInterfaces.contains(this.lhs[n])) continue;
                this.h_speed.put(this.lhs[n], new Long(this.rhs[n]));
            }
        } else {
            return false;
        }
        this.h_name.clear();
        if (this.runSnmpCmdForOid(this.nwIfdevnameOid)) {
            for (n = 0; n < this.lhs.length; ++n) {
                if (!this.v_idOfInterfaces.contains(this.lhs[n])) continue;
                this.h_name.put(this.lhs[n], this.rhs[n]);
            }
        } else {
            return false;
        }
        return this.h_speed.size() == this.h_name.size() && this.h_speed.size() > 0;
    }

    public void initHashtables(String string) {
        if (string.equals("Prev")) {
            for (int i = 0; i < this.v_idOfInterfaces.size(); ++i) {
                this.h_previnOcts.put(this.v_idOfInterfaces.elementAt(i), new Long(-1L));
                this.h_prevoutOcts.put(this.v_idOfInterfaces.elementAt(i), new Long(-1L));
            }
        } else {
            for (int i = 0; i < this.v_idOfInterfaces.size(); ++i) {
                this.h_inOcts.put(this.v_idOfInterfaces.elementAt(i), new Long(-1L));
                this.h_outOcts.put(this.v_idOfInterfaces.elementAt(i), new Long(-1L));
            }
        }
    }
}

