/*
 * Decompiled with CFR 0.152.
 */
import com.eg.apm.NodeBlockedAt;
import com.eg.apm.NodeEventloop;
import com.eg.apm.NodeInfra;
import com.eg.apm.NodeInfraCluster;
import com.eg.apm.NodeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class NodeELTest
extends NodeBase {
    private NodeBlockedAt[] blockedAtData = null;
    public static final String[] propsOrder = new String[]{"event_loop_stack_collection", "event_stack_collection_threshold"};
    private static final int NOT_AVAILABLE = -5;

    public NodeELTest(String[] args) {
        super(args);
        this.needAgentlessDD = true;
        this.isNewDynamicInfoTest = true;
        try {
            logger.info("{} Initializing NodeELTest ...", (Object)this.logPrefix);
            this.setMeasureCount(this.measureCount);
            logger.info("{} NodeELTest initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception initException) {
            logger.error("{} Exception while initializing NodeELTest {} ", (Object)this.logPrefix, (Object)initException);
        }
    }

    public void computeMeasures(Hashtable params) {
        this.getJvmGuid();
        logger.debug("{} - cycle starting ", (Object)this.logPrefix);
        String siteId = "[" + this.reportingName + ":" + this.portNo + "]";
        this.checkForPropsChanges(propsOrder);
        try {
            HashMap<String, NodeInfra> workers;
            int numOfWorkers = 0;
            if (this.nodeRepository.isInfraIdExists(this.apmComponentGUID)) {
                numOfWorkers = this.nodeRepository.getInfraById(this.apmComponentGUID).getWorkerCount();
            }
            if (!this.nodeRepository.isInfraIdExists(this.apmComponentGUID)) {
                logger.debug("{} siteId: {} is not available please check repository ", (Object)this.logPrefix, (Object)siteId);
                return;
            }
            logger.debug("{} siteId: {} numOfWorkers available : {} ", new Object[]{this.logPrefix, siteId, numOfWorkers});
            NodeInfraCluster nodeInfraCluster = this.nodeRepository.getInfraById(this.apmComponentGUID);
            NodeInfra master = nodeInfraCluster.getMaster();
            NodeEventloop eventloop = null;
            if (master != null && master.isMaster()) {
                eventloop = master.getEventloop();
                if (eventloop != null) {
                    this.addMeasures("Master", eventloop, master.getProcessID(), nodeInfraCluster.getWorkerCount());
                    logger.debug("{} Master - addNewMeasure : {}", (Object)this.logPrefix, (Object)this.measures);
                }
            } else {
                logger.debug("{} Master - {} addNewMeasure No Data avaible : {} ", new Object[]{this.logPrefix, siteId, eventloop});
            }
            if ((workers = nodeInfraCluster.getWorkers()) != null && workers.size() > 0) {
                Set<Map.Entry<String, NodeInfra>> set = workers.entrySet();
                for (Map.Entry<String, NodeInfra> mEntry : set) {
                    String key = mEntry.getKey();
                    NodeInfra infraByPid = mEntry.getValue();
                    NodeEventloop eventloopObj = infraByPid.getEventloop();
                    if (eventloopObj == null) continue;
                    String discriptorName = infraByPid.getMode().equalsIgnoreCase("STANDALONE") ? key : "Worker_" + key;
                    this.addMeasures(discriptorName, eventloopObj, infraByPid.getProcessID(), -5);
                    infraByPid.setEventloop(null);
                }
            } else {
                logger.debug("{} Worker - {} No Data avaible in  Node Event loop : {} ", new Object[]{this.logPrefix, siteId, eventloop});
            }
        }
        catch (Exception e) {
            logger.debug("{} Exception occurred while collecting Node eventloop object: {}", (Object)this.logPrefix, (Object)e);
        }
    }

    private void addMeasures(String type, NodeEventloop eventloopObj, String processId, int workerCount) {
        try {
            ArrayList<Double> measures = new ArrayList<Double>();
            double eventLoopSum = eventloopObj.getSum();
            double eventLoopCount = eventloopObj.getNum();
            measures.add(Double.valueOf(eventloopObj.getMax()));
            measures.add(Double.valueOf(eventloopObj.getMin()));
            measures.add(Double.valueOf(eventloopObj.getSum()));
            measures.add(Double.valueOf(eventloopObj.getNum()));
            if (eventLoopSum > 0.0 && eventLoopCount > 0.0) {
                double avgTime = eventLoopSum / eventLoopCount;
                measures.add(NodeUtils.formatDecimal(avgTime));
            } else {
                measures.add(-5.0);
            }
            measures.add(Double.valueOf(eventloopObj.getLag()));
            measures.add(Double.valueOf(workerCount));
            measures.add(Double.valueOf(processId));
            if (this.numOutputFields > 8) {
                measures.add(Double.valueOf(eventloopObj.getIdleTime()));
                measures.add(Double.valueOf(eventloopObj.getActiveTime()));
                measures.add(Double.valueOf(eventloopObj.getUtilization()));
            }
            this.addNewMeasure(type, measures);
            logger.debug("{} Added measures for {} : {}", new Object[]{this.logPrefix, type, measures});
        }
        catch (Exception e) {
            logger.error("{} Exception occurred while adding measures for NodeJs Event Loop Test : {}", (Object)this.logPrefix, (Object)e);
        }
    }

    public HashMap getWorkers() {
        return null;
    }

    public void setWorkers(HashMap workers) {
    }

    public NodeBlockedAt[] getBlockedAtData() {
        return this.blockedAtData;
    }
}

