/*
 * Decompiled with CFR 0.152.
 */
import com.eg.apm.NodeInfra;
import com.eg.apm.NodeInfraCluster;
import java.util.ArrayList;
import java.util.Hashtable;

public class NodeErrorTest
extends NodeBase {
    public static final int ZERO = 0;
    public static final int NOT_AVAILABLE = -5;
    NodeInfraCluster nodeInfraCluster = null;

    public NodeErrorTest(String[] args) {
        super(args);
        this.needAgentlessDD = true;
        this.isNewDynamicInfoTest = true;
        try {
            logger.info("{} Initializing NodeErrorTest...", (Object)this.logPrefix);
            this.setMeasureCount(this.measureCount);
            logger.info("{} NodeErrorTest initialized successfully...", (Object)this.logPrefix);
        }
        catch (Exception initException) {
            logger.error("{}  Exception while initializing NodeErrorTest {}", (Object)this.logPrefix, (Object)initException);
        }
    }

    public void computeMeasures(Hashtable params) {
        this.getJvmGuid();
        logger.debug("{} - Test cycle starting ", (Object)this.logPrefix);
        String siteId = "[" + this.reportingName + ":" + this.portNo + "]";
        try {
            if (!this.nodeRepository.isInfraIdExists(this.apmComponentGUID)) {
                logger.debug("{} nodeJvmGUID: {} is not available in error repository ", (Object)this.logPrefix, (Object)this.apmComponentGUID);
                return;
            }
            this.nodeInfraCluster = this.nodeRepository.getInfraById(this.apmComponentGUID);
            if (this.nodeInfraCluster != null) {
                ArrayList<NodeInfra> errorList = this.nodeInfraCluster.getErrorList();
                ArrayList<Double> measures = new ArrayList<Double>();
                if (errorList != null) {
                    int wCount = this.nodeInfraCluster.getWorkerCount();
                    wCount = wCount == 0 ? -5 : wCount;
                    measures.add(Double.valueOf(errorList.size()));
                    measures.add(Double.valueOf(wCount));
                    this.addNewMeasure(measures);
                } else {
                    measures.add(0.0);
                    measures.add(0.0);
                    this.addNewMeasure(measures);
                }
            }
        }
        catch (Exception e) {
            logger.error("{} Exception occured while collecting Errors : {} ", (Object)this.logPrefix, (Object)e);
        }
    }

    public NodeInfraCluster getNodeErrorCluster() {
        return this.nodeInfraCluster;
    }
}

