/*
 * Decompiled with CFR 0.152.
 */
import com.eg.AgentLogger;
import com.eg.apm.APMComponent;
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.APMConfigUtils;
import com.eg.apm.APMLanguage;
import com.eg.apm.ComponentWatcherTracker;
import com.eg.apm.NodeAPMComponent;
import com.eg.apm.SnapShotTakerWatcher;
import com.eg.apm.Status;
import com.eg.apm.UserAgentUtil;
import com.eg.apm.util.UrlParamMaskHelper;
import com.eg.jtm.DataBaseUtils;
import com.eg.jtm.MethodInfo;
import com.eg.jtm.PropsManager;
import com.eg.jtm.UPDManager;
import com.eg.org.objectweb.asm.Type;
import java.io.Serializable;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.mail.URLName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeTransTestBase
extends NodeBTMBase {
    protected Hashtable sourceTable;
    protected static final String logPrefix = "NodeTransTestBase";
    protected static final Hashtable<String, Hashtable<String, String>> dbConnectionDetails = new Hashtable();
    protected Hashtable slowURLTable = null;
    protected Hashtable stalledURLTable = null;
    protected Hashtable errorURLTable = null;
    protected Hashtable allURLTable = null;
    protected Hashtable externalTable = null;
    protected Hashtable stackTraceTable = null;
    protected Hashtable recentThresholdTable = null;
    protected Hashtable previousThresholdTable = new Hashtable();
    protected HashMap previousAppNameTable = new HashMap();
    protected static final DecimalFormat formatter = new DecimalFormat("#.####");
    private boolean isFirstTime = true;
    private static final int MAX_HEADER_VALUE_LIMIT = 500;
    private HashMap sessionUserMapping = null;
    protected int status_code;

    public NodeTransTestBase(String[] stringArray) {
        super(stringArray);
        this.loggerDispStr = "[" + this.reportingName + ":" + this.portNo + "] [" + logPrefix + "]";
        this.needAgentlessDD = true;
        this.isNewDynamicInfoTest = true;
    }

    private void checkForPropsChanges(String[] stringArray, NodeAPMComponent nodeAPMComponent, String[] stringArray2) {
        PropsManager propsManager = nodeAPMComponent.getPropsManager();
        if (propsManager != null) {
            ArrayList arrayList = this.makePropsListForOffload(stringArray);
            propsManager.handlePropChangesFromTest(arrayList, this.entity);
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>(propsManager.getBTMprops());
            this.removeUnwantedPropsDetails(hashMap, stringArray2);
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            hashMap.put("Socket_Timeout", this.getValueForParam("timeout"));
            hashMap2.put("PropsTable", hashMap);
            hashMap2.put("Entity", this.entity);
            nodeAPMComponent.setPropsDetails(this.entity, hashMap2);
            AgentLogger.testLogger.debug("{} {} is registered with Props {} ", new Object[]{this.loggerDispStr, nodeAPMComponent.getID(), hashMap2});
        }
    }

    private void removeUnwantedPropsDetails(HashMap hashMap, String[] stringArray) {
        if (stringArray != null && stringArray.length >= 1) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (!hashMap.containsKey(string)) continue;
                hashMap.remove(string);
            }
        }
    }

    private void checkForAppNameChanges(NodeAPMComponent nodeAPMComponent) {
        HashMap hashMap = new HashMap();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        HashMap hashMap3 = this.getAppNameTierNameFromIni(new HashMap());
        HashMap hashMap4 = this.getModifiedProps(hashMap3, this.previousAppNameTable);
        hashMap.putAll(hashMap4);
        this.previousAppNameTable = hashMap3;
        AgentLogger.testLogger.debug("{}  currentAppNameTable: {} ,  previousAppNameTable: {} , modifiedAppTable: {} ", new Object[]{this.loggerDispStr, hashMap3, this.previousAppNameTable, hashMap4});
        if (hashMap != null && hashMap.size() > 0) {
            hashMap2.put("ModifiedPropsTable", hashMap);
            hashMap2.put("Entity", this.entity);
            nodeAPMComponent.setPropsDetails(this.entity, hashMap2);
            AgentLogger.testLogger.debug("{}  propsData: {} ", (Object)this.loggerDispStr, hashMap2);
        } else {
            AgentLogger.testLogger.trace("{}  No difference in props table:", (Object)this.loggerDispStr);
        }
    }

    public void computeMeasures(Hashtable hashtable, String[] stringArray, String[] stringArray2) {
        Object object;
        Object object2;
        Object object3;
        int n;
        this.getJvmGuid();
        NodeAPMComponent nodeAPMComponent = (NodeAPMComponent)APMComponentIDRepository.getRepository().getAPMComponent(this.apmComponentGUID);
        if (nodeAPMComponent == null) {
            AgentLogger.testLogger.warn("{} Component [{}] - {} is not available in the Repository", new Object[]{this.loggerDispStr, this.apmComponentGUID, this.NodeID});
            return;
        }
        nodeAPMComponent.printAPMRepositoryDetails(AgentLogger.testLogger);
        if (AgentLogger.testLogger.isDebugEnabled()) {
            AgentLogger.testLogger.debug("{}  Component {} - {} is available in the Repository", new Object[]{this.loggerDispStr, this.apmComponentGUID, this.NodeID});
            ConcurrentHashMap<String, APMComponent> concurrentHashMap = APMComponentIDRepository.getRepository().getComponentRepository();
            AgentLogger.testLogger.debug("{} ALL ID's : {} ", (Object)this.loggerDispStr, concurrentHashMap);
        }
        boolean bl = false;
        this.slowURLTable = new Hashtable();
        this.stalledURLTable = new Hashtable();
        this.errorURLTable = new Hashtable();
        this.allURLTable = new Hashtable();
        this.externalTable = new Hashtable();
        this.stackTraceTable = new Hashtable();
        this.sourceTable = new Hashtable();
        this.recentThresholdTable = new Hashtable();
        if (nodeAPMComponent.getStatus() == Status.NONE) {
            n = 1;
            while (!bl && n <= 10) {
                AgentLogger.testLogger.trace("{} Component {} - {} - Trying to get data from PUSH MODE ", new Object[]{this.loggerDispStr, this.apmComponentGUID, this.NodeID});
                bl = this.getOffLoadData(nodeAPMComponent);
                if (bl && nodeAPMComponent.getStatus() == Status.MANAGED_OFFLOAD) {
                    AgentLogger.testLogger.debug("{} Component {} - {} is registered as {} ", new Object[]{this.loggerDispStr, this.apmComponentGUID, this.NodeID, Status.MANAGED_OFFLOAD});
                    break;
                }
                if (nodeAPMComponent.getStatus() == Status.MANAGED_OFFLOAD) break;
                ++n;
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception exception) {}
            }
        }
        if (nodeAPMComponent.getStatus() == Status.MANAGED_OFFLOAD) {
            String string;
            int n2 = n = nodeAPMComponent.getHeartbeatStatus() == Status.HEART_BEATING ? 1 : 0;
            if (!bl && n != 0) {
                bl = this.getOffLoadData(nodeAPMComponent);
            }
            if (this.meAgentless) {
                string = nodeAPMComponent.getID();
                long l = nodeAPMComponent.getLastUpdatedTimeOfCommonFile();
                object3 = APMConfigUtils.getInstance().getCommonGUIDProps(string, l, APMLanguage.NODEJS);
                if (object3 != null && ((HashMap)object3).size() > 0) {
                    nodeAPMComponent.setCommonGUIDConfiguration((HashMap)object3);
                }
            }
            if (nodeAPMComponent.isPrepareBtmTestConfigs(this.entity)) {
                AgentLogger.testLogger.info("{} [eGTest_Config_Request] Preparing BTM configs for {} - {} - {}", new Object[]{this.loggerDispStr, this.NodeID, this.apmComponentGUID, this.entity});
                this.checkForPropsChanges(stringArray, nodeAPMComponent, stringArray2);
                nodeAPMComponent.setPrepareBtmTestConfigs(this.entity, false);
                if (this.meAgentless) {
                    string = nodeAPMComponent.getID();
                    HashMap hashMap = APMConfigUtils.getInstance().getCommonGUIDProps(string, -1L, APMLanguage.NODEJS);
                    if (hashMap != null && hashMap.size() > 0) {
                        nodeAPMComponent.setCommonGUIDConfiguration(hashMap);
                    }
                }
            }
        }
        if (nodeAPMComponent.getStatus() == Status.NONE) {
            AgentLogger.testLogger.warn("{} Unable to get data for the component via PUSH MODE {} - {} - Current mode is {} , Ensure that server is up and running on BTM PUSH MODE ", new Object[]{this.loggerDispStr, this.apmComponentGUID, this.NodeID, nodeAPMComponent.getStatus()});
        }
        Enumeration enumeration = this.results.keys();
        long l = this.getMaxStalledLimit4None();
        while (enumeration.hasMoreElements()) {
            int n3;
            Object object4;
            Threshold threshold;
            double[] dArray;
            object2 = (String)enumeration.nextElement();
            object3 = (EgResultSet)this.results.get(object2);
            object = ((EgResultSet)object3).thresholds;
            if (object == null || ((Threshold[])object).length <= 0 || (dArray = (threshold = object[1]).getUpperBound()) == null || dArray.length == 0) continue;
            Object object5 = object2;
            int n4 = ((String)object2).indexOf(siteAndInfoSeparator);
            if (n4 > 0) {
                object5 = ((String)object2).substring(n4 + 1);
            }
            if (((String)object5).startsWith("+")) {
                object5 = ((String)object5).substring(1);
            }
            if (dArray.length == 1) {
                object4 = "Unlimited";
                String string = l + "/" + (String)object4;
                this.recentThresholdTable.put(object5, string);
                continue;
            }
            if (dArray.length < 2) continue;
            object4 = new boolean[dArray.length];
            int n5 = 0;
            for (int i = 0; i < dArray.length; ++i) {
                if (!(dArray[i] >= 0.0)) continue;
                object4[i] = true;
                ++n5;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (n5 == 1) {
                stringBuilder.append("Unlimited").append("#").append(l).append("/");
                for (n3 = 0; n3 < ((Object)object4).length; ++n3) {
                    if (object4[n3] == false) continue;
                    stringBuilder.append(dArray[n3]);
                    break;
                }
            } else if (n5 == 2) {
                n3 = 0;
                for (int i = 0; i < ((Object)object4).length; ++i) {
                    if (object4[i] == false) continue;
                    if (n3 == 0) {
                        stringBuilder.append(dArray[i]).append("/");
                        n3 = 1;
                        continue;
                    }
                    stringBuilder.append(dArray[i]);
                    break;
                }
            } else if (n5 == 3) {
                stringBuilder.append(dArray[0]).append("/").append(dArray[2]);
            }
            if (stringBuilder.length() <= 0) continue;
            this.recentThresholdTable.put(object5, stringBuilder.toString());
        }
        object2 = this.getModifiedThresholdPatterns(this.recentThresholdTable, this.previousThresholdTable);
        AgentLogger.testLogger.debug("{} modifiedThreshPatterns: {}", (Object)this.loggerDispStr, object2);
        AgentLogger.testLogger.debug("{} Component {} - {} is available in the Respository & it's mode {} ", new Object[]{this.loggerDispStr, this.apmComponentGUID, this.NodeID, nodeAPMComponent.getStatus()});
        if (nodeAPMComponent.getStatus() == Status.MANAGED_OFFLOAD) {
            boolean bl2;
            boolean bl3 = bl2 = nodeAPMComponent.getHeartbeatStatus() == Status.HEART_BEATING;
            if (!bl && bl2) {
                bl = this.getOffLoadData(nodeAPMComponent);
            }
            if ((object = this.updateThresholds((Hashtable)object2, this.entity)) != null) {
                nodeAPMComponent.setThresholdDetails(this.entity, (HashMap)object);
            }
            if (this.isFirstTime) {
                this.checkForPropsChanges(stringArray, nodeAPMComponent, stringArray2);
                this.isFirstTime = false;
            }
            if (nodeAPMComponent.isPrepareBtmTestConfigs(this.entity)) {
                AgentLogger.testLogger.info("{} [eGTest_Config_Request] Preparing BTM configs for {} - {} - {}", new Object[]{this.loggerDispStr, this.NodeID, this.apmComponentGUID, this.entity});
                this.checkForPropsChanges(stringArray, nodeAPMComponent, stringArray2);
                nodeAPMComponent.setPrepareBtmTestConfigs(this.entity, false);
            }
            if (nodeAPMComponent.isPrepareThresholdConfigs(this.entity)) {
                AgentLogger.testLogger.info("{} [eGTest_Config_Request] Preparing threshold configs for {} - {} - {}", new Object[]{this.loggerDispStr, this.NodeID, this.apmComponentGUID, this.entity});
                object = this.updateThresholds(this.recentThresholdTable, this.entity);
                if (object != null) {
                    nodeAPMComponent.setThresholdDetails(this.entity, (HashMap)object);
                }
                nodeAPMComponent.setPrepareThresholdConfigs(this.entity, false);
            }
        }
        if (nodeAPMComponent.getStatus() == Status.NONE) {
            AgentLogger.testLogger.warn("{} Unable to find the running mode of the Component {} - {} - Current mode is {} \n \t \t \t\t \t \t\t [PULL MODE] --> eGAgent communicate with BTM enabled application server and collect metrics i.e) /<<eg_btm_jar_location>>/config.props having PUSH_TO_AGENT_MODE=false property.\n \t \t \t\t \t \t\t [PUSH MODE] --> eGBTM Jar communicate with eG Agent and send collected metrics  i.e) /<<eg_btm_jar_location>>/config.props having PUSH_TO_AGENT_MODE=true property.", new Object[]{this.loggerDispStr, this.apmComponentGUID, this.NodeID, nodeAPMComponent.getStatus()});
            return;
        }
        ComponentWatcherTracker.isWatcherNull(true);
        SnapShotTakerWatcher.isWatcherNull(true, this.apmComponentGUID);
        AgentLogger.testLogger.debug("{} sourceTable:{} ", (Object)this.loggerDispStr, (Object)this.sourceTable);
        if (this.status_code == 200 && this.sourceTable != null && this.sourceTable.size() > 0) {
            this.computeBTMData(this.sourceTable, nodeAPMComponent);
        } else if (this.status_code != 200) {
            AgentLogger.testLogger.warn("{} Getting status code {} due to some reasons", (Object)this.loggerDispStr, (Object)this.status_code);
        }
    }

    protected ArrayList makePropsListForOffload(String[] stringArray) {
        if (this.propsList != null && this.propsList.size() > 0) {
            this.propsList.clear();
        }
        if (stringArray.length > 0) {
            String string = null;
            for (int i = 0; i < stringArray.length; ++i) {
                string = this.getValueForParam(stringArray[i]);
                if (string != null) {
                    this.propsList.add(string);
                    continue;
                }
                this.propsList.add("-");
            }
            this.propsList.add(this.NodeID);
            string = null;
        }
        AgentLogger.testLogger.debug("{} propsList value is {} ", (Object)this.loggerDispStr, (Object)this.propsList);
        return this.propsList;
    }

    public ArrayList getSlowURLDetails(String string) {
        ArrayList arrayList = null;
        if (this.slowURLTable != null && this.slowURLTable.size() > 0) {
            arrayList = (ArrayList)this.slowURLTable.get(string);
        }
        return arrayList;
    }

    public ArrayList getErrorURLDetails(String string) {
        ArrayList arrayList = null;
        if (this.errorURLTable != null && this.errorURLTable.size() > 0) {
            arrayList = (ArrayList)this.errorURLTable.get(string);
        }
        return arrayList;
    }

    public ArrayList getStalledURLDetails(String string) {
        ArrayList arrayList = null;
        if (this.stalledURLTable != null && this.stalledURLTable.size() > 0) {
            arrayList = (ArrayList)this.stalledURLTable.get(string);
        }
        return arrayList;
    }

    public ArrayList getAllURLDetails(String string) {
        ArrayList arrayList = null;
        if (this.allURLTable != null && this.allURLTable.size() > 0) {
            arrayList = (ArrayList)this.allURLTable.get(string);
        }
        return arrayList;
    }

    public ArrayList getExternalCallDetails(String string) {
        ArrayList arrayList = null;
        if (this.externalTable != null && this.externalTable.size() > 0) {
            arrayList = (ArrayList)this.externalTable.get(string);
        }
        return arrayList;
    }

    public Hashtable getStackTraceTable(String string) {
        Hashtable hashtable = null;
        if (this.stackTraceTable != null && this.stackTraceTable.size() > 0) {
            hashtable = (Hashtable)this.stackTraceTable.get(string);
        }
        return hashtable;
    }

    public Hashtable DataBaseInfo(String string) {
        Hashtable<Object, Object> hashtable = new Hashtable();
        if (dbConnectionDetails.containsKey(string)) {
            hashtable = dbConnectionDetails.get(string);
        } else {
            hashtable = DataBaseUtils.getDBInfo(string, null, null, AgentLogger.testLogger, APMLanguage.NODEJS);
            String string2 = (String)hashtable.get("PORTNUMBER");
            String string3 = (String)hashtable.get("SERVERNAME");
            if (string3.startsWith("jdbc:")) {
                String string4 = this.maskedJdbcURL(string3);
                int n = string4.length();
                if (n > 256) {
                    string4 = string4.substring(0, 252);
                }
                hashtable.put("SERVERNAME", string4);
            } else if (!string2.equals("-") && !string3.startsWith("jdbc:")) {
                try {
                    int n = Integer.parseInt(string2.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    string3 = string3 + "\\" + string2;
                    string2 = "-";
                    hashtable.put("PORTNUMBER", string2);
                    hashtable.put("SERVERNAME", string3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            dbConnectionDetails.put(string, hashtable);
        }
        return hashtable;
    }

    private String maskedJdbcURL(String string) {
        int n = 0;
        string = string.toLowerCase();
        String[] stringArray = new String[]{"password=", "ldap_passwd="};
        n = string.indexOf(stringArray[0]);
        int n2 = 0;
        int n3 = -1;
        if (n < 0) {
            n = string.indexOf(stringArray[1]);
            n2 = stringArray[1].length();
            n3 = 1;
        } else {
            n2 = stringArray[0].length();
            n3 = 0;
        }
        if (n <= 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (n > 0) {
            int n4 = n + n2;
            String string2 = string.substring(n4);
            String string3 = string.substring(0, n4);
            stringBuilder.append(string3);
            int n5 = 0;
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                boolean bl = false;
                switch (c) {
                    case '&': 
                    case ')': 
                    case ',': 
                    case ';': {
                        bl = true;
                        break;
                    }
                    default: {
                        ++n5;
                    }
                }
                if (bl) break;
            }
            if (n5 > 0) {
                string2 = string2.substring(n5);
                stringBuilder.append("$$$$");
            }
            if ((n = string2.indexOf(stringArray[n3])) < 0) {
                stringBuilder.append(string2);
                break;
            }
            string = string2;
        }
        return stringBuilder.toString();
    }

    public HashMap getSessionUserMapping() {
        return this.sessionUserMapping;
    }

    public void clearSessionUserMapping() {
        if (this.sessionUserMapping != null) {
            this.sessionUserMapping.clear();
        }
        this.sessionUserMapping = null;
    }

    public String getJvmGUID() {
        return this.apmComponentGUID;
    }

    public String getApplicationName() {
        AgentLogger.testLogger.debug("{} Method getApplicationName returns :  {}", (Object)this.loggerDispStr, (Object)this.applicationName);
        return this.applicationName;
    }

    public void printOut(String string) {
        System.out.println(this.toString() + " " + this.reportingName + " " + mySDF.format(new Date()) + " :" + logPrefix + string);
    }

    public void printErr(String string) {
        System.err.println(this.toString() + " " + this.reportingName + " " + mySDF.format(new Date()) + " :" + logPrefix + string);
    }

    String STEs2Str(StackTraceElement[] stackTraceElementArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            stringBuilder.append('\t').append(stackTraceElementArray[i].toString()).append('\n');
        }
        return stringBuilder.toString();
    }

    private String getUserName(String string, String string2) {
        if (string.equals("-")) {
            return string2;
        }
        if (string2.equals("-") && this.sessionUserMapping != null && this.sessionUserMapping.containsKey(string)) {
            return (String)this.sessionUserMapping.get(string);
        }
        return string2;
    }

    protected Hashtable formatSource(ArrayList arrayList, Hashtable hashtable, String string, boolean bl) {
        if (arrayList == null || arrayList.isEmpty()) {
            return null;
        }
        Hashtable hashtable2 = new Hashtable();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object;
            Object object2;
            Serializable serializable;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            Serializable serializable2;
            Object object9;
            Object object10;
            String string2;
            Map map;
            String string3;
            String string4;
            String string5;
            String string6;
            MethodInfo methodInfo;
            block87: {
                methodInfo = (MethodInfo)arrayList.get(i);
                if (methodInfo == null) {
                    AgentLogger.testLogger.debug("{} rootInfo is NULL ", (Object)this.loggerDispStr);
                    continue;
                }
                String string7 = null;
                try {
                    string7 = methodInfo.getGuidString();
                    AgentLogger.testLogger.debug("{} guidWithNodeOrder  {}", (Object)this.loggerDispStr, (Object)string7);
                }
                catch (Exception exception) {
                    AgentLogger.testLogger.error("{} guidWithNodeOrder is NULL in Catch Block ==> {}", (Object)this.loggerDispStr, (Object)exception);
                }
                if (string7 == null) {
                    AgentLogger.testLogger.debug("{} guidWithNodeOrder is NULL ", (Object)this.loggerDispStr);
                    continue;
                }
                int n = string7.indexOf("#~#");
                AgentLogger.testLogger.debug("{} nodeIndex :  {}", (Object)this.loggerDispStr, (Object)n);
                if (n < 0) continue;
                string6 = string7.substring(0, n);
                string5 = string7.substring(n + 3);
                String string8 = methodInfo.getRawURL();
                String[] stringArray = string8.split(" @ ");
                if (stringArray == null || stringArray.length < 2) continue;
                String string9 = stringArray[1];
                string4 = stringArray[0];
                string3 = "-";
                map = methodInfo.getProperties();
                string2 = (String)map.get("UTC");
                try {
                    object10 = mySDF.parse(string9);
                    string3 = finalFormat.format((Date)object10);
                    if (string2 != null) break block87;
                    try {
                        object9 = utcSDF.parse(string9 + " " + string);
                        string2 = finalUtcDateFormatter.format((Date)object9);
                        break block87;
                    }
                    catch (Exception exception) {
                        AgentLogger.testLogger.error("{} Exception while Parsing Date for UTC format : {} ", (Object)this.loggerDispStr, (Object)exception);
                    }
                }
                catch (Exception exception) {
                    AgentLogger.testLogger.error("{} Exception while Parsing Date : {}", (Object)this.loggerDispStr, (Object)exception);
                }
                continue;
            }
            object10 = methodInfo.getType();
            object9 = "Web";
            if (object10 != null && ((String)object10).equals("THREAD")) {
                object9 = "Thread";
            }
            long l = methodInfo.getExecutionTime();
            Double d = new Double(l);
            String string10 = (String)map.get("CONTEXT");
            String string11 = (String)map.get("remoteHost");
            String string12 = (String)map.get("Thread_GUID");
            Double d2 = Double.parseDouble((String)map.get("SlowLimit"));
            Double d3 = Double.parseDouble((String)map.get("StalledLimit"));
            String string13 = (String)map.get("QUERYSTRING");
            String string14 = (String)map.get("SESSIONID");
            String string15 = (String)map.get("THREAD");
            String string16 = (String)map.get("DEVICE");
            String string17 = (String)map.get("OS");
            String string18 = (String)map.get("BROWSER");
            String string19 = (String)map.get("REFERER");
            String string20 = "-";
            String string21 = "-";
            String string22 = "-";
            String string23 = "-";
            String string24 = "-";
            String string25 = "-";
            String string26 = "-";
            String string27 = "-";
            String string28 = "-";
            String string29 = "-";
            String string30 = "-";
            String string31 = "-";
            String string32 = "-";
            if (string11.startsWith("/")) {
                string11 = string11.substring(1);
            }
            String string33 = string11;
            String string34 = "-";
            if (string != null && string.equals("unknown")) {
                string = (String)map.get("TimeZone");
            }
            if (this.urlParamsMaskFlag && string13 != null && !string13.equalsIgnoreCase("-")) {
                serializable2 = new StringBuilder();
                ((StringBuilder)serializable2).append("?");
                ((StringBuilder)serializable2).append(string13);
                string13 = ((StringBuilder)serializable2).toString();
                string13 = UrlParamMaskHelper.maskURLParams(string13);
                int n = string13.indexOf("?");
                if (n > -1) {
                    string13 = string13.substring(n + 1);
                }
            }
            if (((String)object9).equals("Web")) {
                try {
                    string23 = (String)map.get("METHODTYPE");
                    if (string23 == null) {
                        string23 = "-";
                    }
                }
                catch (Exception exception) {
                    AgentLogger.testLogger.error("{} Exception while getting HTTP Method Type!!.. so set the default value...{}", (Object)this.loggerDispStr, (Object)exception);
                }
                serializable2 = null;
                try {
                    serializable2 = map.get("STATUS");
                }
                catch (Exception exception) {
                    AgentLogger.testLogger.error("{} Exception while getting HTTP Status Code!!.. so set the default value...{}", (Object)this.loggerDispStr, (Object)exception);
                }
                if (serializable2 != null) {
                    try {
                        string24 = serializable2.toString();
                    }
                    catch (Exception exception) {
                        AgentLogger.testLogger.error("{} Exception occured while performing type casting for HTTP Status Code, so setting the default value..{}", (Object)this.loggerDispStr, (Object)exception);
                    }
                }
                Hashtable hashtable3 = null;
                try {
                    hashtable3 = (Hashtable)map.get("HEADERS");
                }
                catch (Exception exception) {
                    AgentLogger.testLogger.error("{} Exception while doing type casting for Header Data, so setting the default value.. {}", (Object)this.loggerDispStr, (Object)exception);
                }
                object8 = (String)map.get("REMOTE_ADDRESS_HEADER_NAME");
                if (hashtable3 != null && hashtable3.size() > 0) {
                    try {
                        object7 = hashtable3.keySet();
                        object6 = object7.iterator();
                        object5 = null;
                        while (object6.hasNext()) {
                            object5 = (String)object6.next();
                            if (!((String)object5).equalsIgnoreCase("cookie")) continue;
                            string26 = (String)hashtable3.remove(object5);
                            break;
                        }
                        if (string26 == null) {
                            string26 = "-";
                        } else if (string26.length() > 2000) {
                            object4 = string26.substring(0, 2000);
                            string26 = ((String)object4).substring(0, ((String)object4).lastIndexOf(59));
                        }
                        if (this.cookiesParamsMaskFlag) {
                            string26 = UrlParamMaskHelper.maskCookiesValues(string26);
                        }
                    }
                    catch (Exception exception) {
                        AgentLogger.testLogger.error("{} Exception while getting Cookie Values, so setting the default value.. {}", (Object)this.loggerDispStr, (Object)exception);
                    }
                    if (hashtable3 != null && hashtable3.size() > 0) {
                        string25 = this.getHeaderString(hashtable3);
                    }
                    if (object8 != null) {
                        object7 = (String)hashtable3.get(object8);
                        if (object7 == null) {
                            object7 = (String)hashtable3.get(((String)object8).toLowerCase());
                        }
                        if (object7 != null) {
                            string11 = this.getClientIP((String)object7);
                        }
                    }
                    string29 = (String)map.get("User-Agent".toLowerCase());
                } else {
                    if (object8 != null && (object7 = (String)map.get("REMOTE_ADDRESS_HEADER_VALUE")) != null) {
                        string11 = this.getClientIP((String)object7);
                    }
                    string29 = (String)map.get("User-Agent".toLowerCase());
                }
                try {
                    if (string29 == null || string29.equalsIgnoreCase("null") || string29.length() < 0) {
                        string29 = "-";
                    }
                }
                catch (Exception exception) {
                    AgentLogger.testLogger.error("{} Exception while getting User Agent!!.. so set the default value...{}", (Object)this.loggerDispStr, (Object)exception);
                }
                try {
                    string27 = (String)map.get("Username");
                    if (string27 == null) {
                        string27 = "-";
                    } else if (string27.length() > 2000) {
                        string27 = string27.substring(0, 1995) + "...";
                    }
                }
                catch (Exception exception) {
                    AgentLogger.testLogger.error("{} Exception while getting Username!!.. so set the default value...{}", (Object)this.loggerDispStr, (Object)exception);
                }
                try {
                    string28 = (String)map.get("BusinessContext");
                    if (string28 == null) {
                        string28 = "-";
                    } else if (string28.length() > 2000) {
                        string28 = string28.substring(0, 1995) + "...";
                    }
                }
                catch (Exception exception) {
                    AgentLogger.testLogger.error("{} Exception while getting BusinessContext!!.. so set the default value...{}", (Object)this.loggerDispStr, (Object)exception);
                }
            }
            string27 = this.getUserName(string14, string27);
            if (AgentLogger.testLogger.isDebugEnabled()) {
                AgentLogger.testLogger.debug("{} IC userName is : {}", (Object)this.loggerDispStr, (Object)string27);
                AgentLogger.testLogger.debug("{} IC businessContext is : {}", (Object)this.loggerDispStr, (Object)string28);
                AgentLogger.testLogger.debug("{} HTTP MethodType : {}", (Object)this.loggerDispStr, (Object)string23);
                AgentLogger.testLogger.debug("{} HTTP ResponseStatusCode : {}", (Object)this.loggerDispStr, (Object)string24);
                AgentLogger.testLogger.debug("{} headerString : {} requestType : {}", new Object[]{this.loggerDispStr, string25, object9});
                AgentLogger.testLogger.debug("{} cookies :  {}", (Object)this.loggerDispStr, (Object)string26);
            }
            serializable2 = (HashMap)map.get("Fast_Method_Map");
            HashMap hashMap = (HashMap)map.get("Slow_Exceed_Sql_Limit_Map");
            object8 = (HashMap)map.get("Error_Exceed_Sql_Limit_Map");
            if (string11.startsWith("/")) {
                string11 = string11.substring(1);
            }
            if (string11.startsWith("127.") || string11.equals("0:0:0:0:0:0:0:1")) {
                string11 = "localhost";
            }
            if (string12 == null) {
                string12 = "-";
            }
            if (string13.length() > 1024) {
                string13 = string13.substring(0, 1019) + "...";
            }
            if (string19.length() > 2000) {
                string19 = string19.substring(0, 1995) + "...";
            }
            if ((object6 = this.getDetailsList(methodInfo, hashtable, bl, (HashMap)(object7 = (HashMap)map.get("CHILD_MAP")))) != null && ((ArrayList)object6).size() > 0) {
                object5 = (ArrayList)((ArrayList)object6).get(0);
                if (serializable2 != null && serializable2.size() > 0) {
                    this.updateFastAndExceedSqlDetails((ArrayList)object5, (Map)((Object)serializable2), "FASTQUERY");
                }
                if (hashMap != null && hashMap.size() > 0) {
                    this.updateFastAndExceedSqlDetails((ArrayList)object5, hashMap, "SLOWEXCCEDQUERY");
                }
                if (object8 != null && object8.size() > 0) {
                    this.updateFastAndExceedSqlDetails((ArrayList)object5, (Map)object8, "ERROREXCCEDQUERY");
                }
                if ((object4 = (HashMap)map.get("EHCACHE_DETAILS")) != null && object4.size() > 0) {
                    object3 = object4.keySet().iterator();
                    while (object3.hasNext()) {
                        serializable = new StringBuilder();
                        object2 = (String)object3.next();
                        object = (double[])object4.get(object2);
                        ((StringBuilder)serializable).append("EHCACHE").append("#=#");
                        ((StringBuilder)serializable).append((String)object2).append("#=#");
                        ((StringBuilder)serializable).append(object[1]).append("#=#");
                        ((StringBuilder)serializable).append((double)object[0]);
                        ((ArrayList)object5).add((Boolean)serializable);
                    }
                }
                if (object5 != null && ((ArrayList)object5).size() > 0) {
                    object3 = new ArrayList();
                    ((ArrayList)object3).add(string6);
                    ((ArrayList)object3).add(string5);
                    ((ArrayList)object3).add(object9);
                    ((ArrayList)object3).add(string3);
                    ((ArrayList)object3).add(new ArrayList(object5));
                    arrayList3.add(object3);
                }
                boolean bl2 = false;
                serializable = (Boolean)map.get("isErrorURL");
                if (serializable != null) {
                    bl2 = serializable;
                }
                if (!map.containsKey("ExceptionTrace") && bl2) {
                    object2 = new ArrayList();
                    object = (String)map.get("STATUS_MESSAGE");
                    ((ArrayList)object2).add(string6);
                    ((ArrayList)object2).add(string5);
                    ((ArrayList)object2).add(object9);
                    ((ArrayList)object2).add(string3);
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("EXCEPTION").append("#=#").append("0.1.2.3.4.5.6.7.8");
                    stringBuilder.append("#=#").append(0.0);
                    stringBuilder.append("#=#").append("HTTP Error Code " + string24);
                    if (object != null && ((String)object).equals("-") && !((String)object).trim().isEmpty()) {
                        stringBuilder.append("#=#").append("This request has been marked as error due to : " + (String)object + " , " + string24);
                    } else {
                        stringBuilder.append("#=#").append("This request has been marked as error due to : " + string24);
                    }
                    ((ArrayList)object5).add((StringBuilder)stringBuilder);
                    ((ArrayList)object2).add(new ArrayList<Boolean>((Collection<Boolean>)object5));
                    arrayList3.add(object2);
                }
            }
            string4 = NodeTransTestBase.decodeUrlString(string4, this.loggerDispStr);
            string13 = NodeTransTestBase.decodeUrlString(string13, this.loggerDispStr);
            string19 = NodeTransTestBase.decodeUrlString(string19, this.loggerDispStr);
            if (string13.length() > 1024) {
                string13 = string13.substring(0, 1019) + "...";
            }
            if (string19.length() > 2000) {
                string19 = string19.substring(0, 1995) + "...";
            }
            try {
                if (this.measureCount > 23 && !string29.equals("-")) {
                    object5 = UserAgentUtil.getUserAgentDetails(string29);
                    string16 = (String)((Hashtable)object5).get("DEVICE");
                    string17 = (String)((Hashtable)object5).get("OS");
                    string18 = (String)((Hashtable)object5).get("BROWSER");
                    string30 = (String)((Hashtable)object5).get("Browser_version");
                }
            }
            catch (Exception exception) {
                AgentLogger.testLogger.error("{} Exception while getting Device, OS, Browser Details from UserAgent !!.. so set the default value... {} ", (Object)this.loggerDispStr, (Object)exception);
            }
            object5 = null;
            try {
                object4 = new GeoLocalXmlFile(this.reportingName);
                object5 = ((GeoLocalXmlFile)object4).getLocation(string11);
                boolean bl3 = ((GeoLocalXmlFile)object4).isDefault((ArrayList)object5);
                serializable = null;
                if ((object5 == null || ((ArrayList)object5).size() >= 6) && bl3) {
                    object2 = GeoLocationInfo.getInstance();
                    object = new ArrayList();
                    ((ArrayList)object).add(string11);
                    ((GeoLocationInfo)object2).setIPAddresses((ArrayList)object);
                    serializable = ((GeoLocationInfo)object2).getGeoLocationDetails(string11);
                }
                if (serializable != null && ((ArrayList)serializable).size() > 0) {
                    object5 = serializable;
                }
            }
            catch (Exception exception) {
                AgentLogger.testLogger.error("{} Exception while getting Country, Location, Position Details from IP !!.. so set the default value... {} ", (Object)this.loggerDispStr, (Object)exception);
            }
            if (object5 != null && ((ArrayList)object5).size() > 0) {
                string20 = (String)((ArrayList)object5).get(0);
                string32 = (String)((ArrayList)object5).get(2);
                string31 = (String)((ArrayList)object5).get(3);
                object4 = (String)((ArrayList)object5).get(4);
                String string35 = (String)((ArrayList)object5).get(5);
                string22 = (String)object4 + "," + string35;
            }
            try {
                Object v;
                object4 = (HashMap)this.getCauseExceptionTracingTable();
                if (object4 != null && this.apmComponentGUID != null && ((HashMap)object4).size() > 0 && (v = ((HashMap)object4).get(this.apmComponentGUID)) != null) {
                    boolean bl4 = (Boolean)v;
                    string34 = bl4 ? (String)map.get("NODEJS_EXCEPTION_FQCN_BOTTOM") : (String)map.get("NODEJS_EXCEPTION_FQCN_ROOT");
                    string34 = string34 == null ? "-" : string34;
                }
            }
            catch (Exception exception) {
                AgentLogger.testLogger.error("{} Exception occoured while checking exception FQCN for BusinessTransTest. {} ", (Object)this.loggerDispStr, (Object)exception);
            }
            if (this.publicIPMaskFlag || this.privateIPMaskFlag) {
                object4 = string11;
                if (!this.checkIsIpLocalhost(string11)) {
                    string11 = this.getMaskedIP(string11);
                }
                if (!this.checkIsIpLocalhost(string33)) {
                    string33 = ((String)object4).equals(string33) ? string11 : this.getMaskedIP(string33);
                }
            }
            object4 = new ArrayList();
            object3 = (String)map.get("callTrace");
            ((ArrayList)object4).add(string6);
            ((ArrayList)object4).add(string5);
            ((ArrayList)object4).add(this.applicationName);
            ((ArrayList)object4).add(string10);
            ((ArrayList)object4).add(string3);
            ((ArrayList)object4).add(string12);
            ((ArrayList)object4).add(string4);
            ((ArrayList)object4).add(d);
            ((ArrayList)object4).add(string);
            ((ArrayList)object4).add(string11);
            ((ArrayList)object4).add(object9);
            ((ArrayList)object4).add(object10);
            ((ArrayList)object4).add(d2);
            ((ArrayList)object4).add(d3);
            ((ArrayList)object4).add(string13);
            ((ArrayList)object4).add(string14);
            ((ArrayList)object4).add(string15);
            ((ArrayList)object4).add(string16);
            ((ArrayList)object4).add(string17);
            ((ArrayList)object4).add(string18);
            ((ArrayList)object4).add(string19);
            ((ArrayList)object4).add(string20);
            ((ArrayList)object4).add(string21);
            ((ArrayList)object4).add(string22);
            ((ArrayList)object4).add(object3);
            ((ArrayList)object4).add(minusFive);
            ((ArrayList)object4).add(string23);
            ((ArrayList)object4).add(string24);
            ((ArrayList)object4).add(string26);
            ((ArrayList)object4).add(string25);
            ((ArrayList)object4).add(string27);
            ((ArrayList)object4).add(string28);
            ((ArrayList)object4).add(minusFive);
            ((ArrayList)object4).add(minusFive);
            ((ArrayList)object4).add(minusFive);
            int n = string29.length();
            if (n > 1996) {
                string29 = string29.substring(0, 1996) + "...";
            }
            ((ArrayList)object4).add(string29);
            ((ArrayList)object4).add(string30);
            ((ArrayList)object4).add(string31);
            ((ArrayList)object4).add(string32);
            ((ArrayList)object4).add(string33);
            ((ArrayList)object4).add(string34);
            ((ArrayList)object4).add(this.apmComponentGUID);
            ((ArrayList)object4).add(string2);
            arrayList2.add(object4);
        }
        hashtable2.put("DD", arrayList2);
        hashtable2.put("EXTRA", arrayList3);
        return hashtable2;
    }

    private void updateFastAndExceedSqlDetails(ArrayList arrayList, Map map, String string) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = (String)iterator.next();
            Object v = map.get(string2);
            double d = 0.0;
            int n = 0;
            if (v instanceof double[]) {
                object = (double[])map.get(string2);
                n = (int)object[0];
                d = (double)object[1];
            } else {
                object = map.get(string2);
                String string3 = object.toString();
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    d += Double.parseDouble(string4);
                    ++n;
                }
            }
            if (string2 != null && string2.startsWith("mongodb")) {
                stringBuilder.append("MONGODB").append("#=#");
            } else {
                stringBuilder.append("SQL").append("#=#");
            }
            stringBuilder.append(string).append("#=#");
            stringBuilder.append(d).append("#=#");
            stringBuilder.append(string2).append("#=#");
            stringBuilder.append(n).append("#=#");
            stringBuilder.append("-").append("#=#");
            stringBuilder.append("-");
            arrayList.add(stringBuilder);
        }
    }

    private String getHeaderString(Hashtable hashtable) {
        StringBuilder stringBuilder = null;
        try {
            Set set = hashtable.keySet();
            Iterator iterator = set.iterator();
            if (set.size() > 0) {
                stringBuilder = new StringBuilder();
                int n = 2000;
                while (iterator.hasNext()) {
                    int n2;
                    String string = (String)iterator.next();
                    String string2 = (String)hashtable.get(string);
                    int n3 = string.length();
                    int n4 = string2.length();
                    if (n4 >= 500) {
                        StringBuilder stringBuilder2 = new StringBuilder();
                        stringBuilder2.append(string2.substring(0, 10)).append(" ... ").append(string2.substring(n4 - 10));
                        string2 = stringBuilder2.toString();
                        n4 = string2.length();
                    }
                    if ((n2 = n3 + n4 + 4) < n) {
                        stringBuilder.append(string);
                        stringBuilder.append("=");
                        if (this.headersParamsMaskFlag) {
                            string2 = UrlParamMaskHelper.maskHeaderValues(string, string2, this.unmaskedHeaderList);
                            stringBuilder.append(string2);
                        } else {
                            stringBuilder.append(string2);
                        }
                        stringBuilder.append("#~#");
                        n -= n2;
                        continue;
                    }
                    int n5 = stringBuilder.length();
                    AgentLogger.testLogger.warn("{} Current Header size {}. Can't add the header name {} due to limitation !!! ", new Object[]{this.loggerDispStr, n5, string});
                }
            } else {
                stringBuilder = new StringBuilder();
                stringBuilder.append("-");
            }
        }
        catch (Exception exception) {
            AgentLogger.testLogger.error("{} Exception occured while iterating header data : {} ", (Object)this.loggerDispStr, (Object)exception);
        }
        return stringBuilder.toString();
    }

    private ArrayList getDetailsList(MethodInfo methodInfo, Hashtable hashtable, boolean bl, HashMap hashMap) {
        HashMap hashMap2 = this.prepareOrderMap(methodInfo, hashMap);
        boolean bl2 = false;
        long l = 0L;
        Object var9_8 = null;
        ArrayList arrayList = null;
        if (hashMap2 != null && hashMap2.size() > 0) {
            Set set = hashMap2.keySet();
            ArrayList arrayList2 = new ArrayList(set);
            Collections.sort(arrayList2, new AlphanumComparator());
            int n = arrayList2.size();
            Iterator iterator = arrayList2.iterator();
            int n2 = 1;
            arrayList = new ArrayList();
            ArrayList<StringBuilder> arrayList3 = new ArrayList<StringBuilder>();
            while (iterator.hasNext()) {
                Object object;
                Set set2;
                Object object2;
                CharSequence charSequence;
                String string;
                String string2;
                String string3 = (String)iterator.next();
                MethodInfo methodInfo2 = (MethodInfo)hashMap2.get(string3);
                String string4 = methodInfo2.getType();
                long l2 = methodInfo2.getExecutionTime();
                StringBuilder stringBuilder = null;
                if (string4.equals("SQL")) {
                    string2 = (String)methodInfo2.getProperties().get("sqlStmt");
                    string = (String)methodInfo2.getProperties().get("jdbcUrl");
                    charSequence = (String)methodInfo2.getProperties().get("sqlError");
                    object2 = (String)methodInfo2.getProperties().get("stackTrace");
                    set2 = NodeTransTestBase.prepQryForUI(string2);
                    stringBuilder = new StringBuilder();
                    stringBuilder.append(string4).append("#=#").append(string3);
                    stringBuilder.append("#=#").append(l2);
                    stringBuilder.append("#=#").append(string);
                    stringBuilder.append("#=#").append((String)((Object)set2));
                    stringBuilder.append("#=#").append((String)charSequence);
                    stringBuilder.append("#=#").append((String)object2);
                } else if (string4.equals("MONGODB")) {
                    string2 = (String)methodInfo2.getProperties().get("mongoServerDetails");
                    string = (String)methodInfo2.getProperties().get("mongoTableName");
                    charSequence = (String)methodInfo2.getProperties().get("queryType");
                    object2 = (String)methodInfo2.getProperties().get("mongoQuery");
                    set2 = (String)methodInfo2.getProperties().get("error");
                    stringBuilder = new StringBuilder();
                    stringBuilder.append(string4).append("#=#").append(string3);
                    stringBuilder.append("#=#").append(l2);
                    stringBuilder.append("#=#").append(string2);
                    stringBuilder.append("#=#").append((String)object2);
                    stringBuilder.append("#=#").append(string);
                    stringBuilder.append("#=#").append((String)charSequence);
                    stringBuilder.append("#=#").append((String)((Object)set2));
                } else if (string4.equals("EXCEPTION")) {
                    string2 = (String)methodInfo2.getProperties().get("EXCEPTION");
                    string = null;
                    if (this.exceptionParamsMaskFlag) {
                        charSequence = new StringBuilder();
                        object2 = string2.substring(0, string2.indexOf("?^?"));
                        set2 = string2.substring(string2.indexOf("?^?"));
                        string = UrlParamMaskHelper.maskURLParams((String)object2);
                        ((StringBuilder)charSequence).append(string).append((String)((Object)set2));
                        string2 = ((StringBuilder)charSequence).toString();
                    } else {
                        string = string2.substring(0, string2.indexOf("?^?"));
                    }
                    if (string2 != null && string2.length() > 0 && string2.indexOf("?^?") > 0) {
                        stringBuilder = new StringBuilder();
                        stringBuilder.append(string4).append("#=#").append(string3);
                        stringBuilder.append("#=#").append(l2);
                        stringBuilder.append("#=#").append(string);
                        stringBuilder.append("#=#").append(string2);
                    }
                } else if (string4.equals("HTTP")) {
                    string2 = null;
                    string = null;
                    charSequence = null;
                    object2 = null;
                    set2 = null;
                    if (methodInfo2.getProperties() != null) {
                        string2 = (String)methodInfo2.getProperties().get("EXTURL");
                        string = (String)methodInfo2.getProperties().get("METHOD");
                        charSequence = (String)methodInfo2.getProperties().get("NODE_ORDER");
                        object2 = (String)methodInfo2.getProperties().get("SC");
                        set2 = (String)methodInfo2.getProperties().get("RM");
                    }
                    if (charSequence == null) {
                        charSequence = "-";
                    }
                    if (string2 == null) {
                        string2 = "-";
                    }
                    if (string == null) {
                        string = "-";
                    }
                    if (object2 == null) {
                        object2 = "-";
                    }
                    if (set2 == null) {
                        set2 = "-";
                    }
                    stringBuilder = new StringBuilder();
                    stringBuilder.append(string4).append("#=#").append(string3);
                    stringBuilder.append("#=#").append(l2);
                    stringBuilder.append("#=#").append(string2);
                    stringBuilder.append("#=#").append(string);
                    stringBuilder.append("#=#").append((String)charSequence);
                    stringBuilder.append("#=#").append((String)object2);
                    stringBuilder.append("#=#").append((String)((Object)set2));
                } else if (string4.equals("WEBSERVICE")) {
                    string2 = (String)methodInfo2.getProperties().get("TargetUrl");
                    string = (String)methodInfo2.getProperties().get("OperationName");
                    if (string.indexOf("[*#*]") > -1) {
                        int n3 = string.indexOf("[*#*]");
                        object2 = string.substring(0, n3);
                        int n4 = ((String)object2).lastIndexOf("/}");
                        if (n4 > -1) {
                            object2 = ((String)object2).substring(n4 + 2, ((String)object2).length());
                        }
                        if ((n4 = ((String)(object = string.substring(n3, string.length()))).lastIndexOf("/}")) > -1) {
                            object = ((String)object).substring(n4 + 2, ((String)object).length());
                        }
                        string = (String)object2 + "." + (String)object;
                    }
                    charSequence = (String)methodInfo2.getProperties().get("NODE_ORDER");
                    object2 = (String)methodInfo2.getProperties().get("SC");
                    set2 = (String)methodInfo2.getProperties().get("RM");
                    if (charSequence == null) {
                        charSequence = "-";
                    }
                    if (object2 == null) {
                        object2 = "-";
                    }
                    if (set2 == null) {
                        set2 = "-";
                    }
                    stringBuilder = new StringBuilder();
                    stringBuilder.append(string4).append("#=#").append(string3);
                    stringBuilder.append("#=#").append(l2);
                    stringBuilder.append("#=#").append(string2);
                    stringBuilder.append("#=#").append(string);
                    stringBuilder.append("#=#").append((String)charSequence);
                    stringBuilder.append("#=#").append((String)object2);
                    stringBuilder.append("#=#").append((String)((Object)set2));
                } else if (string4.equals("EMAIL")) {
                    string2 = (String)methodInfo2.getProperties().get("method");
                    string = (String)methodInfo2.getProperties().get("endPoint");
                    try {
                        string = this.getEmailEndPoint(string);
                        stringBuilder = new StringBuilder();
                        stringBuilder.append(string4).append("#=#").append(string3);
                        stringBuilder.append("#=#").append(l2);
                        stringBuilder.append("#=#").append(string2);
                        stringBuilder.append("#=#").append(string);
                    }
                    catch (Exception exception) {
                        AgentLogger.testLogger.error("{}  Exception in getDetailsList while preparing data for EMAIL/LDAP  : {}", (Object)this.loggerDispStr, (Object)exception);
                    }
                } else if (string4.equals("JMS")) {
                    string2 = (String)methodInfo2.getProperties().get("JMS-PROVIDER");
                    string = (String)methodInfo2.getProperties().get("JMS-QUEUE");
                    charSequence = (String)methodInfo2.getProperties().get("TYPE");
                    object2 = (String)methodInfo2.getProperties().get("NODE_ORDER");
                    if (object2 == null) {
                        object2 = "-";
                    }
                    stringBuilder = new StringBuilder();
                    stringBuilder.append(string4).append("#=#").append(string3);
                    stringBuilder.append("#=#").append(l2);
                    stringBuilder.append("#=#").append(string2);
                    stringBuilder.append("#=#").append(string);
                    stringBuilder.append("#=#").append((String)charSequence);
                    stringBuilder.append("#=#").append((String)object2);
                } else if (string4.equals("JMS_ENTRY")) {
                    string2 = (String)methodInfo2.getProperties().get("JMS-PROVIDER");
                    string = (String)methodInfo2.getProperties().get("JMS-QUEUE");
                    charSequence = (String)methodInfo2.getProperties().get("TYPE");
                    stringBuilder = new StringBuilder();
                    stringBuilder.append(string4).append("#=#").append(string3);
                    stringBuilder.append("#=#").append(l2);
                    stringBuilder.append("#=#").append(string2);
                    stringBuilder.append("#=#").append(string);
                    stringBuilder.append("#=#").append((String)charSequence);
                } else if (string4.equals("REDIS")) {
                    string2 = (String)methodInfo2.getProperties().get("redisIP");
                    string = (String)methodInfo2.getProperties().get("redisPort");
                    charSequence = (String)methodInfo2.getProperties().get("redisDetails");
                    object2 = new HashMap();
                    if (((String)charSequence).contains(",")) {
                        set2 = new StringTokenizer((String)charSequence, ",");
                        while (((StringTokenizer)((Object)set2)).hasMoreElements()) {
                            object = (String)((StringTokenizer)((Object)set2)).nextElement();
                            NodeTransTestBase.retriveRedisDBAndCommand((String)object, (Map<String, String>)object2);
                        }
                    } else {
                        NodeTransTestBase.retriveRedisDBAndCommand((String)charSequence, (Map<String, String>)object2);
                    }
                    stringBuilder = new StringBuilder();
                    stringBuilder.append(string4).append("#=#").append(string3);
                    stringBuilder.append("#=#").append(l2);
                    stringBuilder.append("#=#").append(string2);
                    stringBuilder.append("#=#").append(string);
                    if (object2 != null && object2.size() >= 1) {
                        set2 = object2.keySet();
                        object = set2.iterator();
                        while (object.hasNext()) {
                            String string5 = (String)object.next();
                            stringBuilder.append("#=#").append(string5);
                            stringBuilder.append("#=#").append((String)object2.get(string5));
                        }
                    }
                } else if (string4.startsWith("Custom_") && (string2 = (String)hashtable.get(string4)) != null && string2.length() > 0) {
                    stringBuilder = new StringBuilder();
                    stringBuilder.append(string4).append("#=#").append(string3);
                    stringBuilder.append("#=#").append(l2);
                    stringBuilder.append("#=#").append(string2);
                }
                if (stringBuilder != null) {
                    arrayList3.add(stringBuilder);
                }
                ++n2;
            }
            arrayList.add(arrayList3);
        }
        return arrayList;
    }

    protected String getEmailEndPoint(String string) {
        try {
            if (string != null && string.length() > 1) {
                StringBuilder stringBuilder = new StringBuilder();
                URLName uRLName = new URLName(string);
                String string2 = uRLName.getProtocol();
                String string3 = uRLName.getHost();
                int n = uRLName.getPort();
                if (string2 != null) {
                    stringBuilder.append(string2);
                    stringBuilder.append("://");
                }
                if (string3 != null) {
                    stringBuilder.append(string3);
                }
                if (n != -1) {
                    stringBuilder.append(":");
                    stringBuilder.append(n);
                }
                return stringBuilder.toString();
            }
        }
        catch (Exception exception) {
            AgentLogger.testLogger.error("{} Exception occurred while retriving Email EndPoint {} ", (Object)this.loggerDispStr, (Object)exception);
        }
        return "-";
    }

    private static Map retriveRedisDBAndCommand(String string, Map<String, String> map) {
        int n = string.indexOf("#");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, string.length());
        if (map.containsKey(string2)) {
            String string4 = map.get(string2);
            String string5 = string3 + "," + string4;
            map.put(string2, string5);
        } else {
            map.put(string2, string3);
        }
        return map;
    }

    private static StringBuilder getMethodDisplayName(MethodInfo methodInfo, String string) {
        StringBuilder stringBuilder = null;
        String string2 = null;
        if (methodInfo != null) {
            String string3 = methodInfo.getClassName();
            String string4 = methodInfo.getMethodName();
            String string5 = methodInfo.getDesc();
            String string6 = null;
            if (string.equals("THREAD_INIT") && string5 != null && string5.indexOf(" [ASYNC]-") > 0) {
                string2 = string5.substring(string5.indexOf(" [ASYNC]-") + 1);
                int n = string5.indexOf("[#");
                if (n > 0) {
                    string6 = string5.substring(string5.indexOf("[#") + 2, string5.indexOf("#] "));
                    string5 = string5.substring(0, string5.indexOf("[#"));
                }
            }
            String string7 = string3.replace("/", ".");
            String string8 = NodeTransTestBase.getParamNames(string5.trim());
            stringBuilder = new StringBuilder();
            stringBuilder.append(string7);
            stringBuilder.append(".");
            stringBuilder.append(string4);
            stringBuilder.append("(");
            stringBuilder.append(string8);
            stringBuilder.append(")");
            if (string6 != null) {
                stringBuilder.append(" [").append(string6).append("] ");
            }
            if (string2 != null) {
                stringBuilder.append(string2);
            }
        }
        return stringBuilder;
    }

    private static String prepQryForUI(String string) {
        String string2;
        if (string == null) {
            return "NULL";
        }
        if (string.indexOf(10) == -1) {
            string2 = string;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            StringBuilder stringBuilder = new StringBuilder();
            int n = stringTokenizer.countTokens();
            for (int i = 0; i < n; ++i) {
                String string3 = stringTokenizer.nextToken();
                if (string3 == null || string3.length() <= 0) continue;
                stringBuilder.append(string3.trim());
                stringBuilder.append(' ');
            }
            string2 = stringBuilder.toString();
        }
        if (string2.indexOf(",N'") != -1) {
            return string2.replaceAll(",N'", ",'");
        }
        return string2;
    }

    private static String getParamNames(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Type type : Type.getArgumentTypes(string)) {
            String string2 = "";
            string2 = type.equals(Type.BOOLEAN_TYPE) ? "boolean" : (type.equals(Type.BYTE_TYPE) ? "byte" : (type.equals(Type.CHAR_TYPE) ? "char" : (type.equals(Type.SHORT_TYPE) ? "short" : (type.equals(Type.INT_TYPE) ? "int" : (type.equals(Type.LONG_TYPE) ? "long" : (type.equals(Type.FLOAT_TYPE) ? "float" : (type.equals(Type.DOUBLE_TYPE) ? "double" : (type.equals(Type.VOID_TYPE) ? "void" : type.getInternalName()))))))));
            int n = string2.lastIndexOf(47);
            if (n > 0) {
                String string3 = string2.substring(n + 1);
                stringBuilder.append(string3 + ",");
                continue;
            }
            stringBuilder.append(string2 + ",");
        }
        String string4 = stringBuilder.toString();
        int n = string4.lastIndexOf(44);
        if (n > 0) {
            string4 = string4.substring(0, n);
        }
        return string4;
    }

    private MethodInfo getExceptionInfoList(MethodInfo methodInfo, HashMap hashMap, Set set, boolean bl) {
        Stack<MethodInfo> stack = new Stack<MethodInfo>();
        stack.push(methodInfo);
        int n = 0;
        while (!stack.isEmpty() && n < 500) {
            ArrayList arrayList;
            ++n;
            MethodInfo methodInfo2 = (MethodInfo)stack.pop();
            String string = methodInfo2.getType();
            if (string.equals("HTTP") && bl) {
                return methodInfo2;
            }
            if (string.equals("EXCEPTION")) {
                set.add(methodInfo2.getId());
            }
            if ((arrayList = (ArrayList)methodInfo2.getChildMinfos()) == null || arrayList.size() <= 0) continue;
            for (int i = 0; i < arrayList.size(); ++i) {
                Long l = (Long)arrayList.get(i);
                MethodInfo methodInfo3 = (MethodInfo)hashMap.get(l);
                stack.push(methodInfo3);
            }
        }
        return null;
    }

    private HashMap prepareOrderMap(MethodInfo methodInfo, HashMap hashMap) {
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        try {
            Stack<Object> stack = new Stack<Object>();
            MethodInfo methodInfo2 = methodInfo;
            stack.push(methodInfo2);
            HashMap<Object, String> hashMap3 = new HashMap<Object, String>();
            hashMap3.put(methodInfo2, "0");
            hashMap2.put("0", methodInfo2);
            ArrayList arrayList = new ArrayList();
            while (!stack.isEmpty()) {
                Object object;
                Serializable serializable;
                ArrayList arrayList2;
                String string;
                block17: {
                    Object object2;
                    Serializable serializable2;
                    methodInfo2 = (MethodInfo)stack.pop();
                    if (arrayList.contains(methodInfo2)) continue;
                    string = (String)hashMap3.get(methodInfo2);
                    String string2 = methodInfo2.getType();
                    if (string2.equals("EMAIL")) {
                        arrayList2 = (ArrayList)methodInfo2.getChildMinfos();
                        if (arrayList2.size() == 1) {
                            serializable2 = (Long)arrayList2.get(0);
                            serializable = (MethodInfo)hashMap.get(serializable2);
                            object = serializable.getType();
                            if (arrayList.contains(serializable)) continue;
                            if (((String)object).equals("EMAIL")) {
                                object2 = (String)serializable.getProperties().get("endPoint");
                                if (object2 == null) {
                                    object2 = "-";
                                }
                                methodInfo2.getProperties().put("endPoint", object2);
                            }
                        }
                    } else if (string2.equals("SQL")) {
                        try {
                            arrayList2 = (ArrayList)methodInfo2.getChildMinfos();
                            if (arrayList2 == null || arrayList2.size() <= 0) break block17;
                            serializable2 = new ArrayList();
                            for (int i = 0; i < arrayList2.size(); ++i) {
                                String string3;
                                object = (Long)arrayList2.get(i);
                                object2 = (MethodInfo)hashMap.get(object);
                                if (object2 == null || !(string3 = ((MethodInfo)object2).getType()).equals("EXCEPTION") && !string3.equals("THREAD_INIT")) continue;
                                serializable2.add(((MethodInfo)object2).getId());
                            }
                            try {
                                if (arrayList2 != null) {
                                    arrayList2.clear();
                                }
                            }
                            catch (Exception exception) {
                                AgentLogger.testLogger.error("{}  Error while clearing SQL ChildInfos : {} ", (Object)this.loggerDispStr, (Object)exception);
                            }
                            if (serializable2.size() > 0) {
                                arrayList2.addAll(serializable2);
                            }
                        }
                        catch (Exception exception) {
                            AgentLogger.testLogger.error("{} Exception occured due to : {}", (Object)this.loggerDispStr, (Object)exception);
                        }
                    }
                }
                arrayList2 = (ArrayList)methodInfo2.getChildMinfos();
                AgentLogger.testLogger.debug("{} childIDList  : {} ", (Object)this.loggerDispStr, (Object)arrayList2);
                if (arrayList2 == null || arrayList2.size() <= 0) continue;
                for (int i = 0; i < arrayList2.size(); ++i) {
                    serializable = (Long)arrayList2.get(i);
                    object = (MethodInfo)hashMap.get(serializable);
                    if (object.equals(methodInfo2)) continue;
                    stack.push(object);
                    hashMap3.put(object, string + "." + i);
                    hashMap2.put(string + "." + i, object);
                }
            }
            stack = null;
        }
        catch (Exception exception) {
            AgentLogger.testLogger.error("{} Error Occured in prepareOrderMap : {}", (Object)this.loggerDispStr, (Object)exception);
        }
        return hashMap2;
    }

    public static String decodeUrlString(String string, String string2) {
        String string3 = string;
        if (string != null) {
            try {
                string3 = URLDecoder.decode(string, "UTF-8");
            }
            catch (Exception exception) {
                AgentLogger.testLogger.warn("{} Decoding fails for the string : {}", (Object)string2, (Object)string);
                AgentLogger.testLogger.error("{} Exception occured while decoding the string : {} {}", new Object[]{string2, string, exception});
            }
        }
        return string3;
    }

    private Hashtable getCaseInsensitiveDetails(Hashtable hashtable) {
        Cloneable cloneable;
        String string;
        Object object;
        Object object2;
        Object object3;
        HashMap hashMap = new HashMap();
        HashSet<String> hashSet = new HashSet<String>();
        try {
            object3 = hashtable.keySet();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                string = ((String)object).toLowerCase();
                cloneable = (ArrayList<String>)hashMap.get(string);
                if (cloneable == null) {
                    cloneable = new ArrayList<String>();
                    cloneable.add((String)object);
                    hashMap.put(string, cloneable);
                    continue;
                }
                hashSet.add(string);
                cloneable.add((String)object);
                hashMap.put(string, cloneable);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!hashSet.isEmpty()) {
            System.out.println(this.entity + " some case insenstive pattern exits, trying to merge !!!");
            object3 = hashSet.iterator();
            while (object3.hasNext()) {
                try {
                    object2 = (String)object3.next();
                    object = (ArrayList)hashMap.get(object2);
                    if (object == null || ((ArrayList)object).size() <= 1) continue;
                    string = (String)((ArrayList)object).get(0);
                    cloneable = (Hashtable)hashtable.get(string);
                    for (int i = 1; i < ((ArrayList)object).size(); ++i) {
                        String string2 = (String)((ArrayList)object).get(i);
                        Hashtable hashtable2 = (Hashtable)hashtable.remove(string2);
                        this.mergeDetails((Hashtable)cloneable, hashtable2);
                        System.out.println(this.entity + " Successfully merged for the " + string2 + " with " + string);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return hashtable;
    }

    private void mergeDetails(Hashtable hashtable, Hashtable hashtable2) {
        try {
            ArrayList arrayList = (ArrayList)hashtable.get("patternData");
            ArrayList arrayList2 = (ArrayList)hashtable2.get("patternData");
            int n = 0;
            int n2 = 0;
            if (arrayList != null) {
                n = arrayList.size();
            }
            if (arrayList2 != null) {
                n2 = arrayList2.size();
            }
            if (n == 0 && n2 == 0) {
                return;
            }
            if (n2 == 0) {
                return;
            }
            if (n == 0) {
                hashtable.put("patternData", arrayList2);
                hashtable.put("SlowURLThreadLists", hashtable2.remove("SlowURLThreadLists"));
                hashtable.put("SlowURLLists", hashtable2.remove("SlowURLLists"));
                hashtable.put("ErrorURLThreadLists", hashtable2.remove("ErrorURLThreadLists"));
                hashtable.put("ErrorURLLists", hashtable2.remove("ErrorURLLists"));
                hashtable.put("StalledURLLists", hashtable2.remove("StalledURLLists"));
                hashtable.put("StalledURLThreadLists", hashtable2.remove("StalledURLThreadLists"));
                hashtable.put("HealthyURLThreadLists", hashtable2.remove("HealthyURLThreadLists"));
                hashtable.put("AllURLLists", hashtable2.remove("AllURLLists"));
                return;
            }
            Set set = hashtable.keySet();
            for (String string : set) {
                ArrayList arrayList3;
                Object object;
                if (string.equals("patternData")) {
                    object = (ArrayList)hashtable.get("patternData");
                    arrayList3 = (ArrayList)hashtable2.remove("patternData");
                    if (object == null || arrayList3 == null) continue;
                    int n3 = ((ArrayList)object).size();
                    for (int i = 0; i < n3; ++i) {
                        double d = (Double)((ArrayList)object).get(i);
                        double d2 = (Double)arrayList3.get(i);
                        double d3 = d + d2;
                        ((ArrayList)object).set(i, new Double(d3));
                    }
                    continue;
                }
                object = hashtable2.remove(string);
                if (object == null || !(object instanceof ArrayList)) continue;
                arrayList3 = (ArrayList)object;
                Object v = hashtable.get(string);
                if (v != null && v instanceof ArrayList) {
                    ArrayList arrayList4 = (ArrayList)v;
                    arrayList4.addAll(arrayList3);
                    hashtable.put(string, arrayList4);
                    continue;
                }
                hashtable.put(string, arrayList3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void computeBTMData(Hashtable hashtable, NodeAPMComponent nodeAPMComponent) {
        if (hashtable != null) {
            hashtable = this.getCaseInsensitiveDetails(hashtable);
        }
        Set set = hashtable.keySet();
        Iterator iterator = set.iterator();
        long l = this.measurePeriod / 1000L / 60L;
        String string = null;
        Hashtable hashtable2 = null;
        if (nodeAPMComponent.getStatus() == Status.MANAGED_OFFLOAD) {
            string = nodeAPMComponent.getTimeZone();
            hashtable2 = nodeAPMComponent.getCustomPointDetails();
            this.sessionUserMapping = nodeAPMComponent.getSessionUserMapping();
        }
        if (string == null) {
            string = "unknown";
        }
        if (hashtable2 == null) {
            hashtable2 = new Hashtable();
        }
        while (iterator.hasNext()) {
            Hashtable hashtable3;
            Cloneable cloneable;
            Cloneable cloneable2;
            ArrayList arrayList;
            boolean bl = false;
            String string2 = (String)iterator.next();
            Hashtable hashtable4 = (Hashtable)hashtable.get(string2);
            AgentLogger.testLogger.debug("{}  {} levelString ==>   {} [levelTable ==>] {}", new Object[]{this.loggerDispStr, this.entity, string2, hashtable4});
            if (hashtable4 == null || hashtable4.size() <= 0) continue;
            ArrayList arrayList2 = (ArrayList)hashtable4.get("patternData");
            if (string2.equals("SUMMARY_PATTERN")) {
                bl = true;
                arrayList2 = (ArrayList)hashtable4.get("SUMMARY_PATTERN");
            }
            int n = 0;
            if (arrayList2 != null) {
                n = arrayList2.size();
            }
            AgentLogger.testLogger.debug("{} {}  resultSize==>  {}[resultList ==>] {}", new Object[]{this.loggerDispStr, this.entity, n, arrayList2});
            if (n >= 18) {
                arrayList = new ArrayList();
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = 0.0;
                double d8 = 0.0;
                double d9 = 0.0;
                double d10 = 0.0;
                double d11 = 0.0;
                double d12 = 0.0;
                double d13 = 0.0;
                double d14 = 0.0;
                double d15 = 0.0;
                double d16 = 0.0;
                double d17 = 0.0;
                double d18 = 0.0;
                double d19 = 0.0;
                double d20 = 0.0;
                double d21 = 0.0;
                double d22 = -5.0;
                double d23 = (Double)arrayList2.get(0);
                if (d23 == 0.0 && !bl) {
                    AgentLogger.testLogger.debug("{}  Transactions for the Pattern   {} is 0, continuing...", (Object)this.loggerDispStr, (Object)string2);
                    continue;
                }
                int n2 = 18;
                block14: for (int i = 0; i < n; i += 2) {
                    double d24 = (Double)arrayList2.get(i);
                    double d25 = (Double)arrayList2.get(i + 1);
                    double d26 = 0.0;
                    if (d24 > 0.0) {
                        d26 = d25 / d24;
                    }
                    if (i < n2) {
                        arrayList.add(new Double(d24));
                        arrayList.add(new Double(d26));
                    }
                    switch (i) {
                        case 0: {
                            d5 = d24;
                            continue block14;
                        }
                        case 2: {
                            d2 = d24;
                            continue block14;
                        }
                        case 4: {
                            d4 = d24;
                            continue block14;
                        }
                        case 6: {
                            d3 = d24;
                            continue block14;
                        }
                        case 10: {
                            d19 = d24;
                            continue block14;
                        }
                        case 12: {
                            d16 = d24;
                            continue block14;
                        }
                        case 14: {
                            d18 = d24;
                            continue block14;
                        }
                        case 16: {
                            d17 = d24;
                            continue block14;
                        }
                        case 18: {
                            d12 = -5.0;
                            continue block14;
                        }
                        case 20: {
                            d13 = -5.0;
                            continue block14;
                        }
                        case 22: {
                            d14 = -5.0;
                        }
                    }
                }
                if (bl) {
                    string2 = "Summary";
                }
                d15 = d19 - (d16 + d18 + d17);
                d = d5 - (d2 + d4 + d3);
                arrayList.add(new Double(d));
                if (d5 > 0.0) {
                    d6 = Double.parseDouble(formatter.format(d / d5 * 100.0));
                    d7 = Double.parseDouble(formatter.format(d2 / d5 * 100.0));
                    d8 = Double.parseDouble(formatter.format(d4 / d5 * 100.0));
                    d9 = Double.parseDouble(formatter.format(d3 / d5 * 100.0));
                    d10 = Double.parseDouble(formatter.format(d5 / (double)l));
                    d11 = Double.parseDouble(formatter.format(d4 / (double)l));
                    d20 = Double.parseDouble(formatter.format(d19 / (double)l));
                    d21 = Double.parseDouble(formatter.format(d18 / (double)l));
                }
                arrayList.add(new Double(d6));
                arrayList.add(new Double(d7));
                arrayList.add(new Double(d8));
                arrayList.add(new Double(d9));
                if (d5 > 0.0) {
                    d22 = (d5 - d4 - d3 - d2 / 2.0) / d5;
                    if (d22 < 0.0) {
                        d22 = 0.0;
                    }
                    d22 *= 100.0;
                    d22 = Double.parseDouble(formatter.format(d22));
                }
                if (this.numOutputFields > 23) {
                    arrayList.add(new Double(d12));
                    arrayList.add(new Double(d13));
                    arrayList.add(new Double(d14));
                    arrayList.add(new Double(d10));
                    arrayList.add(new Double(d11));
                    arrayList.add(new Double(d15));
                    arrayList.add(new Double(d20));
                    arrayList.add(new Double(d21));
                    if (this.numOutputFields > 31) {
                        arrayList.add(new Double(d22));
                    }
                }
                AgentLogger.testLogger.debug("{} {}  Sent addNewMeasure: {} = {}", new Object[]{this.loggerDispStr, this.entity, string2, arrayList});
                string2 = NodeTransTestBase.decodeUrlString(string2, this.loggerDispStr);
                this.addNewMeasure(string2, arrayList);
            }
            if (bl) continue;
            arrayList = new ArrayList();
            Object v = hashtable4.get("SlowURLLists");
            if (v != null && v instanceof ArrayList) {
                arrayList = (ArrayList)v;
            }
            ArrayList arrayList3 = new ArrayList();
            Object v2 = hashtable4.get("ErrorURLLists");
            if (v2 != null && v2 instanceof ArrayList) {
                arrayList3 = (ArrayList)v2;
            }
            ArrayList arrayList4 = new ArrayList();
            Object v3 = hashtable4.get("AllURLLists");
            if (v3 != null && v3 instanceof ArrayList) {
                arrayList4 = (ArrayList)v3;
            }
            ArrayList arrayList5 = new ArrayList();
            Object v4 = hashtable4.get("StalledURLLists");
            if (v4 != null && v4 instanceof ArrayList) {
                arrayList5 = (ArrayList)v4;
            }
            ArrayList arrayList6 = null;
            Object v5 = hashtable4.get("SlowURLThreadLists");
            if (v5 != null && v5 instanceof ArrayList) {
                arrayList6 = (ArrayList)v5;
            }
            ArrayList arrayList7 = null;
            Object v6 = hashtable4.get("ErrorURLThreadLists");
            if (v6 != null && v6 instanceof ArrayList) {
                arrayList7 = (ArrayList)v6;
            }
            ArrayList arrayList8 = null;
            Object v7 = hashtable4.get("StalledURLThreadLists");
            if (v7 != null && v7 instanceof ArrayList) {
                arrayList8 = (ArrayList)v7;
            }
            ArrayList arrayList9 = null;
            Object v8 = hashtable4.get("HealthyURLThreadLists");
            if (v8 != null && v8 instanceof ArrayList) {
                arrayList9 = (ArrayList)v8;
            }
            if (arrayList6 != null && arrayList6.size() > 0) {
                arrayList.addAll(arrayList6);
            }
            if (arrayList7 != null && arrayList7.size() > 0) {
                arrayList3.addAll(arrayList7);
            }
            if (arrayList8 != null && arrayList8.size() > 0) {
                arrayList5.addAll(arrayList8);
            }
            if (arrayList9 != null && arrayList9.size() > 0) {
                arrayList4.addAll(arrayList9);
            }
            ArrayList arrayList10 = new ArrayList();
            Hashtable hashtable5 = this.formatSource(arrayList, hashtable2, string, true);
            if (hashtable5 != null && hashtable5.size() > 0) {
                cloneable2 = (ArrayList)hashtable5.get("DD");
                ArrayList arrayList11 = (ArrayList)hashtable5.get("EXTRA");
                if (cloneable2 != null && ((ArrayList)cloneable2).size() > 0) {
                    this.slowURLTable.put(string2, cloneable2);
                }
                if (arrayList11 != null && arrayList11.size() > 0) {
                    arrayList10.addAll(arrayList11);
                }
            }
            if ((cloneable2 = this.formatSource(arrayList3, hashtable2, string, true)) != null && ((Hashtable)cloneable2).size() > 0) {
                ArrayList arrayList12 = (ArrayList)((Hashtable)cloneable2).get("DD");
                cloneable = (ArrayList)((Hashtable)cloneable2).get("EXTRA");
                if (arrayList12 != null && arrayList12.size() > 0) {
                    this.errorURLTable.put(string2, arrayList12);
                }
                if (cloneable != null && ((ArrayList)cloneable).size() > 0) {
                    arrayList10.addAll(cloneable);
                }
            }
            if ((hashtable3 = this.formatSource(arrayList4, hashtable2, string, true)) != null && hashtable3.size() > 0) {
                cloneable = (ArrayList)hashtable3.get("DD");
                ArrayList arrayList13 = (ArrayList)hashtable3.get("EXTRA");
                if (cloneable != null && ((ArrayList)cloneable).size() > 0) {
                    this.allURLTable.put(string2, cloneable);
                }
                if (arrayList13 != null && arrayList13.size() > 0) {
                    arrayList10.addAll(arrayList13);
                }
            }
            if ((cloneable = this.formatSource(arrayList5, hashtable2, string, true)) != null && ((Hashtable)cloneable).size() > 0) {
                ArrayList arrayList14 = (ArrayList)((Hashtable)cloneable).get("DD");
                ArrayList arrayList15 = (ArrayList)((Hashtable)cloneable).get("EXTRA");
                if (arrayList14 != null && arrayList14.size() > 0) {
                    this.stalledURLTable.put(string2, arrayList14);
                }
                if (arrayList15 != null && arrayList15.size() > 0) {
                    arrayList10.addAll(arrayList15);
                }
            }
            if (arrayList10 == null || arrayList10.size() <= 0) continue;
            this.externalTable.put(string2, arrayList10);
        }
    }

    private boolean getOffLoadData(NodeAPMComponent nodeAPMComponent) {
        boolean bl = false;
        AgentLogger.testLogger.debug("{} offload JVM GUID :{} - {} & Entity {}", new Object[]{this.loggerDispStr, this.apmComponentGUID, this.NodeID, this.entity});
        UPDManager uPDManager = nodeAPMComponent.getUPDManager();
        if (uPDManager != null) {
            this.sourceTable = uPDManager.getMeasures(false, this.entity);
        }
        if (this.sourceTable != null && this.sourceTable.size() > 0) {
            this.status_code = 200;
            bl = true;
        }
        return bl;
    }

    public void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            if (l < 25L) {
                l = 25L;
            }
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }
}

