/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;

public class OraArchiveTest
extends GenericTest {
    public String oraSid;
    public String userName;
    public String userPasswd;
    private String queryStmt;
    private double defValue = -1.0;
    private double version = 11.0;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private int msgLogCounter = 0;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;

    public static void main(String[] stringArray) {
        OraArchiveTest oraArchiveTest = new OraArchiveTest(stringArray);
        oraArchiveTest.computeMeasures(new Hashtable());
    }

    public OraArchiveTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.userName = this.getValueForParam("username");
        if (this.userName == null) {
            this.userName = this.getValueForParam("user");
        }
        this.userPasswd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        if (this.userName == null || this.userName.equalsIgnoreCase("NULL") || this.userName.equalsIgnoreCase("none")) {
            this.userName = "";
        }
        if (this.userPasswd == null || this.userPasswd.equalsIgnoreCase("NULL") || this.userPasswd.equalsIgnoreCase("none")) {
            this.userPasswd = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        this.setSid(this.oraSid);
        this.isNewDynamicInfoTest = true;
        if (this.isPassive) {
            this.defValue = -5.0;
        }
    }

    public double findVersion() {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        String string = "select version from v$instance";
        double d = 0.0;
        try {
            connection = ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug);
            if (connection == null) {
                this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                return 0.0;
            }
            try {
                statement = connection.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "OraArchiveTest Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                string2 = string2.substring(0, string2.indexOf("."));
                d = Double.parseDouble(string2);
            }
            resultSet.close();
            statement.close();
            connection.close();
            return d;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errorMsg = new String("Exception while executing  OraArchiveTest for target: " + this.targetHost);
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception3) {
                // empty catch block
            }
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        Object object;
        Object object2;
        Cloneable cloneable;
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
            cloneable = new ArrayList();
            cloneable = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (cloneable != null && ((ArrayList)cloneable).size() > 2) {
                int n = (Integer)((ArrayList)cloneable).get(0);
                object2 = (String)((ArrayList)cloneable).get(1);
                if (((String)object2).equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    object = (String)((ArrayList)cloneable).get(2);
                    if (((String)object).equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.version = n;
                this.isInitCheckNeeded = false;
            } else {
                if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + cloneable, "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
            }
        }
        if (this.isDataguardEnabled) {
            cloneable = ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
            if (cloneable == null || ((Hashtable)cloneable).size() == 0) {
                return;
            }
            ArrayList arrayList = (ArrayList)((Hashtable)cloneable).get(this.reportingName + ":" + this.oraSid);
            if (arrayList != null && arrayList.size() > 0) {
                object2 = (String)arrayList.get(2);
                object = (String)arrayList.get(3);
                if (!((String)object2).equalsIgnoreCase("PRIMARY") && ((String)object).equalsIgnoreCase("MOUNTED")) {
                    return;
                }
            } else {
                return;
            }
        }
        Statement statement = null;
        object2 = null;
        if (this.isMultitenantDb && !this.isCDB) {
            if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                this.logToErrorFile("INFO", "OraArchiveTest doesnot run for PDB : ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                this.msgLogCounter = 0;
            }
            ++this.msgLogCounter;
            return;
        }
        System.out.println("[OraArcheiveTest]version=====>" + this.version);
        this.queryStmt = "SELECT DECODE(log_mode,'ARCHIVELOG',100,'NOARCHIVELOG',0,0) AS ARCHIVE_LOG_ON FROM V$database";
        object = null;
        Object var6_8 = null;
        try {
            object = ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug);
            if (object == null) {
                this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                return;
            }
            try {
                statement = object.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "OraArchiveTest Failed to Create Statement reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                if (object != null) {
                    try {
                        object.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                if (object2 != null) {
                    try {
                        object2.close();
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception4) {
                        // empty catch block
                    }
                }
                if (object != null) {
                    try {
                        object.close();
                    }
                    catch (Exception exception5) {
                        // empty catch block
                    }
                }
                return;
            }
            object2 = statement.executeQuery(this.queryStmt);
            if (object2.next()) {
                double d;
                this.defValue = d = object2.getDouble(1);
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(this.defValue));
                this.addNewMeasure(arrayList);
            }
            object2.close();
            statement.close();
            object.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
            if (object2 != null) {
                try {
                    object2.close();
                }
                catch (Exception exception6) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception7) {
                    // empty catch block
                }
            }
            if (object != null) {
                try {
                    object.close();
                }
                catch (Exception exception8) {
                    // empty catch block
                }
            }
            this.errorMsg = new String("Exception while executing OraArchiveTest for target: " + this.targetHost);
        }
        finally {
            if (object2 != null) {
                try {
                    object2.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (object != null) {
                try {
                    object.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

