/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;

public class OraCumLogonTest
extends GenericTest {
    public String username = "";
    public String password = "";
    public String oraSid = "";
    double prevCount = -5.0;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    private int msgLogCounter = 0;

    public OraCumLogonTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(1);
        this.username = this.getValueForParam("username");
        if (this.username == null) {
            this.username = this.getValueForParam("user");
        }
        this.password = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        this.isNewDynamicInfoTest = true;
        if (this.username == null || this.username.equalsIgnoreCase("NULL") || this.username.equalsIgnoreCase("none")) {
            this.username = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        this.setSid(this.oraSid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void computeMeasures(Hashtable hashtable) {
        block44: {
            String string;
            Statement statement;
            Object object;
            Object object2;
            block43: {
                Object object3;
                if (this.isInitCheckNeeded) {
                    this.isDataguardEnabled = ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName);
                    object2 = new ArrayList();
                    object2 = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
                    if (object2 != null && ((ArrayList)object2).size() > 2) {
                        int n = (Integer)((ArrayList)object2).get(0);
                        object = (String)((ArrayList)object2).get(1);
                        if (((String)object).equalsIgnoreCase("true")) {
                            this.isCDB = true;
                        }
                        if (n >= 12) {
                            this.isOracle12c = true;
                            object3 = (String)((ArrayList)object2).get(2);
                            if (((String)object3).equalsIgnoreCase("true")) {
                                this.isMultitenantDb = true;
                            }
                        }
                        this.isInitCheckNeeded = false;
                    } else {
                        if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                            this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + object2, "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                            this.msgLogCounter = 0;
                        }
                        ++this.msgLogCounter;
                    }
                }
                if (this.isDataguardEnabled) {
                    object2 = ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName);
                    if (object2 == null || ((Hashtable)object2).size() == 0) {
                        return;
                    }
                    ArrayList arrayList = (ArrayList)((Hashtable)object2).get(this.reportingName + ":" + this.oraSid);
                    if (arrayList != null && arrayList.size() > 0) {
                        object = (String)arrayList.get(2);
                        object3 = (String)arrayList.get(3);
                        if (!((String)object).equalsIgnoreCase("PRIMARY") && ((String)object3).equalsIgnoreCase("MOUNTED")) {
                            return;
                        }
                    } else {
                        return;
                    }
                }
                object2 = null;
                statement = null;
                object = null;
                object3 = new ArrayList();
                string = "select value as count_in_number from v$sysstat where lower(name) ='logons cumulative'";
                System.out.println("OraCumLogonTest===>       queryStmt \t" + string);
                Hashtable hashtable2 = new Hashtable();
                object2 = this.isMultitenantDb && !this.isCDB ? ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug) : ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug);
                if (object2 != null) break block43;
                this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                try {
                    this.closeRset((ResultSet)object);
                    this.closeStmt(statement);
                    this.closeConn((Connection)object2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return;
            }
            try {
                statement = object2.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "OraCumLogonTest Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                this.closeConn((Connection)object2);
                try {
                    this.closeRset((ResultSet)object);
                    this.closeStmt(statement);
                    this.closeConn((Connection)object2);
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
                return;
            }
            object = statement.executeQuery(string);
            String string2 = "";
            String string3 = "";
            double d = 0.0;
            double d2 = 0.0;
            ArrayList arrayList = new ArrayList();
            if (object == null) {
                System.out.println("OraCumLogonTest===>      rset==null     ");
            }
            while (object.next()) {
                string3 = object.getString("count_in_number");
                System.out.println("OraCumLogonTest===>      tmpCount   \t" + string3);
            }
            this.closeRset((ResultSet)object);
            this.closeStmt(statement);
            this.closeConn((Connection)object2);
            try {
                if (string3 == null || string3.trim().length() == 0) {
                    d = -5.0;
                    this.prevCount = -5.0;
                } else {
                    try {
                        d = Double.parseDouble(string3);
                    }
                    catch (Exception exception) {
                        d = -5.0;
                    }
                    d2 = this.prevCount >= 0.0 && d >= this.prevCount ? d - this.prevCount : -5.0;
                }
                if (d2 > 0.0) {
                    d2 /= this.timeSinceLastTest;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                d = -5.0;
                this.prevCount = -5.0;
            }
            this.prevCount = d;
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            arrayList2.add(new Double(d2));
            this.addNewMeasure(arrayList2);
            try {
                this.closeRset((ResultSet)object);
                this.closeStmt(statement);
                this.closeConn((Connection)object2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block44;
            catch (SQLException sQLException) {
                this.logToErrorFile("ERROR : [OraCumLogonTest] compute Measure()", "Could not connect to the database targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, sQLException.toString());
                System.out.println("OraCumLogonTest==>  Could not connect to the database: " + sQLException.getMessage());
                try {
                    this.closeRset((ResultSet)object);
                    this.closeStmt(statement);
                    this.closeConn((Connection)object2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break block44;
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR : [OraCumLogonTest] compute Measure()", "Exception while uploading targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                {
                    catch (Throwable throwable) {
                        try {
                            this.closeRset((ResultSet)object);
                            this.closeStmt(statement);
                            this.closeConn((Connection)object2);
                        }
                        catch (Exception exception3) {
                            exception3.printStackTrace();
                        }
                        throw throwable;
                    }
                }
                try {
                    this.closeRset((ResultSet)object);
                    this.closeStmt(statement);
                    this.closeConn((Connection)object2);
                }
                catch (Exception exception4) {
                    exception4.printStackTrace();
                }
            }
        }
    }

    void closeRset(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            resultSet = null;
        }
        catch (Exception exception) {
            resultSet = null;
        }
    }

    void closeStmt(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
            statement = null;
        }
        catch (Exception exception) {
            statement = null;
        }
    }

    void closeConn(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
            connection = null;
        }
        catch (Exception exception) {
            connection = null;
        }
    }

    public static void main(String[] stringArray) {
        OraCumLogonTest oraCumLogonTest = new OraCumLogonTest(stringArray);
        oraCumLogonTest.computeMeasures(new Hashtable());
    }
}

