/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;

public class OraFlashAreaTest
extends GenericTest {
    public String username = "";
    public String password = "";
    public String oraSid = "";
    private int checkCt = 0;
    private static int maxCheckCt = 24;
    private static final int i_measureCount = 5;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private int msgLogCounter = 0;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;

    public OraFlashAreaTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(5);
        this.username = this.getValueForParam("username");
        if (this.username == null) {
            this.username = this.getValueForParam("user");
        }
        this.password = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        if (this.username == null || this.username.equalsIgnoreCase("NULL") || this.username.equalsIgnoreCase("none")) {
            this.username = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        this.setSid(this.oraSid);
        this.isNewDynamicInfoTest = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        Object object;
        Object object2;
        Object object3;
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName);
            object3 = new ArrayList();
            object3 = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (object3 != null && ((ArrayList)object3).size() > 2) {
                int n = (Integer)((ArrayList)object3).get(0);
                object2 = (String)((ArrayList)object3).get(1);
                if (((String)object2).equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    object = (String)((ArrayList)object3).get(2);
                    if (((String)object).equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isInitCheckNeeded = false;
            } else {
                if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + object3, "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
            }
        }
        if (this.isDataguardEnabled) {
            object3 = ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName);
            if (object3 == null || ((Hashtable)object3).size() == 0) {
                return;
            }
            ArrayList arrayList = (ArrayList)((Hashtable)object3).get(this.reportingName + ":" + this.oraSid);
            if (arrayList != null && arrayList.size() > 0) {
                object2 = (String)arrayList.get(2);
                object = (String)arrayList.get(3);
                if (!((String)object2).equalsIgnoreCase("PRIMARY") && ((String)object).equalsIgnoreCase("MOUNTED")) {
                    return;
                }
            } else {
                return;
            }
        }
        object3 = null;
        Statement statement = null;
        object2 = null;
        object = new ArrayList();
        try {
            if (this.isMultitenantDb && !this.isCDB) {
                if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO", "OraFlashAreaTest doesnot run for PDB : ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
                return;
            }
            String string = "select name, space_limit/1024/1024 space_limit_mb, space_used/1024/1024 space_used_mb from v$recovery_file_dest";
            object3 = ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug);
            if (object3 == null) {
                this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                return;
            }
            try {
                statement = object3.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "OraFlashAreaTest Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                try {
                    if (object3 != null) {
                        object3.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    if (object2 != null) {
                        object2.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    if (object3 != null) {
                        object3.close();
                    }
                }
                catch (Exception exception3) {
                    exception3.printStackTrace();
                }
                return;
            }
            object2 = statement.executeQuery(string);
            while (object2.next()) {
                String string2 = object2.getString(1);
                double d = object2.getDouble(2);
                double d2 = object2.getDouble(3);
                double d3 = d2 / d * 100.0;
                double d4 = 100.0 - d3;
                double d5 = -5.0;
                object = new ArrayList<Double>();
                ((ArrayList)object).add(new Double(d2));
                ((ArrayList)object).add(new Double(d));
                ((ArrayList)object).add(new Double(d3));
                ((ArrayList)object).add(new Double(d4));
                ((ArrayList)object).add(new Double(d5));
                this.addNewMeasure(string2, (ArrayList)object);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "OraFlashAreaTest computeMeasures() targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
            System.out.println("Exception Occured in OraFlashAreaTest.computeMeasures():" + exception.toString());
        }
        finally {
            try {
                if (object2 != null) {
                    object2.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (object3 != null) {
                    object3.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        OraFlashAreaTest oraFlashAreaTest = new OraFlashAreaTest(stringArray);
        oraFlashAreaTest.computeMeasures(new Hashtable());
    }
}

