/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;

public class OraIndexFragHelper
extends EgTest {
    boolean executionFlag = false;
    Connection conn = null;
    Statement csproc = null;
    boolean debug = false;

    public boolean setConnection(String string, String string2, String string3) {
        try {
            Properties properties = new Properties();
            properties.put("user", string2);
            properties.put("password", string3);
            this.conn = ConnectionManager.newConnection(this.entity, "oracle.jdbc.driver.OracleDriver", string, properties, this.debug);
            if (this.conn == null) {
                this.logToErrorFile("Error  :", this.entity, "Connection is null for targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " connString:" + string);
                this.releaseConnection();
                return false;
            }
            if (this.debug) {
                System.out.println("OraIndexFragHelper: Database Connection Established Successfully");
            }
            this.csproc = this.conn.createStatement();
            return true;
        }
        catch (Exception exception) {
            if (this.debug) {
                System.out.println("OraIndexFragHelper: Database Connection Failed");
            }
            this.logToErrorFile("OraIndexFragHelper", " Failed to establish Connection for target " + this.targetHost, " " + exception.toString());
            exception.printStackTrace();
            this.releaseConnection();
            return false;
        }
    }

    public void releaseConnection() {
        if (this.debug) {
            System.out.println("OraIndexFragHelper: release Connection called ");
        }
        if (this.csproc != null) {
            try {
                this.csproc.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.csproc.close();
            }
            catch (Exception exception) {
                this.csproc = null;
            }
        }
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (Exception exception) {
                this.conn = null;
            }
        }
    }

    public void executeThread(String string, String string2, String string3, long l, double d, double d2) {
        this.executeThread(string, string2, string3, l, d, d2, true);
    }

    public void executeThread(String string, String string2, String string3, long l, double d, double d2, boolean bl) {
        RunThread runThread = new RunThread(string, string2, string3, d, d2);
        if (this.debug) {
            System.out.println("OraIndexFragHelper: executeThread RunThread created for schema " + string + " objName " + string2);
        }
        try {
            if (this.debug) {
                System.out.println("OraIndexFragHelper: executeThread Going to create  monitorThread  for schema " + string + " objName " + string2);
            }
            this.monitorThread(runThread, string2, l);
        }
        catch (Exception exception) {
            if (this.debug) {
                System.out.println("OraIndexFragHelper: Exception while creating monitorThread for schema " + string + " objName " + string2);
            }
            exception.printStackTrace();
        }
        if (!this.executionFlag) {
            if (this.debug) {
                System.out.println("OraIndexFragHelper: Execution flag is flase for  for schema " + string + " objName " + string2);
            }
            this.logToErrorFile("OraIndexFragHelper", " Failed to estimate for schema " + string + " for Object ", string2);
        }
    }

    protected boolean monitorThread(RunThread runThread, String string, long l) throws Exception {
        runThread.start();
        long l2 = System.currentTimeMillis();
        long l3 = 10000L;
        try {
            Thread.sleep(l3);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        long l4 = System.currentTimeMillis() - l2;
        while (runThread.isAlive() && l4 < l) {
            if (this.debug) {
                System.out.println("OraIndexFragHelper: Execution for " + string + " still alive" + " " + new Date());
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                if (this.debug) {
                    System.out.println("OraIndexFragHelper: Exception  for " + string + " still alive" + " " + new Date());
                }
                interruptedException.printStackTrace();
            }
            l4 = System.currentTimeMillis() - l2;
        }
        boolean bl = false;
        String string2 = "";
        if (runThread.isAlive()) {
            if (runThread.status == -1) {
                bl = true;
                string2 = " timed out with exception.";
                this.executionFlag = false;
            } else {
                bl = true;
                string2 = " timed out.";
            }
        } else {
            if (this.debug) {
                System.out.println("Execution for " + string + " completed successfully in " + l4 + " ms.");
            }
            if (runThread.status == 1) {
                if (this.debug) {
                    System.out.println("OraIndexFragHelper: Exception  for " + string + " Success" + " " + new Date());
                }
            } else if (runThread.status == -1) {
                bl = true;
                string2 = " got done with exception.";
                if (this.debug) {
                    System.out.println("OraIndexFragHelper: Exception  for " + string + "  " + string2 + " " + new Date());
                }
            } else {
                bl = true;
                string2 = " aborted without exception";
                if (this.debug) {
                    System.out.println("OraIndexFragHelper: Exception  for " + string + "  " + string2 + " " + new Date());
                }
            }
        }
        if (bl) {
            this.executionFlag = false;
            try {
                if (this.csproc != null) {
                    if (this.debug) {
                        System.out.println("OraIndexFragHelper: Before calling calleaable statement.cancel " + new Date());
                    }
                    this.csproc.cancel();
                    if (this.debug) {
                        System.out.println("OraIndexFragHelper: After  calling calleaable statement.cancel " + new Date());
                    }
                }
            }
            catch (Exception exception) {
                if (this.debug) {
                    System.out.println("OraIndexFragHelper: Exception  calling calleaable statement.cancel   " + new Date());
                }
                exception.printStackTrace();
            }
            runThread.interrupt();
            Thread.currentThread();
            Thread.yield();
            System.out.println("Error: Thread " + string2);
            this.logToErrorFile("ERROR", this.entity, "Object " + string + string2);
            throw new Exception("Thread " + string2);
        }
        this.executionFlag = true;
        return this.executionFlag;
    }

    public ArrayList getListOfTables(String string) {
        if (this.conn == null) {
            this.logToErrorFile("ERROR", this.entity, " DB Connetion Object is null ");
            return null;
        }
        Statement statement = null;
        ResultSet resultSet = null;
        String string2 = "select table_name from dba_tables where owner='" + string + "'";
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string3 = "";
            statement = this.conn.createStatement();
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                string3 = resultSet.getString(1);
                arrayList.add(string3);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("[OraIndexFragTest] compute Measure()", "Exception while getting table Names for schema " + string, exception.toString());
            arrayList = null;
        }
        this.closeRS(resultSet);
        this.closeStmt(statement);
        return arrayList;
    }

    private void closeRS(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                resultSet = null;
            }
        }
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                statement = null;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                statement = null;
            }
        }
    }

    public ArrayList[] getFragmentationStatistics(String string, String string2, double d, double d2, boolean bl) {
        if (this.conn == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        ArrayList[] arrayListArray = new ArrayList[]{null, null, null};
        int n = 0;
        int n2 = 0;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.conn.createStatement();
            if (this.debug) {
                System.out.println("OraIndexFragHelper: getFragmentationStatistics method Before executeQuery" + new Date());
                System.out.println("OraIndexFragHelper: getFragmentationStatistics method .Query  is " + string);
            }
            resultSet = statement.executeQuery(string);
            if (this.debug) {
                System.out.println("OraIndexFragHelper: getFragmentationStatistics method After executeQuery" + new Date());
            }
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                String string4 = resultSet.getString(2);
                String string5 = resultSet.getString(3);
                String string6 = resultSet.getString(4);
                double d3 = Double.parseDouble(string6);
                if (string3 == null) {
                    string3 = "-";
                } else if (string3.length() > 64) {
                    string3 = string3.substring(0, 63);
                }
                if (string4 == null) {
                    string4 = "-";
                } else if (string4.length() > 64) {
                    string4 = string4.substring(0, 63);
                }
                if (string5 == null) {
                    string5 = "-";
                } else if (string5.length() > 64) {
                    string5 = string5.substring(0, 63);
                }
                if (!bl) {
                    string5 = "-";
                }
                String string7 = string3 + string2 + string4 + string2 + string5 + string2 + Math.round(d3);
                if (d3 >= d && d3 < d2) {
                    ++n;
                    arrayList.add(string7);
                    continue;
                }
                if (!(d3 >= d2)) continue;
                ++n2;
                arrayList2.add(string7);
            }
            arrayList3.add(new Double(n));
            arrayList3.add(new Double(n2));
            arrayListArray[0] = arrayList3;
            arrayListArray[1] = arrayList;
            arrayListArray[2] = arrayList2;
            this.closeRS(resultSet);
            this.closeStmt(statement);
            return arrayListArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.closeRS(resultSet);
            this.closeStmt(statement);
            return null;
        }
    }

    public Connection checkIndexFragConnection(String string, String string2, Properties properties) {
        Connection connection = null;
        try {
            Class.forName(string);
            connection = DriverManager.getConnection(string2, properties);
        }
        catch (Exception exception) {
            return null;
        }
        return connection;
    }

    class RunThread
    extends Thread {
        protected static final int UNSET = 0;
        protected static final int SUCCESS = 1;
        protected static final int ERR = -1;
        protected int status = 0;
        String schema = "";
        String object = "";
        String factor = "";
        double highlimit = 30.0;
        double veryhighlimit = 50.0;
        boolean includeIndexFrag = true;

        RunThread(String string, String string2, String string3, double d, double d2) {
            this.schema = string;
            this.object = string2;
            this.factor = string3;
            this.highlimit = d;
            this.veryhighlimit = d2;
        }

        RunThread(String string, String string2, String string3, double d, double d2, boolean bl) {
            this.schema = string;
            this.object = string2;
            this.factor = string3;
            this.highlimit = d;
            this.veryhighlimit = d2;
            this.includeIndexFrag = bl;
        }

        public void run() {
            try {
                System.out.println("Ima herererere ");
                if (OraIndexFragHelper.this.conn == null) {
                    System.out.println("OraIndexFragHelper:RunThread:run() method connection is null ");
                    this.status = -1;
                    return;
                }
                if (OraIndexFragHelper.this.debug) {
                    System.out.println("OraIndexFragHelper: Before  before calling calleaable statement.Exeuctee   " + this.object + " " + new Date());
                }
                double d = 0.0;
                try {
                    d = Double.parseDouble(this.factor);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.out.println("OraIndexFragHelper: Before  before calling calleaable statement.Exeuctee   " + this.object + " " + new Date());
                if (d > 0.0) {
                    if (!this.includeIndexFrag) {
                        OraIndexFragHelper.this.csproc.executeUpdate("{call DBMS_STATS.gather_table_stats('" + this.schema.toUpperCase() + "','" + this.object.toUpperCase() + "',ESTIMATE_PERCENT =>" + this.factor + ",cascade=> FALSE)}");
                    } else {
                        OraIndexFragHelper.this.csproc.executeUpdate("{call DBMS_STATS.gather_table_stats('" + this.schema.toUpperCase() + "','" + this.object.toUpperCase() + "',ESTIMATE_PERCENT =>" + this.factor + ")}");
                    }
                } else if (!this.includeIndexFrag) {
                    OraIndexFragHelper.this.csproc.executeUpdate("{call DBMS_STATS.gather_table_stats('" + this.schema.toUpperCase() + "','" + this.object.toUpperCase() + "',ESTIMATE_PERCENT =>DBMS_STATS.AUTO_SAMPLE_SIZE,cascade=> FALSE)}");
                } else {
                    OraIndexFragHelper.this.csproc.executeUpdate("{call DBMS_STATS.gather_table_stats('" + this.schema.toUpperCase() + "','" + this.object.toUpperCase() + "',ESTIMATE_PERCENT =>DBMS_STATS.AUTO_SAMPLE_SIZE)}");
                }
                System.out.println("OraIndexFragHelper: AFter  calling calleaable statement.Exeuctee   " + this.object + " " + new Date());
                if (OraIndexFragHelper.this.debug) {
                    System.out.println("OraIndexFragHelper: AFter  calling calleaable statement.Exeuctee   " + this.object + " " + new Date());
                }
                this.status = 1;
            }
            catch (Exception exception) {
                OraIndexFragHelper.this.logToErrorFile("ERROR", OraIndexFragHelper.this.entity, "Exception while executing index fragmentation check for object " + this.object + "  " + exception.toString());
                exception.printStackTrace();
                this.status = -1;
            }
        }
    }
}

