/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;

public class OraLatchTest
extends GenericTest {
    private String oraSid;
    private String userName;
    private String userPasswd;
    private static String queryStmt = "SELECT name,gets,misses,immediate_gets,immediate_misses  FROM v$latch WHERE name IN ('redo allocation','redo copy')";
    private Hashtable prevGets = new Hashtable();
    private Hashtable prevMisses = new Hashtable();
    private Hashtable prevImmGets = new Hashtable();
    private Hashtable prevImmMisses = new Hashtable();
    private double defValue = -5.0;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private int msgLogCounter = 0;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    public boolean isOracleOnCloud = false;

    public static void main(String[] stringArray) {
        OraLatchTest oraLatchTest = new OraLatchTest(stringArray);
        oraLatchTest.computeMeasures(new Hashtable());
    }

    public OraLatchTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.userName = this.getValueForParam("username");
        if (this.userName == null) {
            this.userName = this.getValueForParam("user");
        }
        this.userPasswd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("oracle_sid");
        }
        String string = this.getValueForParam("cloud_hosted");
        if (this.userName == null || this.userName.equalsIgnoreCase("NULL") || this.userName.equalsIgnoreCase("none")) {
            this.userName = "";
        }
        if (this.userPasswd == null || this.userPasswd.equalsIgnoreCase("NULL") || this.userPasswd.equalsIgnoreCase("none")) {
            this.userPasswd = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        if (string != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes") || string.trim().equalsIgnoreCase("y"))) {
            this.isOracleOnCloud = true;
        }
        if (!this.isOracleOnCloud) {
            this.setSid(this.oraSid);
        }
        this.isNewDynamicInfoTest = true;
        if (this.isPassive) {
            this.defValue = -5.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        String string;
        Object object;
        Object object2;
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
            object2 = new ArrayList();
            object2 = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (object2 != null && ((ArrayList)object2).size() > 2) {
                int n = (Integer)((ArrayList)object2).get(0);
                object = (String)((ArrayList)object2).get(1);
                if (((String)object).equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    string = (String)((ArrayList)object2).get(2);
                    if (string.equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isInitCheckNeeded = false;
            } else {
                if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + object2, " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
            }
        }
        if (this.isDataguardEnabled) {
            object2 = ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
            if (object2 == null || ((Hashtable)object2).size() == 0) {
                return;
            }
            ArrayList arrayList = (ArrayList)((Hashtable)object2).get(this.reportingName + ":" + this.oraSid);
            if (arrayList != null && arrayList.size() > 0) {
                object = (String)arrayList.get(2);
                string = (String)arrayList.get(3);
                if (!((String)object).equalsIgnoreCase("PRIMARY") && string.equalsIgnoreCase("MOUNTED")) {
                    return;
                }
            } else {
                return;
            }
        }
        object2 = null;
        Statement statement = null;
        if (this.isMultitenantDb && !this.isCDB) {
            if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                this.logToErrorFile("INFO", "OraLatchTest doesnot run for PDB : ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                this.msgLogCounter = 0;
            }
            ++this.msgLogCounter;
            return;
        }
        object = null;
        try {
            object = ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug);
            if (object == null) {
                this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                return;
            }
            try {
                statement = object.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "OraLatchTest Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                try {
                    if (object != null) {
                        object.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (object2 != null) {
                    try {
                        object2.close();
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception4) {
                        // empty catch block
                    }
                }
                if (object != null) {
                    try {
                        object.close();
                    }
                    catch (Exception exception5) {
                        // empty catch block
                    }
                }
                return;
            }
            object2 = statement.executeQuery(queryStmt);
            while (object2.next()) {
                double d;
                Double d2;
                string = object2.getString(1);
                double d3 = object2.getDouble(2);
                double d4 = object2.getDouble(3);
                double d5 = object2.getDouble(4);
                double d6 = object2.getDouble(5);
                double d7 = -5.0;
                double d8 = -5.0;
                double d9 = -5.0;
                double d10 = -5.0;
                if (this.prevGets.containsKey(string)) {
                    d2 = (Double)this.prevGets.get(string);
                    d = d2;
                    d7 = d3 - d;
                    double d11 = d7 = d7 < 0.0 ? -5.0 : d7;
                }
                if (this.prevMisses.containsKey(string)) {
                    d2 = (Double)this.prevMisses.get(string);
                    d = d2;
                    d8 = d4 - d;
                    double d12 = d8 = d8 < 0.0 ? -5.0 : d8;
                }
                if (this.prevImmGets.containsKey(string)) {
                    d2 = (Double)this.prevImmGets.get(string);
                    d = d2;
                    d9 = d5 - d;
                    double d13 = d9 = d9 < 0.0 ? -5.0 : d9;
                }
                if (this.prevImmMisses.containsKey(string)) {
                    d2 = (Double)this.prevImmMisses.get(string);
                    d = d2;
                    d10 = d6 - d;
                    d10 = d10 < 0.0 ? -5.0 : d10;
                }
                double d14 = this.defValue;
                if (d7 >= 0.0 && d8 >= 0.0) {
                    d14 = d7 > 0.0 ? d8 * 100.0 / d7 : 0.0;
                }
                double d15 = this.defValue;
                if (d9 >= 0.0 && d10 >= 0.0) {
                    double d16 = d9 + d10;
                    d15 = d16 > 0.0 ? d10 * 100.0 / d16 : 0.0;
                }
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(d14));
                arrayList.add(new Double(d15));
                this.addNewMeasure(string, arrayList);
                this.prevGets.put(string, new Double(d3));
                this.prevMisses.put(string, new Double(d4));
                this.prevImmGets.put(string, new Double(d5));
                this.prevImmMisses.put(string, new Double(d6));
            }
            object2.close();
            statement.close();
            object.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logToErrorFile("Error  :", this.entity, "ComputeMeasures() exception while uploading targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
            if (object2 != null) {
                try {
                    object2.close();
                }
                catch (Exception exception6) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception7) {
                    // empty catch block
                }
            }
            if (object != null) {
                try {
                    object.close();
                }
                catch (Exception exception8) {
                    // empty catch block
                }
            }
            this.prevGets = new Hashtable();
            this.prevMisses = new Hashtable();
            this.prevImmGets = new Hashtable();
            this.prevImmMisses = new Hashtable();
            this.errorMsg = new String("Exception while executing  OraLatchTest for target: " + this.targetHost);
        }
        finally {
            if (object2 != null) {
                try {
                    object2.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (object != null) {
                try {
                    object.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

