/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class OraObjTest
extends GenericTest {
    private String oraSid;
    private String userName;
    private String userPasswd;
    private static String queryStmt = "SELECT OWNER, OBJECT_NAME, OBJECT_TYPE FROM DBA_OBJECTS WHERE UPPER(OWNER)";
    private static String inQuery = " IN (";
    private static String eqQuery = "=";
    private static String restStmt = " AND STATUS <>'VALID'";
    private static String queryStmt2 = "SELECT OWNER, OBJECT_NAME, OBJECT_TYPE, TO_CHAR(LAST_DDL_TIME,'MM:DD:YYYY HH:MI:SS')FROM DBA_OBJECTS WHERE LAST_DDL_TIME>sysdate-";
    private static String restStmt2 = " AND UPPER(OWNER)";
    public ArrayList invalidOwner = new ArrayList();
    public ArrayList invalidName = new ArrayList();
    public ArrayList invalidType = new ArrayList();
    public ArrayList modOwner = new ArrayList();
    public ArrayList modName = new ArrayList();
    public ArrayList modType = new ArrayList();
    public ArrayList modTime = new ArrayList();
    private long lastTime = -1L;
    private String[] acctList = new String[0];
    private long defValue = -1L;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private int msgLogCounter = 0;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;

    public static void main(String[] stringArray) {
        OraObjTest oraObjTest = new OraObjTest(stringArray);
        oraObjTest.computeMeasures(new Hashtable());
    }

    public OraObjTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.userName = this.getValueForParam("username");
        if (this.userName == null) {
            this.userName = this.getValueForParam("user");
        }
        this.userPasswd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        String string = this.getValueForParam("accounts");
        if (string != null || string.trim().length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            this.acctList = new String[stringTokenizer.countTokens()];
            for (int i = 0; i < this.acctList.length; ++i) {
                this.acctList[i] = stringTokenizer.nextToken();
            }
        }
        if (this.userName == null || this.userName.equalsIgnoreCase("NULL") || this.userName.equalsIgnoreCase("none")) {
            this.userName = "";
        }
        if (this.userPasswd == null || this.userPasswd.equalsIgnoreCase("NULL") || this.userPasswd.equalsIgnoreCase("none")) {
            this.userPasswd = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        this.setSid(this.oraSid);
        this.isNewDynamicInfoTest = true;
        if (this.isPassive) {
            this.defValue = -5L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeMeasures(Hashtable hashtable) {
        String string;
        Object object;
        Object object2;
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
            object2 = new ArrayList();
            object2 = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (object2 != null && ((ArrayList)object2).size() > 2) {
                int n = (Integer)((ArrayList)object2).get(0);
                object = (String)((ArrayList)object2).get(1);
                if (((String)object).equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    string = (String)((ArrayList)object2).get(2);
                    if (string.equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isInitCheckNeeded = false;
            } else {
                if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + object2, " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
            }
        }
        if (this.isDataguardEnabled) {
            object2 = ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
            if (object2 == null) return;
            if (((Hashtable)object2).size() == 0) {
                return;
            }
            ArrayList arrayList = (ArrayList)((Hashtable)object2).get(this.reportingName + ":" + this.oraSid);
            if (arrayList == null) return;
            if (arrayList.size() <= 0) return;
            object = (String)arrayList.get(2);
            string = (String)arrayList.get(3);
            if (!((String)object).equalsIgnoreCase("PRIMARY") && string.equalsIgnoreCase("MOUNTED")) {
                return;
            }
        }
        object2 = null;
        Statement statement = null;
        object = null;
        try {
            int n;
            if (this.acctList == null || this.acctList.length == 0) {
                this.logToErrorFile("INFO", "OraObjTest account list is null : ", this.targetHost);
                return;
            }
            if (this.isMultitenantDb) {
                if (this.isCDB) {
                    if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                        this.logToErrorFile("INFO", "OraObjTest doesnot run for CDB : ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                        this.msgLogCounter = 0;
                    }
                    ++this.msgLogCounter;
                    return;
                }
                object = ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug);
            } else {
                object = ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug);
            }
            if (object == null) {
                this.logToErrorFile("ERROR", this.entity, "Oracle connection  is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                return;
            }
            try {
                statement = object.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "OraObjTest Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                if (object != null) {
                    object.close();
                }
                if (object2 != null) {
                    try {
                        object2.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
                if (object == null) return;
                try {
                    object.close();
                    return;
                }
                catch (Exception exception4) {
                    // empty catch block
                }
                return;
            }
            string = queryStmt;
            if (this.acctList.length == 1) {
                string = string + eqQuery;
                string = string + "'" + this.acctList[0].toUpperCase() + "' ";
            } else {
                string = string + inQuery;
                for (int i = 0; i < this.acctList.length; ++i) {
                    string = string + "'" + this.acctList[i].toUpperCase() + "'";
                    if (i >= this.acctList.length - 1) continue;
                    string = string + ",";
                }
                string = string + ")";
            }
            string = string + restStmt;
            System.out.println("QUERY1 " + string);
            object2 = statement.executeQuery(string);
            this.invalidOwner = new ArrayList();
            this.invalidName = new ArrayList();
            this.invalidType = new ArrayList();
            while (object2.next()) {
                String string2 = object2.getString(1);
                String string3 = object2.getString(2);
                String string4 = object2.getString(3);
                this.invalidOwner.add(string2);
                this.invalidName.add(string3);
                this.invalidType.add(string4);
            }
            object2.close();
            long l = -1L;
            long l2 = System.currentTimeMillis();
            double d = 0.0;
            if (this.lastTime > 0L) {
                d = (l2 - this.lastTime) / 1000L;
            }
            if (this.lastTime > 0L && d > 0.0) {
                string = queryStmt2 + "(" + d + "/86400)" + restStmt2;
                if (this.acctList.length == 1) {
                    string = string + "='" + this.acctList[0].toUpperCase() + "'";
                } else {
                    string = string + inQuery;
                    for (int i = 0; i < this.acctList.length; ++i) {
                        string = string + "'" + this.acctList[i].toUpperCase() + "'";
                        if (i >= this.acctList.length - 1) continue;
                        string = string + ",";
                    }
                    string = string + ")";
                }
                System.out.println("QUERY2 " + string);
                this.modOwner = new ArrayList();
                this.modName = new ArrayList();
                this.modType = new ArrayList();
                this.modTime = new ArrayList();
                object2 = statement.executeQuery(string);
                while (object2.next()) {
                    String string5 = object2.getString(1);
                    String string6 = object2.getString(2);
                    String string7 = object2.getString(3);
                    String string8 = object2.getString(4);
                    this.modOwner.add(string5);
                    this.modName.add(string6);
                    this.modType.add(string7);
                    this.modTime.add(string8);
                }
                object2.close();
            }
            this.lastTime = l2;
            statement.close();
            object.close();
            int[] nArray = new int[this.acctList.length];
            for (int i = 0; i < this.acctList.length; ++i) {
                int n2 = 0;
                for (int j = 0; j < this.invalidOwner.size(); ++j) {
                    String string9 = (String)this.invalidOwner.get(j);
                    if (!string9.equalsIgnoreCase(this.acctList[i])) continue;
                    ++n2;
                }
                nArray[i] = n2;
            }
            int[] nArray2 = new int[this.acctList.length];
            for (n = 0; n < this.acctList.length; ++n) {
                int n3 = 0;
                for (int i = 0; i < this.modOwner.size(); ++i) {
                    String string10 = (String)this.modOwner.get(i);
                    if (!string10.equalsIgnoreCase(this.acctList[n])) continue;
                    ++n3;
                }
                nArray2[n] = n3;
            }
            n = 0;
            while (n < this.acctList.length) {
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(nArray[n]));
                arrayList.add(new Double(nArray2[n]));
                this.addNewMeasure(this.acctList[n], arrayList);
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
            if (object2 != null) {
                try {
                    object2.close();
                }
                catch (Exception exception5) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception6) {
                    // empty catch block
                }
            }
            if (object != null) {
                try {
                    object.close();
                }
                catch (Exception exception7) {
                    // empty catch block
                }
            }
            this.lastTime = -1L;
            this.errorMsg = new String("Exception while executing  OraObjTest for target: " + this.targetHost);
            return;
        }
        finally {
            if (object2 != null) {
                try {
                    object2.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (object != null) {
                try {
                    object.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

