/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;

public class OraParamsTest
extends GenericTest {
    public String oraSid;
    public String userName;
    public String userPasswd;
    private String queryStmt;
    private double defValue = -1.0;
    public boolean isOracle12c = false;
    public boolean isCDB = false;
    private int msgLogCounter = 0;
    public boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;

    public static void main(String[] stringArray) {
        OraParamsTest oraParamsTest = new OraParamsTest(stringArray);
        oraParamsTest.computeMeasures(new Hashtable());
    }

    public OraParamsTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(1);
        this.userName = this.getValueForParam("username");
        if (this.userName == null) {
            this.userName = this.getValueForParam("user");
        }
        this.userPasswd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        if (this.userName == null || this.userName.equalsIgnoreCase("NULL") || this.userName.equalsIgnoreCase("none")) {
            this.userName = "";
        }
        if (this.userPasswd == null || this.userPasswd.equalsIgnoreCase("NULL") || this.userPasswd.equalsIgnoreCase("none")) {
            this.userPasswd = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        this.setSid(this.oraSid);
        this.queryStmt = "SELECT COUNT(*) FROM V$PARAMETER WHERE ISDEFAULT='FALSE'";
        this.isNewDynamicInfoTest = true;
        if (this.isPassive) {
            this.defValue = -5.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeMeasures(Hashtable hashtable) {
        Object object;
        Object object2;
        Cloneable cloneable;
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
            cloneable = new ArrayList();
            cloneable = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (cloneable != null && ((ArrayList)cloneable).size() > 2) {
                int n = (Integer)((ArrayList)cloneable).get(0);
                object2 = (String)((ArrayList)cloneable).get(1);
                if (((String)object2).equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    object = (String)((ArrayList)cloneable).get(2);
                    if (((String)object).equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isInitCheckNeeded = false;
            } else {
                if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + cloneable, " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
            }
        }
        if (this.isDataguardEnabled) {
            cloneable = ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
            if (cloneable == null) return;
            if (((Hashtable)cloneable).size() == 0) {
                return;
            }
            ArrayList arrayList = (ArrayList)((Hashtable)cloneable).get(this.reportingName + ":" + this.oraSid);
            if (arrayList == null) return;
            if (arrayList.size() <= 0) return;
            object2 = (String)arrayList.get(2);
            object = (String)arrayList.get(3);
            if (!((String)object2).equalsIgnoreCase("PRIMARY") && ((String)object).equalsIgnoreCase("MOUNTED")) {
                return;
            }
        }
        Connection connection = null;
        object2 = null;
        object = null;
        Object var6_8 = null;
        try {
            if (this.isMultitenantDb) {
                if (this.isCDB) {
                    if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                        this.logToErrorFile("INFO", "OraParamsTest doesnot run for CDB : ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                        this.msgLogCounter = 0;
                    }
                    ++this.msgLogCounter;
                    return;
                }
                connection = ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug);
            } else {
                connection = ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug);
            }
            if (connection == null) {
                this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                return;
            }
            try {
                object2 = connection.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "OraParamsTest Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (object != null) {
                    try {
                        object.close();
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
                if (object2 != null) {
                    try {
                        object2.close();
                    }
                    catch (Exception exception4) {
                        // empty catch block
                    }
                }
                if (connection == null) return;
                try {
                    connection.close();
                    return;
                }
                catch (Exception exception5) {
                    // empty catch block
                }
                return;
            }
            object = object2.executeQuery(this.queryStmt);
            while (object.next()) {
                double d;
                ArrayList<Double> arrayList = new ArrayList<Double>();
                double d2 = d = object.getDouble(1);
                arrayList.add(new Double(d2));
                this.addNewMeasure(arrayList);
            }
            object.close();
            object2.close();
            connection.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
            if (object != null) {
                try {
                    object.close();
                }
                catch (Exception exception6) {
                    // empty catch block
                }
            }
            if (object2 != null) {
                try {
                    object2.close();
                }
                catch (Exception exception7) {
                    // empty catch block
                }
            }
            try {
                connection.close();
            }
            catch (Exception exception8) {
                // empty catch block
            }
            this.errorMsg = new String("Exception while executing OraParamsTest for target: " + this.targetHost);
            return;
        }
        finally {
            if (object != null) {
                try {
                    object.close();
                }
                catch (Exception exception) {}
            }
            if (object2 != null) {
                try {
                    object2.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

