/*
 * Decompiled with CFR 0.152.
 */
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

public class OraRacDbGrowthTest
extends GenericTest {
    private String user;
    private String passwd;
    private String oraSid;
    private String viewName;
    private static final int i_measureCount = 10;
    private static double gbConvertor = 1.073741824E9;
    private boolean service = true;
    private String serviceName = "";
    private boolean useMaxSize = true;
    private static final double DEFAULT_MINUS_ONE = -1.0;

    public OraRacDbGrowthTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.user = this.getValueForParam("username");
        this.passwd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("orasid");
        this.serviceName = this.getValueForParam("servicename");
        this.viewName = this.getValueForParam("alternate_view");
        String string = this.getValueForParam("use_max_size");
        if (this.user == null || this.user.equalsIgnoreCase("NULL") || this.user.equalsIgnoreCase("none")) {
            this.user = "";
        }
        if (this.passwd == null || this.passwd.equalsIgnoreCase("NULL") || this.passwd.equalsIgnoreCase("none")) {
            this.passwd = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        if (this.serviceName == null || this.serviceName.equalsIgnoreCase("NULL") || this.serviceName.equalsIgnoreCase("none") || this.serviceName.length() == 0) {
            this.service = false;
        }
        this.useMaxSize = string != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes"));
    }

    public static void main(String[] stringArray) {
        OraRacDbGrowthTest oraRacDbGrowthTest = new OraRacDbGrowthTest(stringArray);
        oraRacDbGrowthTest.computeMeasures(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        String string;
        double d7;
        double d8;
        double d9;
        double d10;
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        ArrayList<Double> arrayList;
        block14: {
            arrayList = new ArrayList<Double>();
            connection = null;
            statement = null;
            resultSet = null;
            d10 = 0.0;
            d9 = 0.0;
            d8 = 0.0;
            d7 = 0.0;
            double d11 = 0.0;
            string = "";
            d6 = 0.0;
            d5 = 0.0;
            d4 = 0.0;
            d3 = 0.0;
            d2 = 0.0;
            d = 0.0;
            string = this.viewName == null || this.viewName.equals("") || this.viewName.equalsIgnoreCase("NULL") || this.viewName.equalsIgnoreCase("none") ? "select a.FILE_ID,decode(a.maxbytes,0,a.bytes,a.maxbytes) total_size,a.bytes allocated_size,b.free_space free_size from dba_data_files a left join (select file_id,sum(bytes) as free_space from DBA_FREE_SPACE group by file_id) b on a.file_id = b.file_id" : "select a.FILE_ID,decode(a.maxbytes,0,a.bytes,a.maxbytes) total_size,a.bytes allocated_size,b.free_space free_size from dba_data_files a left join (select file_id,sum(bytes) as free_space from " + this.viewName + " group by file_id) b on a.file_id = b.file_id";
            System.out.println("OraRacDbGrowthTest before getting connection targetHost:" + this.targetHost + " CurrentTime:" + new Date());
            connection = ConnectionManager.getOraClstrConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.service, this.serviceName, this.user, this.passwd, debug);
            if (connection != null) break block14;
            System.out.println(this.entity + " connection is null targetHost:" + this.targetHost + " CurrentTime:" + new Date());
            this.logToErrorFile("[OraRacDbGrowthTest] compute Measure()", "database conn is null ", "TargetHost" + this.targetHost);
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            for (int i = 0; i < this.measureCount; ++i) {
                arrayList2.add(new Double(-1.0));
            }
            System.out.println("Adding MeasureList :" + arrayList2);
            this.addNewMeasure(arrayList2);
            this.closeRS(resultSet);
            this.closeST(statement);
            this.closeConn(connection);
            return;
        }
        System.out.println("OraRacDbGrowthTest connection established targetHost:" + this.targetHost + " CurrentTime:" + new Date());
        try {
            statement = connection.createStatement();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logToErrorFile("Error :", this.entity + " Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid + " serviceName:" + this.serviceName, exception.toString());
            this.closeConn(connection);
            this.closeRS(resultSet);
            this.closeST(statement);
            this.closeConn(connection);
            return;
        }
        try {
            System.out.println("OraRacDbGrowthTest statement created targetHost:" + this.targetHost + " CurrentTime:" + new Date());
            System.out.println("OraRacDbGrowthTest before executing query targetHost:" + this.targetHost + " CurrentTime:" + new Date());
            resultSet = statement.executeQuery(string);
            System.out.println("OraRacDbGrowthTest after executing query targetHost:" + this.targetHost + " CurrentTime:" + new Date());
            while (resultSet.next()) {
                double d12 = resultSet.getDouble(1);
                double d13 = resultSet.getDouble(2);
                double d14 = resultSet.getDouble(3);
                double d15 = resultSet.getDouble(4);
                if (d13 == 0.0 || d13 < d14) {
                    d13 = d14;
                }
                if (this.useMaxSize) {
                    d8 += d13;
                    d6 = d13 - d14 + d15;
                    d10 += d6;
                } else {
                    d8 += d14;
                    d6 = d15;
                    d10 += d6;
                }
                d5 += d14;
                d4 = d15;
                d3 += d4;
            }
            d7 = d8 / gbConvertor;
            d2 = d5 / gbConvertor;
            d9 = d10 / gbConvertor;
            d = d3 / gbConvertor;
            arrayList.add(new Double(d2));
            arrayList.add(new Double(d2 - d));
            arrayList.add(new Double(d));
            System.out.println(this.entity + ":" + this.reportingName + " aloc_totalSize_gb== " + d2);
            System.out.println(this.entity + ":" + this.reportingName + " aloc_availability_gb== " + d);
            BigDecimal bigDecimal = new BigDecimal((d2 - d) / d2 * 100.0);
            bigDecimal = bigDecimal.setScale(2, 6);
            arrayList.add(new Double(bigDecimal.doubleValue()));
            BigDecimal bigDecimal2 = new BigDecimal(d / d2 * 100.0);
            bigDecimal2 = bigDecimal2.setScale(2, 6);
            arrayList.add(new Double(bigDecimal2.doubleValue()));
            arrayList.add(new Double(d7));
            arrayList.add(new Double(d7 - d9));
            arrayList.add(new Double(d9));
            BigDecimal bigDecimal3 = new BigDecimal((d7 - d9) / d7 * 100.0);
            bigDecimal3 = bigDecimal3.setScale(2, 6);
            arrayList.add(new Double(bigDecimal3.doubleValue()));
            BigDecimal bigDecimal4 = new BigDecimal(d9 / d7 * 100.0);
            bigDecimal4 = bigDecimal4.setScale(2, 6);
            System.out.println(this.entity + ":" + this.reportingName + " Oracle RAC DB Growth test free_percentage :" + bigDecimal4);
            arrayList.add(new Double(bigDecimal4.doubleValue()));
            System.out.println(this.entity + ":" + this.reportingName + " Oracle RAC DB Growth test measure ArrayList :" + arrayList);
            this.addNewMeasure(arrayList);
            this.closeRS(resultSet);
            this.closeST(statement);
            this.closeConn(connection);
            this.closeRS(resultSet);
            this.closeST(statement);
            this.closeConn(connection);
        }
        catch (Exception exception) {
            try {
                System.out.println("Exception Occured in OraRacDbGrowthTest.computeMeasures():" + exception.toString());
                exception.printStackTrace();
                this.logToErrorFile("Error :", " Exception Occured in OraRacDbGrowthTest.computeMeasures():", exception.toString());
                ArrayList<Double> arrayList3 = new ArrayList<Double>();
                for (int i = 0; i < this.measureCount; ++i) {
                    arrayList3.add(new Double(-1.0));
                }
                System.out.println("Adding MeasureList :" + arrayList3);
                this.addNewMeasure(arrayList3);
                this.closeRS(resultSet);
                this.closeST(statement);
                this.closeConn(connection);
            }
            catch (Throwable throwable) {
                this.closeRS(resultSet);
                this.closeST(statement);
                this.closeConn(connection);
                throw throwable;
            }
        }
    }

    void closeRS(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            resultSet = null;
        }
        catch (Exception exception) {
            resultSet = null;
        }
    }

    void closeST(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
            statement = null;
        }
        catch (Exception exception) {
            statement = null;
        }
    }

    void closeConn(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
            connection = null;
        }
        catch (Exception exception) {
            connection = null;
        }
    }
}

