/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class OraRacSqlNetTest
extends GenericTest {
    public String oraSid;
    public String userName;
    public String userPasswd;
    public boolean service = true;
    public String serviceName = "";
    private static int availabilityIndex = 0;
    private static int responseTimeIndex = 1;
    private static int kbyteRateSentIndex = 2;
    private static int kbyteRateRecvdIndex = 3;
    private static int dbConnAvilIndex = 4;
    private static int dbConnTimeIndex = 5;
    private static int qryProAvailIndex = 6;
    private static int qryExeTimeIndex = 7;
    private static int noOfRecordsIndex = 8;
    public boolean foundVersion = false;
    public boolean isSql9 = false;
    public boolean isSql10 = false;
    public boolean userPrivilege = true;
    public int defValue = -1;
    private String index;
    public int availability = 0;
    public int dbConnAvailable = 0;
    public double dbConnTime = 0.0;
    public int qryProAvailable = 0;
    public double qryExeTime = 0.0;
    public int noOfRecords = 0;
    public String queryStmt;
    public double prevBytesSent = -1.0;
    public double prevBytesRecvd = -1.0;
    public double responseTime = -1.0;
    double kbytesSentRate;
    double kbytesRecvdRate;
    public ArrayList racSqlNetAvaDDList = new ArrayList();
    private String ddLine = "";
    private static String fieldSep = new String("");
    private static String sync0 = new String("x");

    public static void main(String[] stringArray) {
        OraRacSqlNetTest oraRacSqlNetTest = new OraRacSqlNetTest(stringArray);
        oraRacSqlNetTest.computeMeasures(new Hashtable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OraRacSqlNetTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.userName = this.getValueForParam("username");
        this.userPasswd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("orasid");
        this.serviceName = this.getValueForParam("servicename");
        if (this.userName == null || this.userName.equalsIgnoreCase("NULL") || this.userName.equalsIgnoreCase("none")) {
            this.userName = "";
        }
        if (this.userPasswd == null || this.userPasswd.equalsIgnoreCase("NULL") || this.userPasswd.equalsIgnoreCase("none")) {
            this.userPasswd = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        if (this.serviceName == null || this.serviceName.equalsIgnoreCase("NULL") || this.serviceName.equalsIgnoreCase("none") || this.serviceName.length() == 0) {
            this.service = false;
        }
        if (this.isPassive) {
            this.defValue = -5;
        }
        this.queryStmt = "SELECT name,value  FROM v$sysstat  WHERE NAME IN  ('bytes sent via SQL*Net to client','bytes received via SQL*Net from client','SQL*Net roundtrips to/from client')";
        if (this.timeout == 0L) {
            this.timeout = 2L * EgConfigInfo.msecPerMin;
        }
        this.needAgentlessDD = true;
        if (fieldSep.length() == 0) {
            String string = sync0;
            synchronized (string) {
                if (fieldSep.length() == 0) {
                    EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
                    fieldSep = egTesterInfo.getDDSeparator1();
                }
            }
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        Object var2_2 = null;
        if (this.isPassive) {
            this.availability = this.defValue;
            this.responseTime = this.defValue;
            this.qryProAvailable = this.defValue;
            this.noOfRecords = this.defValue;
            this.dbConnAvailable = this.defValue;
            this.dbConnTime = this.defValue;
            this.qryExeTime = this.defValue;
            this.kbytesSentRate = this.defValue;
            this.kbytesRecvdRate = this.defValue;
        } else {
            this.availability = 0;
            this.responseTime = -5.0;
            this.qryProAvailable = -5;
            this.dbConnAvailable = -5;
            this.dbConnTime = -5.0;
            this.qryExeTime = -5.0;
            this.noOfRecords = -5;
            this.kbytesSentRate = -5.0;
            this.kbytesRecvdRate = -5.0;
        }
        OraRacSqlNetHelper oraRacSqlNetHelper = new OraRacSqlNetHelper(this);
        boolean bl = this.checkForTimeout(oraRacSqlNetHelper);
        this.racSqlNetAvaDDList = new ArrayList();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (bl) {
            ArrayList arrayList2 = oraRacSqlNetHelper.names;
            ArrayList arrayList3 = oraRacSqlNetHelper.values;
            if (arrayList2 == null || arrayList3 == null || arrayList2.size() == 0 || arrayList3.size() == 0) {
                this.ddLine = oraRacSqlNetHelper.ddString;
                this.ddLine = this.ddLine + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-";
                this.racSqlNetAvaDDList.add(this.ddLine);
                System.out.println("ddLine :" + this.ddLine);
                System.out.println("racSqlNetDDList :" + this.racSqlNetAvaDDList);
                arrayList = new ArrayList();
                arrayList.add(new Double(this.availability));
                arrayList.add(new Double(this.responseTime));
                arrayList.add(new Double(this.kbytesSentRate));
                arrayList.add(new Double(this.kbytesRecvdRate));
                arrayList.add(new Double(this.dbConnAvailable));
                arrayList.add(new Double(this.dbConnTime));
                arrayList.add(new Double(this.qryProAvailable));
                arrayList.add(new Double(this.qryExeTime));
                arrayList.add(new Double(this.noOfRecords));
            } else {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    String string = (String)arrayList2.get(i);
                    Double d = (Double)arrayList3.get(i);
                    double d2 = d;
                    if (string.startsWith("bytes sent")) {
                        if (this.prevBytesSent < 0.0 || this.prevBytesSent > d2 || this.timeSinceLastTest < 0.0) {
                            this.prevBytesSent = d2;
                            continue;
                        }
                        this.kbytesSentRate = (d2 - this.prevBytesSent) / (1000.0 * this.timeSinceLastTest);
                        this.kbytesSentRate = this.roundDouble(this.kbytesSentRate, 4);
                        if (new Double(this.kbytesSentRate).toString().length() >= 16) {
                            this.logToErrorFile("Error :", "OraRacSqlNetTest bytes Sent Rate current value", "" + d2);
                            this.logToErrorFile("Error :", "OraRacSqlNetTest bytes Sent Rate previous value is ", "" + this.prevBytesSent);
                            this.logToErrorFile("Error :", "OraRacSqlNetTest bytes Sent Rate calculated value", "" + this.kbytesSentRate);
                            this.logToErrorFile("Error :", "OraRacSqlNetTest bytes Sent Rate value is too large", this.targetHost);
                            this.kbytesSentRate = -5.0;
                        }
                        this.prevBytesSent = d2;
                        continue;
                    }
                    if (!string.startsWith("bytes rec")) continue;
                    if (this.prevBytesRecvd < 0.0 || this.prevBytesRecvd > d2 || this.timeSinceLastTest < 0.0) {
                        this.prevBytesRecvd = d2;
                        continue;
                    }
                    this.kbytesRecvdRate = (d2 - this.prevBytesRecvd) / (1000.0 * this.timeSinceLastTest);
                    this.kbytesRecvdRate = this.roundDouble(this.kbytesRecvdRate, 4);
                    if (new Double(this.kbytesRecvdRate).toString().length() >= 16) {
                        this.logToErrorFile("Error :", "OraRacSqlNetTest bytes Recvd Rate current value is ", "" + d2);
                        this.logToErrorFile("Error :", "OraRacSqlNetTest bytes Recvd Rate previous value is ", "" + this.prevBytesRecvd);
                        this.logToErrorFile("Error :", "OraRacSqlNetTest bytes Recvd Rate calculated value", "" + this.kbytesRecvdRate);
                        this.logToErrorFile("Error :", "OraRacSqlNetTest bytes Recvd Rate value is too large", this.targetHost);
                        this.kbytesRecvdRate = -5.0;
                    }
                    this.prevBytesRecvd = d2;
                }
                arrayList = new ArrayList();
                arrayList.add(new Double(this.availability));
                arrayList.add(new Double(this.responseTime));
                arrayList.add(new Double(this.kbytesSentRate));
                arrayList.add(new Double(this.kbytesRecvdRate));
                arrayList.add(new Double(this.dbConnAvailable));
                arrayList.add(new Double(this.dbConnTime));
                arrayList.add(new Double(this.qryProAvailable));
                arrayList.add(new Double(this.qryExeTime));
                arrayList.add(new Double(this.noOfRecords));
            }
        } else {
            this.ddLine = this.ddLine + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-";
            this.racSqlNetAvaDDList.add(this.ddLine);
            System.out.println("ddLine :" + this.ddLine);
            System.out.println("racSqlNetDDList :" + this.racSqlNetAvaDDList);
            arrayList = new ArrayList();
            arrayList.add(new Double(this.availability));
            arrayList.add(new Double(this.responseTime));
            arrayList.add(new Double(this.kbytesSentRate));
            arrayList.add(new Double(this.kbytesRecvdRate));
            arrayList.add(new Double(this.dbConnAvailable));
            arrayList.add(new Double(this.dbConnTime));
            arrayList.add(new Double(this.qryProAvailable));
            arrayList.add(new Double(this.qryExeTime));
            arrayList.add(new Double(this.noOfRecords));
        }
        this.errorMsg = new String("Exception while executing OraRacSqlNetTest for target: " + this.targetHost);
        System.out.println("Adding MeasureList :" + arrayList);
        this.addNewMeasure(arrayList);
    }

    private boolean checkForTimeout(OraRacSqlNetHelper oraRacSqlNetHelper) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        do {
            long l4 = System.currentTimeMillis();
            this.suspendForPeriod(l3);
            if (oraRacSqlNetHelper.done) {
                return true;
            }
            long l5 = System.currentTimeMillis();
            long l6 = l5 - l4;
            if (l6 < 0L) {
                l6 = l3;
            }
            if ((l2 += l6) >= this.timeout) {
                System.out.println("OraRacSqlNetTest timeout happeneded ... " + l2);
                double d = this.timeout / 1000L;
                this.ddLine = "Timeout happened while establishing connection. Connection establishment time exceeded configured timeout value:" + d + " secs";
                oraRacSqlNetHelper.interrupt();
                Thread.currentThread();
                Thread.yield();
                try {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                oraRacSqlNetHelper.stop();
                return false;
            }
            l = l3;
            if (this.timeout - l2 >= l) continue;
            l = this.timeout - l2;
        } while ((l3 = l) > 0L);
        double d = this.timeout / 1000L;
        this.ddLine = "Timeout happened while establishing connection. Connection establishment time exceeded configured timeout value:" + d + " secs";
        oraRacSqlNetHelper.interrupt();
        Thread.currentThread();
        Thread.yield();
        try {
            Thread.currentThread();
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        oraRacSqlNetHelper.stop();
        System.out.println("OraRacSqlNetTest timeout happeneded ... " + l2);
        return false;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            if (l < EgAgentCommon.minimumSleep) {
                l = EgAgentCommon.minimumSleep;
            }
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    private double roundDouble(double d, int n) {
        Object object;
        double d2 = 0.0;
        Object object2 = "";
        if (n <= 0) {
            object2 = object = "" + (int)(d + (d > 0.0 ? 0.5 : -0.5));
        } else {
            String string;
            object = "";
            if (d < 0.0) {
                object = (String)object + "-";
                d = -d;
            }
            if ((d += 0.5 * Math.pow(10.0, -n)) > 1.0) {
                int n2 = (int)d;
                object = (String)object + n2;
                d -= (double)n2;
            } else {
                object = (String)object + "0";
            }
            if (d > 0.0) {
                String string2 = "" + (int)((d += 1.0) * Math.pow(10.0, n));
                object = (String)object + "." + string2.substring(1);
            }
            object2 = (string = EgDbInfo.formatValue((String)object)) == null || string.trim().length() == 0 ? object : string;
        }
        object = new Double((String)object2);
        d2 = ((Double)object).isNaN() ? 0.0 : (Double)object;
        return d2;
    }

    public void freeTest() {
        this.racSqlNetAvaDDList = new ArrayList();
    }
}

