/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;

public class OraRollSegTest
extends GenericTest {
    public String oraSid;
    public String userName;
    public String userPasswd;
    public static String fieldSep = null;
    private static String q = "select name \"Rollback Segment\" , writes,waits,gets,(100-(waits/gets)) \"Hit Ratio\" from v$rollstat a,v$rollname b where a.usn=b.usn and a.status='ONLINE'";
    Hashtable prevWrites = new Hashtable();
    Hashtable prevWaits = new Hashtable();
    Hashtable prevGets = new Hashtable();
    private double defValue = -1.0;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private int msgLogCounter = 0;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    public boolean isOracleOnCloud = false;

    public static void main(String[] stringArray) {
        OraRollSegTest oraRollSegTest = new OraRollSegTest(stringArray);
        oraRollSegTest.computeMeasures(new Hashtable());
    }

    public OraRollSegTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.userName = this.getValueForParam("username");
        if (this.userName == null) {
            this.userName = this.getValueForParam("user");
        }
        this.userPasswd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("oracle_sid");
        }
        String string = this.getValueForParam("cloud_hosted");
        if (this.userName == null || this.userName.equalsIgnoreCase("NULL") || this.userName.equalsIgnoreCase("none")) {
            this.userName = "";
        }
        if (this.userPasswd == null || this.userPasswd.equalsIgnoreCase("NULL") || this.userPasswd.equalsIgnoreCase("none")) {
            this.userPasswd = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        if (string != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes") || string.trim().equalsIgnoreCase("y"))) {
            this.isOracleOnCloud = true;
        }
        if (!this.isOracleOnCloud) {
            this.setSid(this.oraSid);
        }
        if (fieldSep == null) {
            EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
            fieldSep = egTesterInfo.getDDSeparator1();
            egTesterInfo = null;
        }
        if (fieldSep == null) {
            fieldSep = ";";
        }
        this.isNewDynamicInfoTest = true;
        if (this.isPassive) {
            this.defValue = -5.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeMeasures(Hashtable hashtable) {
        Object object;
        Object object2;
        Object object3;
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
            object3 = new ArrayList();
            object3 = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (object3 != null && ((ArrayList)object3).size() > 2) {
                int n = (Integer)((ArrayList)object3).get(0);
                object2 = (String)((ArrayList)object3).get(1);
                if (((String)object2).equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    object = (String)((ArrayList)object3).get(2);
                    if (((String)object).equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isInitCheckNeeded = false;
            } else {
                if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + object3, " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
            }
        }
        if (this.isDataguardEnabled) {
            object3 = ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
            if (object3 == null) return;
            if (((Hashtable)object3).size() == 0) {
                return;
            }
            ArrayList arrayList = (ArrayList)((Hashtable)object3).get(this.reportingName + ":" + this.oraSid);
            if (arrayList == null) return;
            if (arrayList.size() <= 0) return;
            object2 = (String)arrayList.get(2);
            object = (String)arrayList.get(3);
            if (!((String)object2).equalsIgnoreCase("PRIMARY") && ((String)object).equalsIgnoreCase("MOUNTED")) {
                ArrayList<Double> arrayList2 = new ArrayList<Double>();
                int n = 0;
                while (n < this.measureCount) {
                    arrayList2.add(new Double(-5.0));
                    ++n;
                }
                return;
            }
        }
        object3 = null;
        Connection connection = null;
        object2 = null;
        object = new ArrayList<String>();
        try {
            Object object4;
            if (this.isMultitenantDb && !this.isCDB) {
                if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO", "OraRollSegTest doesnot run for PDB : ", "targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
                return;
            }
            connection = ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug);
            if (connection == null) {
                this.logToErrorFile("Error  :", this.entity, " Connection is null targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                return;
            }
            try {
                object2 = connection.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "OraRollbackTest Failed to Create Statement targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (object3 != null) {
                    try {
                        object3.close();
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
                if (object2 != null) {
                    try {
                        object2.close();
                    }
                    catch (Exception exception4) {
                        // empty catch block
                    }
                }
                if (connection == null) return;
                try {
                    connection.close();
                    return;
                }
                catch (Exception exception5) {
                    // empty catch block
                }
                return;
            }
            try {
                object3 = object2.executeQuery(q);
                while (object3.next()) {
                    Serializable serializable;
                    object4 = object3.getString(1);
                    ((ArrayList)object).add(object4);
                    double d = object3.getDouble(2);
                    double d2 = object3.getDouble(3);
                    double d3 = object3.getDouble(4);
                    double d4 = object3.getDouble(5);
                    double d5 = -1.0;
                    double d6 = -1.0;
                    double d7 = -1.0;
                    boolean bl = this.prevWaits.containsKey(object4);
                    if (bl) {
                        Double d8 = (Double)this.prevWrites.get(object4);
                        Double d9 = (Double)this.prevWaits.get(object4);
                        serializable = (Double)this.prevGets.get(object4);
                        if (d8 == null || d9 == null || serializable == null) continue;
                        double d10 = d8;
                        double d11 = d9;
                        double d12 = (Double)serializable;
                        d5 = d - d10;
                        d6 = d2 - d11;
                        d7 = d3 - d12;
                        d5 = d5 < 0.0 ? -1.0 : d5;
                        d6 = d6 < 0.0 ? -1.0 : d6;
                        d7 = d7 < 0.0 ? -1.0 : d7;
                    }
                    this.prevWaits.put(object4, new Double(d2));
                    this.prevWrites.put(object4, new Double(d));
                    this.prevGets.put(object4, new Double(d3));
                    if (!bl) continue;
                    double d13 = -1.0;
                    if (d7 == 0.0) {
                        d13 = 100.0;
                    } else if (d7 > 0.0) {
                        d13 = 100.0 - d6 / d7;
                    }
                    serializable = new ArrayList();
                    ((ArrayList)serializable).add(new Double(d5));
                    ((ArrayList)serializable).add(new Double(d6));
                    ((ArrayList)serializable).add(new Double(d7));
                    ((ArrayList)serializable).add(new Double(d13));
                    ((ArrayList)serializable).add(new Double(d4));
                    this.addNewMeasure((String)object4, (ArrayList)serializable);
                }
                object3.close();
                object3 = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (object3 != null) {
                    try {
                        object3.close();
                    }
                    catch (Exception exception6) {
                        // empty catch block
                    }
                }
                if (object2 != null) {
                    try {
                        object2.close();
                    }
                    catch (Exception exception7) {
                        // empty catch block
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception8) {
                        // empty catch block
                    }
                }
                this.prevWaits = new Hashtable();
                this.prevGets = new Hashtable();
                this.prevWrites = new Hashtable();
            }
            object4 = this.prevWaits.keys();
            while (object4.hasMoreElements()) {
                String string = (String)object4.nextElement();
                if (((ArrayList)object).indexOf(string) >= 0) continue;
                this.prevWaits.remove(string);
                this.prevWrites.remove(string);
                this.prevGets.remove(string);
            }
            object2.close();
            connection.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
            if (object3 != null) {
                try {
                    object3.close();
                }
                catch (Exception exception9) {
                    // empty catch block
                }
            }
            if (object2 != null) {
                try {
                    object2.close();
                }
                catch (Exception exception10) {
                    // empty catch block
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception11) {
                    // empty catch block
                }
            }
            this.prevWaits = new Hashtable();
            this.prevGets = new Hashtable();
            this.prevWrites = new Hashtable();
            this.errorMsg = new String("Exception while executing  OraRollSegTest for target: " + this.targetHost);
            return;
        }
        finally {
            if (object3 != null) {
                try {
                    object3.close();
                }
                catch (Exception exception) {}
            }
            if (object2 != null) {
                try {
                    object2.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

