/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;

public class OraRollbackTest
extends GenericTest {
    private String oraSid;
    private String userName;
    private String userPasswd;
    private String queryStmt;
    private String queryStmt1;
    private double prevSUH = 0.0;
    private double prevSUB = 0.0;
    private double prevUH = 0.0;
    private double prevUB = 0.0;
    private double prevS = 0.0;
    private double defValue = -1.0;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private int msgLogCounter = 0;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    public boolean isOracleOnCloud = false;

    public static void main(String[] stringArray) {
        OraRollbackTest oraRollbackTest = new OraRollbackTest(stringArray);
        oraRollbackTest.computeMeasures(new Hashtable());
    }

    public OraRollbackTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(2);
        this.userName = this.getValueForParam("username");
        if (this.userName == null) {
            this.userName = this.getValueForParam("user");
        }
        this.userPasswd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("oracle_sid");
        }
        String string = this.getValueForParam("cloud_hosted");
        if (this.userName == null || this.userName.equalsIgnoreCase("NULL") || this.userName.equalsIgnoreCase("none")) {
            this.userName = "";
        }
        if (this.userPasswd == null || this.userPasswd.equalsIgnoreCase("NULL") || this.userPasswd.equalsIgnoreCase("none")) {
            this.userPasswd = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        if (string != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes") || string.trim().equalsIgnoreCase("y"))) {
            this.isOracleOnCloud = true;
        }
        if (!this.isOracleOnCloud) {
            this.setSid(this.oraSid);
        }
        this.isNewDynamicInfoTest = true;
        if (this.isPassive) {
            this.defValue = -5.0;
        }
        this.queryStmt = "select class, count from v$waitstat where class in ('system undo header', 'system undo block', 'undo header', 'undo block')";
        this.queryStmt1 = "SELECT sum(value) FROM V$SYSSTAT WHERE name in ('db block gets', 'consistent gets')";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeMeasures(Hashtable hashtable) {
        String string;
        String string2;
        Cloneable cloneable;
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
            cloneable = new ArrayList();
            cloneable = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (cloneable != null && ((ArrayList)cloneable).size() > 2) {
                int n = (Integer)((ArrayList)cloneable).get(0);
                string2 = (String)((ArrayList)cloneable).get(1);
                if (string2.equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    string = (String)((ArrayList)cloneable).get(2);
                    if (string.equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isInitCheckNeeded = false;
            } else {
                if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + cloneable, " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
            }
        }
        if (this.isDataguardEnabled) {
            cloneable = ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
            if (cloneable == null) return;
            if (((Hashtable)cloneable).size() == 0) {
                return;
            }
            ArrayList arrayList = (ArrayList)((Hashtable)cloneable).get(this.reportingName + ":" + this.oraSid);
            if (arrayList == null) return;
            if (arrayList.size() <= 0) return;
            string2 = (String)arrayList.get(2);
            string = (String)arrayList.get(3);
            if (!string2.equalsIgnoreCase("PRIMARY") && string.equalsIgnoreCase("MOUNTED")) {
                return;
            }
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        ResultSet resultSet = null;
        Statement statement = null;
        Connection connection = null;
        try {
            Object object;
            if (this.isMultitenantDb) {
                if (this.isCDB) {
                    if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                        this.logToErrorFile("INFO", "OraRollbackTest doesnot run for CDB : ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                        this.msgLogCounter = 0;
                    }
                    ++this.msgLogCounter;
                    return;
                }
                connection = ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug);
            } else {
                connection = ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug);
            }
            if (connection == null) {
                this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                return;
            }
            try {
                statement = connection.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "OraRollbackTest Failed to Create Statement targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception4) {
                        // empty catch block
                    }
                }
                if (connection == null) return;
                try {
                    connection.close();
                    return;
                }
                catch (Exception exception5) {
                    // empty catch block
                }
                return;
            }
            resultSet = statement.executeQuery(this.queryStmt);
            while (resultSet.next()) {
                object = resultSet.getString(1);
                if (((String)object).equalsIgnoreCase("system undo header")) {
                    d = resultSet.getDouble(2);
                    continue;
                }
                if (((String)object).equalsIgnoreCase("system undo block")) {
                    d2 = resultSet.getDouble(2);
                    continue;
                }
                if (((String)object).equalsIgnoreCase("undo header")) {
                    d3 = resultSet.getDouble(2);
                    continue;
                }
                if (!((String)object).equalsIgnoreCase("undo block")) continue;
                d4 = resultSet.getDouble(2);
            }
            resultSet.close();
            resultSet = statement.executeQuery(this.queryStmt1);
            while (resultSet.next()) {
                d5 = resultSet.getDouble(1);
            }
            if (this.prevSUH > d || this.prevSUB > d2 || this.prevUH > d3 || this.prevUB > d4 || this.prevS > d5) {
                d6 = -1.0;
                d7 = -1.0;
            } else {
                d8 = d - this.prevSUH + (d2 - this.prevSUB);
                d9 = d3 - this.prevUH + (d4 - this.prevUB);
                d10 = d5 - this.prevS;
                if (d10 == 0.0) {
                    d6 = 0.0;
                    d7 = 0.0;
                } else {
                    d6 = d8 * 100.0 / d10;
                    d7 = d9 * 100.0 / d10;
                }
            }
            object = new ArrayList();
            ((ArrayList)object).add(new Double(d6));
            ((ArrayList)object).add(new Double(d7));
            this.addNewMeasure((ArrayList)object);
            resultSet.close();
            statement.close();
            connection.close();
            this.prevS = d5;
            this.prevSUH = d;
            this.prevSUB = d2;
            this.prevUH = d3;
            this.prevUB = d4;
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception6) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception7) {
                    // empty catch block
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception8) {
                    // empty catch block
                }
            }
            this.errorMsg = new String("Exception while executing  OraRollbackTest for target: " + this.targetHost);
            return;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

