/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;

public class OraServRespTest
extends GenericTest {
    public String oraSid = "";
    public String username = "";
    public String password = "";
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private boolean isMultitenantDb = false;
    private static final int i_measureCount = 2;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    public boolean isOracleOnCloud = false;
    private int msgLogCounter = 0;

    public OraServRespTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(2);
        this.username = this.getValueForParam("username");
        if (this.username == null) {
            this.username = this.getValueForParam("user");
        }
        this.password = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("oracle_sid");
        }
        String string = this.getValueForParam("cloud_hosted");
        if (this.username == null || this.username.equalsIgnoreCase("NULL") || this.username.equalsIgnoreCase("none")) {
            this.username = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        if (string != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes") || string.trim().equalsIgnoreCase("y"))) {
            this.isOracleOnCloud = true;
        }
        if (!this.isOracleOnCloud) {
            this.setSid(this.oraSid);
        }
        this.isNewDynamicInfoTest = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        Object object;
        Object object2;
        Cloneable cloneable;
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName);
            cloneable = new ArrayList();
            cloneable = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (cloneable != null && cloneable.size() > 2) {
                int n = (Integer)cloneable.get(0);
                object2 = (String)cloneable.get(1);
                if (((String)object2).equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    object = (String)cloneable.get(2);
                    if (((String)object).equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isInitCheckNeeded = false;
            } else {
                if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + cloneable, " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
            }
        }
        if (this.isDataguardEnabled) {
            cloneable = ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName);
            if (cloneable == null || ((Hashtable)cloneable).size() == 0) {
                return;
            }
            ArrayList arrayList = (ArrayList)((Hashtable)cloneable).get(this.reportingName + ":" + this.oraSid);
            if (arrayList != null && arrayList.size() > 0) {
                object2 = (String)arrayList.get(2);
                object = (String)arrayList.get(3);
                if (!((String)object2).equalsIgnoreCase("PRIMARY") && ((String)object).equalsIgnoreCase("MOUNTED")) {
                    return;
                }
            } else {
                return;
            }
        }
        cloneable = "select metric_name,value from v$sysmetric where intsize_csec >= 6000 and metric_name in ('SQL Service Response Time','Response Time Per Txn') order by 1";
        Connection connection = null;
        object2 = null;
        object = null;
        try {
            connection = this.isMultitenantDb && !this.isCDB ? ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug) : ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug);
            if (connection == null) {
                this.logToErrorFile("ERROR", this.entity, "Oracle connection  is null for host " + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                return;
            }
            try {
                object2 = connection.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "OraServRespTest Failed to Create Statement targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    if (object != null) {
                        object.close();
                    }
                    if (object2 != null) {
                        object2.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception3) {
                    System.out.println("Exception Occured in [" + this.getClass().getName() + "].computeMeasures() - finally block :" + exception3.toString());
                }
                return;
            }
            object = object2.executeQuery((String)((Object)cloneable));
            ArrayList<Double> arrayList = new ArrayList<Double>();
            double d = -5.0;
            while (object.next()) {
                try {
                    d = object.getDouble(2);
                }
                catch (Exception exception) {
                    d = -5.0;
                }
                double d2 = d / 100.0;
                arrayList.add(new Double(d2));
            }
            if (arrayList != null && arrayList.size() == 2) {
                this.addNewMeasure(arrayList);
            } else {
                this.addDefaultMeasure();
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
            System.out.println("Exception Occured in [" + this.getClass().getName() + "].computeMeasures():" + exception.toString());
            exception.printStackTrace();
            if (this.isPassive) {
                this.addDefaultMeasure();
            }
        }
        finally {
            try {
                if (object != null) {
                    object.close();
                }
                if (object2 != null) {
                    object2.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                System.out.println("Exception Occured in [" + this.getClass().getName() + "].computeMeasures() - finally block :" + exception.toString());
            }
        }
    }

    public void addDefaultMeasure() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(-5.0));
        arrayList.add(new Double(-5.0));
        this.addNewMeasure(arrayList);
    }

    public static void main(String[] stringArray) {
        OraServRespTest oraServRespTest = new OraServRespTest(stringArray);
        oraServRespTest.computeMeasures(new Hashtable());
    }
}

