/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class OraSystemWaitTest
extends GenericTest {
    private String oraSid = "";
    private String userName;
    private String userPasswd;
    private String queryStmt;
    private String queryStmt1;
    private double defValue = -1.0;
    private boolean foundVersion = false;
    private boolean isSql9 = false;
    private boolean isSql10 = false;
    ArrayList excludeInfo;
    Hashtable previous = new Hashtable();
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    public boolean isOracleOnCloud = false;
    private int msgLogCounter = 0;

    public static void main(String[] stringArray) {
        OraSystemWaitTest oraSystemWaitTest = new OraSystemWaitTest(stringArray);
        oraSystemWaitTest.executeTest();
    }

    public OraSystemWaitTest(String[] stringArray) {
        super(stringArray);
        String[] stringArray2;
        Object object;
        String string;
        this.setMeasureCount(4);
        this.isNewDynamicInfoTest = true;
        this.userName = this.getValueForParam("user");
        this.userPasswd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("sid");
        }
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("oracle_sid");
        }
        if ((string = this.getValueForParam("cloud_hosted")) != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes") || string.trim().equalsIgnoreCase("y"))) {
            this.isOracleOnCloud = true;
        }
        if (!this.isOracleOnCloud) {
            this.setSid(this.oraSid);
        }
        String string2 = this.getValueForParam("exclude");
        String string3 = "";
        if (string2 != null && !string2.equalsIgnoreCase("none")) {
            object = new StringTokenizer(string2, ",");
            this.excludeInfo = new ArrayList();
            while (((StringTokenizer)object).countTokens() > 0) {
                this.excludeInfo.add(((StringTokenizer)object).nextToken().trim());
            }
        }
        if ((stringArray2 = ((com.eg.EgThresholdInfo)(object = new EgThresholdInfo("agent"))).getMeasurementsForTest("OraSystemWaitTest")) != null) {
            this.numOutputFields = stringArray2.length;
        }
        object = null;
        this.queryStmt = "";
        if (this.isPassive) {
            this.defValue = -5.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        Object object;
        block29: {
            String string;
            String string2;
            if (this.isInitCheckNeeded) {
                this.isDataguardEnabled = ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
                object = new ArrayList();
                object = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
                if (object != null && ((ArrayList)object).size() > 2) {
                    int n = (Integer)((ArrayList)object).get(0);
                    string2 = (String)((ArrayList)object).get(1);
                    if (string2.equalsIgnoreCase("true")) {
                        this.isCDB = true;
                    }
                    if (n >= 12) {
                        this.isOracle12c = true;
                        string = (String)((ArrayList)object).get(2);
                        if (string.equalsIgnoreCase("true")) {
                            this.isMultitenantDb = true;
                        }
                    }
                    this.isInitCheckNeeded = false;
                } else {
                    if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                        this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + object, " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                        this.msgLogCounter = 0;
                    }
                    ++this.msgLogCounter;
                }
            }
            if (this.isDataguardEnabled) {
                object = ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
                if (object == null || ((Hashtable)object).size() == 0) {
                    return;
                }
                ArrayList arrayList = (ArrayList)((Hashtable)object).get(this.reportingName + ":" + this.oraSid);
                if (arrayList != null && arrayList.size() > 0) {
                    string2 = (String)arrayList.get(2);
                    string = (String)arrayList.get(3);
                    if (!string2.equalsIgnoreCase("PRIMARY") && string.equalsIgnoreCase("MOUNTED")) {
                        return;
                    }
                } else {
                    return;
                }
            }
            connection = null;
            Object var10_10 = null;
            statement = null;
            resultSet = null;
            connection = this.isMultitenantDb && !this.isCDB ? ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug) : ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug);
            if (connection != null) break block29;
            this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
            this.closeRs(resultSet);
            this.closeStmt(statement);
            this.closeConn(connection);
            return;
        }
        this.queryStmt = "Select Event, Total_waits,Total_timeouts,Time_waited from v$system_event where wait_class# <> 6 union  select 'CPU Time' Event, 0 total_waits,0 total_timeouts, value/100 time_waited from v$sysstat where name='CPU used by this session' order by Time_waited desc";
        try {
            statement = connection.createStatement();
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "OraSystemWaitTest Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
            exception.printStackTrace();
            this.closeConn(connection);
            this.closeRs(resultSet);
            this.closeStmt(statement);
            this.closeConn(connection);
            return;
        }
        try {
            Object object2;
            ArrayList arrayList;
            resultSet = statement.executeQuery(this.queryStmt);
            Hashtable<Object, Object> hashtable2 = new Hashtable<Object, Object>();
            while (resultSet.next()) {
                arrayList = new ArrayList();
                object2 = new ArrayList();
                object = resultSet.getString("event");
                double d = resultSet.getDouble("Total_waits");
                double d2 = resultSet.getDouble("total_timeouts");
                double d3 = resultSet.getDouble("time_waited");
                if (this.excludeInfo != null && this.excludeInfo.size() > 0 && this.excludeInfo.contains(object)) continue;
                ((ArrayList)object2).add(new Double(d));
                ((ArrayList)object2).add(new Double(d2));
                ((ArrayList)object2).add(new Double(d3));
                hashtable2.put(object, object2);
            }
            resultSet.close();
            statement.close();
            connection.close();
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                Object object3;
                double d;
                object2 = (String)enumeration.nextElement();
                ArrayList arrayList2 = (ArrayList)hashtable2.get(object2);
                ArrayList arrayList3 = (ArrayList)this.previous.get(object2);
                if (arrayList3 == null || arrayList3 == null || arrayList3.size() <= 0) continue;
                arrayList = new ArrayList();
                double d4 = (Double)arrayList3.get(0);
                double d5 = (Double)arrayList3.get(1);
                double d6 = (Double)arrayList3.get(2);
                double d7 = (Double)arrayList2.get(0);
                double d8 = (Double)arrayList2.get(1);
                double d9 = (Double)arrayList2.get(2);
                double d10 = d7 - d4;
                double d11 = d8 - d5;
                double d12 = d = d9 - d6;
                if (((String)object2).trim().equalsIgnoreCase("CPU Time")) {
                    d10 = -5.0;
                    d11 = -5.0;
                    d = -5.0;
                } else {
                    if (d > 0.0) {
                        d = d7 > 0.0 ? d9 * 0.01 / d7 : 0.0;
                    }
                    if (d < 0.0) {
                        d = -5.0;
                    }
                    if (Double.isNaN(d)) {
                        d = 0.0;
                    }
                    object3 = this.round(d, 4);
                    d = Double.parseDouble((String)object3);
                }
                d10 = d10 < 0.0 ? -5.0 : d10;
                d11 = d11 < 0.0 ? -5.0 : d11;
                d = d < 0.0 ? -5.0 : d;
                double d13 = d12 = d12 < 0.0 ? -5.0 : d12;
                if (!(d > 0.0 || d11 > 0.0 || d10 > 0.0) && !(d12 > 0.0)) continue;
                object3 = new ArrayList();
                ((ArrayList)object3).add(new Double(d10));
                ((ArrayList)object3).add(new Double(d11));
                ((ArrayList)object3).add(new Double(d));
                ((ArrayList)object3).add(new Double(d12));
                this.addNewMeasure((String)object2, (ArrayList)object3);
            }
            this.previous = (Hashtable)hashtable2.clone();
            this.closeRs(resultSet);
            this.closeStmt(statement);
            this.closeConn(connection);
        }
        catch (Exception exception) {
            try {
                this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                this.errorMsg = new String("Exception while executing  OraSystemWaitTest for target: " + this.targetHost);
                try {
                    connection.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this.previous = new Hashtable();
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
            }
            catch (Throwable throwable) {
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
                throw throwable;
            }
        }
    }

    public String round(double d, int n) {
        if (n <= 0) {
            String string = "" + (int)(d + (d > 0.0 ? 0.5 : -0.5));
            return string;
        }
        String string = "";
        if (d < 0.0) {
            string = string + "-";
            d = -d;
        }
        if ((d += 0.5 * Math.pow(10.0, -n)) > 1.0) {
            long l = (long)d;
            string = string + l;
            d -= (double)l;
        } else {
            string = string + "0";
        }
        if (d > 0.0) {
            String string2 = "" + (long)((d += 1.0) * Math.pow(10.0, n));
            string = string + "." + string2.substring(1);
        }
        return string;
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

