/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class OraTablespacesTest
extends GenericTest {
    private String oraSid;
    private String userName;
    private String userPasswd;
    private String mode = "All";
    private String viewName;
    private ArrayList tableSpaceNames = new ArrayList();
    private ArrayList prevPhysReads = new ArrayList();
    private ArrayList prevPhysWrites = new ArrayList();
    private String query1 = null;
    private String query2 = null;
    private String query3 = null;
    private String query4 = null;
    private boolean isExternal = false;
    private static double bToMb = 1048576.0;
    private static double kbToMb = 1024.0;
    private double defValue = -1.0;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    public boolean isOracleOnCloud = false;
    private int msgLogCounter = 0;

    public static void main(String[] stringArray) {
        OraTablespacesTest oraTablespacesTest = new OraTablespacesTest(stringArray);
        oraTablespacesTest.computeMeasures(new Hashtable());
    }

    public OraTablespacesTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.userName = this.getValueForParam("username");
        if (this.userName == null) {
            this.userName = this.getValueForParam("user");
        }
        this.userPasswd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        this.mode = this.getValueForParam("mode");
        this.viewName = this.getValueForParam("alternate_view");
        String string = this.getValueForParam("isCluster");
        if (string == null) {
            string = this.getValueForParam("isExternal");
        }
        if (string != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes"))) {
            this.isExternal = true;
        }
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("oracle_sid");
        }
        String string2 = this.getValueForParam("cloud_hosted");
        if (this.userName == null || this.userName.equalsIgnoreCase("NULL") || this.userName.equalsIgnoreCase("none")) {
            this.userName = "";
        }
        if (this.userPasswd == null || this.userPasswd.equalsIgnoreCase("NULL") || this.userPasswd.equalsIgnoreCase("none")) {
            this.userPasswd = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        if (string2 != null && (string2.trim().equalsIgnoreCase("true") || string2.trim().equalsIgnoreCase("yes") || string2.trim().equalsIgnoreCase("y"))) {
            this.isOracleOnCloud = true;
        }
        if (!this.isExternal && this.isOracleOnCloud) {
            this.isExternal = this.isOracleOnCloud;
        }
        if (!this.isExternal) {
            this.setSid(this.oraSid);
        }
        this.isNewDynamicInfoTest = true;
        if (this.isPassive) {
            this.defValue = -5.0;
        }
        String string3 = "";
        string3 = this.mode != null && this.mode.equalsIgnoreCase("All") ? "" : (this.mode != null && this.mode.equalsIgnoreCase("Read/Write") ? " and ts.status = 'ONLINE' " : (this.mode != null && this.mode.equalsIgnoreCase("ReadOnly") ? " and ts.status = 'READ ONLY' " : ""));
        this.query1 = " SELECT TS.NAME,SUM(FS.PHYRDS) AS PHYSICAL_READS,SUM(FS.PHYWRTS) AS PHYSICAL_WRITES FROM V$FILESTAT FS,V$DATAFILE DF,V$TABLESPACE TS,DBA_DATA_FILES DDF WHERE FS.FILE#=DF.FILE# AND \tDDF.FILE_ID=DF.FILE# AND \tDDF.TABLESPACE_NAME=TS.NAME GROUP BY  TS.NAME ";
        this.query3 = "SELECT   TABLESPACE_NAME, MAX(AUTOEXTENSIBLE) AS AUTOEXTENSIBLE  FROM DBA_DATA_FILES GROUP BY TABLESPACE_NAME ";
        this.query4 = this.viewName == null || this.viewName.equals("") || this.viewName.equalsIgnoreCase("NULL") || this.viewName.equalsIgnoreCase("none") ? "SELECT nvl(max_size.tablespace_name,0),nvl(\"SIZE\"/(1024*1024),0) \"SIZE(MB)\",nvl(free_size.biggest,0),nvl(free_size.smallest,0), nvl(max_size.max_extend / (1024 * 1024),0) \"MAX_SIZE(MB)\",nvl(TRUNC ((max_size.max_extend - \"SIZE\" + free)/ seg_max_next.next_extent),-3) \"EXHAUST_AFTER\",decode(free_size.contents,'UNDO',undo_size.undo_used_size_mb,((\"SIZE\"-free_size.free)/1024/1024)) \"USED\" FROM (SELECT B.tablespace_NAME as tablespace_name, nvl(A.FREE,0) as free,nvl(A.BIGGEST,0) as biggest,nvl(A.SMALLEST,0) as smallest,b.contents FROM (SELECT /*+ use_hash (A.ts A.fi) */ tablespace_name,SUM (BYTES) \"FREE\",MAX (BYTES) \"BIGGEST\",MIN (BYTES) \"SMALLEST\" FROM dba_free_space A GROUP BY tablespace_name) A,(SELECT TABLESPACE_NAME,CONTENTS FROM DBA_TABLESPACES ) B WHERE A.TABLESPACE_NAME(+)=B.tablespace_NAME) free_size,(SELECT B.NAME as tablespace_name, nvl(A.\"SIZE\",0) as \"SIZE\" FROM (SELECT tablespace_name,SUM (BYTES) \"SIZE\" FROM dba_data_files GROUP BY tablespace_name) A,(SELECT NAME FROM V$TABLESPACE ) B WHERE A.TABLESPACE_NAME(+)=B.NAME ) phy_size, (SELECT B.NAME as tablespace_name,  A.NEXT_EXTENT  as next_extent FROM (SELECT tablespace_name, MAX (next_extent) next_extent FROM dba_segments GROUP BY tablespace_name ) A,(SELECT NAME FROM V$TABLESPACE ) B WHERE A.TABLESPACE_NAME(+)=B.NAME ) seg_max_next,(SELECT B.NAME as tablespace_name,a.max_extend FROM (SELECT ts.tablespace_name,SUM (ts_size) max_extend FROM dba_tablespaces ts,(SELECT tablespace_name, autoextensible,GREATEST (maxbytes,BYTES) \"TS_SIZE\" FROM dba_data_files ) df WHERE df.tablespace_name = ts.tablespace_name GROUP BY ts.tablespace_name) A,  (SELECT NAME FROM V$TABLESPACE) B WHERE B.NAME(+)=A.TABLESPACE_NAME) max_size,(SELECT\ttablespace_name,sum(bytes)/1024/1024 undo_used_size_mb \tfrom dba_undo_extents\twhere\tstatus <> 'EXPIRED' group by tablespace_name ) undo_size WHERE max_size.tablespace_name = seg_max_next.tablespace_name AND max_size.tablespace_name = phy_size.tablespace_name AND max_size.tablespace_name = free_size.tablespace_name and\tmax_size.tablespace_name = undo_size.tablespace_name(+)" : "SELECT nvl(max_size.tablespace_name,0),nvl(\"SIZE\"/(1024*1024),0) \"SIZE(MB)\", nvl(free_size.biggest,0),nvl(free_size.smallest,0), nvl(max_size.max_extend / (1024 * 1024),0) \"MAX_SIZE(MB)\",nvl(TRUNC ((max_size.max_extend - \"SIZE\" + free)/ seg_max_next.next_extent),-3) \"EXHAUST_AFTER\",decode(free_size.contents,'UNDO',undo_size.undo_used_size_mb,((\"SIZE\"-free_size.free)/1024/1024)) \"USED\" FROM (SELECT B.tablespace_NAME as tablespace_name, nvl(A.FREE,0) as free,nvl(A.BIGGEST,0) as biggest,nvl(A.SMALLEST,0) as smallest,b.contents FROM (SELECT /*+ use_hash (A.ts A.fi) */ tablespace_name,SUM (BYTES) \"FREE\",MAX (BYTES) \"BIGGEST\",MIN (BYTES) \"SMALLEST\" FROM " + this.viewName + " A GROUP BY tablespace_name) A,(SELECT " + "TABLESPACE_NAME,CONTENTS FROM DBA_TABLESPACES ) B WHERE A.TABLESPACE_NAME(+)=B.tablespace_NAME) free_size," + "(SELECT B.NAME as tablespace_name, nvl(A.\"SIZE\",0) as \"SIZE\" FROM (SELECT tablespace_name,SUM (BYTES) \"SIZE\" " + "FROM dba_data_files GROUP BY tablespace_name) A,(SELECT NAME FROM V$TABLESPACE ) B WHERE " + "A.TABLESPACE_NAME(+)=B.NAME ) phy_size, (SELECT B.NAME as tablespace_name,  A.NEXT_EXTENT  as next_extent " + "FROM (SELECT tablespace_name, MAX (next_extent) next_extent FROM dba_segments GROUP BY tablespace_name ) A," + "(SELECT NAME FROM V$TABLESPACE ) B WHERE A.TABLESPACE_NAME(+)=B.NAME ) seg_max_next,(SELECT B.NAME as " + "tablespace_name,a.max_extend FROM (SELECT ts.tablespace_name,SUM (ts_size) max_extend FROM dba_tablespaces ts," + "(SELECT tablespace_name, autoextensible,GREATEST (maxbytes,BYTES) \"TS_SIZE\" FROM dba_data_files ) df " + "WHERE df.tablespace_name = ts.tablespace_name GROUP BY ts.tablespace_name) A,  (SELECT NAME FROM V$TABLESPACE) B " + "WHERE B.NAME(+)=A.TABLESPACE_NAME) max_size,(SELECT\ttablespace_name,sum(bytes)/1024/1024 undo_used_size_mb \tfrom dba_undo_extents\twhere\tstatus <> 'EXPIRED' group by tablespace_name ) undo_size WHERE max_size.tablespace_name = seg_max_next.tablespace_name AND " + "max_size.tablespace_name = phy_size.tablespace_name AND max_size.tablespace_name = free_size.tablespace_name " + "and\tmax_size.tablespace_name = undo_size.tablespace_name(+)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        Connection connection;
        Hashtable<Object, ArrayList> hashtable2;
        ResultSet resultSet;
        Statement statement;
        ArrayList<Object> arrayList;
        double d;
        Object object;
        block45: {
            String string;
            String string2;
            if (this.isInitCheckNeeded) {
                this.isDataguardEnabled = ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
                object = new ArrayList();
                object = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
                if (object != null && ((ArrayList)object).size() > 2) {
                    int n = (Integer)((ArrayList)object).get(0);
                    string2 = (String)((ArrayList)object).get(1);
                    if (string2.equalsIgnoreCase("true")) {
                        this.isCDB = true;
                    }
                    if (n >= 12) {
                        this.isOracle12c = true;
                        string = (String)((ArrayList)object).get(2);
                        if (string.equalsIgnoreCase("true")) {
                            this.isMultitenantDb = true;
                        }
                    }
                    this.isInitCheckNeeded = false;
                } else {
                    if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                        this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + object, " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                        this.msgLogCounter = 0;
                    }
                    ++this.msgLogCounter;
                }
            }
            if (this.isDataguardEnabled) {
                object = ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
                if (object == null || ((Hashtable)object).size() == 0) {
                    return;
                }
                ArrayList arrayList2 = (ArrayList)((Hashtable)object).get(this.reportingName + ":" + this.oraSid);
                if (arrayList2 != null && arrayList2.size() > 0) {
                    string2 = (String)arrayList2.get(2);
                    string = (String)arrayList2.get(3);
                    if (!string2.equalsIgnoreCase("PRIMARY") && string.equalsIgnoreCase("MOUNTED")) {
                        return;
                    }
                } else {
                    return;
                }
            }
            d = -5.0;
            arrayList = new ArrayList<Object>();
            statement = null;
            resultSet = null;
            hashtable2 = new Hashtable<Object, ArrayList>();
            connection = null;
            Object var14_14 = null;
            connection = this.isMultitenantDb && !this.isCDB ? ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug) : ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug);
            if (connection != null) break block45;
            this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
            this.closeRs(resultSet);
            this.closeStmt(statement);
            this.closeConn(connection);
            return;
        }
        try {
            statement = connection.createStatement();
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "OraTableSpacesTest Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
            exception.printStackTrace();
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            this.closeRs(resultSet);
            this.closeStmt(statement);
            this.closeConn(connection);
            return;
        }
        try {
            String string = "select b.tablespace_name, (space*block_size)/1024/1024 size_in_MB from (select ts_name, sum(space) space from dba_recyclebin  group by ts_name)a , (select tablespace_name, block_size from dba_tablespaces ) b where a.ts_name=b.tablespace_name";
            String string3 = "select tablespace_name, contents from dba_tablespaces where contents='UNDO'";
            String string4 = "";
            String string5 = "";
            double d2 = 0.0;
            Hashtable<String, Double> hashtable3 = new Hashtable<String, Double>();
            String string6 = "";
            String string7 = "";
            ArrayList<String> arrayList3 = new ArrayList<String>();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                string6 = resultSet.getString(1);
                string7 = resultSet.getString(2);
                if (string6 == null) continue;
                string6 = string6.trim();
                arrayList3.add(string6);
            }
            this.closeRs(resultSet);
            System.out.println(this.entity + ": undoTabspaceList:" + arrayList3 + ": targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                string4 = resultSet.getString(1);
                string5 = resultSet.getString(2);
                d2 = this.getDoubleValue(string5);
                hashtable3.put(string4, new Double(d2));
            }
            this.closeRs(resultSet);
            resultSet = statement.executeQuery(this.query4);
            String string8 = "";
            ArrayList<Object> arrayList4 = new ArrayList<Object>();
            while (resultSet.next()) {
                ArrayList<Double> arrayList5 = new ArrayList<Double>();
                object = resultSet.getString(1);
                double d3 = resultSet.getDouble(2);
                double d4 = resultSet.getDouble(3);
                d4 /= bToMb;
                double d5 = resultSet.getDouble(4);
                d5 /= bToMb;
                double d6 = resultSet.getDouble(5);
                if (d6 == 0.0) continue;
                double d7 = resultSet.getDouble(6);
                double d8 = resultSet.getDouble(7);
                double d9 = 0.0;
                double d10 = 0.0;
                System.out.println(this.entity + ": Tablespacename:" + (String)object + ": targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                System.out.println(this.entity + ": Current size:" + d3 + ": targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                System.out.println(this.entity + ":  Biggest extent:" + d4 + ": targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                System.out.println(this.entity + ": Smalles extent:" + d5 + ": targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                System.out.println(this.entity + ": Max size:" + d6 + ": targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                System.out.println(this.entity + ": receivedUsedSize:" + d8 + ": targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                if (arrayList3.contains(object)) {
                    d10 = -5.0;
                    d9 = d8;
                } else if (hashtable3 != null && hashtable3.size() > 0) {
                    if (hashtable3.containsKey(object)) {
                        d10 = (Double)hashtable3.get(object);
                        d9 = d8 - d10;
                        System.out.println(this.entity + ": recycleBinTabSpcSize:" + d10 + ": targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                        System.out.println(this.entity + ":Exact usedSize:" + d9 + ": targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    } else {
                        d9 = d8;
                    }
                } else {
                    d9 = d8;
                }
                double d11 = d6 - d9;
                System.out.println(this.entity + ": free:" + d11 + ": targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                if (d3 > 0.0) {
                    d = d9 / d3 * 100.0;
                }
                System.out.println(this.entity + ": pctUsed:" + d + ": targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                if (arrayList != null && !arrayList.contains(object)) {
                    arrayList.add(object);
                }
                double d12 = 0.0;
                if (d11 < 0.0) {
                    d11 = 0.0;
                    d12 = 0.0;
                } else {
                    d12 = d11 * 100.0 / d6;
                }
                System.out.println(this.entity + ": Free percentage:" + d12 + ": targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                arrayList5.add(new Double(d));
                arrayList5.add(new Double(-1.0));
                arrayList5.add(new Double(-1.0));
                arrayList5.add(new Double(-1.0));
                arrayList5.add(new Double(d6));
                arrayList5.add(new Double(d3));
                arrayList5.add(new Double(d11));
                arrayList5.add(new Double(d12));
                arrayList5.add(new Double(d4));
                arrayList5.add(new Double(d5));
                arrayList5.add(new Double(d7));
                if (this.measureCount > 11) {
                    arrayList5.add(new Double(d10));
                }
                hashtable2.put(object, arrayList5);
            }
            this.closeRs(resultSet);
            resultSet = statement.executeQuery(this.query1);
            while (resultSet.next()) {
                object = resultSet.getString(1);
                if (arrayList4 != null && !arrayList4.contains(object)) {
                    arrayList4.add(object);
                }
                double d13 = resultSet.getDouble(2);
                double d14 = resultSet.getDouble(3);
                if (!arrayList.contains(object)) continue;
                int n = this.tableSpaceNames.indexOf(object);
                if (n == -1) {
                    this.tableSpaceNames.add(object);
                    this.prevPhysReads.add(new Double(d13));
                    this.prevPhysWrites.add(new Double(d14));
                    continue;
                }
                if (this.timeSinceLastTest < 0.0) {
                    this.prevPhysReads.set(n, new Double(d13));
                    this.prevPhysWrites.set(n, new Double(d14));
                    continue;
                }
                Double d15 = (Double)this.prevPhysReads.get(n);
                double d16 = d15;
                d15 = (Double)this.prevPhysWrites.get(n);
                double d17 = d15;
                double d18 = (d13 - d16) / this.timeSinceLastTest;
                d18 = d18 < 0.0 ? -1.0 : d18;
                double d19 = (d14 - d17) / this.timeSinceLastTest;
                d19 = d19 < 0.0 ? -1.0 : d19;
                ArrayList arrayList6 = (ArrayList)hashtable2.get(object);
                if (arrayList6 != null) {
                    arrayList6.set(1, new Double(d18));
                    arrayList6.set(2, new Double(d19));
                    hashtable2.put(object, arrayList6);
                }
                this.prevPhysReads.set(n, new Double(d13));
                this.prevPhysWrites.set(n, new Double(d14));
            }
            this.closeRs(resultSet);
            resultSet = statement.executeQuery(this.query3);
            while (resultSet.next()) {
                object = resultSet.getString(1);
                ArrayList arrayList7 = (ArrayList)hashtable2.get(object);
                if (arrayList7 == null) continue;
                string8 = resultSet.getString(2);
                boolean bl = false;
                if (string8 != null && string8.equalsIgnoreCase("Yes")) {
                    bl = true;
                }
                arrayList7.set(3, new Double((double)bl));
                hashtable2.put(object, arrayList7);
            }
            arrayList.clear();
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string9 = (String)enumeration.nextElement();
                ArrayList arrayList8 = (ArrayList)hashtable2.get(string9);
                if (arrayList8 == null) continue;
                this.addNewMeasure(string9, arrayList8);
            }
            this.closeRs(resultSet);
            this.closeStmt(statement);
            this.closeConn(connection);
            this.closeRs(resultSet);
            this.closeStmt(statement);
            this.closeConn(connection);
        }
        catch (Exception exception) {
            try {
                System.out.println("GET CONN FAILED!!!");
                exception.printStackTrace();
                this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
                this.errorMsg = new String("Exception while executing OraTablespacesTest for target: " + this.targetHost);
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
            }
            catch (Throwable throwable) {
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
                throw throwable;
            }
        }
    }

    private double getDoubleValue(String string) {
        double d = 0.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d = 0.0;
        }
        return d;
    }

    protected double roundDouble(double d) {
        double d2 = 0.0;
        int n = 2;
        d2 = this.roundDouble(d, n);
        return d2;
    }

    protected double roundDouble(double d, int n) {
        String string = "roundDouble";
        double d2 = 0.0;
        try {
            Object object;
            Object object2 = "";
            if (n <= 0) {
                object2 = object = "" + (int)(d + (d > 0.0 ? 0.5 : -0.5));
            } else {
                String string2;
                object = "";
                if (d < 0.0) {
                    object = (String)object + "-";
                    d = -d;
                }
                if ((d += 0.5 * Math.pow(10.0, -n)) > 1.0) {
                    int n2 = (int)d;
                    object = (String)object + n2;
                    d -= (double)n2;
                } else {
                    object = (String)object + "0";
                }
                if (d > 0.0) {
                    String string3 = "" + (int)((d += 1.0) * Math.pow(10.0, n));
                    object = (String)object + "." + string3.substring(1);
                }
                object2 = (string2 = EgDbInfo.formatValue((String)object)) == null || string2.trim().length() == 0 ? object : string2;
            }
            object = new Double((String)object2);
            d2 = ((Double)object).isNaN() ? 0.0 : (Double)object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d2;
    }

    void closeRs(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            resultSet = null;
        }
        catch (Exception exception) {
            resultSet = null;
        }
    }

    void closeStmt(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
            statement = null;
        }
        catch (Exception exception) {
            statement = null;
        }
    }

    void closeConn(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
            connection = null;
        }
        catch (Exception exception) {
            connection = null;
        }
    }
}

