/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;

public class OraTempDataFileTest
extends GenericTest {
    public String oraSid = null;
    public String username = null;
    public String password = null;
    private static final int i_measureCount = 4;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    private int msgLogCounter = 0;

    public OraTempDataFileTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(4);
        this.username = this.getValueForParam("username");
        if (this.username == null) {
            this.username = this.getValueForParam("user");
        }
        this.password = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        this.isNewDynamicInfoTest = true;
        if (this.username == null || this.username.equalsIgnoreCase("NULL") || this.username.equalsIgnoreCase("none")) {
            this.username = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        this.setSid(this.oraSid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        String string;
        Object object;
        Object object2;
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName);
            object2 = new ArrayList();
            object2 = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (object2 != null && ((ArrayList)object2).size() > 2) {
                int n = (Integer)((ArrayList)object2).get(0);
                object = (String)((ArrayList)object2).get(1);
                if (((String)object).equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    string = (String)((ArrayList)object2).get(2);
                    if (string.equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isInitCheckNeeded = false;
            } else {
                if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + object2, " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
            }
        }
        if (this.isDataguardEnabled) {
            object2 = ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName);
            if (object2 == null || ((Hashtable)object2).size() == 0) {
                return;
            }
            ArrayList arrayList = (ArrayList)((Hashtable)object2).get(this.reportingName + ":" + this.oraSid);
            if (arrayList != null && arrayList.size() > 0) {
                object = (String)arrayList.get(2);
                string = (String)arrayList.get(3);
                if (!((String)object).equalsIgnoreCase("PRIMARY") && string.equalsIgnoreCase("MOUNTED")) {
                    return;
                }
            } else {
                return;
            }
        }
        object2 = null;
        Statement statement = null;
        object = null;
        string = "select a.file_name,(a.allocated_bytes/1024/1024) as \"Allocated_Size(MB)\",(b.bytes_used/1024/1024) as \"Used_Size(MB)\",(b.bytes_free/1024/1024) as \"Free_Size(MB)\" from (select tablespace_name,file_name, bytes as allocated_bytes from dba_temp_files) a,(select tablespace_name,bytes_used as bytes_used,bytes_free as bytes_free from v$temp_space_header) b where a.tablespace_name = b.tablespace_name";
        try {
            object2 = this.isMultitenantDb && !this.isCDB ? ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug) : ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug);
            if (object2 == null) {
                this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                return;
            }
            try {
                statement = object2.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "OraTempDataFileTest Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                try {
                    if (object2 != null) {
                        object2.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    if (object != null) {
                        object.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    if (object2 != null) {
                        object2.close();
                    }
                }
                catch (Exception exception3) {
                    System.out.println("Exception Occured in OraTempDataFileTest.computeMeasures() in finllay block :" + exception3.toString());
                }
                return;
            }
            object = statement.executeQuery(string);
            ArrayList<Double> arrayList = null;
            String string2 = null;
            while (object.next()) {
                string2 = object.getString(1);
                double d = Double.parseDouble(object.getString(2));
                double d2 = Double.parseDouble(object.getString(3));
                double d3 = Double.parseDouble(object.getString(4));
                double d4 = d3 / d * 100.0;
                arrayList = new ArrayList<Double>();
                arrayList.add(new Double(d));
                arrayList.add(new Double(d2));
                arrayList.add(new Double(d3));
                arrayList.add(new Double(d4));
                this.addNewMeasure(string2, arrayList);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
            System.out.println("Exception Occured in OraTempDataFileTest.computeMeasures() :" + exception.toString());
        }
        finally {
            try {
                if (object != null) {
                    object.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (object2 != null) {
                    object2.close();
                }
            }
            catch (Exception exception) {
                System.out.println("Exception Occured in OraTempDataFileTest.computeMeasures() in finllay block :" + exception.toString());
            }
        }
    }

    public static void main(String[] stringArray) {
        OraTempDataFileTest oraTempDataFileTest = new OraTempDataFileTest(stringArray);
        oraTempDataFileTest.computeMeasures(new Hashtable());
    }
}

