/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;

public class OraTransRollTest
extends GenericTest {
    public String oraSid = "";
    public String username = "";
    public String password = "";
    int defValue = -1;
    ArrayList prevList = new ArrayList();
    private boolean isOracle12c = false;
    private boolean checkOracleVersion = true;
    private boolean isCDB = false;
    private boolean isMultitenantDb = false;

    public OraTransRollTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(3);
        this.username = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        if (this.username == null || this.username.equalsIgnoreCase("NULL") || this.username.equalsIgnoreCase("none")) {
            this.username = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        this.setSid(this.oraSid);
        this.isNewDynamicInfoTest = true;
        if (this.isPassive) {
            this.defValue = -5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        Object object;
        String string;
        ArrayList<Double> arrayList;
        ArrayList<Double> arrayList2;
        int n;
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        ResultSet resultSet;
        Statement statement;
        Connection connection;
        block19: {
            connection = null;
            statement = null;
            resultSet = null;
            d5 = -5.0;
            d4 = -5.0;
            d3 = -5.0;
            d2 = -5.0;
            d = -5.0;
            n = 0;
            arrayList2 = new ArrayList<Double>();
            arrayList = new ArrayList<Double>();
            ArrayList arrayList3 = new ArrayList();
            string = "SELECT NAME,  VALUE FROM V$SYSSTAT WHERE NAME IN ('user commits', 'user rollbacks', 'transaction rollbacks')";
            if (this.checkOracleVersion) {
                arrayList3 = ConnectionManager.checkOracleVersion(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug);
                this.checkOracleVersion = false;
                if (arrayList3 != null && arrayList3.size() > 2) {
                    int n2 = (Integer)arrayList3.get(0);
                    object = (String)arrayList3.get(1);
                    if (((String)object).equalsIgnoreCase("true")) {
                        this.isCDB = true;
                    }
                    if (n2 >= 12) {
                        this.isOracle12c = true;
                        String string2 = (String)arrayList3.get(2);
                        if (string2.equalsIgnoreCase("true")) {
                            this.isMultitenantDb = true;
                        }
                    }
                }
            }
            connection = this.isMultitenantDb && !this.isCDB ? ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug) : ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug);
            if (connection != null) break block19;
            this.logToErrorFile("Error", "OraTransRollTest connection is null for : ", this.targetHost);
            this.closeRs(resultSet);
            this.closeStmt(statement);
            this.closeConn(connection);
            return;
        }
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                if (n == 0) {
                    d5 = resultSet.getDouble(2);
                    arrayList.add(new Double(d5));
                } else if (n != 1 && n == 2) {
                    d4 = resultSet.getDouble(2);
                    arrayList.add(new Double(d4));
                    if (!this.prevList.isEmpty()) {
                        d2 = (Double)this.prevList.get(0);
                        d3 = (Double)this.prevList.get(1);
                        if (d5 >= d2 && d4 >= d3) {
                            d = (d4 -= d3) * 100.0 / ((d5 -= d2) + d4);
                            this.prevList = (ArrayList)arrayList.clone();
                            arrayList2.add(new Double(d5));
                            arrayList2.add(new Double(d4));
                            arrayList2.add(new Double(d));
                        } else {
                            this.prevList = (ArrayList)arrayList.clone();
                            arrayList2.add(new Double(-1.0));
                            arrayList2.add(new Double(-1.0));
                            arrayList2.add(new Double(-1.0));
                        }
                    } else {
                        this.prevList = (ArrayList)arrayList.clone();
                        arrayList2.add(new Double(-1.0));
                        arrayList2.add(new Double(-1.0));
                        arrayList2.add(new Double(-1.0));
                    }
                }
                ++n;
            }
            if (debug) {
                System.out.println("[OraTransRollTest]===>output" + arrayList2);
            }
            this.addNewMeasure(arrayList2);
            this.closeRs(resultSet);
            this.closeStmt(statement);
            this.closeConn(connection);
        }
        catch (Exception exception) {
            try {
                System.out.println("Exception Occured in OraTransRollTest.computeMeasures():" + exception.toString());
                this.logToErrorFile("Exception Occured in OraTransRollTest:", ".computeMeasures()", "Unable to getconnection " + exception.toString());
                exception.printStackTrace();
                object = new ArrayList();
                ((ArrayList)object).add(new Double(-1.0));
                ((ArrayList)object).add(new Double(-1.0));
                ((ArrayList)object).add(new Double(-1.0));
                this.addNewMeasure((ArrayList)object);
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
            }
            catch (Throwable throwable) {
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
                throw throwable;
            }
        }
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        OraTransRollTest oraTransRollTest = new OraTransRollTest(stringArray);
        oraTransRollTest.computeMeasures(new Hashtable());
    }
}

