/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgSpecsInfo;
import com.eg.IPV6Helper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;

public class ProgressDbValidator
extends EgServerValidator {
    public String reportingName = "";
    public String test = "";
    public String host = "";
    public String port = "";
    public String user = "";
    public String password = "";
    public String domain = "";
    public String isAgentLess = "";
    public String alMode = "";
    public String alUser = "";
    public String alPassword = "";
    public boolean isConnectivityOk = true;
    public boolean isExternalTest = false;
    public boolean meAgentLess = false;
    private String ssl = "false";
    private String dbName = "";
    public String validationErrorMsg = "";
    public ArrayList validationMsgs = null;
    public Hashtable validationErrorMap = new Hashtable();
    private boolean isUserPrevilegeDenied = false;
    private ArrayList previlegeDeniedTables = new ArrayList();
    EgSpecsInfo specsInfo = new EgSpecsInfo("manager");

    public ProgressDbValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = string.substring(0, string.indexOf(":"));
                String string3 = string.substring(string.indexOf(":") + 1);
                if ((string2 = string2.trim()) != null && string2.equalsIgnoreCase("-host")) {
                    this.host = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-port")) {
                    this.port = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-database_name")) {
                    this.dbName = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-rptname")) {
                    this.reportingName = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-test")) {
                    this.test = string3;
                    if (!this.specsInfo.isExternalTest(this.test)) continue;
                    this.isExternalTest = true;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-username")) {
                    this.user = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-password")) {
                    if ((string3 = EgCrypt.decrypt(string3)).indexOf("~EG~") != -1) {
                        string3 = string3.substring(0, string3.indexOf("~EG~"));
                    }
                    this.password = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-agentless")) {
                    this.isAgentLess = string3;
                    if (this.isAgentLess != null && this.isAgentLess.equalsIgnoreCase("y")) {
                        this.meAgentLess = true;
                        continue;
                    }
                    this.isAgentLess = "false";
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-almode")) {
                    this.alMode = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-aluser")) {
                    this.alUser = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-alpassword")) {
                    if ((string3 = EgCrypt.decrypt(string3)).indexOf("~EG~") != -1) {
                        string3 = string3.substring(0, string3.indexOf("~EG~"));
                    }
                    this.alPassword = string3;
                    continue;
                }
                if (string2 == null || !string2.equalsIgnoreCase("-ssl")) continue;
                this.ssl = string3;
            }
        }
        this.validationMsgs = new ArrayList();
        this.validate();
    }

    public void validate() {
        try {
            if (!this.checkProgressDbConnectivity()) {
                if (!this.isIPReachable()) {
                    this.validationMsgs.add("Progress Database Server Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$Host IP/Name  '" + this.host + "' is invalid or Host IP/Name is unreachable");
                    this.validationMsgs.add("Port$#$NA");
                } else if (!this.isPortReachable()) {
                    this.validationMsgs.add("Progress Database Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$Port settings is incorrect");
                } else {
                    String string = (String)this.validationErrorMap.get("Progressdb_Connectivity");
                    if (this.isUserPrevilegeDenied) {
                        String string2 = "";
                        StringBuffer stringBuffer = new StringBuffer(string);
                        int n = this.previlegeDeniedTables.size();
                        stringBuffer.append(" due to : [ \"User '" + this.user + "' doesn't have SELECT permission to the following tables:\" ]");
                        int n2 = 0;
                        for (int i = 0; i < n; ++i) {
                            string2 = (String)this.previlegeDeniedTables.get(i);
                            n2 = i + 1;
                            stringBuffer.append(" (" + n2 + ")." + string2);
                            if (i + 1 == n) continue;
                            stringBuffer.append(",");
                        }
                        string = stringBuffer.toString();
                        System.out.println("TESTING ::" + string);
                    }
                    this.validationMsgs.add("Progress Database Server Connectivity$#$" + string);
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$OK");
                }
            } else {
                this.validationMsgs.add("Progress Database Connectivity$#$OK");
                this.validationMsgs.add("Host IP/Name$#$OK");
                this.validationMsgs.add("Port$#$OK");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean checkProgressDbConnectivity() {
        block15: {
            boolean bl = false;
            String string = "";
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            String string2 = "com.ddtek.jdbc.openedge.OpenEdgeDriver";
            String string3 = "jdbc:datadirect:openedge://" + this.host + ":" + this.port + ";databaseName=" + this.dbName;
            try {
                this.host = IPV6Helper.getValidIPAddress(this.host);
                Class.forName(string2);
                connection = DriverManager.getConnection(string3, this.user, this.password);
                if (connection != null) {
                    this.checkProgressDBUserprivilege(connection);
                }
                this.closeResultSet(resultSet);
                this.closeStatement(statement);
                this.closeConnnection(connection);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                int n = sQLException.getErrorCode();
                String string4 = sQLException.getMessage();
                this.isConnectivityOk = false;
                if (n == -20228) {
                    bl = true;
                    string4 = "Access denied Authorization failed";
                } else if (n == -20109) {
                    bl = true;
                    string4 = "Remote Database Name not valid";
                }
                if (bl) {
                    this.validationErrorMsg = string4.trim();
                } else {
                    String string5 = this.getStackTraceAsString(sQLException);
                    if (string5 != null && string5.indexOf("[OpenEdge]") > 0) {
                        string5 = string5.substring(string5.indexOf("OpenEdge]") + 9, string5.length());
                        string = string5 = string5.substring(0, string5.indexOf(")") + 1);
                    } else {
                        string = string5;
                    }
                    this.validationErrorMsg = string;
                }
                this.validationErrorMap.put("Progressdb_Connectivity", this.validationErrorMsg);
                this.closeResultSet(resultSet);
                this.closeStatement(statement);
                this.closeConnnection(connection);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                break block15;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.closeResultSet(resultSet);
                this.closeStatement(statement);
                this.closeConnnection(connection);
            }
        }
        return this.isConnectivityOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkProgressDBUserprivilege(Connection connection) {
        Statement statement = null;
        ResultSet resultSet = null;
        boolean bl = false;
        String string = "";
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("PUB.\"_ActAILog\"");
            arrayList.add("PUB.\"_ActBILog\"");
            arrayList.add("PUB.\"_ActIOFile\"");
            arrayList.add("PUB.\"_ActIndex\"");
            arrayList.add("PUB.\"_ActServer\"");
            arrayList.add("PUB.\"_Actbuffer\"");
            arrayList.add("PUB.\"_Area\"");
            arrayList.add("PUB.\"_AreaStatus\"");
            arrayList.add("PUB.\"_BuffStatus\"");
            arrayList.add("PUB.\"_Connect\"");
            arrayList.add("PUB.\"_Latch\"");
            arrayList.add("PUB.\"_LockReq\"");
            arrayList.add("PUB.\"_UserIO\"");
            arrayList.add("PUB.\"_UserLock\"");
            System.out.println("ProgressDbValidator tableList::" + arrayList);
            try {
                statement = connection.createStatement();
            }
            catch (Exception exception) {
                String string2 = this.getStackTraceAsString(exception);
                if (string2 != null && string2.indexOf("[OpenEdge]") > 0) {
                    string2 = string2.substring(string2.indexOf("OpenEdge]") + 9, string2.length());
                    string = string2 = string2.substring(0, string2.indexOf(")") + 1);
                } else {
                    string = string2;
                }
                this.validationErrorMsg = string;
                this.closeConnnection(connection);
                this.isConnectivityOk = false;
                this.closeResultSet(resultSet);
                this.closeStatement(statement);
                this.closeConnnection(connection);
                return;
            }
            String string3 = "";
            for (int i = 0; i < arrayList.size(); ++i) {
                try {
                    string3 = (String)arrayList.get(i);
                    resultSet = statement.executeQuery("select top 1 * from " + string3);
                    continue;
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    int n = sQLException.getErrorCode();
                    String string4 = sQLException.getMessage();
                    this.isConnectivityOk = false;
                    this.isUserPrevilegeDenied = true;
                    if (n == -20228) {
                        bl = true;
                        string4 = "Access denied Authorization failed";
                    }
                    if (bl) {
                        this.validationErrorMsg = string4.trim();
                    } else {
                        String string5 = this.getStackTraceAsString(sQLException);
                        if (string5 != null && string5.indexOf("[OpenEdge]") > 0) {
                            string5 = string5.substring(string5.indexOf("OpenEdge]") + 9, string5.length());
                            string = string5 = string5.substring(0, string5.indexOf(")") + 1);
                        } else {
                            string = string5;
                        }
                        this.validationErrorMsg = string;
                    }
                    this.validationErrorMap.put("Progressdb_Connectivity", this.validationErrorMsg);
                    this.previlegeDeniedTables.add(string3);
                }
            }
            this.closeResultSet(resultSet);
            this.closeStatement(statement);
            this.closeConnnection(connection);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string6 = exception.getMessage();
            this.isConnectivityOk = false;
            String string7 = this.getStackTraceAsString(exception);
            if (string7 != null && string7.indexOf("[OpenEdge]") > 0) {
                string7 = string7.substring(string7.indexOf("OpenEdge]") + 9, string7.length());
                string = string7 = string7.substring(0, string7.indexOf(")") + 1);
            } else {
                string = string7;
            }
            this.validationErrorMsg = string;
        }
        finally {
            this.closeResultSet(resultSet);
            this.closeStatement(statement);
            this.closeConnnection(connection);
        }
    }

    public ArrayList getValidationMsgs() {
        System.out.println("########getting Validation Hashtable---->" + this.validationMsgs);
        return this.validationMsgs;
    }

    public void closeConnnection(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void closeStatement(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void closeResultSet(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
    }
}

