/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgJNIUtil;
import java.util.ArrayList;
import java.util.Hashtable;

public class ProtocolAnalyAgTest
extends GenericTest {
    private EgJNIUtil egPerfUtil = null;
    private static String object = "MSExchange Protocol Analysis Agent";
    private static String[] counters = new String[]{"Senders Processed", "Senders Blocked Because of Local Open Proxy", "Senders Blocked Because of Remote Open Proxy", "Senders Blocked Because of Local SRL", "Senders Blocked Because of Remote SRL"};
    private boolean debug = false;
    private double[] diffValues = null;
    private boolean firstTime = true;

    public ProtocolAnalyAgTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(5);
        String string = this.getValueForParam("debug");
        this.debug = string != null && !"false".equalsIgnoreCase(string);
        this.isDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        ArrayList<Double> arrayList = null;
        if (!this.meAgentless) {
            if (this.egPerfUtil == null) {
                this.egPerfUtil = new EgJNIUtil();
            }
        } else if (this.isPerfmon) {
            this.checkNbt();
            if (this.nbtName == null) {
                this.errorMsg = "Failed to get the NETBios name for  " + this.targetHost;
                this.setErrorMessage(this.errorMsg);
                this.stopTest();
                return;
            }
            if (this.egPerfUtil == null) {
                EgJNIUtil.isHostAvailable((String)this.nbtName);
                this.egPerfUtil = new EgJNIUtil();
            }
        }
        double[] dArray = null;
        if (!this.meAgentless) {
            dArray = this.egPerfUtil.getCounterValue(object, counters);
        } else if (this.isPerfmon) {
            dArray = this.egPerfUtil.getCounterValue(object, counters, this.nbtName, "perfmon");
        }
        if (dArray == null || dArray.length == 0) {
            this.setErrorMessage("No counter values are available in XChgProtocolAnalysisAgentTest_ex for " + this.targetHost);
            this.stopTest();
            this.firstTime = true;
            this.diffValues = new double[counters.length];
            return;
        }
        arrayList = new ArrayList<Double>();
        if (this.firstTime) {
            this.firstTime = false;
            this.diffValues = new double[counters.length];
            for (int i = 0; i < counters.length; ++i) {
                arrayList.add(new Double(-5.0));
                this.diffValues[i] = dArray[i];
            }
        } else {
            double d = 0.0;
            for (int i = 0; i < dArray.length; ++i) {
                d = dArray[i] - this.diffValues[i];
                arrayList.add(new Double(d));
                this.diffValues[i] = dArray[i];
            }
        }
        this.addNewMeasure(arrayList);
    }

    public void stopTest() {
        if (this.egPerfUtil != null) {
            this.egPerfUtil.stop();
            this.egPerfUtil = null;
            this.diffValues = new double[counters.length];
        }
    }
}

