/*
 * Decompiled with CFR 0.152.
 */
import com.eg.Base64Coder;
import com.eg.EgLangInfo;
import com.eg.IniFile;
import com.egurkha.util.EgUtilities;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Scanner;
import java.util.StringTokenizer;

public class RabbitMQValidator
extends EgServerValidator {
    public String reportingName = "";
    public String test = "";
    public String host = "";
    public String port = "";
    public String isAgentLess = "";
    public String alMode = "";
    public String alUser = "";
    public String alPassword = "";
    public String url = "";
    public String user = "none";
    public String password = "none";
    public String ssl = null;
    public boolean isSSL = false;
    private long timeout;
    public boolean isConnectivityOk = false;
    public boolean isTableInfoComing = true;
    public boolean meAgentLess = false;
    public String connectivityMsg = "";
    public String subject = "WORKING_TESTS";
    public String key = "";
    public String errorMsg = "error";
    public String validationMsg = "";
    public String validationErrorMsg = "";
    public boolean isFromManager = false;
    public boolean isTargetIp = true;
    public ArrayList validationMsgs = null;
    public Hashtable validationErrorMap = new Hashtable();
    protected static final int DEFAULT_CONNECTION_TIMEOUT = 15000;
    protected static final int DEFAULT_READ_TIMEOUT = 60000;
    protected static final String METHOD_GET = "GET";
    protected static final String AUTHORIZATION_KEY = "Authorization";
    protected static final String CONTENT_TYPE_KEY = "Content-Type";
    protected static final String CONTENT_TYPE_VALUE = "application/json";
    protected static final String CACHE_CONTROL_KEY = "Cache-Control";
    protected static final String CACHE_CONTROL_VALUE = "no-cache";
    protected String token = null;
    EgUtilities egutil = EgUtilities.createInstance();
    String logMessage = "";
    String trustStoreFile = null;
    String privateKeyFile = null;
    String privateKeyFilePassword = null;
    String tlsVersion = null;
    boolean privateKeyAvailable = false;
    protected static final String NULL = "null";
    protected static final String NONE = "none";
    protected static final String HYPHEN = "-";
    private long collectionTimeout;
    private static final long collectionTimeout_Chk = 50L;
    private static final String def_IdleTimeout = "120";
    protected static final String TEST_NAME = "RabbitMQValidator";
    protected static final int ASCII_CODE_FOR_SPACE = 32;
    protected static final String SPACE = new String(" ");
    protected static final String BASE_REST_EXECUTOR_CLASS = SPACE + "RabbitMQValidator" + "RESTExecutor" + SPACE;
    protected static final String LOG_FILE_NAME = "RabbitMQValidatorLog";
    protected static final String INI_ENTRY_FOR_LOG_FILE_SIZE = "RabbitMQValidatorLogSizeLimitInMB";
    protected static final String DEBUG_LOG_ABSOLUTE_PATH = EgInstallInfo.getInstallDir() + "/agent/logs/" + "RabbitMQValidatorLog";
    protected static final double MB_TO_BYTES = 1048576.0;
    protected static final double DEBUG_LOG_FILE_SIZE_IN_MB = 1.0;
    protected double debugLogSizeLimitInMB = 1048576.0;
    String javaOptions = "java";
    String heapDumpPath = null;
    protected static final String COLONS = ":";
    private static final String RABBITMQ_REST_OUTPUT = "RABBITMQ_REST_OUTPUT:";
    private static final String RABBITMQ_ENDPOINT_URL_OUTPUT = "RABBITMQ_ENDPOINT_URL_OUTPUT:";
    private static final String SEPERATOR_1 = "~!~";
    protected static final String EG_TIME_FORMAT = "MM/dd/yyyy HH:mm:ss";
    protected static final SimpleDateFormat MY_SDF = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    String entity = "RabbitMQValidator";
    protected static final String DEBUG = "DEBUG    ";
    protected static final String ERROR = "ERROR    ";
    protected static final String INFO = "INFO     ";
    protected static final String CRITICAL = "CRITICAL ";
    protected static final String WARNING = "WARNING  ";

    public RabbitMQValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        String string = "Constructor";
        string = this.methodNameTemplate(string);
        try {
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    Object object;
                    String string2 = stringArray[i];
                    String string3 = string2.substring(0, string2.indexOf(COLONS));
                    String string4 = string2.substring(string2.indexOf(COLONS) + 1);
                    if ((string3 = string3.trim()) != null && string3.equalsIgnoreCase("-host")) {
                        this.host = string4;
                    } else if (string3 != null && string3.equalsIgnoreCase("-port")) {
                        this.port = string4;
                    } else if (string3 != null && string3.equalsIgnoreCase("-rptname")) {
                        this.reportingName = string4;
                    } else if (string3 != null && string3.equalsIgnoreCase("-test")) {
                        this.test = string4;
                    } else if (string3 != null && string3.equalsIgnoreCase("-username")) {
                        this.user = string4;
                    } else if (string3 != null && string3.equalsIgnoreCase("-password")) {
                        this.password = string4;
                        if (this.password == null || this.password.trim().length() == 0 || this.password.equalsIgnoreCase(NULL) || this.password.equalsIgnoreCase(NONE)) {
                            this.password = NONE;
                            this.logMessage = string + "Password is null or empty ";
                            this.printOut(this.logMessage);
                            this.logMessage = "";
                        } else {
                            this.password = EgCrypt.decrypt(this.password);
                            if (this.password.indexOf("~EG~") != -1) {
                                this.password = this.password.substring(0, this.password.indexOf("~EG~"));
                            }
                        }
                    } else if (string3 != null && string3.equalsIgnoreCase("-ssl")) {
                        this.ssl = string4;
                    } else if (string3 != null && string3.equalsIgnoreCase("-agentless")) {
                        this.isAgentLess = string4;
                        if (this.isAgentLess != null && this.isAgentLess.equalsIgnoreCase("y")) {
                            this.meAgentLess = true;
                        } else {
                            this.isAgentLess = "false";
                        }
                    } else if (string3 != null && string3.equalsIgnoreCase("-almode")) {
                        this.alMode = string4;
                    } else if (string3 != null && string3.equalsIgnoreCase("-aluser")) {
                        this.alUser = string4;
                    } else if (string3 != null && string3.equalsIgnoreCase("-alpassword")) {
                        this.alPassword = string4;
                    } else if (string3 != null && string3.equalsIgnoreCase("-timeout_seconds")) {
                        object = string4;
                        this.printOut(string + "Timeout string value in constructor : " + (String)object);
                        try {
                            this.collectionTimeout = Long.parseLong((String)object) * 1000L;
                        }
                        catch (NumberFormatException numberFormatException) {
                            try {
                                this.collectionTimeout = Long.parseLong(def_IdleTimeout) * 1000L;
                            }
                            catch (NumberFormatException numberFormatException2) {}
                        }
                    } else if (string3 != null && string3.equalsIgnoreCase("-truststore_file")) {
                        this.trustStoreFile = string4;
                        if (this.trustStoreFile == null || this.trustStoreFile.trim().length() == 0 || this.trustStoreFile.equalsIgnoreCase(NULL) || this.trustStoreFile.equalsIgnoreCase(NONE)) {
                            this.trustStoreFile = NONE;
                            this.logMessage = string + "Truststore File  null or empty ";
                            this.printOut(this.logMessage);
                            this.logMessage = "";
                        }
                    } else if (string3 != null && string3.equalsIgnoreCase("-private_key_file")) {
                        this.privateKeyFile = string4;
                        if (this.privateKeyFile == null || this.privateKeyFile.trim().length() == 0 || this.privateKeyFile.equalsIgnoreCase(NULL) || this.privateKeyFile.equalsIgnoreCase(NONE)) {
                            this.privateKeyFile = NONE;
                            this.logMessage = string + "Private Key File  null or empty ";
                            this.printOut(this.logMessage);
                            this.logMessage = "";
                        }
                    } else if (string3 != null && string3.equalsIgnoreCase("-private_key_file_password")) {
                        this.privateKeyFilePassword = string4;
                        if (this.privateKeyFilePassword == null || this.privateKeyFilePassword.trim().length() == 0 || this.privateKeyFilePassword.equalsIgnoreCase(NULL) || this.privateKeyFilePassword.equalsIgnoreCase(NONE)) {
                            this.privateKeyFilePassword = NONE;
                            this.logMessage = string + "Private Key File Password is null or empty ";
                            this.printOut(this.logMessage);
                            this.logMessage = "";
                        } else {
                            this.privateKeyFilePassword = EgCrypt.decrypt(this.privateKeyFilePassword);
                            if (this.privateKeyFilePassword.indexOf("~EG~") != -1) {
                                this.privateKeyFilePassword = this.privateKeyFilePassword.substring(0, this.privateKeyFilePassword.indexOf("~EG~"));
                            }
                        }
                    } else if (string3 != null && string3.equalsIgnoreCase("-tls_version")) {
                        this.tlsVersion = string4;
                        if (this.tlsVersion == null || this.tlsVersion.trim().length() == 0 || this.tlsVersion.equalsIgnoreCase(NULL) || this.tlsVersion.equalsIgnoreCase(NONE)) {
                            this.tlsVersion = this.privateKeyFile != NONE && this.privateKeyFile != NULL && this.privateKeyFilePassword != NONE && this.privateKeyFilePassword != NULL ? "TLSv1.2" : NONE;
                            this.logMessage = string + "TLS Version is null or empty from user input";
                            this.printOut(this.logMessage);
                            this.logMessage = "";
                        }
                    }
                    object = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini", false);
                    String string5 = ((IniFile)object).getValue("AGENT_SETTINGS", INI_ENTRY_FOR_LOG_FILE_SIZE);
                    if (string5 != null && string5.length() > 0) {
                        string5 = string5.trim();
                        try {
                            this.debugLogSizeLimitInMB = Double.parseDouble(string5);
                            this.debugLogSizeLimitInMB *= 1048576.0;
                            this.printOut(string + "strLogSizeLimitInMB value in bytes : " + this.debugLogSizeLimitInMB);
                        }
                        catch (Exception exception) {
                            this.printOut(string + "Conversion error for strLogSizeLimitInMB value to bytes : " + string5 + " ,exception :" + exception.toString());
                            this.debugLogSizeLimitInMB = 1048576.0;
                        }
                    } else {
                        this.debugLogSizeLimitInMB = 1048576.0;
                    }
                    if ("true".equalsIgnoreCase(this.ssl)) {
                        this.url = "https://";
                        this.isSSL = true;
                        continue;
                    }
                    this.url = "http://";
                }
                this.token = this.createBasicAuthToken(this.user, this.password);
            }
            if (this.timeout == 0L) {
                this.timeout = 2L * EgConfigInfo.msecPerMin;
            }
            if (!this.isIpAddress(this.host)) {
                this.isTargetIp = false;
            }
            this.key = this.test + "#~#" + this.reportingName + COLONS + this.port + COLONS + this.host;
            this.validationMsgs = new ArrayList();
            this.validate();
            this.isFromManager = bl;
        }
        catch (Exception exception) {
            this.printOutStackTrace(string + "Error :", exception);
        }
    }

    public void validate() {
        String string = "validate";
        string = this.methodNameTemplate(string);
        try {
            this.printOut(string + "admin_host " + this.admin_host);
            if (!this.isIPReachable()) {
                String string2 = this.host;
                if (this.url != null && !this.url.equals("")) {
                    string2 = this.admin_host;
                }
                this.validationMsgs.add("RabbitMQ Server Connectivity$#$NA");
                this.validationMsgs.add("Host IP/Name$#$Host IP/Name  '" + string2 + "' is invalid or Host IP/Name is unreachable");
                this.validationMsgs.add("Port$#$NA");
            } else if (!this.isPortReachable()) {
                this.validationMsgs.add("RabbitMQ Server Connectivity$#$NA");
                this.validationMsgs.add("Host IP/Name$#$OK");
                this.validationMsgs.add("Port$#$Port settings is incorrect or RabbitMQ Server is down");
            } else {
                this.validationMsgs.add("Host IP/Name$#$OK");
                this.validationMsgs.add("Port$#$OK");
                this.checkRabbitMQConnectivity();
                this.printOut(string + "final arrayList " + this.getValidationMsgs());
            }
            if (!this.isFromManager) {
                return;
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace(string + "Error :", exception);
            exception.printStackTrace();
        }
    }

    public boolean isIpAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return false;
        }
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            try {
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (n2 <= 255 && n2 >= 0) continue;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    private String createBasicAuthToken(String string, String string2) {
        String string3 = string + COLONS + string2;
        String string4 = Base64Coder.encodeString(string3);
        return "Basic " + string4;
    }

    public void checkRabbitMQConnectivity() {
        double d = 0.0;
        Object var3_2 = null;
        String string = null;
        String string2 = "checkRabbitMQConnectivity";
        string2 = this.methodNameTemplate(string2);
        if (this.isSSL) {
            this.printOut(string2 + " Calling SSL or MTLS with exec method ");
            string = this.getDataFromExe("overview");
            this.printOut(string2 + " Calling SSL or MTLS with exec method jsonText : " + string);
            string = this.parseJSONText(string);
            d = this.convertToDouble(string);
            this.printOut(string2 + " Calling SSL or MTLS with exec method jsonText code : " + d);
        } else {
            this.printOut(string2 + " Calling Non-SSL with normal method ");
            d = this.checkRabbitMQConnectivityForNonSSL();
        }
        if (d == 200.0) {
            this.validationErrorMsg = "code 200 - Server is running normal";
            this.validationMsgs.add("User/Password$#$OK");
            this.validationMsgs.add("RabbitMQ Server Connectivity$#$OK");
        } else if (d == 500.0) {
            this.validationErrorMsg = "Error 500 - No Response from server due to internal server error";
            this.validationMsgs.add("User/Password$#$NA");
            this.validationMsgs.add("RabbitMQ Server Connectivity$#$No Response from server due to internal server error");
        } else if (d == 404.0) {
            this.validationErrorMsg = "Error 404 - No Response from server";
            this.validationMsgs.add("User/Password$#$NA");
            this.validationMsgs.add("RabbitMQ Server Connectivity$#$No Response from server");
        } else if (d == 503.0) {
            this.validationErrorMsg = "Error 503 - The server is currently unavailable or not started";
            this.validationMsgs.add("User/Password$#$NA");
            this.validationMsgs.add("RabbitMQ Server Connectivity$#$The server is currently unavailable or not started");
        } else if (d == 401.0) {
            this.validationErrorMsg = "Error 401 - Unauthorized: Access is denied due to invalid credentials";
            this.validationMsgs.add("User/Password$#$NA");
            this.validationMsgs.add("RabbitMQ Server Connectivity$#$ Access denied. Please check Username/Password");
        } else {
            this.validationErrorMsg = "Unable to validate";
            this.validationMsgs.add("User/Password$#$NA");
            this.validationMsgs.add("RabbitMQ Server Connectivity$#$ Unable to validate");
        }
    }

    public int checkRabbitMQConnectivityForNonSSL() {
        HttpURLConnection httpURLConnection = null;
        String string = "checkRabbitMQConnectivityForNonSSL";
        string = this.methodNameTemplate(string);
        String string2 = "";
        string2 = "http://" + this.host + COLONS + this.port;
        URL uRL = null;
        try {
            uRL = new URL(null, string2 + "/api/overview");
        }
        catch (MalformedURLException malformedURLException) {
            this.logMessage = string + " MalformedURLException ";
            this.printOutStackTrace(this.logMessage, malformedURLException);
            this.logMessage = "";
            malformedURLException.printStackTrace();
        }
        try {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
        }
        catch (IOException iOException) {
            this.logMessage = string + " HttpURLConnection  error ";
            this.printOutStackTrace(this.logMessage, iOException);
            this.logMessage = "";
            iOException.printStackTrace();
        }
        try {
            httpURLConnection.setRequestMethod(METHOD_GET);
        }
        catch (ProtocolException protocolException) {
            this.logMessage = string + " Your HTTP connection does not support  setRequestMethod ";
            this.printOutStackTrace(this.logMessage, protocolException);
            this.logMessage = "";
            protocolException.printStackTrace();
        }
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setConnectTimeout(15000);
        httpURLConnection.setReadTimeout(60000);
        httpURLConnection.addRequestProperty(CONTENT_TYPE_KEY, CONTENT_TYPE_VALUE);
        httpURLConnection.setRequestProperty(AUTHORIZATION_KEY, this.token);
        httpURLConnection.setRequestProperty(CACHE_CONTROL_KEY, CACHE_CONTROL_VALUE);
        RabbitMQConnectionThread rabbitMQConnectionThread = new RabbitMQConnectionThread(httpURLConnection, string);
        int n = 0;
        boolean bl = this.checkForTimeout(rabbitMQConnectionThread);
        if (bl) {
            n = rabbitMQConnectionThread.code;
        }
        if (!bl || n != 200) {
            this.logMessage = string + " Timing out or invalid response code:" + n;
            this.printOut(this.logMessage);
            this.logMessage = "";
        }
        httpURLConnection.disconnect();
        return n;
    }

    protected String decodeResponse(InputStream inputStream) throws IOException {
        Scanner scanner = new Scanner(inputStream);
        scanner.useDelimiter("\\A");
        return scanner.hasNext() ? scanner.next() : "";
    }

    private boolean checkForTimeout(RabbitMQConnectionThread rabbitMQConnectionThread) {
        long l;
        String string = "checkForTimeout";
        string = this.methodNameTemplate(string);
        long l2 = 0L;
        long l3 = 250L;
        long l4 = 2L * EgConfigInfo.msecPerMin;
        do {
            if (l3 < EgAgentCommon.minimumSleep) {
                l3 = EgAgentCommon.minimumSleep;
            }
            this.suspendForPeriod(l3);
            if (rabbitMQConnectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= l4) {
                this.logMessage = string + "Timed out and hence going to kill the thread :" + System.currentTimeMillis();
                this.printOut(this.logMessage);
                this.logMessage = "";
                rabbitMQConnectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                this.logMessage = string + " Timed out and killed the thread :" + System.currentTimeMillis();
                this.printOut(this.logMessage);
                this.logMessage = "";
                rabbitMQConnectionThread.stop();
                return false;
            }
            l = l3;
            if (l4 - l2 >= l) continue;
            l = l4 - l2;
        } while ((l3 = l) > 0L);
        this.logMessage = string + " sleepTime less than zero in checkForTimeout :" + System.currentTimeMillis();
        this.printOut(this.logMessage);
        this.logMessage = "";
        rabbitMQConnectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        rabbitMQConnectionThread.stop();
        return false;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-host:192.168.11.147", "-port:15672", "-username:admin", "-password:password", "-ssl:false", "-test:RabMQCluster"};
        RabbitMQValidator rabbitMQValidator = new RabbitMQValidator(stringArray2, new Boolean(false));
        rabbitMQValidator.checkRabbitMQConnectivity();
        System.out.println(rabbitMQValidator.getValidationMsgs());
    }

    public ArrayList getValidationMsgs() {
        String string = "getValidationMsgs";
        string = this.methodNameTemplate(string);
        this.printOut(string + "Validation messages :" + this.validationMsgs);
        return this.validationMsgs;
    }

    public String getDataFromExe(String string) {
        String string2;
        String string3;
        Object object;
        String string4 = "getDataFromExe";
        string4 = this.methodNameTemplate(string4);
        String string5 = "";
        this.heapDumpPath = null;
        this.javaOptions = "java";
        try {
            object = System.getProperty("os.name");
            string3 = System.getProperty("java.version");
            string2 = System.getProperty("os.arch");
            if (string3.compareTo("10.0") > 0) {
                this.heapDumpPath = "-XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null -XX:-CreateCoredumpOnCrash";
                if (object != null && ((String)object).toLowerCase().indexOf("win") >= 0) {
                    this.heapDumpPath = "-XX:ErrorFile=NUL -XX:HeapDumpPath=NUL -XX:-CreateCoredumpOnCrash";
                }
                this.printOut(string4 + "javaVersion 10.0 HeapDumpPath :" + this.heapDumpPath);
            } else if (string3.compareTo("1.7") > 0) {
                this.heapDumpPath = "-XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null -XX:-CreateMinidumpOnCrash";
                if (object != null && ((String)object).toLowerCase().indexOf("win") >= 0) {
                    this.heapDumpPath = "-XX:ErrorFile=NUL -XX:HeapDumpPath=NUL -XX:-CreateMinidumpOnCrash";
                }
                this.printOut(string4 + "javaVersion 1.7  HeapDumpPath :" + this.heapDumpPath);
            } else if (string3.compareTo("1.6") > 0) {
                this.heapDumpPath = "-XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null";
                if (object != null && ((String)object).toLowerCase().indexOf("win") >= 0) {
                    this.heapDumpPath = "-XX:ErrorFile=NUL -XX:HeapDumpPath=NUL";
                }
                this.printOut(string4 + "javaVersion 1.6 HeapDumpPath :" + this.heapDumpPath);
            }
            if (this.heapDumpPath != null) {
                this.printOut(string4 + " HeapDumpPath :" + this.heapDumpPath);
                this.javaOptions = this.javaOptions + " " + this.heapDumpPath;
                this.printOut(string4 + " HeapDumpPath :" + this.heapDumpPath + " java options : " + this.javaOptions);
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace(string4 + "Error while set the heapDumpPath to call rexec process  :", exception);
        }
        this.printOut(string4 + " javaOptions " + this.javaOptions);
        if (this.privateKeyFile != NONE && this.privateKeyFile != NULL && this.privateKeyFilePassword != NONE && this.privateKeyFilePassword != NULL) {
            this.javaOptions = this.javaOptions + " -Djavax.net.ssl.trustStore=" + this.trustStoreFile;
            this.printOut(string4 + "Calling MTLS enabled  javaOptions " + this.javaOptions);
        }
        object = new ArrayList();
        string3 = EgCrypt.encrypt(this.password, true);
        string2 = EgCrypt.encrypt(this.privateKeyFilePassword, true);
        String string6 = " -host " + this.host + " -port " + this.port + " -username " + this.user + " -password " + string3 + " -timeout " + this.collectionTimeout + " -rptName " + this.reportingName + " -entity " + this.entity + " -log_size " + this.debugLogSizeLimitInMB + " -private_key_file  " + this.privateKeyFile + " -private_key_file_password " + string2 + " -tls_version " + this.tlsVersion + " -uri " + string;
        String string7 = "";
        String string8 = "";
        boolean bl = false;
        String string9 = "";
        try {
            boolean bl2;
            String string10 = System.getProperty("os.name").toLowerCase();
            boolean bl3 = bl2 = System.getProperty("java.version").compareTo("1.5") > 0;
            if (string10.indexOf("win") >= 0) {
                bl = true;
            }
            if (bl) {
                string8 = EgInstallInfo.getInstallDir() + "\\jre\\bin\\";
                string9 = EgInstallInfo.getInstallDir() + "\\lib\\eg_agent.jar;" + EgInstallInfo.getInstallDir() + "\\lib\\eg_util.jar;" + EgInstallInfo.getInstallDir() + "\\lib\\commons-codec.jar;" + EgInstallInfo.getInstallDir() + "\\agent\\lib\\json-simple-1.1.1.jar";
                string7 = bl2 ? "cmd.exe /c " + string8 + this.javaOptions + " -client -cp \"" + string9 + "\"" + BASE_REST_EXECUTOR_CLASS + string6 : "cmd.exe /c " + string8 + this.javaOptions + " -cp \"" + string9 + "\"" + BASE_REST_EXECUTOR_CLASS + string6;
            } else if (string10.indexOf("aix") >= 0) {
                string9 = EgInstallInfo.getInstallDir() + "/lib/eg_agent.jar:" + EgInstallInfo.getInstallDir() + "/lib/eg_util.jar:" + EgInstallInfo.getInstallDir() + "/lib/commons-codec.jar:" + EgInstallInfo.getInstallDir() + "/agent/lib/json-simple-1.1.1.jar";
                string7 = "/opt/egurkha/jre/bin/" + this.javaOptions + " -cp " + string9 + BASE_REST_EXECUTOR_CLASS + string6;
            } else if (bl2) {
                string9 = EgInstallInfo.getInstallDir() + "/lib/eg_agent.jar:" + EgInstallInfo.getInstallDir() + "/lib/eg_util.jar:" + EgInstallInfo.getInstallDir() + "/lib/commons-codec.jar:" + EgInstallInfo.getInstallDir() + "/agent/lib/json-simple-1.1.1.jar";
                string7 = "/opt/egurkha/jre/bin/" + this.javaOptions + " -client -cp " + string9 + BASE_REST_EXECUTOR_CLASS + string6;
            } else {
                string9 = EgInstallInfo.getInstallDir() + "/lib/eg_agent.jar:" + EgInstallInfo.getInstallDir() + "/lib/eg_util.jar:" + EgInstallInfo.getInstallDir() + "/lib/commons-codec.jar:" + EgInstallInfo.getInstallDir() + "/agent/lib/json-simple-1.1.1.jar";
                string7 = "/opt/egurkha/jre/bin/" + this.javaOptions + " -cp " + string9 + BASE_REST_EXECUTOR_CLASS + string6;
            }
            this.printOut(string4 + "Inside execute program " + string7);
            this.printOut(string4 + "Going to call getExecOutputLines to execute" + BASE_REST_EXECUTOR_CLASS);
            ArrayList arrayList = this.egutil.getExecOutputLines(string7);
            this.printOut(string4 + "Completed  getExecOutputLines method call for" + BASE_REST_EXECUTOR_CLASS);
            if (arrayList == null || arrayList.size() < 2) {
                this.logMessage = string4 + "Rexec process returned null or some exception " + arrayList;
                this.putWarningMessageToLogfile(this.logMessage);
                this.logMessage = "";
            }
            object = (ArrayList)arrayList.get(0);
            if (arrayList != null && !arrayList.isEmpty() && arrayList.size() > 0) {
                ArrayList arrayList2 = new ArrayList();
                arrayList2 = (ArrayList)arrayList.get(1);
                if (arrayList2 != null && !arrayList2.isEmpty() && arrayList2.size() > 0) {
                    this.logMessage = string4 + "Rexec process some exception : errArrayList  " + arrayList2;
                    this.putWarningMessageToLogfile(this.logMessage);
                    this.logMessage = "";
                }
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace(string4 + "Error while rexec process :", exception);
        }
        this.printOut(string4 + "Output ArrayList  :" + object);
        if (object != null && !((ArrayList)object).isEmpty() && ((ArrayList)object).size() > 0) {
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                String string11 = "" + ((ArrayList)object).get(i);
                this.printOut(string4 + "Output ArrayList Before adding  :" + string11);
                if (string11.startsWith(HYPHEN)) {
                    this.printOut(string4 + "Skipping the line " + string11);
                    continue;
                }
                string5 = string5 + ((ArrayList)object).get(i);
            }
        }
        this.printOut(string4 + "Output ArrayList After construct   :" + string5);
        return string5;
    }

    private String parseJSONText(String string) {
        String string2 = "parseJSONText";
        string2 = this.methodNameTemplate(string2);
        String string3 = "";
        if (string != null && string.trim().length() > 0) {
            if ((string = string.substring(string.indexOf(RABBITMQ_REST_OUTPUT))).startsWith(RABBITMQ_REST_OUTPUT)) {
                String string4 = string.substring(RABBITMQ_REST_OUTPUT.length() + SEPERATOR_1.length());
                this.printOut(string2 + "Text 1 :" + string4);
                try {
                    ArrayList arrayList = this.myTokenizer(string4, SEPERATOR_1);
                    if (arrayList != null && !arrayList.isEmpty() && arrayList.size() > 0) {
                        for (int i = 0; i < arrayList.size(); ++i) {
                            String string5 = "" + arrayList.get(i);
                            if (string5 != null && string5.trim().length() > 0) {
                                this.printOut("********** S :" + string5);
                                if (!string5.startsWith(RABBITMQ_ENDPOINT_URL_OUTPUT)) continue;
                                string3 = string5.substring(RABBITMQ_ENDPOINT_URL_OUTPUT.length());
                                continue;
                            }
                            this.logMessage = string2 + "tokenize error ";
                            this.putWarningMessageToLogfile(this.logMessage);
                            this.logMessage = "";
                        }
                    } else {
                        this.printOut(string2 + "Text 1  tokenize error :" + string4);
                    }
                }
                catch (Exception exception) {
                    this.printOutStackTrace(string2 + "Exception while parsing the json text value ", exception);
                }
                this.printOut(string2 + "Response string  :" + string3);
            } else {
                this.logMessage = string2 + "Output not available ,please check the " + DEBUG_LOG_ABSOLUTE_PATH + " logs folder for more details";
                this.putWarningMessageToLogfile(this.logMessage);
                this.logMessage = "";
            }
        } else {
            this.logMessage = string2 + "JSON Text Output is empty or null  ,please check the " + DEBUG_LOG_ABSOLUTE_PATH + "  logs  for more details";
            this.putWarningMessageToLogfile(this.logMessage);
            this.logMessage = "";
        }
        return string3;
    }

    private ArrayList myTokenizer(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        int n = 0;
        int n2 = string.indexOf(string2);
        while (n2 >= 0) {
            string3 = string.substring(n, n2);
            arrayList.add(string3);
            n = n2 + 1;
            n2 = string.indexOf(string2, n);
        }
        string3 = string.substring(n);
        arrayList.add(string3);
        return arrayList;
    }

    protected String methodNameTemplate(String string) {
        return "[" + string + "] :";
    }

    public void printOut(String string) {
        this.printOut(string, true);
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string);
    }

    public void printOut(String string, boolean bl) {
        if (this.debugLogSizeLimitInMB > 0.0) {
            RabbitMQValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >> " + string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            RabbitMQValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putInfoMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >> " + string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            RabbitMQValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putWarningMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >> " + string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            RabbitMQValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.putErrorMessageToLogfile(string2 + string3);
    }

    public static synchronized void debugLogToFile(String string, double d) {
        try {
            PrintWriter printWriter = null;
            String string2 = DEBUG_LOG_ABSOLUTE_PATH;
            File file = new File(string2);
            if (file.exists() && (double)file.length() >= d) {
                String string3 = string2 + ".1";
                File file2 = new File(string3);
                if (file2.exists()) {
                    file2.delete();
                }
                EgInstallInfo.fileRename(string2, string3);
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string2, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            RabbitMQValidator.debugLogToFile("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }

    protected double convertToDouble(String string) {
        String string2 = "[convertToDouble] :";
        double d = 0.0;
        if (string != null && string.trim().length() > 0 && !string.equalsIgnoreCase(NULL) && !string.equalsIgnoreCase(NONE)) {
            if ((string = this.validateString(string)).equalsIgnoreCase(HYPHEN)) {
                return d;
            }
        } else {
            return d;
        }
        try {
            d = EgLangInfo.getDoubleValue(string, true);
        }
        catch (Exception exception) {
            d = 0.0;
        }
        return d;
    }

    protected String validateString(String string) {
        return this.validateString(string, HYPHEN);
    }

    protected String validateString(String string, String string2) {
        String string3 = string2;
        if (string == null || string.trim().length() == 0 || string.equalsIgnoreCase(NULL) || string.equalsIgnoreCase(NONE)) {
            string3 = string2;
        } else {
            try {
                string3 = string.trim();
            }
            catch (Exception exception) {
                string3 = string2;
            }
        }
        return string3;
    }

    class RabbitMQConnectionThread
    extends Thread {
        private HttpURLConnection connection;
        private String methodName = "[run]:";
        public String responseString = null;
        public boolean done = false;
        public int code = 0;

        public RabbitMQConnectionThread(HttpURLConnection httpURLConnection, String string) {
            this.connection = httpURLConnection;
            this.methodName = this.methodName + string;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.connection.connect();
            }
            catch (IOException iOException) {
                RabbitMQValidator.this.logMessage = this.methodName + " Error : URL connect and returned ";
                RabbitMQValidator.this.printOutStackTrace(RabbitMQValidator.this.logMessage, iOException);
                RabbitMQValidator.this.logMessage = "";
                iOException.printStackTrace();
                return;
            }
            try {
                RabbitMQValidator.this.logMessage = this.methodName + " and its Response code :" + this.connection.getResponseCode();
                RabbitMQValidator.this.printOut(RabbitMQValidator.this.logMessage);
                RabbitMQValidator.this.logMessage = "";
            }
            catch (IOException iOException) {
                RabbitMQValidator.this.logMessage = this.methodName + " Error ";
                RabbitMQValidator.this.printOutStackTrace(RabbitMQValidator.this.logMessage, iOException);
                RabbitMQValidator.this.logMessage = "";
                iOException.printStackTrace();
                return;
            }
            InputStream inputStream = null;
            try {
                this.code = this.connection.getResponseCode();
                RabbitMQValidator.this.printOut(this.methodName + "code " + this.code);
                inputStream = this.code == 200 ? this.connection.getInputStream() : this.connection.getErrorStream();
                RabbitMQValidator.this.printOut(this.methodName + "Response before decode :" + this.connection.getErrorStream());
            }
            catch (IOException iOException) {
                RabbitMQValidator.this.logMessage = this.methodName + " response  exception ";
                RabbitMQValidator.this.printOutStackTrace(RabbitMQValidator.this.logMessage, iOException);
                RabbitMQValidator.this.logMessage = "";
                iOException.printStackTrace();
                return;
            }
            try {
                this.responseString = RabbitMQValidator.this.decodeResponse(inputStream);
                RabbitMQValidator.this.printOut(this.methodName + "After decode for the method  " + this.methodName + "  ====> Response  : " + this.responseString);
            }
            catch (IOException iOException) {
                RabbitMQValidator.this.logMessage = this.methodName + " response after decode , Error ";
                RabbitMQValidator.this.printOutStackTrace(RabbitMQValidator.this.logMessage, iOException);
                RabbitMQValidator.this.logMessage = "";
                iOException.printStackTrace();
                return;
            }
            finally {
                if (null != inputStream) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        RabbitMQValidator.this.logMessage = this.methodName + "  response close error ";
                        RabbitMQValidator.this.printOutStackTrace(RabbitMQValidator.this.logMessage, iOException);
                        RabbitMQValidator.this.logMessage = "";
                        iOException.printStackTrace();
                        return;
                    }
                }
            }
            this.done = true;
        }
    }
}

