/*
 * Decompiled with CFR 0.152.
 */
import com.eg.Base64Coder;
import com.eg.EgSSL;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.StringTokenizer;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class RabbitMQValidatorRESTExecutor {
    private static final int j = 124;
    String port = null;
    String protocol = "https";
    String username = null;
    String password = null;
    String baseURLString = null;
    private long collectionTimeout;
    private static final String def_IdleTimeout = "120";
    String tmp_timeout = null;
    String reportingName = null;
    String entity = null;
    private static final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    private static final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    String logMessage = "";
    String className = this.getClass().getName();
    String targetHost = null;
    protected static final String HYPHEN = "-";
    protected static final String TEST_NAME = "RabbitMQValidator";
    protected static final String LOG_FILE_NAME = "RabbitMQValidatorLog";
    protected static final String DEBUG_LOG_ABSOLUTE_PATH = EgInstallInfo.getInstallDir() + "/agent/logs/" + "RabbitMQValidatorLog";
    double debugLogSizeLimitInMB = 1000000.0;
    protected static final String RETURNING_INFO_MESSAGE = ",So returning";
    protected static final int ASCII_CODE_FOR_SPACE = 32;
    protected static final String SPACE = new String(" ");
    protected static final String REQUEST_METHOD_GET = "GET";
    protected static final String AUTHORIZATION = "Authorization";
    protected static final String BASIC = "Basic" + SPACE;
    protected static final String AUTHORIZATION_KEY = "Authorization";
    protected static final String CONTENT_TYPE_KEY = "Content-Type";
    protected static final String CONTENT_TYPE_VALUE = "application/json";
    protected static final String CACHE_CONTROL_KEY = "Cache-Control";
    protected static final String CACHE_CONTROL_VALUE = "no-cache";
    protected static final int DEFAULT_CONNECTION_TIMEOUT = 15000;
    protected static final int DEFAULT_READ_TIMEOUT = 60000;
    protected static final String COLONS = ":";
    private static final String RABBITMQ_REST_OUTPUT = "RABBITMQ_REST_OUTPUT:";
    private static final String RABBITMQ_ENDPOINT_URL_OUTPUT = "RABBITMQ_ENDPOINT_URL_OUTPUT:";
    private static final String SEPERATOR_1 = "~!~";
    boolean deep_debug = false;
    String authEncoded = null;
    protected static final String DEBUG = "DEBUG    ";
    protected static final String ERROR = "ERROR    ";
    protected static final String INFO = "INFO     ";
    protected static final String CRITICAL = "CRITICAL ";
    protected static final String WARNING = "WARNING  ";
    protected static final String NULL = "null";
    protected static final String NONE = "none";
    String privateKeyFile = null;
    String privateKeyFilePassword = null;
    String tlsVersion = null;
    SSLSocketFactory sockFact = null;
    String endPointURL = null;
    boolean privateKeyAvail = false;

    public RabbitMQValidatorRESTExecutor(String[] stringArray) {
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                if (stringArray[i].equals("-host") && i + 1 < stringArray.length) {
                    this.targetHost = new String(stringArray[++i]);
                    if (this.targetHost != null) {
                        this.targetHost = this.targetHost.trim();
                    }
                }
                if (stringArray[i].equals("-port") && i + 1 < stringArray.length) {
                    this.port = new String(stringArray[++i]);
                    if (this.port == null) continue;
                    this.port = this.port.trim();
                    continue;
                }
                if (stringArray[i].equals("-username") && i + 1 < stringArray.length) {
                    this.username = new String(stringArray[++i]);
                    if (this.username == null) continue;
                    this.username = this.username.trim();
                    continue;
                }
                if (stringArray[i].equals("-password") && i + 1 < stringArray.length) {
                    this.password = new String(stringArray[++i]);
                    if (this.password != null) {
                        this.password = this.password.trim();
                    }
                    this.password = this.decrypt(this.password);
                    continue;
                }
                if (stringArray[i].equals("-timeout") && i + 1 < stringArray.length) {
                    string = new String(stringArray[++i]);
                    try {
                        this.collectionTimeout = Long.parseLong(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        try {
                            this.collectionTimeout = Long.parseLong(def_IdleTimeout) * 1000L;
                        }
                        catch (NumberFormatException numberFormatException2) {}
                    }
                    continue;
                }
                if (stringArray[i].equals("-rptName") && i + 1 < stringArray.length) {
                    this.reportingName = new String(stringArray[++i]);
                    if (this.reportingName == null) continue;
                    this.reportingName = this.reportingName.trim();
                    continue;
                }
                if (stringArray[i].equals("-entity") && i + 1 < stringArray.length) {
                    this.entity = new String(stringArray[++i]);
                    if (this.entity == null) continue;
                    this.entity = this.entity.trim();
                    continue;
                }
                if (stringArray[i].equals("-log_size") && i + 1 < stringArray.length) {
                    if ((string = new String(stringArray[++i])) != null && string.length() > 0) {
                        string = string.trim();
                        try {
                            this.debugLogSizeLimitInMB = Double.parseDouble(string);
                        }
                        catch (Exception exception) {
                            this.printOut("[" + this.className + "]: [Constructor ]: strLogSizeLimitInMB : " + string + " ,exception :" + exception.toString());
                            this.debugLogSizeLimitInMB = 5000000.0;
                        }
                    }
                    this.printOut("[" + this.className + "]: [Constructor ]: debugLogSizeLimitInMB : " + this.debugLogSizeLimitInMB);
                    continue;
                }
                if (stringArray[i].equals("-private_key_file") && i + 1 < stringArray.length) {
                    this.privateKeyFile = new String(stringArray[++i]);
                    if (this.privateKeyFile != null && this.privateKeyFile.trim().length() != 0 && !this.privateKeyFile.equalsIgnoreCase(NULL) && !this.privateKeyFile.equalsIgnoreCase(NONE)) continue;
                    this.privateKeyFile = NONE;
                    this.logMessage = "[" + this.className + "]: [Constructor ]: Private Key File  null or empty ";
                    this.printOut(this.logMessage);
                    this.logMessage = "";
                    continue;
                }
                if (stringArray[i].equals("-private_key_file_password") && i + 1 < stringArray.length) {
                    this.privateKeyFilePassword = new String(stringArray[++i]);
                    this.privateKeyFilePassword = this.decrypt(this.privateKeyFilePassword);
                    if (this.privateKeyFilePassword != null && this.privateKeyFilePassword.trim().length() != 0 && !this.privateKeyFilePassword.equalsIgnoreCase(NULL) && !this.privateKeyFilePassword.equalsIgnoreCase(NONE)) continue;
                    this.privateKeyFilePassword = NONE;
                    this.logMessage = "[" + this.className + "]: [Constructor ]: Private Key File Password is null or empty ";
                    this.printOut(this.logMessage);
                    this.logMessage = "";
                    continue;
                }
                if (stringArray[i].equals("-tls_version") && i + 1 < stringArray.length) {
                    this.tlsVersion = new String(stringArray[++i]);
                    if (this.tlsVersion != null && this.tlsVersion.trim().length() != 0 && !this.tlsVersion.equalsIgnoreCase(NULL) && !this.tlsVersion.equalsIgnoreCase(NONE)) continue;
                    this.tlsVersion = NONE;
                    this.logMessage = "[" + this.className + "]: [Constructor ]: TLS Version is null or empty ";
                    this.printOut(this.logMessage);
                    this.logMessage = "";
                    continue;
                }
                if (!stringArray[i].equals("-uri") || i + 1 >= stringArray.length) continue;
                this.endPointURL = new String(stringArray[++i]);
                if (this.endPointURL != null && this.endPointURL.trim().length() != 0 && !this.endPointURL.equalsIgnoreCase(NULL) && !this.endPointURL.equalsIgnoreCase(NONE)) continue;
                this.endPointURL = NONE;
                this.logMessage = "[" + this.className + "]: [Constructor ]: Endpoint URL is null or empty ";
                this.printOut(this.logMessage);
                this.logMessage = "";
            }
            this.baseURLString = this.protocol + "://" + this.targetHost + COLONS + this.port;
            String string = this.username + COLONS + this.password;
            this.authEncoded = Base64Coder.encodeString(string);
        }
        catch (Exception exception) {
            this.printOutStackTrace("[" + this.className + "]: [Constructor ]: error ", exception);
        }
    }

    public String decrypt(String string) {
        int n;
        if (string != null && string.length() < 2) {
            return string;
        }
        if (string != null && string.indexOf(COLONS) == -1) {
            return string;
        }
        ArrayList arrayList = this.myTokenizer(string, COLONS);
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        int n2 = n = arrayList.size();
        byte[] byArray = new byte[n];
        String string2 = null;
        int n3 = n - 1;
        for (int i = 0; i < n2; ++i) {
            string2 = (String)arrayList.get(i);
            int n4 = 0;
            try {
                n4 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                return string;
            }
            int n5 = 124 - n4 + n3 * 3;
            --n3;
            byArray[--n] = (byte)n5;
        }
        String string3 = new String(byArray);
        return string3;
    }

    private ArrayList myTokenizer(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        int n = 0;
        int n2 = string.indexOf(string2);
        while (n2 >= 0) {
            string3 = string.substring(n, n2);
            arrayList.add(string3);
            n = n2 + 1;
            n2 = string.indexOf(string2, n);
        }
        string3 = string.substring(n);
        arrayList.add(string3);
        return arrayList;
    }

    public static void main(String[] stringArray) {
        RabbitMQValidatorRESTExecutor rabbitMQValidatorRESTExecutor = new RabbitMQValidatorRESTExecutor(stringArray);
        rabbitMQValidatorRESTExecutor.getJSONDataFromURL();
    }

    private void setPrivateKey() {
        String string = "setPrivateKey";
        string = this.methodNameTemplate(string);
        try {
            this.printOut(string + "Setting PrivateKey properties .... ");
            File file = new File(this.privateKeyFile);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(EgSSL.keyMgrFactory);
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            FileInputStream fileInputStream = new FileInputStream(file);
            keyStore.load(fileInputStream, this.privateKeyFilePassword.toCharArray());
            ((InputStream)fileInputStream).close();
            keyManagerFactory.init(keyStore, this.privateKeyFilePassword.toCharArray());
            SSLContext sSLContext = SSLContext.getInstance(this.tlsVersion);
            sSLContext.init(keyManagerFactory.getKeyManagers(), null, new SecureRandom());
            this.sockFact = sSLContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(this.sockFact);
            this.privateKeyAvail = true;
        }
        catch (Exception exception) {
            this.printOutStackTrace(string + "Exception while setting privatekey properties ", exception);
        }
    }

    public void getJSONDataFromURL() {
        Object object;
        String string = "getJSONDataFromURL";
        string = this.methodNameTemplate(string);
        String string2 = null;
        Object var7_3 = null;
        long l = System.currentTimeMillis();
        if (this.privateKeyFile != NONE && this.privateKeyFile != NULL && this.privateKeyFilePassword != NONE && this.privateKeyFilePassword != NULL) {
            this.setPrivateKey();
        } else {
            this.enableSSLForHTTPSConnection();
        }
        long l2 = System.currentTimeMillis();
        String string3 = "RABBITMQ_ENDPOINT_URL_OUTPUT:none";
        this.printOut(string + "------------------------------------------------------------------------------------------------------------");
        try {
            l2 = System.currentTimeMillis();
            string2 = this.baseURLString + "/api/" + this.endPointURL;
            this.printOut(string + this.endPointURL + " before call data collection thread  =========> " + string2 + " Request method :" + REQUEST_METHOD_GET);
            object = new DataCollectionThread(string2, REQUEST_METHOD_GET);
            this.runThread((MonitoredThread)object, "DataCollection", 20L);
            this.printOut(string + "Data Collected for  " + this.targetHost + " for " + this.endPointURL + "  " + (System.currentTimeMillis() - l2) + "ms.");
            string3 = RABBITMQ_ENDPOINT_URL_OUTPUT + ((DataCollectionThread)object).getResponseCode();
            this.printOut(string + string3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printOutStackTrace(string + this.endPointURL + "  =========> " + string2 + " ,Exception raised ", exception);
        }
        this.printOut(string + "------------------------------------------------------------------------------------------------------------");
        object = "RABBITMQ_REST_OUTPUT:~!~" + string3;
        this.printOut(string + " All of the data collection process is completed ,going to remove the session ,but please check data collected properly ");
        System.out.println((String)object);
        this.printOut(string + "Data collection for all process for   " + this.targetHost + " took  " + (System.currentTimeMillis() - l) + "ms.");
    }

    protected void runThread(MonitoredThread monitoredThread, String string, long l) throws Exception {
        String string2 = "runThread";
        string2 = this.methodNameTemplate(string2);
        monitoredThread.start();
        long l2 = System.currentTimeMillis();
        long l3 = 20L;
        try {
            Thread.sleep(l3);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            this.printOutStackTrace(string2, interruptedException);
        }
        long l4 = System.currentTimeMillis() - l2;
        while (monitoredThread.isAlive() && l4 < this.collectionTimeout) {
            this.printOut(string2 + "Thread " + string + " still alive");
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            l4 = System.currentTimeMillis() - l2;
        }
        boolean bl = false;
        String string3 = "";
        this.printOut(string2 + "mt.status   :" + monitoredThread.status);
        this.printOut(string2 + "mt.isAlive   :" + monitoredThread.isAlive());
        if (monitoredThread.isAlive()) {
            if (monitoredThread.status == -1) {
                bl = true;
                string3 = " timed out with exception.";
            } else {
                bl = true;
                string3 = " timed out.";
            }
        } else if (monitoredThread.status != 1) {
            if (monitoredThread.status == -1) {
                bl = true;
                string3 = " got done with exception.";
            } else {
                bl = true;
                string3 = " aborted without exception";
            }
        }
        this.printOut(string2 + "interruptThread   :" + bl);
        if (bl) {
            monitoredThread.interrupt();
            Thread.currentThread();
            Thread.yield();
            this.putErrorMessageToLogfile("Thread " + string + string3);
            throw new Exception("Thread " + string + " " + string3);
        }
    }

    protected String decodeResponse(InputStream inputStream) {
        String string = "decodeResponse";
        string = this.methodNameTemplate(string);
        try {
            if (inputStream != null && inputStream.toString().trim().length() > 0) {
                Scanner scanner = new Scanner(inputStream);
                scanner.useDelimiter("\\A");
                return scanner.hasNext() ? scanner.next() : "";
            }
            this.logMessage = string + " Response is null or empty";
            this.putWarningMessageToLogfile(this.logMessage);
            this.logMessage = "";
        }
        catch (Exception exception) {
            this.printOutStackTrace(string + "Exception while decoding the  response", exception);
            exception.printStackTrace();
        }
        return null;
    }

    void enableSSLForHTTPSConnection() {
        String string = null;
        EgSSL egSSL = EgSSL.getInstance();
        egSSL.enableSSL();
        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        Object var4_4 = null;
        MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
        KeyManager[] keyManagerArray = null;
        TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
        SSLContext sSLContext = null;
        try {
            sSLContext = SSLContext.getInstance("SSL");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            string = "[enableSSLForHTTPSConnection]";
            this.printOutStackTrace(string, noSuchAlgorithmException);
        }
        try {
            sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
        }
        catch (KeyManagementException keyManagementException) {
            string = "[enableSSLForHTTPSConnection]";
            this.printOutStackTrace(string, keyManagementException);
        }
        SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
        HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
        HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
    }

    protected String methodNameTemplate(String string) {
        return "[" + string + "] :";
    }

    public void printOut(String string) {
        this.printOut(string, true);
    }

    public void printOut(String string, boolean bl) {
        if (this.debugLogSizeLimitInMB > 0.0) {
            RabbitMQValidatorRESTExecutor.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putInfoMessageToLogfile(String string) {
        if (this.debugLogSizeLimitInMB > 0.0) {
            RabbitMQValidatorRESTExecutor.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putWarningMessageToLogfile(String string) {
        if (this.debugLogSizeLimitInMB > 0.0) {
            RabbitMQValidatorRESTExecutor.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        if (this.debugLogSizeLimitInMB > 0.0) {
            RabbitMQValidatorRESTExecutor.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.putErrorMessageToLogfile(string2 + string3);
    }

    public static synchronized void debugLogToFile(String string, double d) {
        try {
            PrintWriter printWriter = null;
            String string2 = DEBUG_LOG_ABSOLUTE_PATH;
            File file = new File(string2);
            if (file.exists() && (double)file.length() >= d) {
                String string3 = string2 + ".1";
                File file2 = new File(string3);
                if (file2.exists()) {
                    file2.delete();
                }
                EgInstallInfo.fileRename(string2, string3);
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string2, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            RabbitMQValidatorRESTExecutor.debugLogToFile("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }

    public String replaceAll(String string, String string2, String string3) {
        String string4 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        try {
            string4 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            return string;
        }
        while (stringTokenizer.hasMoreTokens()) {
            string4 = string4 + string3 + stringTokenizer.nextToken();
        }
        return string4;
    }

    class DataCollectionThread
    extends MonitoredThread {
        URL url = null;
        String urlString = null;
        String responseString = null;
        String requestType = null;
        InputStream is = null;
        OutputStream out = null;
        int responseCode = 0;

        DataCollectionThread(String string, String string2) {
            String string3 = "DataCollectionThread::Constructor";
            string3 = RabbitMQValidatorRESTExecutor.this.methodNameTemplate(string3);
            try {
                this.setName("DataCollection_" + RabbitMQValidatorRESTExecutor.this.reportingName);
                this.url = new URL(null, string);
            }
            catch (Exception exception) {
                RabbitMQValidatorRESTExecutor.this.printOutStackTrace(string3 + "Exception while construct the URL", exception);
                exception.printStackTrace();
            }
            this.urlString = string;
            this.requestType = string2;
            RabbitMQValidatorRESTExecutor.this.printOut(string3 + "urlStr  : " + string);
            RabbitMQValidatorRESTExecutor.this.printOut(string3 + "requestType  :" + string2);
        }

        public void run() {
            String string = "DataCollectionThread::run";
            string = RabbitMQValidatorRESTExecutor.this.methodNameTemplate(string);
            Object var2_2 = null;
            try {
                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)this.url.openConnection();
                httpsURLConnection = (HttpsURLConnection)this.url.openConnection();
                httpsURLConnection.setDoInput(true);
                httpsURLConnection.setDoOutput(true);
                httpsURLConnection.setConnectTimeout(15000);
                httpsURLConnection.setReadTimeout(60000);
                httpsURLConnection.addRequestProperty(RabbitMQValidatorRESTExecutor.CONTENT_TYPE_KEY, RabbitMQValidatorRESTExecutor.CONTENT_TYPE_VALUE);
                httpsURLConnection.setRequestProperty("Authorization", BASIC + RabbitMQValidatorRESTExecutor.this.authEncoded);
                httpsURLConnection.setRequestProperty(RabbitMQValidatorRESTExecutor.CACHE_CONTROL_KEY, RabbitMQValidatorRESTExecutor.CACHE_CONTROL_VALUE);
                if (RabbitMQValidatorRESTExecutor.this.privateKeyAvail) {
                    httpsURLConnection.setSSLSocketFactory(RabbitMQValidatorRESTExecutor.this.sockFact);
                }
                if (this.requestType.equalsIgnoreCase(RabbitMQValidatorRESTExecutor.REQUEST_METHOD_GET)) {
                    RabbitMQValidatorRESTExecutor.this.printOut(string + "Request type  - GET - process here");
                    httpsURLConnection.setRequestMethod(RabbitMQValidatorRESTExecutor.REQUEST_METHOD_GET);
                    try {
                        httpsURLConnection.connect();
                    }
                    catch (Exception exception) {
                        RabbitMQValidatorRESTExecutor.this.printOutStackTrace(string + " Request type  - GET - Error while connect the server", exception);
                    }
                }
                int n = 0;
                try {
                    this.responseCode = n = httpsURLConnection.getResponseCode();
                    RabbitMQValidatorRESTExecutor.this.logMessage = string + " and its Response code :" + n + " for the URL  :" + this.urlString;
                    RabbitMQValidatorRESTExecutor.this.printOut(RabbitMQValidatorRESTExecutor.this.logMessage);
                    if (n > 300) {
                        RabbitMQValidatorRESTExecutor.this.putInfoMessageToLogfile(RabbitMQValidatorRESTExecutor.this.logMessage);
                    }
                    RabbitMQValidatorRESTExecutor.this.logMessage = "";
                }
                catch (Exception exception) {
                    RabbitMQValidatorRESTExecutor.this.printOutStackTrace(string + "Error while get the response code the server", exception);
                }
                InputStream inputStream = null;
                try {
                    inputStream = n == 200 ? httpsURLConnection.getInputStream() : httpsURLConnection.getErrorStream();
                    this.responseString = RabbitMQValidatorRESTExecutor.this.decodeResponse(inputStream);
                }
                catch (Exception exception) {
                    RabbitMQValidatorRESTExecutor.this.printOutStackTrace(string + "Error while get the response info from the server", exception);
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                        inputStream = null;
                    }
                    catch (Exception exception) {
                        RabbitMQValidatorRESTExecutor.this.printOutStackTrace(string + "Error while close the response", exception);
                    }
                }
                try {
                    httpsURLConnection.disconnect();
                }
                catch (Exception exception) {
                    RabbitMQValidatorRESTExecutor.this.printOutStackTrace(string + "Error while disconnect", exception);
                }
                if (RabbitMQValidatorRESTExecutor.this.deep_debug) {
                    RabbitMQValidatorRESTExecutor.this.logMessage = string + " responseString :" + this.responseString;
                    RabbitMQValidatorRESTExecutor.this.printOut(RabbitMQValidatorRESTExecutor.this.logMessage);
                    RabbitMQValidatorRESTExecutor.this.logMessage = "";
                }
                this.status = this.responseString == null || this.responseString.trim().length() == 0 ? -1 : 1;
            }
            catch (Exception exception) {
                this.status = -1;
                exception.printStackTrace();
                RabbitMQValidatorRESTExecutor.this.printOutStackTrace(string + "Exception inside the thread run method", exception);
            }
        }

        public String getResponseString() {
            String string = "getResponseString";
            string = RabbitMQValidatorRESTExecutor.this.methodNameTemplate(string);
            this.responseString = RabbitMQValidatorRESTExecutor.this.replaceAll(this.responseString, System.lineSeparator(), "");
            RabbitMQValidatorRESTExecutor.this.printOut(string + "After decode for the method  " + string + "  ====> Response  : " + this.responseString);
            return this.responseString;
        }

        public int getResponseCode() {
            return this.responseCode;
        }
    }

    abstract class MonitoredThread
    extends Thread {
        protected static final int UNSET = 0;
        protected static final int SUCCESS = 1;
        protected static final int ERR = -1;
        protected int status = 0;

        MonitoredThread() {
        }

        public abstract void run();
    }
}

