/*
 * Decompiled with CFR 0.152.
 */
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.resps.StreamInfo;

public class RedisStrmKeyStatTest
extends RedisBase {
    private static String myDatePattern = "dd/MM/yy HH:mm:ss";
    private final SimpleDateFormat mySDF = new SimpleDateFormat(myDatePattern);
    int slowLogEntriesCount = 0;
    String redisKeyPatter = "";
    int intScanCount = 0;

    public RedisStrmKeyStatTest(String[] stringArray) {
        super(stringArray);
        try {
            this.printOut("constructor started:");
            this.needAgentlessDD = false;
            logger.info("{} Initializing RedisStrmKeyStatTest ...", (Object)this.logPrefix);
            this.setMeasureCount(this.measureCount);
            String string = this.getValueForParam("key_pattern_match");
            this.printOut("redisScanPattern :" + string);
            if (string == null || string.length() <= 0 || string.equalsIgnoreCase("none")) {
                logger.info("{} REDIS redisKeyPatter is null or empty or none : {}", (Object)this.logPrefix, (Object)string);
                logger.info("{} redisKeyPatter set value as star(*)", (Object)this.logPrefix);
                this.redisKeyPatter = "*";
                this.printOut("REDIS redisKeyPattern is null or empty or none,set value as " + this.redisKeyPatter);
            } else {
                this.redisKeyPatter = string;
                this.printOut("REDIS redisKeyPatter :" + this.redisKeyPatter);
                logger.info("{} Redis Server is redisKeyPattern:" + this.redisKeyPatter, (Object)this.logPrefix);
            }
            this.printOut("redisScanPattern new:" + string);
            String string2 = this.getValueForParam("maximum_keys_to_fetch_per_call");
            this.printOut("redisScanMaxCount :" + string2);
            if (string2 == null || string2.length() <= 0 || string2.equalsIgnoreCase("none")) {
                logger.info("{} REDIS ScanMaxCount is null or empty or none : {}", (Object)this.logPrefix, (Object)string2);
                this.intScanCount = 100;
                this.printOut("REDIS ScanMaxCount is null or empty or none, set value as :" + this.intScanCount);
            } else {
                this.intScanCount = Integer.valueOf(string2);
                this.printOut("REDIS ScanMaxCount value:" + this.intScanCount);
                logger.info("{} Redis Server is ScanMaxCount:" + this.intScanCount, (Object)this.logPrefix);
            }
            this.printOut("redisScanMaxCount new:" + string2);
            logger.info("{} RedisStrmKeyStatTest initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception exception) {
            this.printOut("Exception while initializing RedisStrmKeyStatTest {}" + exception.getMessage());
            logger.warn("{} Exception while initializing RedisStrmKeyStatTest {}", (Object)this.logPrefix, (Object)exception);
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testStart);
            this.printOut("computeMeasures started");
            this.getRedisStreamKeys();
        }
        catch (Exception exception) {
            logger.warn("{} Exception occured inside {}", (Object)this.logPrefix, (Object)exception);
        }
        finally {
            logger.debug("{},{}", (Object)this.logPrefix, (Object)this.testEnd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRedisStreamKeys() {
        int n = -5;
        int n2 = -5;
        boolean bl = false;
        Jedis jedis = null;
        try {
            jedis = this.getConnection();
            ArrayList arrayList = (ArrayList)this.getKeys(this.redisKeyPatter, this.intScanCount);
            this.printOut("arrList:" + arrayList);
            logger.debug("{} Result for REDIS scan Command [cmdsKeys get] : {}", (Object)this.logPrefix, (Object)arrayList);
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            ArrayList<Double> arrayList3 = new ArrayList<Double>();
            long l = 0L;
            double d = 0.0;
            long l2 = 0L;
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList3 = new ArrayList();
                String string = arrayList.get(i).toString().trim();
                long l3 = jedis.ttl(string);
                long l4 = jedis.memoryUsage(string);
                StreamInfo streamInfo = jedis.xinfoStream(string);
                long l5 = streamInfo.getLength();
                double d2 = 0.0;
                if (l3 < 0L) {
                    l3 = -5L;
                } else {
                    l += l3;
                }
                if (l4 < 0L) {
                    l4 = -5L;
                } else {
                    d2 = new Double(l4);
                    d += (d2 /= 1024.0);
                }
                if (l5 < 0L) {
                    l5 = -5L;
                } else {
                    l2 += l5;
                }
                arrayList3.add(new Double(this.round(d2, 2)));
                arrayList3.add(new Double(l3));
                arrayList3.add(new Double(l5));
                logger.debug("[getRedisStreamKeys],info:" + string + "List:", (Object)this.logPrefix, arrayList3);
                this.printOut("[getRedisStreamKeys],info:" + string + "List:" + arrayList3);
                this.addNewMeasure(string, arrayList3);
            }
            arrayList2.add(new Double(this.round(d, 2)));
            arrayList2.add(new Double(l));
            arrayList2.add(new Double(l2));
            this.printOut("[getRedisStreamKeys],info:SummaryList:" + arrayList2);
            logger.debug("[getRedisStreamKeys],info:SummaryList:", (Object)this.logPrefix, arrayList2);
            this.addNewMeasure("Summary", arrayList2);
        }
        catch (Exception exception) {
            logger.warn("{} Exception occurred in getRedisStreamKeys", (Object)this.logPrefix, (Object)exception);
            this.addNewMeasure(this.finalMeasures(this.measureCount));
            this.logToErrorFile("ERROR", this.entity, "Exception occurred in getRedisStreamKeys: : " + exception.getMessage());
            this.printOut("Exception occurred in getRedisStreamKeys: " + exception.getMessage());
            logger.trace("{} [getRedisStreamKeys] Sending -5 ", (Object)this.logPrefix);
        }
        finally {
            this.closeConnection(jedis);
        }
    }

    public void printOut(String string) {
        System.out.println(" >> " + this.reportingName + " : " + this.entity + ": [ " + this.mySDF.format(new Date()) + " ] : >> " + string);
    }

    public static void main(String[] stringArray) throws InterruptedException {
        RedisStrmKeyStatTest redisStrmKeyStatTest = new RedisStrmKeyStatTest(stringArray);
        redisStrmKeyStatTest.computeMeasures(new Hashtable());
    }
}

