/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgCrypt;
import com.eg.EgExternalInfo;
import com.eg.EgInstallInfo;
import com.eg.IPV6Helper;
import com.egurkha.util.EgUtilities;
import com.sap.mw.jco.JCO;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class SapAbapInstanceValidator
extends EgServerValidator {
    public SapControlBase sapCntrlBase = null;
    EgExternalInfo extInfo = new EgExternalInfo("agent");
    public ArrayList validationMsgs = null;
    public Hashtable validationErrorMap = new Hashtable();
    public String reportingName = "";
    public String test = "";
    public String host = "";
    public String appServer = "";
    public String port = "";
    public String msgsrvPort = "";
    public String user = "";
    public String password = "";
    public String domain = "";
    public String isAgentLess = "";
    public String alMode = "";
    public String alUser = "";
    public String alPassword = "";
    public String validationMsg = "";
    public String validationErrorMsg = "";
    private String instanceName = "";
    private String timeout;
    private String sapuser = "";
    private String sysNo = "";
    private String clientName = "";
    private String router = "";
    private String isPassive = "";
    private String almode = "";
    private String msgServer = "";
    private String connectionType = "";
    private String sapSid = "";
    private String logonGroup = "";
    private String os = "";
    private String rptName = "";
    private String mCount = "";
    private String egMeasHost = "";
    private String egMeasPeriod = "";
    private String central_wsdl_port;
    private String wsdl_port;
    private String ssl = "";
    private String os_Username = "";
    private String os_Password = "";
    private String jco_Version = "";
    private String connectorport = "";
    private boolean isFromManager = false;
    private boolean isTargetIp = true;
    private boolean isInstanceBased = true;
    private boolean isSSL = false;
    public boolean meAgentLess = false;
    private boolean isSAPAuthFailed = false;
    private boolean isSysnoFailed = false;
    private boolean isLogonGroupFailed = false;
    private boolean isClientNameFailed = false;
    private boolean isClientNameFailedorUserlocked = false;
    private boolean isSysnoORrouterFailed = false;
    private boolean isWSDLPortFailed = false;
    private boolean isWSDLorCWSDLPortFailed = false;
    private boolean isFaultCode = false;
    private boolean isSSLPort = false;
    private boolean isSupportedFilesMissing = false;
    public String subject = "WORKING_TESTS";
    public String key = "";
    public String errorMessage = "";

    public SapAbapInstanceValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        System.out.println("SapAbapInstanceValidator method called");
        String[] stringArray2 = new String[stringArray.length * 2];
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = string.substring(0, string.indexOf(":"));
                String string3 = string.substring(string.indexOf(":") + 1);
                if ((string2 = string2.trim()) != null && string2.equalsIgnoreCase("-rptname")) {
                    this.reportingName = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-test")) {
                    this.test = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-host")) {
                    this.host = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-Application_server")) {
                    this.appServer = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-port")) {
                    this.port = string3;
                    this.msgsrvPort = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-agentless")) {
                    this.isAgentLess = string3;
                    if (this.isAgentLess != null && this.isAgentLess.equalsIgnoreCase("y")) {
                        this.meAgentLess = true;
                    }
                } else if (string2 != null && string2.equalsIgnoreCase("-instancename")) {
                    this.instanceName = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-timeout")) {
                    this.timeout = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-sapuser")) {
                    this.sapuser = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-password")) {
                    this.password = EgCrypt.decrypt(string3);
                    if (this.password != null && this.password.length() > 0 && this.password.endsWith("~EG~")) {
                        this.password = this.password.substring(0, this.password.indexOf("~EG~"));
                    }
                } else if (string2 != null && string2.equalsIgnoreCase("-sysno")) {
                    this.sysNo = string3;
                    if (this.msgsrvPort.length() > 2) {
                        this.msgsrvPort = this.msgsrvPort.substring(0, 2) + string3;
                    }
                } else if (string2 != null && string2.equalsIgnoreCase("-clientname")) {
                    this.clientName = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-Message_Server")) {
                    this.msgServer = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-Connection_type")) {
                    System.out.println("SapAbapInstanceValidator Connection_type " + string3);
                    if (string3 == null || string3.equalsIgnoreCase("") || string3.equalsIgnoreCase("true")) {
                        System.out.println("SapAbapInstanceValidator Connection_type:application_server");
                        string3 = "application_server";
                    }
                    if (string3 != null && string3.equalsIgnoreCase("false")) {
                        System.out.println("SapAbapInstanceValidator Connection_type:group_server");
                        string3 = "group_server";
                    }
                    this.connectionType = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-sid")) {
                    this.sapSid = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-logon_group")) {
                    this.logonGroup = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-router")) {
                    this.router = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-isPassive")) {
                    this.isPassive = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-almode")) {
                    this.almode = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-os")) {
                    this.os = string3;
                } else if (string2 == null || !string2.equalsIgnoreCase("-sshPort")) {
                    if (string2 != null && string2.equalsIgnoreCase("-rptName")) {
                        this.reportingName = string3;
                        long l = System.currentTimeMillis();
                        string3 = this.reportingName + "_validation";
                    } else if (string2 != null && string2.equalsIgnoreCase("-mCount")) {
                        this.mCount = string3;
                    } else if (string2 != null && string2.equalsIgnoreCase("-egMeasHost")) {
                        this.egMeasHost = string3;
                    } else if (string2 != null && string2.equalsIgnoreCase("-egMeasPeriod")) {
                        this.egMeasPeriod = string3;
                    } else if (string2 != null && string2.equalsIgnoreCase("-central_wsdl_port")) {
                        this.central_wsdl_port = string3;
                        this.connectorport = string3;
                    } else if (string2 != null && string2.equalsIgnoreCase("-wsdl_port")) {
                        this.wsdl_port = string3;
                        this.connectorport = string3;
                    } else if (string2 != null && string2.equalsIgnoreCase("-ssl")) {
                        if (string3.equalsIgnoreCase("true")) {
                            this.isSSL = true;
                        }
                    } else if (string2 != null && string2.equalsIgnoreCase("-os_username")) {
                        this.os_Username = string3;
                    } else if (string2 != null && string2.equalsIgnoreCase("-os_password")) {
                        this.os_Password = EgCrypt.decrypt(string3);
                        if (this.os_Password != null && this.os_Password.length() > 0 && this.os_Password.endsWith("~EG~")) {
                            this.os_Password = this.os_Password.substring(0, this.os_Password.indexOf("~EG~"));
                        }
                    } else if (string2 != null && string2.equalsIgnoreCase("-Jco_version")) {
                        this.jco_Version = string3;
                    }
                }
                stringArray2[n] = string2;
                if (string2 != null && string2.equalsIgnoreCase("-password")) {
                    stringArray2[++n] = this.password;
                } else if (string2 != null && string2.equalsIgnoreCase("-os_password")) {
                    stringArray2[++n] = this.os_Password;
                } else {
                    System.out.println("SapAbapInstanceValidator args " + string2 + ":" + string3);
                    stringArray2[++n] = string3;
                }
                ++n;
            }
        }
        if (!this.isIpAddress(this.host)) {
            this.isTargetIp = false;
        }
        this.key = this.test + "#~#" + this.reportingName + ":" + this.port;
        this.validationMsgs = new ArrayList();
        if (this.instanceName == null || this.instanceName.equalsIgnoreCase("NULL") || this.instanceName.trim().length() == 0) {
            this.isInstanceBased = false;
        }
        if (this.extInfo.isRemoteBased(this.reportingName)) {
            this.meAgentLess = true;
        }
        this.sapCntrlBase = new SapControlBase(stringArray2);
        this.validate(stringArray2);
        this.isFromManager = bl;
    }

    public boolean isIPReachable(String string) {
        ArrayList arrayList;
        EgUtilities egUtilities = EgUtilities.createInstance();
        String string2 = "";
        this.agentOS = this.agentOS.toLowerCase();
        if (this.isUsingVC) {
            string = this.vCenterIp;
        }
        if (this.isWebLogic) {
            string = this.admin_host;
        }
        if (this.agentOS != null && this.agentOS.indexOf("windows") > -1) {
            string2 = "cmd.exe /c  " + EgInstallInfo.getInstallDir() + "/bin/nfping " + string;
        } else if (this.agentOS != null && (this.agentOS.indexOf("linux") > -1 || this.agentOS.indexOf("sunos") > -1 || this.agentOS.indexOf("hpux") > -1 || this.agentOS.indexOf("aix") > -1 || this.agentOS.indexOf("osf1") > -1)) {
            boolean bl = IPV6Helper.validateIPV6(string);
            string2 = bl ? EgInstallInfo.getInstallDir() + "/bin/fping6 " + string : EgInstallInfo.getInstallDir() + "/bin/fping " + string;
        }
        ArrayList arrayList2 = egUtilities.getExecOutputLines(string2);
        if (arrayList2 != null && !arrayList2.isEmpty() && (arrayList = (ArrayList)arrayList2.get(0)) != null && !arrayList.isEmpty()) {
            ArrayList arrayList3;
            for (int i = 0; i < arrayList.size(); ++i) {
                String string3 = ((String)arrayList.get(i)).toLowerCase();
                if (string3 == null || string3.length() <= 0 || string3.indexOf("alive") <= 0 && !string3.startsWith("reply")) continue;
                this.isIPReachable = true;
                break;
            }
            if (!this.isIPReachable && arrayList2.size() >= 2 && (arrayList3 = (ArrayList)arrayList2.get(1)) != null && !arrayList3.isEmpty()) {
                this.ipStacktrace = (String)arrayList3.get(0);
            }
        }
        return this.isIPReachable;
    }

    public boolean isIpAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return false;
        }
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            try {
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (n2 <= 255 && n2 >= 0) continue;
                return false;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        return true;
    }

    public void validate(String[] stringArray) {
        try {
            System.out.println("connectionTyp:" + this.connectionType + ",msgServer:" + this.msgServer + ",sapSid:" + this.sapSid + ",logonGroup:" + this.logonGroup);
            if (this.isInstanceBased) {
                if (this.connectionType.equalsIgnoreCase("group_server")) {
                    if (this.msgServer == null) {
                        this.msgServer = "";
                    }
                    if (!this.msgServer.equalsIgnoreCase("")) {
                        this.host = this.msgServer;
                    }
                } else {
                    if (this.appServer == null) {
                        this.appServer = "";
                    }
                    if (!this.appServer.equalsIgnoreCase("")) {
                        this.host = this.appServer;
                    }
                }
                if (this.jco_Version != null && this.jco_Version.equalsIgnoreCase("3.x")) {
                    if (!this.isIPReachable(this.host)) {
                        this.validationMsgs.add("Host IP/Name$#$Host IP/Name  '" + this.host + "' is invalid or Host IP/Name is unreachable");
                        this.validationMsgs.add("JCO Implementation$#$NA");
                        if (this.connectionType.equalsIgnoreCase("group_server")) {
                            this.validationMsgs.add("SID$#$NA");
                        } else {
                            this.validationMsgs.add("Sysno$#$NA");
                        }
                        this.validationMsgs.add("Client Name$#$NA");
                        this.validationMsgs.add("SAP UserName/Password$#$NA");
                        this.validationMsgs.add("SAP ABAP Instance Connectivity$#$Failed");
                    } else if (!this.checkSapAbapJCO3Connectivity(stringArray)) {
                        this.subject = "ERROR_TESTS";
                        System.out.println("Debug: JCO3 Connectivity failed ");
                        String string = (String)this.validationErrorMap.get("SAP_ABAP_CONNECTIVITY");
                        if (string == null) {
                            string = "Something went wrong.";
                        }
                        if (this.isSysnoFailed) {
                            this.validationMsgs.add("Host IP/Name$#$OK");
                            this.validationMsgs.add("JCO Implementation$#$OK");
                            if (this.connectionType.equalsIgnoreCase("group_server")) {
                                this.validationMsgs.add("SID/SAP System up$#$Failed");
                                this.validationMsgs.add("Logon Group$#$NA");
                            } else {
                                this.validationMsgs.add("Sysno/SAP System up$#$Failed");
                            }
                            this.validationMsgs.add("Client Name$#$NA");
                            this.validationMsgs.add("SAP UserName/Password$#$NA");
                        } else if (this.isLogonGroupFailed) {
                            this.validationMsgs.add("Host IP/Name$#$OK");
                            this.validationMsgs.add("JCO Implementation$#$OK");
                            if (this.connectionType.equalsIgnoreCase("group_server")) {
                                this.validationMsgs.add("SID$#$OK");
                                this.validationMsgs.add("Logon Group$#$Failed");
                            } else {
                                this.validationMsgs.add("Sysno/SAP System up$#$Failed");
                            }
                            this.validationMsgs.add("Client Name$#$NA");
                            this.validationMsgs.add("SAP UserName/Password$#$NA");
                        } else if (this.isClientNameFailed) {
                            this.validationMsgs.add("Host IP/Name$#$OK");
                            this.validationMsgs.add("JCO Implementation$#$OK");
                            if (this.connectionType.equalsIgnoreCase("group_server")) {
                                this.validationMsgs.add("SID$#$OK");
                                this.validationMsgs.add("Logon Group$#$OK");
                            } else {
                                this.validationMsgs.add("Sysno$#$OK");
                            }
                            this.validationMsgs.add("Client Name$#$Failed");
                            this.validationMsgs.add("SAP UserName/Password$#$NA");
                        } else if (this.isSAPAuthFailed) {
                            this.validationMsgs.add("Host IP/Name$#$OK");
                            this.validationMsgs.add("JCO Implementation$#$OK");
                            if (this.connectionType.equalsIgnoreCase("group_server")) {
                                this.validationMsgs.add("SID$#$OK");
                                this.validationMsgs.add("Logon Group$#$OK");
                            } else {
                                this.validationMsgs.add("Sysno$#$OK");
                            }
                            this.validationMsgs.add("Client Name$#$OK");
                            this.validationMsgs.add("SAP UserName/Password$#$Failed");
                        } else if (this.isSupportedFilesMissing) {
                            this.validationMsgs.add("Host IP/Name$#$OK");
                            this.validationMsgs.add("JCO Implementation$#$Failed");
                            if (this.connectionType.equalsIgnoreCase("group_server")) {
                                this.validationMsgs.add("SID$#$NA");
                                this.validationMsgs.add("Logon Group$#$NA");
                            } else {
                                this.validationMsgs.add("Sysno$#$NA");
                            }
                            this.validationMsgs.add("Client Name$#$NA");
                            this.validationMsgs.add("SAP UserName/Password$#$NA");
                        }
                        this.validationMsgs.add("SAP ABAP Instance Connectivity$#$" + string);
                    } else {
                        System.out.println("Debug: JCO3 Connectivity success ");
                        this.validationMsgs.add("Host IP/Name$#$OK");
                        this.validationMsgs.add("JCO Implementation$#$OK");
                        if (this.connectionType.equalsIgnoreCase("group_server")) {
                            this.validationMsgs.add("SID$#$OK");
                            this.validationMsgs.add("Logon Group$#$OK");
                        } else {
                            this.validationMsgs.add("Sysno$#$OK");
                        }
                        this.validationMsgs.add("Client Name$#$OK");
                        this.validationMsgs.add("SAP UserName/Password$#$OK");
                        if (this.instanceName != null && !this.instanceName.equalsIgnoreCase("none") && !this.instanceName.equalsIgnoreCase("default") && this.sapSid.equalsIgnoreCase("")) {
                            String string = (String)this.validationErrorMap.get("INSTANCE_NAME");
                            if (string != null) {
                                this.validationMsgs.add("Instance name$#$" + string);
                            } else {
                                this.validationMsgs.add("Instance name$#$OK");
                            }
                        }
                        this.validationMsgs.add("SAP ABAP Instance Connectivity$#$OK");
                    }
                } else if (!this.isIPReachable(this.host)) {
                    this.validationMsgs.add("Host IP/Name$#$Host IP/Name  '" + this.host + "' is invalid or unreachable");
                    this.validationMsgs.add("JCO Implementation$#$NA");
                    this.validationMsgs.add("Sysno$#$NA");
                    this.validationMsgs.add("Client Name$#$NA");
                    this.validationMsgs.add("SAP UserName/Password$#$NA");
                    this.validationMsgs.add("SAP ABAP Instance Connectivity$#$Failed");
                } else if (!this.checkSapAbapJCO2Connectivity(stringArray)) {
                    this.subject = "ERROR_TESTS";
                    System.out.println("Debug: JCO2.x Connectivity failed ");
                    String string = (String)this.validationErrorMap.get("SAP_ABAP_CONNECTIVITY");
                    if (string == null) {
                        string = "Something went wrong.";
                    }
                    if (this.isSysnoFailed) {
                        this.validationMsgs.add("Host IP/Name$#$OK");
                        this.validationMsgs.add("JCO Implementation$#$OK");
                        if (this.connectionType.equalsIgnoreCase("group_server")) {
                            this.validationMsgs.add("SID/SAP System up$#$Failed");
                            this.validationMsgs.add("Logon Group$#$NA");
                        } else {
                            this.validationMsgs.add("Sysno/SAP System up$#$Failed");
                        }
                        this.validationMsgs.add("Client Name$#$NA");
                        this.validationMsgs.add("SAP UserName/Password$#$NA");
                    } else if (this.isLogonGroupFailed) {
                        this.validationMsgs.add("Host IP/Name$#$OK");
                        this.validationMsgs.add("JCO Implementation$#$OK");
                        if (this.connectionType.equalsIgnoreCase("group_server")) {
                            this.validationMsgs.add("SID$#$OK");
                            this.validationMsgs.add("Logon Group$#$Failed");
                        } else {
                            this.validationMsgs.add("Sysno/SAP System up$#$Failed");
                        }
                        this.validationMsgs.add("Client Name$#$NA");
                        this.validationMsgs.add("SAP UserName/Password$#$NA");
                    } else if (this.isClientNameFailed) {
                        this.validationMsgs.add("Host IP/Name$#$OK");
                        this.validationMsgs.add("JCO Implementation$#$OK");
                        if (this.connectionType.equalsIgnoreCase("group_server")) {
                            this.validationMsgs.add("SID$#$OK");
                            this.validationMsgs.add("Logon Group$#$OK");
                        } else {
                            this.validationMsgs.add("Sysno$#$OK");
                        }
                        this.validationMsgs.add("Client Name$#$Failed");
                        this.validationMsgs.add("SAP UserName/Password$#$NA");
                    } else if (this.isSAPAuthFailed) {
                        this.validationMsgs.add("Host IP/Name$#$OK");
                        this.validationMsgs.add("JCO Implementation$#$OK");
                        if (this.connectionType.equalsIgnoreCase("group_server")) {
                            this.validationMsgs.add("SID$#$OK");
                            this.validationMsgs.add("Logon Group$#$OK");
                        } else {
                            this.validationMsgs.add("Sysno$#$OK");
                        }
                        this.validationMsgs.add("Client Name$#$OK");
                        this.validationMsgs.add("SAP UserName/Password$#$Failed");
                    } else if (this.isSupportedFilesMissing) {
                        this.validationMsgs.add("Host IP/Name$#$OK");
                        this.validationMsgs.add("JCO Implementation$#$Failed");
                        if (this.connectionType.equalsIgnoreCase("group_server")) {
                            this.validationMsgs.add("SID$#$NA");
                            this.validationMsgs.add("Logon Group$#$NA");
                        } else {
                            this.validationMsgs.add("Sysno$#$NA");
                        }
                        this.validationMsgs.add("Client Name$#$NA");
                        this.validationMsgs.add("SAP UserName/Password$#$NA");
                    }
                    this.validationMsgs.add("SAP ABAP Instance Connectivity$#$" + string);
                } else {
                    System.out.println("Debug: JCO2.x Connectivity success ");
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("JCO Implementation$#$OK");
                    if (this.connectionType.equalsIgnoreCase("group_server")) {
                        this.validationMsgs.add("SID$#$OK");
                        this.validationMsgs.add("Logon Group$#$OK");
                    } else {
                        this.validationMsgs.add("Sysno$#$OK");
                    }
                    this.validationMsgs.add("Client Name$#$OK");
                    this.validationMsgs.add("SAP UserName/Password$#$OK");
                    if (this.instanceName != null && !this.instanceName.equalsIgnoreCase("none") && !this.instanceName.equalsIgnoreCase("default") && this.sapSid.equalsIgnoreCase("")) {
                        String string = (String)this.validationErrorMap.get("INSTANCE_NAME");
                        if (string != null) {
                            this.validationMsgs.add("Instance name$#$" + string);
                        } else {
                            this.validationMsgs.add("Instance name$#$OK");
                        }
                    }
                    this.validationMsgs.add("SAP ABAP Instance Connectivity$#$OK");
                }
            } else if (!this.isIPReachable(this.host)) {
                this.validationMsgs.add("Host IP/Name$#$Host IP/Name  '" + this.host + "' is invalid or unreachable");
                if (this.wsdl_port != null && this.wsdl_port.trim().length() > 0) {
                    this.validationMsgs.add("WSDL Port$#$NA");
                } else {
                    this.validationMsgs.add("Central WSDL port$#$NA");
                }
                this.validationMsgs.add("OS UserName/Password$#$NA");
                this.validationMsgs.add("SAPControl Web service connectivity$#$Failed");
            } else if (!this.checkSapAbapWSDLConnectivity()) {
                String string = (String)this.validationErrorMap.get("SAP_WSDL_CONNECTIVITY");
                if (string == null) {
                    string = "Something went wrong.";
                }
                if (this.isFaultCode) {
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    if (this.wsdl_port != null && this.wsdl_port.length() > 0) {
                        this.validationMsgs.add("WSDL Port$#$NA");
                    } else {
                        this.validationMsgs.add("Central WSDL Port$#$NA");
                    }
                    this.validationMsgs.add("OS UserName/Password$#$" + string);
                    this.validationMsgs.add("SAPControl Web service connectivity$#$" + string);
                } else if (this.isWSDLorCWSDLPortFailed) {
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    if (this.wsdl_port != null && this.wsdl_port.length() > 0) {
                        this.validationMsgs.add("WSDL Port$#$Failed");
                    } else {
                        this.validationMsgs.add("Central WSDL Port$#$Failed");
                    }
                    this.validationMsgs.add("OS UserName/Password$#$OK");
                    this.validationMsgs.add("SAPControl Web service connectivity$#$" + string);
                } else if (this.isWSDLPortFailed) {
                    string = this.wsdl_port != null && this.wsdl_port.length() > 0 ? "SAP System is down" : "SAP System is down";
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    if (this.wsdl_port != null && this.wsdl_port.length() > 0) {
                        this.validationMsgs.add("WSDL Port$#$OK");
                    } else {
                        this.validationMsgs.add("Central WSDL Port$#$OK");
                    }
                    this.validationMsgs.add("SAP System up$#$Failed");
                    this.validationMsgs.add("OS UserName/Password$#$NA");
                    this.validationMsgs.add("SAPControl Web service connectivity$#$" + string);
                } else if (string != null) {
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("OS UserName/Password$#$NA");
                    this.validationMsgs.add("SAPControl Web service connectivity$#$" + string);
                }
            } else {
                this.validationMsgs.add("Host IP/Name$#$OK");
                if (this.wsdl_port != null && this.wsdl_port.trim().length() > 0) {
                    this.validationMsgs.add("WSDL Port$#$OK");
                } else {
                    this.validationMsgs.add("Central WSDL Port$#$OK");
                }
                this.validationMsgs.add("OS UserName/Password$#$OK");
                this.validationMsgs.add("SAPControl Web service connectivity$#$OK");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.getValidationMsgs();
    }

    public ArrayList getValidationMsgs() {
        System.out.println("SapAbapInstanceValidator validationMsgs : " + this.validationMsgs);
        return this.validationMsgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkSapAbapJCO2Connectivity(String[] stringArray) {
        try {
            boolean bl;
            JCO.Client client2 = null;
            boolean bl2 = false;
            String string = "SUCCESS";
            AsAbapJco2Base asAbapJco2Base = new AsAbapJco2Base(stringArray);
            client2 = asAbapJco2Base.getConnection();
            if (client2 == null) {
                string = asAbapJco2Base.getErrorMsgForValidation();
            }
            if (client2 != null && (bl = asAbapJco2Base.executeCommand(client2))) {
                System.out.println("Debug: Got JCO2.x connection from validation framework");
            }
            if (string != null && string.equalsIgnoreCase("SUCCESS")) {
                if (this.instanceName != null && !this.instanceName.equalsIgnoreCase("none") && !this.instanceName.equalsIgnoreCase("default")) {
                    this.isValidInstance(asAbapJco2Base.getInstanceNameForValidation());
                }
                this.errorMessage = "SUCCESS";
                return true;
            }
            if (string != null && string.indexOf("ERROR_LOGON_FAILURE:") > -1 && string.indexOf("Client") > -1) {
                this.isClientNameFailed = true;
                string = string.substring(string.lastIndexOf(":") + 1);
                this.validationErrorMap.put("SAP_ABAP_CONNECTIVITY", string);
                this.errorMessage = string;
                return false;
            }
            if (string != null && string.indexOf("ERROR_LOGON_FAILURE:") > -1 && string.indexOf("Name") > -1) {
                this.isSAPAuthFailed = true;
                string = string.substring(string.lastIndexOf(":") + 1);
                this.validationErrorMap.put("SAP_ABAP_CONNECTIVITY", string);
                this.errorMessage = string;
                return false;
            }
            if (string != null && string.indexOf("ERROR_LOGON_FAILURE:") > -1 && string.indexOf("Password") > -1) {
                this.isSAPAuthFailed = true;
                string = string.substring(string.lastIndexOf(":") + 1);
                this.validationErrorMap.put("SAP_ABAP_CONNECTIVITY", string);
                this.errorMessage = string;
                return false;
            }
            if (string != null && string.indexOf("Logon group") > -1) {
                string = string.substring(string.lastIndexOf("ERROR       ") + 12, string.lastIndexOf("TIME"));
                this.isLogonGroupFailed = true;
                string = string.trim();
                this.validationErrorMap.put("SAP_ABAP_CONNECTIVITY", string);
                this.errorMessage = string;
                return false;
            }
            if (string != null && string.indexOf("ERROR_COMMUNICATION:") > -1) {
                string = string.substring(string.lastIndexOf("ERROR       ") + 12, string.lastIndexOf("TIME"));
                this.isSysnoFailed = true;
                string = string.trim();
                this.validationErrorMap.put("SAP_ABAP_CONNECTIVITY", string);
                this.errorMessage = string;
                return false;
            }
            if (string == null) return true;
            if (string.indexOf("ERROR_PROGRAM:") <= -1) return true;
            string = string.substring(string.lastIndexOf(":") + 1);
            this.validationErrorMap.put("SAP_ABAP_CONNECTIVITY", string);
            this.errorMessage = string;
            return false;
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            System.out.println("We are in ExceptionInInitializerError block " + exceptionInInitializerError.getMessage());
            String string = exceptionInInitializerError.getMessage();
            this.isSupportedFilesMissing = true;
            if (string != null && string.indexOf("JCO.nativeInit():") > -1) {
                String string2 = string.substring(string.lastIndexOf("JCO.nativeInit():") + "JCO.nativeInit():".length());
                this.validationErrorMap.put("SAP_ABAP_CONNECTIVITY", "Missing or Wrong RFC files placed for JCO2.x. Could not load middleware layer." + string2);
                return false;
            } else if (string != null && string.indexOf("Could not load middleware layer 'com.sap.mw.jco.rfc.MiddlewareRFC'") > -1) {
                this.validationErrorMap.put("SAP_ABAP_CONNECTIVITY", "Missing or Wrong RFC files placed for JCO2.x. Could not load middleware layer.");
                this.errorMessage = "Missing or Wrong RFC files placed for JCO 2.x. Could not load middleware layer.";
                return false;
            } else {
                this.validationErrorMap.put("SAP_ABAP_CONNECTIVITY", "Missing or Wrong RFC files placed for JCO2.x. Could not load middleware layer.");
                this.errorMessage = "Missing or Wrong RFC files placed for JCO 2.x. Could not load middleware layer.";
            }
            return false;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.isSupportedFilesMissing = true;
            System.out.println("We are in NoClassDefFoundError block " + noClassDefFoundError.getMessage());
            if ("com/sap/mw/jco/JCO$Client".equalsIgnoreCase(noClassDefFoundError.getMessage())) {
                this.validationErrorMap.put("SAP_ABAP_CONNECTIVITY", "JCO2.x supported jar file is missing.");
                this.errorMessage = "SAP ABAP JCO2.x supported jars are missing..";
                return false;
            } else {
                this.validationErrorMap.put("SAP_ABAP_CONNECTIVITY", "JCO2.x supported jar file is missing.");
                this.errorMessage = "SAP ABAP JCO2.x supported jar or dll files are missing..";
            }
            return false;
        }
        catch (Throwable throwable) {
            this.validationErrorMap.put("SAP_ABAP_CONNECTIVITY", "Something went wrong. Error: " + throwable.getMessage());
            throwable.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkSapAbapJCO3Connectivity(String[] stringArray) {
        try {
            AsAbapJco3Base asAbapJco3Base = new AsAbapJco3Base(stringArray);
            if (asAbapJco3Base != null && asAbapJco3Base.getConnection()) {
                boolean bl = asAbapJco3Base.executeCommandValidation();
                String string = asAbapJco3Base.getErrorMsgForValidation();
                if (string != null && string.equalsIgnoreCase("SUCCESS")) {
                    if (this.instanceName != null && !this.instanceName.equalsIgnoreCase("none") && !this.instanceName.equalsIgnoreCase("default")) {
                        this.isValidInstance(asAbapJco3Base.getInstanceNameForValidation());
                    }
                    this.errorMessage = string;
                    return true;
                }
                if (string != null && string.indexOf("ERROR_LOGON_FAILURE:") > -1 && string.indexOf("Client") > -1) {
                    this.isClientNameFailed = true;
                    string = string.substring(string.lastIndexOf(":") + 1);
                    this.validationErrorMap.put("SAP_ABAP_CONNECTIVITY", string);
                    this.errorMessage = string;
                    return false;
                }
                if (string != null && string.indexOf("ERROR_LOGON_FAILURE:") > -1 && string.indexOf("Name") > -1) {
                    this.isSAPAuthFailed = true;
                    string = string.substring(string.lastIndexOf(":") + 1);
                    this.validationErrorMap.put("SAP_ABAP_CONNECTIVITY", string);
                    this.errorMessage = string;
                    return false;
                }
                if (string != null && string.indexOf("ERROR_LOGON_FAILURE:") > -1 && string.indexOf("Password") > -1) {
                    this.isSAPAuthFailed = true;
                    string = string.substring(string.lastIndexOf(":") + 1);
                    this.validationErrorMap.put("SAP_ABAP_CONNECTIVITY", string);
                    this.errorMessage = string;
                    return false;
                }
                if (string != null && string.indexOf("Logon group") > -1) {
                    string = string.substring(string.lastIndexOf("ERROR       ") + 12, string.lastIndexOf("TIME"));
                    this.isLogonGroupFailed = true;
                    string = string.trim();
                    this.validationErrorMap.put("SAP_ABAP_CONNECTIVITY", string);
                    this.errorMessage = string;
                    return false;
                }
                if (string != null && string.indexOf("ERROR_COMMUNICATION:") > -1) {
                    string = string.substring(string.lastIndexOf("ERROR       ") + 12, string.lastIndexOf("TIME"));
                    this.isSysnoFailed = true;
                    string = string.trim();
                    this.validationErrorMap.put("SAP_ABAP_CONNECTIVITY", string);
                    this.errorMessage = string;
                    return false;
                }
                if (string == null) return true;
                if (string.indexOf("ERROR_PROGRAM:") <= -1) return true;
                string = string.substring(string.lastIndexOf(":") + 1);
                this.validationErrorMap.put("SAP_ABAP_CONNECTIVITY", string);
                this.errorMessage = string;
                return false;
            }
            System.out.println("Debug: Didn't get JCO3.x connection");
            return true;
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            this.isSupportedFilesMissing = true;
            System.out.println("JCO3.x We are in ExceptionInInitializerError block " + exceptionInInitializerError.getMessage());
            String string = "";
            this.errorMessage = exceptionInInitializerError.getMessage();
            if (this.errorMessage != null && this.errorMessage.indexOf("java.lang.UnsatisfiedLinkError:") > -1) {
                if (this.errorMessage != null && this.errorMessage.indexOf("JCo initialization failed") > -1) {
                    this.validationErrorMap.put("SAP_ABAP_CONNECTIVITY", "rfc file is missing for JCO3.x ");
                    return false;
                }
                if (this.errorMessage != null && this.errorMessage.indexOf("Error getting the version of the native layer") > -1) {
                    this.validationErrorMap.put("SAP_ABAP_CONNECTIVITY", "Wrong rfc file is placed for JCO3.x.(please check you may placed wrong OS bit version)");
                    return false;
                } else {
                    this.validationErrorMap.put("SAP_ABAP_CONNECTIVITY", "Missing or Wrong RFC files placed for JCO3.x.");
                }
                return false;
            }
            this.validationErrorMap.put("SAP_ABAP_CONNECTIVITY", this.errorMessage);
            return false;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println("We are in UnsatisfiedLinkError block " + unsatisfiedLinkError.getMessage());
            this.isSupportedFilesMissing = true;
            this.validationErrorMap.put("SAP_ABAP_CONNECTIVITY", "Missing or Wrong RFC files placed for JCO3.x.");
            this.errorMessage = "Missing or Wrong RFC files placed for JCO3.x";
            return false;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.out.println("We are in NoClassDefFoundError block " + noClassDefFoundError.getMessage());
            this.isSupportedFilesMissing = true;
            if ("com/sap/conn/jco/JCoException".equalsIgnoreCase(noClassDefFoundError.getMessage())) {
                this.validationErrorMap.put("SAP_ABAP_CONNECTIVITY", "JCO3.x supported jar file is missing.");
                this.errorMessage = "Missing or Wrong jar files placed for JCO 3.x";
                return false;
            } else {
                this.validationErrorMap.put("SAP_ABAP_CONNECTIVITY", "JCO3.x supported jar file is missing.");
                this.errorMessage = "Missing or Wrong jar files placed for JCO 3.x";
            }
            return false;
        }
        catch (Throwable throwable) {
            this.validationErrorMap.put("SAP_ABAP_CONNECTIVITY", "Something went wrong. Error: " + throwable.getMessage());
            throwable.printStackTrace();
            return false;
        }
    }

    public boolean isValidInstance(String string) {
        System.out.println("isValidInstance method get called ........");
        System.out.println("Discovered Instance name :" + string);
        System.out.println("TestParam Instance name :" + this.instanceName);
        if (string != null && !string.equalsIgnoreCase(this.instanceName)) {
            this.validationErrorMap.put("INSTANCE_NAME", "Invalid instance name");
            return false;
        }
        return true;
    }

    public boolean checkSapAbapWSDLConnectivity() {
        String string = "http://";
        String string2 = "";
        string2 = this.wsdl_port != null && this.wsdl_port.length() > 0 ? string + this.host + ":" + this.wsdl_port + "/?wsdl" : string + this.host + ":" + this.central_wsdl_port + "/?wsdl";
        boolean bl = this.getWSDLConnection(string2);
        if (this.isSSL) {
            if (this.isSSLPort) {
                string = "https://";
                string2 = this.wsdl_port != null && this.wsdl_port.length() > 0 ? string + this.host + ":" + this.wsdl_port + "/?wsdl" : string + this.host + ":" + this.central_wsdl_port + "/?wsdl";
                bl = this.getWSDLConnection(string2);
            } else {
                String string3 = "";
                string3 = this.wsdl_port != null && this.wsdl_port.length() > 0 ? "WSDL Port is down or unavailable" : "Central WSDL Port is down or unavailable";
                this.validationErrorMap.put("SAP_WSDL_CONNECTIVITY", string3);
                return false;
            }
        }
        return bl;
    }

    public boolean getWSDLConnection(String string) {
        try {
            String string2 = "";
            string2 = this.wsdl_port != null && this.wsdl_port.length() > 0 ? "GetQueueStatistic" : "EnqGetStatistic";
            String string3 = this.sapCntrlBase.getSoapRequest(string2);
            String string4 = SapControlBase.invokeOperation(string3, string2, string, this.os_Username, this.os_Password);
            ArrayList arrayList = new ArrayList();
            if (string4 == null || string4.trim().length() == 0) {
                return false;
            }
            if (string4 != null) {
                String string5 = "";
                if (string4.indexOf("faultcode") >= 0 || string4.indexOf("faultstring") >= 0) {
                    if (string4.indexOf("Invalid Credentials") > 0) {
                        string5 = "Invalid username/password; logon denied";
                        this.isFaultCode = true;
                    } else if (string4.indexOf("Enqueue service not supported") > 0 || string4.indexOf("No queue information available") > 0) {
                        string5 = this.wsdl_port != null && this.wsdl_port.length() > 0 ? "Central WSDL port value configured for WSDL port" : "WSDL port value configured for Central WSDL port";
                        this.isWSDLorCWSDLPortFailed = true;
                    } else {
                        string5 = this.wsdl_port != null && this.wsdl_port.length() > 0 ? "WSDL Port is down or unavailable" : "Central WSDL Port is down or unavailable";
                    }
                    this.validationErrorMap.put("SAP_WSDL_CONNECTIVITY", string5);
                    return false;
                }
                if (string4.indexOf("ERROR in Invoke Operation >") > -1) {
                    if (!this.isSSLPort && this.isSSL && this.isSpecificPortReachable(this.connectorport)) {
                        this.isSSLPort = true;
                    } else {
                        if (this.wsdl_port != null && this.wsdl_port.length() > 0) {
                            this.isWSDLPortFailed = true;
                            string5 = "WSDL Port is down or unavailable";
                        } else {
                            this.isWSDLPortFailed = true;
                            string5 = "Central WSDL Port is down or unavailable";
                        }
                        this.validationErrorMap.put("SAP_WSDL_CONNECTIVITY", string5);
                    }
                    return false;
                }
                return true;
            }
        }
        catch (Throwable throwable) {
            String string6 = "";
            String string7 = this.getStackTraceAsString(throwable);
            string6 = string7.indexOf("DestinationException") > 0 ? "WSDL port is down or listener is down" : (string7.indexOf("NoPermissionException") > 0 ? "Invalid username/password; logon denied" : "Listener refused the connection due to 'Unknown  WSDL Port'");
            this.validationErrorMap.put("SAP_WSDL_CONNECTIVITY", string6);
            return false;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        SapAbapInstanceValidator sapAbapInstanceValidator = new SapAbapInstanceValidator(stringArray, new Boolean(false));
    }
}

