/*
 * Decompiled with CFR 0.152.
 */
import com.sap.mw.jco.JCO;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class SapMonPerfJco2Test
extends AsAbapJco2Base {
    public ArrayList monSetsList = new ArrayList();
    public int perfAtr = 0;
    public int red = 0;
    public int yellow = 0;
    public int green = 0;
    public int inactive = 0;
    public ArrayList ddlist = new ArrayList();
    public ArrayList mteVal = new ArrayList();
    protected Hashtable ddhash = new Hashtable();
    public Hashtable detHT;
    public String monSets = this.getValueForParam("Sets");
    public String mons = this.getValueForParam("Monitors");
    public String MonitorName = "";
    public String MonitorSetName = "";
    public String prevDt = "";
    public String prevTime = "";
    public String currValTime = "";
    public String currValDt = "";
    public static final String MON_SET_NAME = "SAP CCMS Monitor Templates";
    private static final ArrayList perfAttrList = new ArrayList();

    public SapMonPerfJco2Test(String[] stringArray) {
        super(stringArray);
        this.printOut("INFO    :monitor sets are " + this.monSets + " and monitors are " + this.mons);
        this.detHT = this.parseMonDetails(this.monSets, this.mons);
        this.setMeasureCount(5);
    }

    public synchronized Hashtable getDDData() {
        return this.ddhash;
    }

    public void resetDDData() {
        if (this.ddhash.size() != 0) {
            this.ddhash = new Hashtable();
        }
    }

    public synchronized Hashtable getMeasures(Hashtable hashtable) {
        Hashtable hashtable2 = new Hashtable();
        this.resetDDData();
        JCO.Client client = this.getConnection();
        Enumeration enumeration = this.detHT.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ArrayList arrayList = (ArrayList)this.detHT.get(string);
            this.printOut("INFO    :setName is " + string + " monsList is " + arrayList.toString());
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2 = (String)arrayList.get(i);
                if (client == null || !this.prepMonitorTree(string, string2, client)) {
                    this.addNotAvailableMeasure(hashtable2, string2);
                    continue;
                }
                this.ddhash.put(string2, this.ddlist);
                ArrayList<Double> arrayList2 = new ArrayList<Double>();
                arrayList2.add(new Double(this.perfAtr));
                arrayList2.add(new Double(this.red));
                arrayList2.add(new Double(this.yellow));
                arrayList2.add(new Double(this.green));
                arrayList2.add(new Double(this.inactive));
                System.out.println("monitorName   :" + string2 + "  :  measurelist   :" + arrayList2);
                hashtable2.put(string2, arrayList2);
            }
        }
        if (client != null) {
            this.logoffAndReleaseClient(client);
        }
        return hashtable2;
    }

    void addNotAvailableMeasure(Hashtable hashtable, String string) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(-5.0));
        arrayList.add(new Double(-5.0));
        arrayList.add(new Double(-5.0));
        arrayList.add(new Double(-5.0));
        arrayList.add(new Double(-5.0));
        hashtable.put(string, arrayList);
    }

    boolean prepMonitorTree(String string, String string2, JCO.Client client) {
        this.printOut("INFO    :Getting tree for monitor " + string2 + " in set " + string);
        try {
            JCO.Table table = this.getTreeNodesTblForMonitor(string, string2, client);
            if (table == null) {
                System.out.println("(TreeNodesTbl= getTreeNodesTblForMonitor(setName, monitorName)) == null");
                return false;
            }
            JCO.Table table2 = this.getTemplateNodesTblForMonitor(string, string2, client);
            if (table2 == null) {
                System.out.println("Second (TmplNodesTbl= getTemplateNodesTblForMonitor(setName, monitorName)) == null");
                return false;
            }
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            this.prevDt = "N/A";
            this.prevTime = "N/A";
            this.currValTime = "";
            this.currValDt = "";
            this.red = 0;
            this.yellow = 0;
            this.green = 0;
            this.inactive = 0;
            this.perfAtr = 0;
            this.ddlist = new ArrayList();
            this.printOut("INFO    :Num rows is " + table.getNumRows());
            for (int i = 0; i < table.getNumRows(); ++i) {
                int n;
                table.setRow(i);
                String string7 = table.getString("MTCLASS");
                if (this.isAttribute(string7) && !this.isPerfAttr(string7)) {
                    this.printOut("INFO    :Skipping  . Since possible shutdown app server");
                    continue;
                }
                String string8 = table.getString("MTNAMESHRT");
                if (string8.indexOf(" Segment ") != -1) {
                    this.printOut("INFO    :Skipping " + string8 + " . Since possible shutdown app server");
                    continue;
                }
                if (this.isPerfAttr(string7)) {
                    this.mteVal = this.getMTEVal(table, table2, client);
                    System.out.println("mteVal  :" + this.mteVal);
                    if (this.mteVal == null || this.mteVal.size() == 0) continue;
                    this.mteVal.add(string8);
                    this.getMetrics(this.mteVal);
                    continue;
                }
                StringBuffer stringBuffer = new StringBuffer();
                String string9 = table.getString("ALLEVINTRE");
                int n2 = Integer.parseInt(string9);
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append("/t");
                }
                if (string8.indexOf(" : MTE class ") != -1) {
                    n = 0;
                    int n3 = string8.indexOf(44);
                    string8 = string8.substring(0, n3) + " : No MTEs currently available";
                } else {
                    n = this.isLongMTENameNeeded(table) ? 1 : 0;
                }
                if (n != 0) {
                    String string10 = table.getString("MSEGNAME");
                    String string11 = this.getNameFromTemplateNode(table, table2, string10);
                    if (string11 != null) {
                        stringBuffer.append(string11);
                    } else {
                        stringBuffer.append(string8);
                    }
                } else {
                    stringBuffer.append(string8);
                }
                String string12 = stringBuffer.toString();
                this.ddlist.add(string12);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLongMTENameNeeded(JCO.Table table) {
        boolean bl = false;
        int n = table.getRow();
        try {
            int n2 = table.getInt("ALPARINTRE") - 1;
            if (n2 < 0) {
                boolean bl2 = true;
                return bl2;
            }
            String string = table.getString("MTCLASS");
            if (this.isVirtualNode(string)) {
                bl = false;
            }
            table.setRow(n2);
            string = table.getString("MTCLASS");
            if (this.isVirtualNode(string)) {
                bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", this.entity, "Exception while determining if long MTE name is needed for MTE " + table.getString("MTNAMESHRT") + " : " + exception.toString());
        }
        finally {
            table.setRow(n);
            return bl;
        }
    }

    String getNameFromTemplateNode(JCO.Table table, JCO.Table table2, String string) {
        int n = table2.getNumRows();
        int n2 = table2.getRow() + 1;
        if (n2 > n) {
            this.printOut("ERROR   :Curser in Template Nodes Table exceeded table size even before lookup");
            return null;
        }
        String string2 = "";
        if (string.startsWith("SAP_CCMS_")) {
            string = string.substring(9);
        }
        String string3 = null;
        boolean bl = false;
        try {
            string2 = table.getString("MTUID");
            for (int i = n2; i < n; ++i) {
                table2.nextRow();
                String string4 = table2.getString("MTUID");
                String string5 = table2.getString("MTMCNAME");
                if (string5.startsWith("SAP_CCMS_")) {
                    string5 = string5.substring(9);
                }
                if (!string4.equals(string2) || !string5.equals(string)) continue;
                bl = true;
                break;
            }
            if (bl) {
                string3 = table2.getString("NAME");
            }
        }
        catch (Exception exception) {
            this.printOut("ERROR   :Exception while getting template node name for MT ROW UID " + string2 + " : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "Exception while getting template node name for MT ROW UID " + string2 + " : " + exception.toString());
            return null;
        }
        if (string3 == null) {
            this.printOut("ERROR   :Could not find template node name for MT ROW UID " + string2 + " and mtName " + table.getString("MTNAMESHRT"));
            return null;
        }
        return string3;
    }

    void getMetrics(ArrayList arrayList) {
        String string;
        String string2;
        System.out.println("Calling getMetrics ...");
        String string3 = (String)arrayList.get(0);
        String string4 = (String)arrayList.get(1);
        if (string4 == null || string4.length() == 0) {
            string4 = "N/A";
        }
        if ((string2 = (String)arrayList.get(2)).equalsIgnoreCase("red")) {
            ++this.red;
        } else if (string2.equalsIgnoreCase("yellow")) {
            ++this.yellow;
        } else if (string2.equalsIgnoreCase("green")) {
            ++this.green;
        } else if (string2.equalsIgnoreCase("grey")) {
            ++this.inactive;
        }
        String string5 = (String)arrayList.get(3);
        String string6 = (String)arrayList.get(4);
        if (string6 == null || string6.length() == 0) {
            string6 = this.prevDt.equals("N/A") ? "N/A" : this.prevDt;
        }
        if ((string = (String)arrayList.get(5)) == null || string.length() == 0) {
            string = this.prevTime.equals("N/A") ? "N/A" : this.prevTime;
        }
        String string7 = (String)arrayList.get(6);
        ++this.perfAtr;
    }

    boolean isAttribute(String string) {
        return string.equals("100") || string.equals("101") || string.equals("102") || string.equals("110") || string.equals("111");
    }

    boolean isPerfAttr(String string) {
        return string.equals("100");
    }

    boolean isVirtualNode(String string) {
        return string.equals("199");
    }

    JCO.Table getTemplateNodesTblForMonitor(String string, String string2, JCO.Client client) {
        JCO.Structure structure;
        JCO.Function function = this.createFunction("BAPI_SYSTEM_MON_GETTEMPLATE");
        if (function == null) {
            this.logToErrorFile("ERROR", this.entity, " Could not find function BAPI_SYSTEM_MON_GETTREE\n");
            return null;
        }
        JCO.ParameterList parameterList = function.getImportParameterList();
        parameterList.setValue(this.eGSapXMIUser, "EXTERNAL_USER_NAME");
        try {
            structure = parameterList.getStructure("MONITOR_NAME");
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", this.entity, "Could not get MONITOR_NAME JCO structure for BAPI_SYSTEM_MON_GETTEMPALTE input : " + exception.toString());
            return null;
        }
        structure.setValue(MON_SET_NAME, "MS_NAME");
        structure.setValue(string2, "MONI_NAME");
        try {
            this.executeFunction(function, client, true);
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", this.entity, "Exception while executing BAPI_SYSTEM_MON_GETTEMPLATE function : " + exception.toString());
            return null;
        }
        parameterList = function.getTableParameterList();
        JCO.Table table = null;
        try {
            table = parameterList.getTable("TEMPLATE_NODES");
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", this.entity, "Could not get TREE_NODES JCO table for BAPI_SYSTEM_MON_GETTEMPALTE output : " + exception.toString());
            return null;
        }
        System.out.println("JTable template " + table);
        return table;
    }

    ArrayList getMTEVal(JCO.Table table, JCO.Table table2, JCO.Client client) {
        try {
            String string = table.getString("MTSYSID");
            String string2 = table.getString("MTMCNAME");
            String string3 = table.getString("MTNUMRANGE");
            String string4 = table.getString("MTUID");
            String string5 = table.getString("MTCLASS");
            String string6 = table.getString("MTINDEX");
            String string7 = table.getString("EXTINDEX");
            JCO.Function function = this.createFunction("BAPI_SYSTEM_MTE_GETPERFCURVAL");
            if (function == null) {
                return null;
            }
            JCO.Structure structure = function.getImportParameterList().getStructure("TID");
            structure.setValue(string, "MTSYSID");
            structure.setValue(string2, "MTMCNAME");
            structure.setValue(string3, "MTNUMRANGE");
            structure.setValue(string4, "MTUID");
            structure.setValue(string5, "MTCLASS");
            structure.setValue(string6, "MTINDEX");
            structure.setValue(string, "MTSYSID");
            function.getImportParameterList().setValue(this.eGSapXMIUser, "EXTERNAL_USER_NAME");
            try {
                this.executeFunction(function, client, true);
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR", this.entity, "Exception while executing BAPI_SYSTEM_MTE_GETPERFCURVAL function : " + exception.toString());
            }
            JCO.Structure structure2 = function.getExportParameterList().getStructure("CURRENT_VALUE");
            if (structure2 == null) {
                this.printOut("INFO    :CURRENT_VAL struct from getperfcurVal is null");
                return null;
            }
            JCO.Function function2 = this.createFunction("BAPI_SYSTEM_MTE_GETPERFPROP");
            if (function2 == null) {
                return null;
            }
            structure = function2.getImportParameterList().getStructure("TID");
            structure.setValue(string, "MTSYSID");
            structure.setValue(string2, "MTMCNAME");
            structure.setValue(string3, "MTNUMRANGE");
            structure.setValue(string4, "MTUID");
            structure.setValue(string5, "MTCLASS");
            structure.setValue(string6, "MTINDEX");
            structure.setValue(string, "MTSYSID");
            function2.getImportParameterList().setValue(this.eGSapXMIUser, "EXTERNAL_USER_NAME");
            try {
                this.executeFunction(function2, client, true);
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR", this.entity, "Exception while executing BAPI_SYSTEM_MTE_GETPERFPROP function : " + exception.toString());
            }
            JCO.Structure structure3 = function2.getExportParameterList().getStructure("PROPERTIES");
            if (structure3 == null) {
                this.printOut("INFO    :PROPERTIES struct from getperfprop is null");
                return null;
            }
            JCO.Function function3 = this.createFunction("BAPI_SYSTEM_MTE_GETGENPROP");
            if (function3 == null) {
                return null;
            }
            structure = function3.getImportParameterList().getStructure("TID");
            structure.setValue(string, "MTSYSID");
            structure.setValue(string2, "MTMCNAME");
            structure.setValue(string3, "MTNUMRANGE");
            structure.setValue(string4, "MTUID");
            structure.setValue(string5, "MTCLASS");
            structure.setValue(string6, "MTINDEX");
            structure.setValue(string, "MTSYSID");
            function3.getImportParameterList().setValue(this.eGSapXMIUser, "EXTERNAL_USER_NAME");
            try {
                this.executeFunction(function3, client, true);
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR", this.entity, "Exception while executing BAPI_SYSTEM_MTE_GETGENPROP function : " + exception.toString());
            }
            JCO.Structure structure4 = function3.getExportParameterList().getStructure("ACTUAL_ALERT_DATA");
            if (structure4 == null) {
                this.printOut("INFO    :ACTUAL_ALERT_DATA struct from getgenprop is null");
                return null;
            }
            ArrayList arrayList = this.formatVal(structure2, structure3, structure4);
            return arrayList;
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", this.entity, " Exception while printing mte Value : " + exception.toString());
            return null;
        }
    }

    ArrayList formatVal(JCO.Structure structure, JCO.Structure structure2, JCO.Structure structure3) {
        try {
            if (this.currValDt.length() != 0) {
                this.prevDt = this.currValDt;
                this.prevTime = this.currValTime;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = "";
            String string2 = structure.getString("ALRELEVVAL");
            this.currValDt = structure.getString("ALRELVALDT");
            this.currValTime = structure.getString("ALRELVALTI");
            String string3 = structure2.getString("VALUNIT");
            String string4 = structure2.getString("DECIMALS");
            String string5 = structure2.getString("ATTRGROUP");
            String string6 = structure3.getString("VALUE");
            int n = Integer.parseInt(string6);
            if (n == 0) {
                string = "grey";
            } else if (n == 1) {
                string = "green";
            } else if (n == 2) {
                string = "yellow";
            } else if (n == 3) {
                string = "red";
            }
            int n2 = Integer.parseInt(string4);
            StringBuffer stringBuffer = new StringBuffer();
            if (n2 > 0) {
                int n3;
                int n4 = string2.length();
                if (n2 > n4 - 1) {
                    n3 = n2 - n4 + 1;
                    StringBuffer stringBuffer2 = new StringBuffer();
                    for (int i = 0; i < n3; ++i) {
                        stringBuffer2.append("0");
                    }
                    stringBuffer2.append(string2);
                    string2 = stringBuffer2.toString();
                    n4 = string2.length();
                }
                n3 = n4 - n2;
                stringBuffer.append(string2.substring(0, n3)).append(".").append(string2.substring(n3)).append(" ");
            } else {
                stringBuffer.append(string2).append(" ");
            }
            arrayList.add(stringBuffer.toString());
            arrayList.add(string3);
            arrayList.add(string);
            arrayList.add(string6);
            arrayList.add(this.currValDt);
            arrayList.add(this.currValTime);
            return arrayList;
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", this.entity, " Exception while printing node data : " + exception.toString());
            return null;
        }
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("-password")) continue;
            stringArray[i + 1] = EgCrypt.decrypt(stringArray[i + 1]);
            break;
        }
        SapMonPerfJco2Test sapMonPerfJco2Test = new SapMonPerfJco2Test(stringArray);
        System.out.println(sapMonPerfJco2Test.getMeasures(new Hashtable()));
    }

    public Hashtable parseMonDetails(String string, String string2) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
        StringTokenizer stringTokenizer3 = null;
        Hashtable hashtable = new Hashtable();
        int n2 = stringTokenizer.countTokens();
        int n3 = n2 < (n = stringTokenizer2.countTokens()) ? n2 : n;
        this.printOut("INFO    :Number of valid iterations of monitor details is " + n3);
        for (int i = 0; i < n3; ++i) {
            String string3 = stringTokenizer.nextToken().trim();
            String string4 = stringTokenizer2.nextToken();
            stringTokenizer3 = new StringTokenizer(string4, "~#~");
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer3.hasMoreTokens()) {
                String string5 = stringTokenizer3.nextToken().trim();
                arrayList.add(string5);
            }
            hashtable.put(string3, arrayList);
        }
        this.printOut("INFO    :Parsed monitor details : " + hashtable.toString());
        return hashtable;
    }

    protected JCO.Table getTreeNodesTblForMonitor(String string, String string2, JCO.Client client) {
        Object var4_4 = null;
        long l = System.currentTimeMillis();
        if (!this.logonToXMI(client)) {
            return null;
        }
        String string3 = "BAPI_SYSTEM_MON_GETTREE not found in SAP.";
        JCO.Function function = null;
        try {
            function = this.createFunction("BAPI_SYSTEM_MON_GETTREE");
        }
        catch (Exception exception) {
            this.printOut("Error while executing BAPI_SYSTEM_MON_GETTREE : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "Error while executing BAPI_SYSTEM_MON_GETTREE : " + exception.toString());
            exception.printStackTrace();
            return null;
        }
        if (function == null) {
            this.printOut("Error : Could not create function BAPI_SYSTEM_MON_GETTREE");
            return null;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        JCO.Table table = null;
        Object var13_14 = null;
        String string4 = new String();
        String string5 = "";
        String string6 = "";
        boolean bl = false;
        try {
            function.getImportParameterList().setValue(this.eGSapXMIUser, "EXTERNAL_USER_NAME");
            JCO.Structure structure = function.getImportParameterList().getStructure("MONITOR_NAME");
            structure.setValue(string2, "MONI_NAME");
            structure.setValue(MON_SET_NAME, "MS_NAME");
            this.executeFunction(function, client, true);
            table = function.getTableParameterList().getTable("TREE_NODES");
            bl = perfAttrList.contains(string2);
            int n = table.getNumRows();
            if (debug) {
                this.printOut(table.toString());
            }
        }
        catch (Exception exception) {
            this.printOut("Exception while trying to get monitor tree: " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "Exception while trying to get monitor tree: " + exception.toString());
            exception.printStackTrace();
            boolean bl2 = false;
        }
        return table;
    }

    static {
        perfAttrList.add("Entire System");
        perfAttrList.add("Communications");
        perfAttrList.add("Background Processing");
        perfAttrList.add("Database");
        perfAttrList.add("Buffers");
        perfAttrList.add("System Configuration");
        perfAttrList.add("Spool System");
    }
}

