/*
 * Decompiled with CFR 0.152.
 */
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class SapMonsJco3_cf
extends AsAbapJco3Base {
    private String MonSet = "";
    ArrayList MonsetList = new ArrayList();
    boolean isFirstTime = true;
    boolean connFailed = true;
    String MonSetUpper = null;

    public SapMonsJco3_cf(String[] stringArray) {
        super(stringArray);
        this.setConfigInfoTestFlag(true);
        this.MonSet = this.getValueForParam("monitor_sets");
        this.MonSetUpper = this.MonSet.toUpperCase();
        TreeSet<String> treeSet = new TreeSet<String>();
        if (this.MonSetUpper.indexOf("ALL") != -1 || this.MonSetUpper.indexOf("NONE") != -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.MonSet, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                try {
                    treeSet.add(string);
                }
                catch (Exception exception) {
                    this.printOut("ERROR : Exception while adding String " + string + " to treeset : " + exception.toString());
                    this.logToErrorFile("ERROR", this.thisServer, "Exception while adding String " + string + " to treeset : " + exception.toString());
                }
            }
            this.MonsetList = new ArrayList(treeSet);
            this.printOut("Got MonsetList " + this.MonsetList.toString());
        }
        this.setMeasureCount(2);
    }

    public TreeSet getAllSets() {
        JCoFunction jCoFunction = this.getFunction("BAPI_SYSTEM_MS_GETLIST");
        if (jCoFunction == null) {
            return null;
        }
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", this.eGSapXMIUser);
        try {
            this.executeFunction(jCoFunction, true);
        }
        catch (Exception exception) {
            this.printOut("ERROR : Exception while executing BAPI_SYSTEM_MS_GETLIST : " + exception.toString());
            this.printOut("ERROR : " + EgInstallInfo.getStackTraceAsString(exception));
            this.logToErrorFile("ERROR", this.thisServer, "Exception while executing BAPI_SYSTEM_MS_GETLIST : " + exception.toString());
            this.logToErrorFile("ERROR", this.thisServer, EgInstallInfo.getStackTraceAsString(exception));
            return null;
        }
        JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("MONITOR_SETS");
        int n = jCoTable.getNumRows();
        TreeSet<String> treeSet = new TreeSet<String>();
        this.printOut("INFO : Obtained " + n + " monitor sets");
        if (n > 0) {
            this.printOut("INFO : Obtained " + n + " monitor sets");
            for (int i = 0; i < n; ++i) {
                String string = jCoTable.getString("NAME");
                treeSet.add(string);
                jCoTable.nextRow();
            }
        }
        return treeSet;
    }

    public Hashtable getMeasures() {
        Hashtable hashtable = new Hashtable();
        this.setSessID();
        try {
            this.runThread(new AsAbapJco3Base.ContextManager(this.sessID, this.destName, 1), "Begin Context");
        }
        catch (Exception exception) {
            this.printOut("ERROR : Could not begin context : " + exception.toString());
            this.logToErrorFile("ERROR", this.reportingName + " : " + this.entity, "ERROR : Could not begin context : " + exception.toString());
            this.endSession();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("-");
            if (this.MonsetList.size() > 0) {
                for (int i = 0; i < this.MonsetList.size(); ++i) {
                    String string = (String)this.MonsetList.get(i);
                    hashtable.put(string, arrayList);
                }
            } else {
                arrayList = new ArrayList();
                arrayList.add("-");
                hashtable.put(this.MonSetUpper, arrayList);
            }
            return hashtable;
        }
        if (!this.logonToXMI("XAL", "1.0")) {
            this.printOut("ERROR : Could not logon to XMI interface");
            this.logToErrorFile("ERROR", this.thisServer, "Could not logon to XMI interface");
            try {
                this.runThread(new AsAbapJco3Base.ContextManager(this.sessID, this.destName, 2), "End Context");
            }
            catch (Exception exception) {
                this.printOut("Error ending context : " + exception.toString());
                this.logToErrorFile("ERROR", this.reportingName + " : " + this.entity, "Error ending context : " + exception.toString());
            }
            this.endSession();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("-");
            if (this.MonsetList.size() > 0) {
                for (int i = 0; i < this.MonsetList.size(); ++i) {
                    String string = (String)this.MonsetList.get(i);
                    hashtable.put(string, arrayList);
                }
            } else {
                arrayList = new ArrayList();
                arrayList.add("-");
                hashtable.put(this.MonSetUpper, arrayList);
            }
            return hashtable;
        }
        this.printOut("logged onto XMI");
        if (this.isFirstTime) {
            String string = this.MonSet.toUpperCase();
            TreeSet treeSet = new TreeSet();
            if (string.indexOf("ALL") != -1 || string.indexOf("NONE") != -1) {
                treeSet = this.getAllSets();
                if (treeSet == null) {
                    this.printOut("ERROR : Error while getting the list of all sets");
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add("-");
                    hashtable.put(string, arrayList);
                    return hashtable;
                }
                this.MonsetList = new ArrayList(treeSet);
                this.printOut("Determined MonsetList = " + this.MonsetList.toString());
            }
            this.isFirstTime = false;
        }
        for (int i = 0; i < this.MonsetList.size(); ++i) {
            String string = (String)this.MonsetList.get(i);
            this.addMonsToMeasHT(hashtable, string);
        }
        try {
            this.runThread(new AsAbapJco3Base.ContextManager(this.sessID, this.destName, 2), "End Context");
        }
        catch (Exception exception) {
            this.printOut("Error ending context : " + exception.toString());
            this.logToErrorFile("ERROR", this.reportingName + " : " + this.entity, "Error ending context : " + exception.toString());
        }
        this.endSession();
        return hashtable;
    }

    public void addMonsToMeasHT(Hashtable hashtable, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string2;
            this.printOut("INFO : Trying to get monitors for set " + string);
            JCoFunction jCoFunction = this.getFunction("BAPI_SYSTEM_MON_GETLIST");
            if (jCoFunction == null) {
                this.printOut("Error : Could not create function BAPI_SYSTEM_MON_GETLIST");
                arrayList.add("-");
                hashtable.put(string, arrayList);
                return;
            }
            jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", this.eGSapXMIUser);
            JCoStructure jCoStructure = jCoFunction.getImportParameterList().getStructure("MONI_SET_NAME");
            if (jCoStructure == null) {
                this.printOut("Error : Could not get structure MONI_SET_NAME");
                arrayList.add("-");
                hashtable.put(string, arrayList);
                return;
            }
            jCoStructure.setValue("NAME", string);
            try {
                this.executeFunction(jCoFunction, true);
            }
            catch (Exception exception) {
                this.printOut("ERROR : Exception while executing BAPI_SYSTEM_MON_GETLIST function : " + exception.toString());
                this.logToErrorFile("ERROR", this.entity, "Exception while executing BAPI_SYSTEM_MON_GETLIST function : " + exception.toString());
                arrayList.add("-");
                hashtable.put(string, arrayList);
                return;
            }
            JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("MONITOR_NAMES");
            int n = jCoTable.getNumRows();
            if (n == 0) {
                arrayList.add("-");
                hashtable.put(string, arrayList);
                return;
            }
            TreeSet<String> treeSet = new TreeSet<String>();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                String string3 = jCoTable.getString("MONI_NAME");
                treeSet.add(string3);
                jCoTable.nextRow();
            }
            Iterator iterator = treeSet.iterator();
            if (iterator.hasNext()) {
                string2 = (String)iterator.next();
                stringBuffer.append(" [ " + string2 + " ] ");
            }
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                stringBuffer.append(",");
                stringBuffer.append(" [ " + string2 + " ] ");
            }
            arrayList.add(stringBuffer.toString());
            this.printOut("INFO : SapMons_cf] MonSetName " + string + " " + arrayList + ". List size = " + arrayList.size());
            hashtable.put(string, arrayList);
        }
        catch (Exception exception) {
            arrayList.add("-");
            hashtable.put(string, arrayList);
            this.printOut("ERROR : Exception while trying to get montiors in set " + string + " : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, this.thisServer + " : " + "Exception while trying to get montiors in set " + string + " : " + exception.toString());
            this.logToErrorFile("ERROR", this.thisServer, EgInstallInfo.getStackTraceAsString(exception));
        }
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("-password")) continue;
            stringArray[i + 1] = EgCrypt.decrypt(stringArray[i + 1]);
            break;
        }
        SapMonsJco3_cf sapMonsJco3_cf = new SapMonsJco3_cf(stringArray);
        sapMonsJco3_cf.decryptPassword();
        System.out.println("Measures = " + sapMonsJco3_cf.getMeasures().toString());
    }
}

