/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;

public class SapRoutValidator
extends EgServerValidator {
    private SapControlBase sapControlBase = null;
    private String sys_OS = "";
    private SapWasGenericTest sapWasGenericTest = null;
    private String path = "";
    private String searchPattern = "";
    private String serverIDs = "";
    private boolean isWSDLPortFailed = false;
    private boolean isWSDLorCWSDLPortFailed = false;
    private boolean isFaultCode = false;
    private boolean isSSL = false;
    private boolean isInstanceBased = true;
    private boolean sslFlag = false;
    private boolean isFromManager = false;
    private String wsdlUrl = "";
    private Hashtable validationErrorMap = new Hashtable();
    private ArrayList validationMsgs = null;
    private String[] params = null;
    private boolean isSapRouter = false;
    private boolean isDevRout = false;
    private boolean isSapDirParam = false;
    private boolean isSapRoutDir = false;
    private boolean isSearchPattern = false;

    public SapRoutValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        this.sys_OS = System.getProperty("os.name").toUpperCase();
        if (stringArray != null && stringArray.length > 0) {
            this.params = new String[stringArray.length * 2];
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = string.substring(0, string.indexOf(":"));
                String string3 = string.substring(string.indexOf(":") + 1);
                if ((string2 = string2.trim()) != null && string2.equalsIgnoreCase("-host")) {
                    this.host = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-port")) {
                    this.port = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-Saprouter_dir")) {
                    this.isSapDirParam = true;
                    this.path = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-alertFile")) {
                    this.path = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-searchPattern")) {
                    this.searchPattern = string3;
                    this.isSearchPattern = true;
                } else {
                    this.params[n] = string2;
                    this.params[++n] = string3;
                }
                this.validationMsgs = new ArrayList();
                ++n;
            }
        }
        this.validate();
        this.isFromManager = bl;
    }

    public void validate() {
        try {
            if (!this.isIPReachable()) {
                this.validationMsgs.add("Host IP/Name$#$Failed");
                this.validationMsgs.add("SAProuter Port$#$NA");
                this.validationMsgs.add("SAProuter Directory$#$NA");
                this.validationMsgs.add("SAProuter Connectivity$#$Host IP/Name  '" + this.host + "' is invalid or unreachable");
            } else if (!this.isSpecificPortReachable(this.port)) {
                this.validationMsgs.add("Host IP/Name$#$OK");
                this.validationMsgs.add("SAProuter Port$#$Failed");
                this.validationMsgs.add("SAProuter Directory$#$NA");
                this.validationMsgs.add("SAProuter Connectivity$#$SAProuter Port  '" + this.port + "' is invalid or unreachable");
            } else if (!this.checkSapRoutDirectory()) {
                String string = (String)this.validationErrorMap.get("SAPRout_Connectivity");
                if (this.isSapRoutDir) {
                    if (string != null && string.equalsIgnoreCase("File not exists") || string != null && string.indexOf("Saprouter directory") > -1) {
                        this.validationMsgs.add("Host IP/Name$#$OK");
                        this.validationMsgs.add("SAProuter Port$#$OK");
                        this.validationMsgs.add("SAProuter Directory$#$Failed");
                        this.validationMsgs.add("SAProuter Connectivity$#$" + string);
                    } else if (string != null) {
                        this.validationMsgs.add("Host IP/Name$#$OK");
                        this.validationMsgs.add("SAProuter Port$#$OK");
                        this.validationMsgs.add("SAProuter Directory$#$Failed");
                        this.validationMsgs.add("SAProuter Connectivity$#$" + string);
                    } else {
                        this.validationMsgs.add("Host IP/Name$#$OK");
                        this.validationMsgs.add("SAProuter Port$#$OK");
                        this.validationMsgs.add("SAProuter Directory$#$NA");
                        this.validationMsgs.add("SAProuter Connectivity$#$Failed");
                    }
                } else if (string != null && string.equalsIgnoreCase("File not exists") || string != null && string.indexOf("dev_rout* trace files") > -1 || string != null && string.indexOf("saprouter* log files") > -1) {
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("SAProuter Port$#$OK");
                    this.validationMsgs.add("SAProuter Alertfile$#$Failed");
                    this.validationMsgs.add("SAProuter Connectivity$#$" + string);
                } else if (string != null) {
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("SAProuter Port$#$OK");
                    this.validationMsgs.add("SAProuter Alertfile$#$Failed");
                    this.validationMsgs.add("SAProuter Connectivity$#$" + string);
                } else {
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("SAProuter Port$#$OK");
                    this.validationMsgs.add("SAProuter Alertfile$#$NA");
                    this.validationMsgs.add("SAProuter Connectivity$#$Failed");
                }
            } else {
                this.validationMsgs.add("Host IP/Name$#$OK");
                this.validationMsgs.add("SAProuter Port$#$OK");
                if (this.isSapRoutDir) {
                    this.validationMsgs.add("SAProuter Directory$#$OK");
                } else if (this.isSapRouter || this.isDevRout) {
                    this.validationMsgs.add("SAProuter Alertfile$#$OK");
                }
                this.validationMsgs.add("SAProuter Connectivity$#$OK");
            }
            if (!this.isFromManager) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String findAndReplaceString(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string2.length();
        int n2 = string.length();
        while ((n2 = string.lastIndexOf(string2, n2 - 1)) > -1) {
            stringBuffer.replace(n2, n2 + n, string3);
        }
        return stringBuffer.toString();
    }

    public boolean checkSapRoutDirectory() {
        try {
            String string = this.path;
            if (string == null && string.equals("")) {
                return false;
            }
            string = this.findAndReplaceString(string, "\\", "/");
            boolean bl = false;
            boolean bl2 = false;
            String string2 = string;
            int n = string.lastIndexOf("/");
            String string3 = string;
            if (n >= 0) {
                string3 = string3.substring(n + 1);
            }
            if (string3 == null || string3.equals("")) {
                return false;
            }
            if (string3.indexOf("*") >= 0) {
                int n2 = string.lastIndexOf(string3);
                if (n2 < 0) {
                    return false;
                }
                string = string.substring(0, n2);
                bl2 = true;
            }
            String string4 = string3;
            boolean bl3 = true;
            boolean bl4 = false;
            String[] stringArray = null;
            File file = null;
            String string5 = null;
            Object var13_17 = null;
            File file2 = new File(string);
            System.out.println("Path " + string);
            if (!file2.exists()) {
                this.validationErrorMap.put("SAPRout_Connectivity", "File not exists");
                System.out.println("[SapRoutValidator] File not exists " + string);
                return false;
            }
            if (!file2.canRead()) {
                if (file2.canRead()) {
                    System.out.println("INFOSapRoutValidator" + file2 + " file permission has been changed and able to read the file now!");
                } else {
                    this.validationErrorMap.put("SAPRout_Connectivity", file2 + " file permission has been changed and not able to read the file now!");
                    System.out.println("ERRORSapRoutValidator" + file2 + " file permission has been changed and not able to read the file now!");
                }
                return false;
            }
            if (file2.isDirectory()) {
                bl = true;
            }
            if (bl) {
                stringArray = file2.list();
                if (stringArray == null) {
                    return false;
                }
                boolean bl5 = false;
                for (int i = 0; i < stringArray.length; ++i) {
                    string5 = !string.endsWith("/") ? string + "/" + stringArray[i] : string + stringArray[i];
                    file = new File(string5);
                    System.out.println("[SapRoutValidator] f1.isDirectory(): " + file.isDirectory() + " f1.getName(): " + file.getName());
                    if (file.isDirectory()) continue;
                    String string6 = file.getName();
                    long l = file.lastModified();
                    bl5 = true;
                    if (this.searchPattern.equals("") && string6.equalsIgnoreCase("saprouter.exe")) {
                        this.isSapRoutDir = true;
                        System.out.println("saprouter.exe is available");
                        return true;
                    }
                    if (this.isSearchPattern && string6.indexOf("dev_rout") > -1) {
                        this.isDevRout = true;
                        System.out.println("dev_rout* trace files are available");
                        return true;
                    }
                    if (this.isSearchPattern || string6.indexOf("saprouter") <= -1 || string6.equalsIgnoreCase("saprouter.exe")) continue;
                    this.isSapRouter = true;
                    System.out.println("saprouter* log files are available");
                    return true;
                }
            } else if (this.isSapDirParam && !this.isSearchPattern) {
                this.isSapRoutDir = true;
                System.out.println("saprouter directory path is wrong (" + this.path + ")");
            } else if (this.isSearchPattern) {
                file = new File(string);
                this.isDevRout = true;
                System.out.println("[SapRoutValidator] f1.isDirectory(): " + file.isDirectory() + " f1.getName(): " + file.getName());
                String string7 = file.getName();
                if (string7.indexOf("dev_rout") > -1) {
                    System.out.println("dev_rout* trace files are available");
                    return true;
                }
            } else if (!this.isSapDirParam && !this.isSearchPattern) {
                file = new File(string);
                this.isSapRouter = true;
                System.out.println("[SapRoutValidator] f1.isDirectory(): " + file.isDirectory() + " f1.getName(): " + file.getName());
                String string8 = file.getName();
                if (string8.indexOf("saprouter") > -1 && !string8.equalsIgnoreCase("saprouter.exe")) {
                    System.out.println("saprouter* log files are available");
                    return true;
                }
            }
        }
        catch (Exception exception) {
            String string;
            String string9 = "";
            string9 = string = this.getStackTraceAsString(exception);
            this.validationErrorMap.put("SAPRout_Connectivity", string9);
            return false;
        }
        if (this.isSapRoutDir) {
            this.validationErrorMap.put("SAPRout_Connectivity", "Saprouter directory (" + this.path + ") doesn't have saprouter.exe file");
        } else if (this.isDevRout) {
            this.validationErrorMap.put("SAPRout_Connectivity", "Saprouter directory (" + this.path + ") doesn't have dev_rout* trace files");
        } else if (this.isSapRouter) {
            this.validationErrorMap.put("SAPRout_Connectivity", "Saprouter directory (" + this.path + ") doesn't have saprouter* log files");
        }
        return false;
    }

    public ArrayList getValidationMsgs() {
        System.out.println("validationMsgs : " + this.validationMsgs);
        return this.validationMsgs;
    }

    public static void main(String[] stringArray) {
        try {
            SapRoutValidator sapRoutValidator = new SapRoutValidator(stringArray, new Boolean(false));
            sapRoutValidator.getValidationMsgs();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

