/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgCrypt;
import com.sap.jmx.remote.JmxConnectionFactory;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.MBeanServerConnection;

public class SapWasValidator
extends EgServerValidator {
    private SapControlBase sapControlBase = null;
    private SapWasGenericTest sapWasGenericTest = null;
    private String connectorport = "";
    private String username = "";
    private String password = "";
    private String wsdl_port = "";
    private String central_wsdl_port = "";
    private String instanceName = "";
    private String dispatcherID = "";
    private String serverIDs = "";
    private boolean isWSDLPortFailed = false;
    private boolean isWSDLorCWSDLPortFailed = false;
    private boolean isFaultCode = false;
    private boolean isSSL = false;
    private boolean isInstanceBased = true;
    private boolean sslFlag = false;
    private boolean isFromManager = false;
    private String wsdlUrl = "";
    private Hashtable validationErrorMap = new Hashtable();
    private ArrayList validationMsgs = null;
    private String[] params = null;
    private boolean isAuthenticatedUser = false;
    private boolean isSSLPort = false;
    private boolean isFoundDispatcherID = false;
    private MBeanServerConnection mbsc = null;

    public SapWasValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        if (stringArray != null && stringArray.length > 0) {
            this.params = new String[stringArray.length * 2];
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = string.substring(0, string.indexOf(":"));
                String string3 = string.substring(string.indexOf(":") + 1);
                if ((string2 = string2.trim()) != null && string2.equalsIgnoreCase("-host")) {
                    this.host = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-wsdl_port")) {
                    this.wsdl_port = string3;
                    this.connectorport = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-port")) {
                    this.port = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-connectorport")) {
                    this.connectorport = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-central_wsdl_port")) {
                    this.central_wsdl_port = string3;
                    this.connectorport = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-username")) {
                    this.username = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-password")) {
                    this.password = EgCrypt.decrypt(string3);
                    if (this.password != null && this.password.length() > 0 && this.password.endsWith("~EG~")) {
                        this.password = this.password.substring(0, this.password.indexOf("~EG~"));
                    }
                } else if (string2 != null && string2.equalsIgnoreCase("-os_username")) {
                    this.username = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-os_password")) {
                    this.password = EgCrypt.decrypt(string3);
                    if (this.password != null && this.password.length() > 0 && this.password.endsWith("~EG~")) {
                        this.password = this.password.substring(0, this.password.indexOf("~EG~"));
                    }
                } else if (string2 != null && string2.equalsIgnoreCase("-SID")) {
                    this.instanceName = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-ssl")) {
                    if (string3.equalsIgnoreCase("true")) {
                        this.sslFlag = true;
                    }
                } else if (string2 != null && string2.equalsIgnoreCase("-DispatcherID")) {
                    System.out.println("sapwasvalidation constructor dispatcherID value: " + string3);
                    this.dispatcherID = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-ServerIDs")) {
                    System.out.println("sapwasvalidation constructor serverIDs value: " + string3);
                    this.serverIDs = string3;
                }
                if (string2 != null && string2.equalsIgnoreCase("-ServerIDs") && !string3.equalsIgnoreCase("default")) {
                    this.params[n] = string2;
                    this.params[++n] = "default";
                } else if (string2 != null && (string2.equalsIgnoreCase("-password") || string2.equalsIgnoreCase("-os_password"))) {
                    this.params[n] = string2;
                    this.params[++n] = this.password;
                } else {
                    System.out.println("sapwasvalidation constructor key: " + string2);
                    System.out.println("sapwasvalidation constructor value: " + string3);
                    this.params[n] = string2;
                    this.params[++n] = string3;
                }
                this.validationMsgs = new ArrayList();
                ++n;
            }
            if (this.instanceName == null || this.instanceName.equalsIgnoreCase("NULL") || this.instanceName.equalsIgnoreCase("none") || this.instanceName.length() == 0) {
                this.isInstanceBased = false;
            }
        }
        System.out.println("sapwasvalidation constructor isInstanceBased: " + this.isInstanceBased);
        this.validate();
        this.isFromManager = bl;
    }

    public void validate() {
        try {
            System.out.println("validate started ");
            System.out.println("validate isInstanceBased: " + this.isInstanceBased);
            if (this.isInstanceBased) {
                if (!this.isIPReachable()) {
                    this.validationMsgs.add("SAP WAS Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$Host IP/Name  '" + this.host + "' is invalid or unreachable");
                    this.validationMsgs.add("Connector Port$#$NA");
                    this.validationMsgs.add("Instance Name$#$NA");
                } else if (!this.checkSapWasJMXConnectivity()) {
                    System.out.println("validate isInstanceBased else if ");
                    String string = (String)this.validationErrorMap.get("SAPWas_Connectivity");
                    System.out.println("validate sapWasConnectivityErrorMsg: " + string);
                    if (string != null && string.indexOf("Cannot open connection") > -1) {
                        this.validationMsgs.add("Host IP/Name or Connector Port$#$" + string);
                        this.validationMsgs.add("Username/Password$#$NA");
                        this.validationMsgs.add("SID$#$NA");
                        this.validationMsgs.add("SAP WAS Connectivity$#$Failed");
                    } else if (string != null && string.indexOf("Cannot authenticate the user") > -1) {
                        this.validationMsgs.add("Host IP/Name $#$OK");
                        this.validationMsgs.add("Connector Port$#$OK");
                        this.validationMsgs.add("Username/Password$#$" + string);
                        this.validationMsgs.add("SID$#$NA");
                        this.validationMsgs.add("SAP WAS Connectivity$#$Failed");
                    } else if (string != null && string.indexOf("Connector Port is down") > -1) {
                        this.validationMsgs.add("Host IP/Name$#$OK");
                        this.validationMsgs.add("Connector Port$#$" + string);
                        this.validationMsgs.add("Username/Password$#$NA");
                        this.validationMsgs.add("SID$#$NA");
                        this.validationMsgs.add("SAP WAS Connectivity$#$Failed");
                    } else if (string != null && string.indexOf("missing for JMX Connection") > -1) {
                        this.validationMsgs.add("Host IP/Name$#$OK");
                        this.validationMsgs.add("Connector Port$#$NA");
                        this.validationMsgs.add("Username/Password$#$NA");
                        this.validationMsgs.add("SID$#$NA");
                        this.validationMsgs.add("SAP WAS Connectivity$#$" + string);
                    } else {
                        this.validationMsgs.add("Host IP/Name$#$OK");
                        this.validationMsgs.add("Connector Port$#$OK");
                        this.validationMsgs.add("Username/Password$#$NA");
                        this.validationMsgs.add("SID$#$NA");
                        this.validationMsgs.add("SAP WAS Connectivity$#$" + string);
                    }
                } else {
                    System.out.println("validate isInstanceBased else ");
                    if (!this.isSapWasInstanceReachable()) {
                        System.out.println("validate isInstanceBased instance not reachable");
                        String string = (String)this.validationErrorMap.get("SAPWas_Instance");
                        System.out.println("validate isInstanceBased sapWasInstanceErrors:" + string);
                        this.validationMsgs.add("Host IP/Name$#$OK");
                        this.validationMsgs.add("Connector Port$#$OK");
                        this.validationMsgs.add("Username/Password$#$OK");
                        if (string != null && string.indexOf("SAP WAS Instance") > -1) {
                            this.validationMsgs.add("SID$#$" + string);
                        } else if (string != null && string.indexOf("Dispatcher ID") > -1) {
                            this.validationMsgs.add("SID$#$OK");
                            this.validationMsgs.add("Dispatcher ID$#$" + string);
                            this.validationMsgs.add("Server IDS$#$NA");
                        } else {
                            this.validationMsgs.add("SID$#$OK");
                            if (this.isFoundDispatcherID) {
                                this.validationMsgs.add("Dispatcher ID$#$OK");
                            }
                            this.validationMsgs.add("Server IDS$#$" + string);
                        }
                        this.validationMsgs.add("SAP WAS Connectivity$#$OK");
                    } else {
                        this.validationMsgs.add("Host IP/Name$#$OK");
                        this.validationMsgs.add("Connector Port$#$OK");
                        this.validationMsgs.add("Username/Password$#$OK");
                        this.validationMsgs.add("SID$#$OK");
                        if (this.isFoundDispatcherID) {
                            this.validationMsgs.add("Dispatcher ID$#$OK");
                        }
                        if (!this.serverIDs.equalsIgnoreCase("default")) {
                            this.validationMsgs.add("Server IDS$#$OK");
                        }
                        this.validationMsgs.add("SAP WAS Connectivity$#$OK");
                    }
                }
            } else {
                System.out.println("validate else ");
                if (!this.isIPReachable()) {
                    this.validationMsgs.add("Host IP/Name$#$Host IP/Name  '" + this.host + "' is invalid or unreachable");
                    if (this.wsdl_port != null && this.wsdl_port.trim().length() > 0) {
                        this.validationMsgs.add("WSDL Port$#$NA");
                    } else {
                        this.validationMsgs.add("Central WSDL Port$#$NA");
                    }
                    this.validationMsgs.add("OS Username/Password$#$NA");
                    this.validationMsgs.add("SAP WAS Connectivity$#$Failed");
                } else if (!this.checkSAPWasWSDLConnectivity()) {
                    String string = (String)this.validationErrorMap.get("SAPWas_Connectivity");
                    System.out.println("validate WSDL_ConnectivityErrMsg: " + string);
                    System.out.println("validate isWSDLorCWSDLPortFailed: " + this.isWSDLorCWSDLPortFailed);
                    System.out.println("validate isFaultCode: " + this.isFaultCode);
                    System.out.println("validate isWSDLPortFailed: " + this.isWSDLPortFailed);
                    if (string == null) {
                        string = "Something went wrong.";
                    }
                    if (this.isFaultCode) {
                        this.validationMsgs.add("Host IP/Name$#$OK");
                        if (this.wsdl_port != null && this.wsdl_port.length() > 0) {
                            this.validationMsgs.add("WSDL Port$#$NA");
                        } else {
                            this.validationMsgs.add("Central WSDL Port$#$NA");
                        }
                        this.validationMsgs.add("OS Username/Password$#$" + string);
                        this.validationMsgs.add("SAP WAS Connectivity$#$" + string);
                    } else if (this.isWSDLorCWSDLPortFailed) {
                        this.validationMsgs.add("Host IP/Name$#$OK");
                        if (this.wsdl_port != null && this.wsdl_port.length() > 0) {
                            this.validationMsgs.add("WSDL Port$#$Failed");
                        } else {
                            this.validationMsgs.add("Central WSDL Port$#$Failed");
                        }
                        this.validationMsgs.add("OS Username/Password$#$OK");
                        this.validationMsgs.add("SAP WAS Connectivity$#$" + string);
                    } else if (this.isWSDLPortFailed) {
                        string = this.wsdl_port != null && this.wsdl_port.length() > 0 ? "SAP System is down" : "SAP System is down";
                        this.validationMsgs.add("Host IP/Name$#$OK");
                        if (this.wsdl_port != null && this.wsdl_port.length() > 0) {
                            this.validationMsgs.add("WSDL Port$#$OK");
                        } else {
                            this.validationMsgs.add("Central WSDL Port$#$OK");
                        }
                        this.validationMsgs.add("SAP System up$#$Failed");
                        this.validationMsgs.add("OS Username/Password$#$NA");
                        this.validationMsgs.add("SAP WAS Connectivity$#$" + string);
                    } else if (string != null) {
                        this.validationMsgs.add("Host IP/Name$#$OK");
                        this.validationMsgs.add("OS Username/Password$#$NA");
                        this.validationMsgs.add("SAP WAS Connectivity$#$" + string);
                    }
                } else {
                    System.out.println("validation no error for wsdl ");
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    if (this.wsdl_port != null && this.wsdl_port.trim().length() > 0) {
                        this.validationMsgs.add("WSDL Port$#$OK");
                    } else {
                        this.validationMsgs.add("Central WSDL Port$#$OK");
                    }
                    this.validationMsgs.add("OS Username/Password$#$OK");
                    this.validationMsgs.add("SAP WAS Connectivity$#$OK");
                }
            }
            if (!this.isFromManager) {
                return;
            }
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            System.out.println("validate errMsg: " + string);
        }
    }

    public boolean checkSAPWasWSDLConnectivity() {
        String string = "http://";
        String string2 = "";
        string2 = this.wsdl_port != null && this.wsdl_port.length() > 0 ? string + this.host + ":" + this.wsdl_port + "/?wsdl" : string + this.host + ":" + this.central_wsdl_port + "/?wsdl";
        boolean bl = this.getWSDLConnection(string2);
        System.out.println("checkSapAbapWSDLConnectivity bfr ssl ........status: " + bl);
        if (this.isSSL) {
            System.out.println("checkSapAbapWSDLConnectivity ........isSSL: " + this.isSSL);
            if (this.isSSLPort) {
                string = "https://";
                string2 = this.wsdl_port != null && this.wsdl_port.length() > 0 ? string + this.host + ":" + this.wsdl_port + "/?wsdl" : string + this.host + ":" + this.central_wsdl_port + "/?wsdl";
                bl = this.getWSDLConnection(string2);
            } else {
                String string3 = "";
                string3 = this.wsdl_port != null && this.wsdl_port.length() > 0 ? "WSDL Port is down or unavailable" : "Central WSDL Port is down or unavailable";
                this.validationErrorMap.put("SAPWas_Connectivity", string3);
                return false;
            }
        }
        return bl;
    }

    public boolean getWSDLConnection(String string) {
        try {
            this.sapControlBase = new SapControlBase(this.params);
            String string2 = "";
            string2 = this.wsdl_port != null && this.wsdl_port.length() > 0 ? "J2EEGetApplicationAliasList" : "EnqGetLockTable";
            System.out.println("wsdl Url 1==> " + string);
            String string3 = this.sapControlBase.getSoapRequest(string2);
            String string4 = SapControlBase.invokeOperation(string3, string2, string, this.username, this.password);
            ArrayList arrayList = new ArrayList();
            if (string4 == null || string4.trim().length() == 0) {
                System.out.println("Cannot get soap response from invokeOperation()");
                return false;
            }
            if (string4 != null) {
                System.out.println("getWSDLConnection soapResponse: " + string4);
                String string5 = "";
                if (string4.indexOf("faultcode") >= 0 || string4.indexOf("faultstring") >= 0) {
                    if (string4.indexOf("Invalid Credentials") > 0) {
                        string5 = "Invalid Username/Password; logon denied";
                        this.isFaultCode = true;
                    } else if (string4.indexOf("EnqMon_GetTable failed") > 0 || string4.indexOf("JsfOpenShm failed: object not found") > 0) {
                        string5 = this.wsdl_port != null && this.wsdl_port.length() > 0 ? "Central WSDL port value configured for WSDL port" : "WSDL port value configured for Central WSDL port";
                        this.isWSDLorCWSDLPortFailed = true;
                    } else {
                        string5 = this.wsdl_port != null && this.wsdl_port.length() > 0 ? "WSDL Port is down or unavailable" : "Central WSDL Port is down or unavailable";
                    }
                    this.validationErrorMap.put("SAPWas_Connectivity", string5);
                    return false;
                }
                if (string4.indexOf("ERROR in Invoke Operation >") > -1) {
                    if (!this.isSSLPort && this.isSSL && this.isSpecificPortReachable(this.connectorport)) {
                        this.isSSLPort = true;
                    } else {
                        if (this.wsdl_port != null && this.wsdl_port.length() > 0) {
                            this.isWSDLPortFailed = true;
                            string5 = "WSDL Port is down or unavailable";
                        } else {
                            this.isWSDLPortFailed = true;
                            string5 = "Central WSDL Port is down or unavailable";
                        }
                        this.validationErrorMap.put("SAPWas_Connectivity", string5);
                    }
                    return false;
                }
                return true;
            }
        }
        catch (Exception exception) {
            String string6 = "";
            String string7 = exception.getMessage();
            System.out.println("getWSDLConnection errMsg: " + string7);
            string6 = "SAP Connectivity failue due to " + string7;
            this.validationErrorMap.put("SAPWas_Connectivity", string6);
            return false;
        }
        return false;
    }

    public boolean checkSapWasJMXConnectivity() {
        try {
            System.out.println("checkSapWasJMXConnectivity method started: ");
            Properties properties = new Properties();
            properties.setProperty("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
            properties.setProperty("java.naming.security.principal", this.username);
            properties.setProperty("java.naming.security.credentials", this.password);
            properties.setProperty("java.naming.provider.url", this.host + ":" + this.connectorport);
            this.mbsc = JmxConnectionFactory.getMBeanServerConnection((String)"service:jmx:com.sap.engine.services.jmx.connector.p4:", (Hashtable)properties);
            if (this.mbsc != null) {
                return true;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String string = noClassDefFoundError.getMessage();
            System.out.println("checkSapWasJMXConnectivity errMsg: " + string);
            String string2 = "SAP WAS supported jars are missing for JMX Connection";
            if (string.indexOf("JmxConnectionFactory") > -1) {
                string2 = "SAP WAS supported jar file 'com_sap_pj_jmx.jar' is missing for JMX Connection";
            } else if (string.indexOf("SAPIOException") > -1) {
                string2 = "SAP WAS supported jar file 'exception.jar' is missing for JMX Connection";
            } else if (string.indexOf("InitialContextFactoryImpl") > -1) {
                string2 = "SAP WAS supported jar file 'logging.jar' is missing for JMX Connection";
            }
            this.validationErrorMap.put("SAPWas_Connectivity", string2);
            return false;
        }
        catch (Exception exception) {
            String string = "";
            String string3 = this.getStackTraceAsString(exception);
            System.out.println("checkSapWasJMXConnectivity errMsg exception: " + string3);
            String string4 = "Caused by: com.sap.engine.services.rmi_p4.P4IOException: ";
            String string5 = "Caused by: com.sap.engine.services.security.exceptions.BaseLoginException: ";
            if (string3.indexOf(string4) > -1) {
                int n = string3.indexOf(string4) + string4.length();
                string = string3.substring(n);
                string = string.substring(0, string.indexOf("at ")).trim();
            } else if (string3.indexOf(string5) > -1) {
                int n = string3.indexOf(string5) + string5.length();
                string = string3.substring(n);
                string = string.substring(0, string.indexOf("at ")).trim();
            } else if (string3.indexOf("DestinationException") > 0) {
                string = "Connector Port is down or unavailable";
            } else if (string3.indexOf("NoPermissionException") > 0) {
                string = "Invalid Username/Password logon denied";
            } else if (string3.indexOf("ConnectorFactory") > -1) {
                string = "SAP WAS supported jar file 'sapj2eeclient.jar' is missing for JMX Connection";
            }
            System.out.println("checkSapWasJMXConnectivity validationErrorMsg: " + string);
            this.validationErrorMap.put("SAPWas_Connectivity", string);
            return false;
        }
        return false;
    }

    public boolean isSapWasInstanceReachable() {
        block18: {
            try {
                System.out.println("isSapWasInstanceReachable started");
                ArrayList<String> arrayList = new ArrayList<String>();
                boolean bl = false;
                String string = "";
                this.sapWasGenericTest = new SapWasGenericTest(this.params);
                this.sapWasGenericTest.mbsc = this.mbsc;
                String string2 = this.sapWasGenericTest.populateClusterIDs(this.dispatcherID, "default");
                System.out.println("isSapWasInstanceReachable clusIDs:" + string2);
                if (string2 != null && string2.length() > 0) {
                    Object object;
                    Object object2;
                    String string3 = "";
                    string = string2.substring(0, string2.indexOf("|"));
                    string2 = string2.substring(string2.indexOf("|") + 1);
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                    System.out.println("isSapWasInstanceReachable clusIDs serverIDList:" + stringTokenizer);
                    if (!this.dispatcherID.equalsIgnoreCase("none") && !string.equalsIgnoreCase("none")) {
                        System.out.println("isSapWasInstanceReachable dispID is not none");
                        this.isFoundDispatcherID = true;
                        if (!string.equalsIgnoreCase(this.dispatcherID)) {
                            System.out.println("isSapWasInstanceReachable Invalid Dispatcher ID -  dispID : " + string + ",dispatcherID:" + this.dispatcherID);
                            String string4 = "Invalid Dispatcher ID: " + this.dispatcherID;
                            this.validationErrorMap.put("SAPWas_Instance", string4);
                            return false;
                        }
                    }
                    while (stringTokenizer.hasMoreTokens()) {
                        object2 = stringTokenizer.nextToken();
                        object = ((String)object2).substring(((String)object2).indexOf(":") + 1);
                        arrayList.add((String)object);
                    }
                    System.out.println("isSapWasInstanceReachable serverIDsArr: " + arrayList);
                    if (this.serverIDs.equalsIgnoreCase("default")) {
                        System.out.println("isSapWasInstanceReachable serverIDs default");
                        bl = true;
                    } else {
                        System.out.println("isSapWasInstanceReachable serverIDs not default");
                        System.out.println("isSapWasInstanceReachable serverIDs list :" + this.serverIDs);
                        object2 = new ArrayList();
                        if (this.serverIDs.indexOf("$") > -1) {
                            System.out.println("isSapWasInstanceReachable serverIDs contains $");
                            object = new StringTokenizer(this.serverIDs, "$");
                            while (((StringTokenizer)object).hasMoreTokens()) {
                                String string5 = ((StringTokenizer)object).nextToken();
                                System.out.println("isSapWasInstanceReachable serverIDs tmpServerID: " + string5);
                                String string6 = string5;
                                if (string5.indexOf(":") > -1) {
                                    string6 = string5.substring(string5.indexOf(":") + 1);
                                }
                                System.out.println("isSapWasInstanceReachable serverIDs serverID " + string6);
                                if (arrayList.contains(string6) || ((ArrayList)object2).contains(string5) || string5.equalsIgnoreCase("default")) continue;
                                if (string3.length() > 0) {
                                    string3 = string3 + ",";
                                }
                                System.out.println("isSapWasInstanceReachable serverIDs invalidServerIDs: " + string3);
                                string3 = string3 + string5;
                                ((ArrayList)object2).add(string5);
                            }
                            if (string3.length() == 0) {
                                bl = true;
                            }
                            System.out.println("isSapWasInstanceReachable serverIDs invalidServerIDs list: " + string3);
                        } else {
                            System.out.println("isSapWasInstanceReachable serverIDs else");
                            object = this.serverIDs;
                            if (this.serverIDs.indexOf(":") > -1) {
                                object = this.serverIDs.substring(this.serverIDs.indexOf(":") + 1);
                            }
                            System.out.println("isSapWasInstanceReachable serverIDs: " + (String)object);
                            if (arrayList.contains(object)) {
                                System.out.println("isSapWasInstanceReachable isServerExists true");
                                bl = true;
                            } else {
                                System.out.println("isSapWasInstanceReachable isServerExists false");
                                bl = false;
                                string3 = string3 + this.serverIDs;
                            }
                        }
                    }
                    System.out.println("isSapWasInstanceReachable isServerExists: " + bl);
                    if (!bl) {
                        object2 = "Invalid Server IDS: " + string3;
                        this.validationErrorMap.put("SAPWas_Instance", object2);
                        return false;
                    }
                }
            }
            catch (Exception exception) {
                String string = exception.getMessage();
                System.out.println("isSapWasInstanceReachable errMsg :" + string);
                if (this.sapWasGenericTest != null && string != null && (string == null || string.indexOf("InstanceNotFoundException") <= 0)) break block18;
                String string7 = "SAP WAS Instance '" + this.instanceName + "' is not running or unavailable";
                this.validationErrorMap.put("SAPWas_Instance", string7);
                return false;
            }
        }
        return true;
    }

    public ArrayList getValidationMsgs() {
        System.out.println("validationMsgs : " + this.validationMsgs);
        return this.validationMsgs;
    }

    public static void main(String[] stringArray) {
        try {
            String[] stringArray2 = new String[]{"-host:172.16.8.113", "-port:50000", "-username:j2ee_admin", "-password:eGsolman123", "-connectorport:50002", "-SID:SMJ", "-DispatcherID:none", "-ServerIDs:default", "-rptName:SAP_WAS", "-agentless:y", "-aluser:None", "-alpassword:CCF1978907AD00AB972C9B9138C9744A", "-almode:Perfmon", "-os:win7", "-sshPort:22", "-alencrypt:None", "-alkeyfile:None", "-egMeasPeriod:300"};
            stringArray = stringArray2;
            SapWasValidator sapWasValidator = new SapWasValidator(stringArray, new Boolean(false));
            sapWasValidator.getValidationMsgs();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

