/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

public class SetupSSLApache {
    int sslEngineLineNo;
    int clearModuleListLineNo;
    int loadModuleLineNo;
    int addModuleLineNo;
    int lastAddModuleNo;
    int lastLoadModuleNo;
    String httpdFile;
    String errorMsg = "TRUE";
    boolean writeFlag = false;
    BufferedReader reader = null;
    BufferedWriter writer = null;
    FileInputStream readFile = null;
    FileOutputStream writeFile = null;
    Vector lines = new Vector(10, 2);
    boolean sslEnabled = false;

    public static void main(String[] stringArray) {
        if (stringArray.length <= 3) {
            System.out.println("insufficient arguments ");
            System.out.println(" Usage :- java SetupSSLApache -serverpath <apache server_path > ");
            return;
        }
        if (!stringArray[0].equals("-serverpath")) {
            System.out.println(" Usage :- java SetupSSLApache -serverpath <apache server_path > -sslenabled < y/n > ");
            return;
        }
        if (!stringArray[2].equals("-sslenabled")) {
            System.out.println(" Usage :- java SetupSSLApache -serverpath <apache server_path > -sslenabled < y/n > ");
            return;
        }
        File file = new File(stringArray[1]);
        if (!file.exists()) {
            stringArray[1] = " file Not exist ...";
            System.out.println(" file Not exist ...");
            return;
        }
        SetupSSLApache setupSSLApache = new SetupSSLApache(stringArray[1], stringArray[3]);
        setupSSLApache.readConfigFile();
        setupSSLApache.checkForUpdate();
        if (setupSSLApache.writeFlag) {
            setupSSLApache.updateConfigFile();
        }
        System.out.println(setupSSLApache.errorMsg);
    }

    public SetupSSLApache(String string, String string2) {
        this.httpdFile = string;
        this.sslEnabled = string2.equals("y");
    }

    void checkForUpdate() {
        String string;
        int n = this.lines.size();
        this.loadModuleLineNo = -1;
        this.addModuleLineNo = -1;
        this.clearModuleListLineNo = -1;
        this.sslEngineLineNo = -1;
        this.lastAddModuleNo = -1;
        this.lastLoadModuleNo = -1;
        for (int i = 0; i < n && (string = (String)this.lines.get(i)) != null; ++i) {
            if ((string = string.trim()).length() <= 0 || string.startsWith("#")) continue;
            if ((string = string.toUpperCase()).indexOf("LOADMODULE") != -1) {
                this.lastLoadModuleNo = i;
            }
            if (string.indexOf("ADDMODULE") != -1) {
                this.lastAddModuleNo = i;
            }
            if (string.indexOf("EGURKHA_MODULE") != -1) {
                this.loadModuleLineNo = i;
            }
            if (string.indexOf("MOD_EGURKHA.C") == -1) continue;
            this.addModuleLineNo = i;
        }
        if (this.loadModuleLineNo == -1) {
            this.writeFlag = true;
            if (this.lastLoadModuleNo != -1) {
                if (this.sslEnabled) {
                    this.lines.add(this.lastLoadModuleNo + 1, "LoadModule egurkha_module     libexec/mod_ssl_egurkha.so");
                } else {
                    this.lines.add(this.lastLoadModuleNo + 1, "LoadModule egurkha_module     libexec/mod_egurkha.so");
                }
                if (this.lastAddModuleNo > this.lastLoadModuleNo) {
                    ++this.lastAddModuleNo;
                }
            } else {
                this.lines.add("LoadModule egurkha_module     libexec/mod_egurkha.so");
            }
        }
        if (this.addModuleLineNo == -1) {
            this.writeFlag = true;
            if (this.lastAddModuleNo != -1 && this.lastLoadModuleNo != -1) {
                this.lines.add(this.lastAddModuleNo + 1, "AddModule mod_egurkha.c");
            } else {
                this.lines.add("AddModule mod_egurkha.c");
            }
        }
    }

    void readConfigFile() {
        try {
            this.reader = new BufferedReader(new FileReader(this.httpdFile));
        }
        catch (IOException iOException) {
            this.errorMsg = "Error in opening the file " + this.httpdFile;
        }
        try {
            String string;
            while ((string = this.reader.readLine()) != null && string != null) {
                this.lines.add(string);
            }
        }
        catch (IOException iOException) {
            this.errorMsg = "Error in reading the file " + this.httpdFile;
        }
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            this.errorMsg = "Error when closing  the file " + this.httpdFile + " data may not be read properly";
        }
    }

    void updateConfigFile() {
        try {
            this.writer = new BufferedWriter(new FileWriter(this.httpdFile));
        }
        catch (IOException iOException) {
            this.errorMsg = this.httpdFile + " File cannot " + " opened for eGurkha Configuration ";
            return;
        }
        int n = this.lines.size();
        for (int i = 0; i < n; ++i) {
            try {
                String string = (String)this.lines.get(i);
                if (string == null) break;
                this.writer.write(string, 0, string.length());
                this.writer.newLine();
                continue;
            }
            catch (IOException iOException) {
                System.out.println("Error when eGurkha write in the file" + this.httpdFile);
            }
        }
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            this.errorMsg = "Error when closing  the file " + this.httpdFile + " data may not be written properly";
        }
    }
}

