/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

class SiebelBase
extends GenericTest {
    private JMXServiceURL jmxService = null;
    private JMXConnector jmxConnector = null;
    private MBeanServerConnection beanServerConn = null;
    protected String urlStr = "";
    protected String userName = "";
    protected String password = "";
    protected String jvmPort = this.getValueForParam("Jmx_Remote_Port");
    protected String jndiName = "";
    public boolean debug = false;

    public SiebelBase(String[] stringArray) {
        super(stringArray);
        String string;
        if (this.jvmPort == null || "None".equalsIgnoreCase(this.jvmPort)) {
            this.urlStr = this.targetHost;
        } else if (this.jvmPort != null) {
            this.urlStr = this.targetHost + ":" + this.jvmPort;
        }
        this.jndiName = this.getValueForParam("Jndi_Name");
        if (this.jndiName == null || "None".equalsIgnoreCase(this.jndiName) || "Null".equalsIgnoreCase(this.jndiName)) {
            this.jndiName = "jmx/siebel/agent";
        }
        this.userName = this.getValueForParam("siebel_agent_user");
        if (this.userName == null) {
            this.userName = "none";
        }
        this.password = this.getValueForParam("siebel_agent_password");
        if (this.password == null) {
            this.password = "none";
        }
        if ((string = this.getValueForParam("debug")) == null) {
            this.debug = false;
        }
        if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"))) {
            this.debug = true;
        }
    }

    protected boolean connectToJVM() {
        boolean bl = true;
        String string = "service:jmx:rmi:///jndi/rmi://" + this.urlStr + "/" + this.jndiName;
        try {
            this.jmxService = new JMXServiceURL(string);
            HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
            String[] stringArray = new String[]{this.userName, this.password};
            hashMap.put("jmx.remote.credentials", stringArray);
            this.jmxConnector = JMXConnectorFactory.connect(this.jmxService, hashMap);
            this.beanServerConn = this.jmxConnector.getMBeanServerConnection();
            if (this.beanServerConn == null) {
                this.logToErrorFile("SiebelBase", "Connection to JVM is not established for Host", "componentName::" + this.reportingName);
                return false;
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("SiebelBase", "Connection to JVM is not established for Host", "componentName::" + this.reportingName);
            this.closeJVMConn();
            return false;
        }
        return bl;
    }

    public void closeJVMConn() {
        try {
            if (this.jmxConnector != null) {
                this.jmxConnector.close();
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public Hashtable getCompStatus() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        try {
            ObjectName objectName = new ObjectName("Siebel:activated=true,name=ServerAdmin,kind=ServerAdmin");
            TabularData tabularData = (TabularData)this.beanServerConn.invoke(objectName, "listComponents", new Object[0], new String[0]);
            Set<?> set = tabularData.keySet();
            Iterator<?> iterator = set.iterator();
            while (iterator.hasNext()) {
                Object object;
                Object obj = iterator.next();
                Object[] objectArray = ((List)obj).toArray();
                CompositeData compositeData = tabularData.get(objectArray);
                CompositeType compositeType = compositeData.getCompositeType();
                Set<String> set2 = compositeType.keySet();
                if (set2 == null || set2.size() <= 0) continue;
                Iterator<String> iterator2 = set2.iterator();
                String string = "";
                String string2 = "";
                String string3 = "";
                String string4 = "";
                while (iterator2.hasNext()) {
                    object = iterator2.next();
                    Object object2 = compositeData.get((String)object);
                    if (((String)object).equals("CC_NAME")) {
                        string = (String)object2;
                        continue;
                    }
                    if (((String)object).equals("CP_DISP_RUN_STATE")) {
                        string2 = (String)object2;
                        continue;
                    }
                    if (((String)object).equals("CP_MAX_MTS_PROCS")) {
                        string3 = (String)object2;
                        continue;
                    }
                    if (!((String)object).equals("CP_ACTV_MTS_PROCS")) continue;
                    string4 = (String)object2;
                }
                string3 = string3 != null && string3.length() > 0 ? string3 : "-5.0";
                string4 = string4 != null && string4.length() > 0 ? string4 : "-5.0";
                object = new ArrayList();
                ((ArrayList)object).add(string2);
                ((ArrayList)object).add(string3);
                ((ArrayList)object).add(string4);
                hashtable.put(string, object);
            }
            return hashtable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new Hashtable();
        }
    }

    public double stringtoDouble(String string) {
        double d = -5.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d = -5.0;
        }
        return d;
    }

    public Hashtable getTaskDetails() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        try {
            ObjectName objectName = new ObjectName("Siebel:activated=true,name=ServerAdmin,kind=ServerAdmin");
            TabularData tabularData = (TabularData)this.beanServerConn.invoke(objectName, "listTasks", new Object[0], new String[0]);
            Set<?> set = tabularData.keySet();
            Iterator<?> iterator = set.iterator();
            while (iterator.hasNext()) {
                Object object;
                Object obj = iterator.next();
                Object[] objectArray = ((List)obj).toArray();
                CompositeData compositeData = tabularData.get(objectArray);
                CompositeType compositeType = compositeData.getCompositeType();
                Set<String> set2 = compositeType.keySet();
                if (set2 == null || set2.size() <= 0) continue;
                Iterator<String> iterator2 = set2.iterator();
                String string = "";
                String string2 = "";
                String string3 = "";
                String string4 = "";
                String string5 = "";
                String string6 = "";
                String string7 = "";
                while (iterator2.hasNext()) {
                    object = iterator2.next();
                    Object object2 = compositeData.get((String)object);
                    if (((String)object).equals("CC_NAME")) {
                        string = (String)object2;
                        continue;
                    }
                    if (((String)object).equals("TK_DISP_RUNSTATE")) {
                        string2 = (String)object2;
                        continue;
                    }
                    if (((String)object).equals("CC_RUNMODE")) {
                        string3 = (String)object2;
                        continue;
                    }
                    if (((String)object).equals("TK_TASKID")) {
                        string4 = (String)object2;
                        continue;
                    }
                    if (((String)object).equals("TK_START_TIME")) {
                        string5 = (String)object2;
                        continue;
                    }
                    if (((String)object).equals("TK_STATUS")) {
                        string7 = (String)object2;
                        string7 = string7 != null && string7.length() > 0 ? string7 : "-";
                        continue;
                    }
                    if (!((String)object).equals("TK_END_TIME")) continue;
                    string6 = (String)object2;
                }
                object = new ArrayList();
                ((ArrayList)object).add(string2);
                ((ArrayList)object).add(string3);
                ((ArrayList)object).add(string4);
                ((ArrayList)object).add(string5);
                ((ArrayList)object).add(string7);
                ((ArrayList)object).add(string6);
                hashtable.put(string + "##" + string4, object);
            }
            return hashtable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new Hashtable();
        }
    }

    public Hashtable getNotify() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            ObjectName objectName = new ObjectName("Siebel:activated=true,name=ServerAdmin,kind=ServerAdmin");
            TabularData tabularData = (TabularData)this.beanServerConn.invoke(objectName, "listStateValuesForComponent", new Object[]{new String("AdminNotify")}, new String[]{"java.lang.String"});
            Set<?> set = tabularData.keySet();
            Iterator<?> iterator = set.iterator();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                Object[] objectArray = ((List)obj).toArray();
                CompositeData compositeData = tabularData.get(objectArray);
                CompositeType compositeType = compositeData.getCompositeType();
                Set<String> set2 = compositeType.keySet();
                if (set2 == null || set2.size() <= 0) continue;
                Iterator<String> iterator2 = set2.iterator();
                String string = "";
                String string2 = "";
                while (iterator2.hasNext()) {
                    String string3 = iterator2.next();
                    if (string3.equals("CURR_VAL") || string3.equals("STATEVAL_NAME")) {
                        Object object = compositeData.get(string3);
                        if (string3.equals("STATEVAL_NAME")) {
                            string = (String)object;
                        } else {
                            string2 = (String)object;
                        }
                    }
                    if (string.length() <= 0 || string2.length() <= 0) continue;
                    hashtable.put(string, string2);
                }
            }
            return hashtable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new Hashtable();
        }
    }

    public Hashtable getStatistics() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            ObjectName objectName = new ObjectName("Siebel:activated=true,name=ServerAdmin,kind=ServerAdmin");
            TabularData tabularData = (TabularData)this.beanServerConn.invoke(objectName, "listStatistics", new Object[0], new String[0]);
            Set<?> set = tabularData.keySet();
            Iterator<?> iterator = set.iterator();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                Object[] objectArray = ((List)obj).toArray();
                CompositeData compositeData = tabularData.get(objectArray);
                CompositeType compositeType = compositeData.getCompositeType();
                Set<String> set2 = compositeType.keySet();
                if (set2 == null || set2.size() <= 0) continue;
                Iterator<String> iterator2 = set2.iterator();
                String string = "";
                String string2 = "";
                while (iterator2.hasNext()) {
                    String string3 = iterator2.next();
                    if (string3.equals("CURR_VAL") || string3.equals("STAT_NAME")) {
                        Object object = compositeData.get(string3);
                        if (string3.equals("STAT_NAME")) {
                            string = (String)object;
                        } else {
                            string2 = (String)object;
                        }
                    }
                    if (string.length() <= 0 || string2.length() <= 0) continue;
                    hashtable.put(string, string2);
                }
            }
            return hashtable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new Hashtable();
        }
    }

    public static void main(String[] stringArray) {
        SiebelBase siebelBase = new SiebelBase(stringArray);
        boolean bl = siebelBase.connectToJVM();
        if (bl) {
            Hashtable hashtable = siebelBase.getCompStatus();
            System.out.println("compstatus========>" + hashtable);
            siebelBase.closeJVMConn();
        }
    }
}

