/*
 * Decompiled with CFR 0.152.
 */
import com.tmax.tibero.jdbc.ext.TbDataSource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;

public class TibTransTest
extends GenericTest {
    private String tibSid = "";
    private String username = "";
    private String password = "";
    private double prevRollbacks = -5.0;
    private double prevCommits = -5.0;
    private String transQuery = "";
    private boolean isFirstTime = true;

    public TibTransTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.username = this.getValueForParam("username");
        this.password = this.getValueForParam("password");
        this.tibSid = this.getValueForParam("tibero_sid");
        if (this.username == null || this.username.equalsIgnoreCase("NULL") || this.username.equalsIgnoreCase("none")) {
            this.username = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        if (this.tibSid == null || this.tibSid.equalsIgnoreCase("NULL") || this.tibSid.equalsIgnoreCase("none")) {
            this.tibSid = "";
        }
        this.transQuery = "SELECT NAME, VALUE FROM V$SYSSTAT WHERE NAME IN ('the number of user commits performed','user rollbacks')";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        block16: {
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            try {
                String string = "jdbc:tibero:thin:@";
                String string2 = string + "" + this.targetHost + ":" + this.portNo + ":" + this.tibSid;
                System.out.println("URL::" + string2);
                TbDataSource tbDataSource = new TbDataSource();
                tbDataSource.setURL(string2);
                tbDataSource.setUser(this.username);
                tbDataSource.setPassword(this.password);
                System.out.println("Bef Connection");
                try {
                    connection = tbDataSource.getConnection();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (connection == null) {
                    this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.tibSid);
                    this.closeRs(resultSet);
                    this.closeStmt(statement);
                    this.closeConn(connection);
                    return;
                }
                try {
                    statement = connection.createStatement();
                }
                catch (Exception exception) {
                    this.logToErrorFile("Error :", this.entity + " Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.tibSid, exception.toString());
                    exception.printStackTrace();
                    this.closeConn(connection);
                    this.closeRs(resultSet);
                    this.closeStmt(statement);
                    this.closeConn(connection);
                    return;
                }
                resultSet = statement.executeQuery(this.transQuery);
                while (resultSet.next()) {
                    String string3 = resultSet.getString(1);
                    if (string3.equalsIgnoreCase("the number of user commits performed")) {
                        d = resultSet.getDouble(2);
                        continue;
                    }
                    if (!string3.equalsIgnoreCase("user rollbacks")) continue;
                    d2 = resultSet.getDouble(2);
                }
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
                if (this.isFirstTime) {
                    d3 = -5.0;
                    d4 = -5.0;
                    d5 = -5.0;
                    this.isFirstTime = false;
                } else {
                    double d6;
                    d3 = this.getDiff(d, this.prevCommits);
                    d4 = this.getDiff(d2, this.prevRollbacks);
                    d5 = d3 < 0.0 || d4 < 0.0 ? -5.0 : ((d6 = d3 + d4) == 0.0 ? 0.0 : d4 / d6 * 100.0);
                }
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(d3));
                arrayList.add(new Double(d4));
                arrayList.add(new Double(d5));
                this.addNewMeasure(arrayList);
                this.prevCommits = d;
                this.prevRollbacks = d2;
                this.closeRs(resultSet);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.tibSid, exception.toString());
                break block16;
            }
            finally {
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
            }
            this.closeStmt(statement);
            this.closeConn(connection);
        }
    }

    private double getDiff(double d, double d2) {
        double d3 = 0.0;
        if (d2 >= 0.0 && d >= d2 && (d3 = d - d2) < 0.0) {
            d3 = -5.0;
        }
        return d3;
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        TibTransTest tibTransTest = new TibTransTest(stringArray);
        tibTransTest.computeMeasures(new Hashtable());
    }
}

