/*
 * Decompiled with CFR 0.152.
 */
import com.ibm.mq.MQException;
import com.ibm.mq.pcf.PCFException;
import com.ibm.mq.pcf.PCFMessage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class WSMQEventBase
extends GenericTest {
    private final String EG_TIME_FORMAT = "MM/dd/yyyy HH:mm:ss";
    private final SimpleDateFormat MY_SDF = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

    public WSMQEventBase(String[] stringArray) {
        super(stringArray);
    }

    public static void main(String[] stringArray) {
    }

    private String applTypeToString(int n) {
        String string = null;
        switch (n) {
            case -1: {
                string = "MQAT_UNKNOWN";
                break;
            }
            case 0: {
                string = "MQAT_NO_CONTEXT";
                break;
            }
            case 1: {
                string = "MQAT_CICS";
                break;
            }
            case 2: {
                string = "MQAT_ZOS";
                break;
            }
            case 3: {
                string = "MQAT_IMS";
                break;
            }
            case 4: {
                string = "MQAT_OS2";
                break;
            }
            case 5: {
                string = "MQAT_DOS";
                break;
            }
            case 6: {
                string = "MQAT_UNIX";
                break;
            }
            case 7: {
                string = "MQAT_QMGR";
                break;
            }
            case 8: {
                string = "MQAT_OS400";
                break;
            }
            case 9: {
                string = "MQAT_WINDOWS";
                break;
            }
            case 10: {
                string = "MQAT_CICS_VSE";
                break;
            }
            case 11: {
                string = "MQAT_WINDOWS_NT";
                break;
            }
            case 12: {
                string = "MQAT_VMS";
                break;
            }
            case 13: {
                string = "MQAT_NSK";
                break;
            }
            case 14: {
                string = "MQAT_VOS";
                break;
            }
            case 15: {
                string = "MQAT_OPEN_TP1";
                break;
            }
            case 18: {
                string = "MQAT_VM";
                break;
            }
            case 19: {
                string = "MQAT_IMS_BRIDGE";
                break;
            }
            case 20: {
                string = "MQAT_XCF";
                break;
            }
            case 21: {
                string = "MQAT_CICS_BRIDGE";
                break;
            }
            case 22: {
                string = "MQAT_NOTES_AGENT";
                break;
            }
            case 23: {
                string = "MQAT_TPF";
                break;
            }
            case 25: {
                string = "MQAT_USER";
                break;
            }
            case 26: {
                string = "MQAT_BROKER/MQAT_QMGR_PUBLISH";
                break;
            }
            case 28: {
                string = "MQAT_JAVA";
                break;
            }
            case 29: {
                string = "MQAT_DQM";
                break;
            }
            case 30: {
                string = "MQAT_CHANNEL_INITIATOR";
                break;
            }
            case 31: {
                string = "MQAT_WLM";
                break;
            }
            case 32: {
                string = "MQAT_BATCH";
                break;
            }
            case 33: {
                string = "MQAT_RRS_BATCH";
                break;
            }
            case 34: {
                string = "MQAT_SIB";
                break;
            }
            case 35: {
                string = "MQAT_SYSTEM_EXTENSION";
                break;
            }
            case 36: {
                string = "MQAT_MCAST_PUBLISH";
                break;
            }
            default: {
                string = "Unknown!";
            }
        }
        return string;
    }

    public static String pcfReasonToString(int n) {
        String string;
        switch (n) {
            case 2001: {
                string = "Alias Base Queue Type Error";
                break;
            }
            case 2368: {
                string = "Change Object";
                break;
            }
            case 2367: {
                string = "Create Object";
                break;
            }
            case 2369: {
                string = "Delete Object";
                break;
            }
            case 2370: {
                string = "Refresh Object";
                break;
            }
            case 2234: {
                string = "Channel Auto-definition Error";
                break;
            }
            case 2284: {
                string = "Channel Conversion Error";
                break;
            }
            case 2371: {
                string = "Channel SSL Error";
                break;
            }
            case 2552: {
                string = "Channel SSL Warning";
                break;
            }
            case 2283: {
                string = "Channel Stopped";
                break;
            }
            case 2198: {
                string = "Default Transmission Queue Type Error";
                break;
            }
            case 2199: {
                string = "Default Transmission Queue Usage Error";
                break;
            }
            case 2016: {
                string = "Get Inhibited";
                break;
            }
            case 2051: {
                string = "Put Inhibited";
                break;
            }
            case 2053: {
                string = "Queue Full";
                break;
            }
            case 2057: {
                string = "Queue Type Error";
                break;
            }
            case 2184: {
                string = "Remote Queue Name Error";
                break;
            }
            case 2091: {
                string = "Transmission Queue Type Error";
                break;
            }
            case 2092: {
                string = "Transmission Queue Usage Error";
                break;
            }
            case 2082: {
                string = "Unknown Alias Base Queue";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    public static String platformToString(int n) {
        String string;
        switch (n) {
            case 3: {
                string = "UNIX";
                break;
            }
            case 13: {
                string = "NSK";
                break;
            }
            case 4: {
                string = "OS400";
                break;
            }
            case 12: {
                string = "VMS";
                break;
            }
            case 5: {
                string = "WINDOWS";
                break;
            }
            case 11: {
                string = "WINDOWS NT";
                break;
            }
            case 1: {
                string = "ZOS";
                break;
            }
            case 2: {
                string = "OS2";
                break;
            }
            case 27: {
                string = "VSE";
                break;
            }
            default: {
                string = "UNKNOWN";
            }
        }
        return string;
    }

    private String rtrim(String string) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 == 0 || string.charAt(n2 - 1) != ' ') {
            return string;
        }
        for (n = n2 - 2; n >= 0 && string.charAt(n) == ' '; --n) {
        }
        if (n < 0) {
            return "";
        }
        return string.substring(0, n + 1);
    }

    protected ArrayList displayAlias_Base_Queue_Type_Error(PCFMessage pCFMessage) throws PCFException {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = pCFMessage.getIntParameterValue(20);
        stringBuilder.append("ReasonCode: " + pCFMessage.getReason());
        stringBuilder.append(",EventName: Alias Base Queue Type Error - MQRC_ALIAS_BASE_Q_TYPE_ERROR (2001, X'7D1')");
        stringBuilder.append(",EventType: Local");
        stringBuilder.append(",QMgrName: " + pCFMessage.getStringParameterValue(2015));
        stringBuilder.append(",QName: " + pCFMessage.getStringParameterValue(2016));
        stringBuilder.append(",BaseObjectName: " + pCFMessage.getStringParameterValue(2002));
        String string = "";
        switch (n) {
            case 3: {
                string = "MQQT_ALIAS";
                break;
            }
            case 2: {
                string = "MQQT_MODEL";
                break;
            }
            default: {
                string = "Unknown!";
            }
        }
        stringBuilder.append(",QType: " + n + " " + string);
        stringBuilder.append(",ApplType: " + pCFMessage.getIntParameterValue(1) + " (" + this.applTypeToString(pCFMessage.getIntParameterValue(1)) + ")");
        stringBuilder.append(",ApplName: " + pCFMessage.getStringParameterValue(3024));
        try {
            stringBuilder.append(",ObjectQMgrName: " + pCFMessage.getStringParameterValue(3023));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        try {
            stringBuilder.append(",ConnName: " + pCFMessage.getStringParameterValue(3506));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        try {
            stringBuilder.append(",ChannelName: " + pCFMessage.getStringParameterValue(3501));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        stringBuilder.append("," + this.rtrim(pCFMessage.getStringParameterValue(2015)) + " - " + pCFMessage.getReason() + " - " + WSMQEventBase.pcfReasonToString(pCFMessage.getReason()) + " ==> " + pCFMessage.getStringParameterValue(2002));
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    protected ArrayList displayChannel_Auto_Definition_Error(PCFMessage pCFMessage) throws PCFException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = pCFMessage.getIntParameterValue(1511);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ReasonCode: " + pCFMessage.getReason());
        stringBuilder.append(",EventName: Channel Auto-Definition Error - MQRC_CHANNEL_AUTO_DEF_ERROR (2234, X'8BA')");
        stringBuilder.append(",EventType: Channel");
        stringBuilder.append(",QMgrName: " + pCFMessage.getStringParameterValue(2015));
        stringBuilder.append(",ChannelName: " + pCFMessage.getStringParameterValue(3501));
        String string = "";
        switch (n) {
            case 3: {
                string = "MQCHT_RECEIVER)";
                break;
            }
            case 7: {
                string = "MQCHT_SVRCONN)";
                break;
            }
            case 9: {
                string = "MQCHT_CLUSSDR)";
                break;
            }
            default: {
                string = "Unknown!)";
            }
        }
        stringBuilder.append(",ChannelType: " + n + " (" + string);
        stringBuilder.append(",ErrorIdentifier: " + pCFMessage.getIntParameterValue(1013));
        stringBuilder.append(",ConnectionName: " + pCFMessage.getStringParameterValue(3506));
        try {
            stringBuilder.append(",AuxErrDataInt1: " + pCFMessage.getIntParameterValue(1070));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        stringBuilder.append("," + this.rtrim(pCFMessage.getStringParameterValue(2015)) + " - " + pCFMessage.getReason() + " - " + WSMQEventBase.pcfReasonToString(pCFMessage.getReason()) + " ==> " + pCFMessage.getStringParameterValue(3501));
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    protected ArrayList displayChannel_Conversion_Error(PCFMessage pCFMessage) throws PCFException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = pCFMessage.getIntParameterValue(1072);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ReasonCode: " + pCFMessage.getReason());
        stringBuilder.append(",EventName: Channel Conversion Error - MQRC_CHANNEL_CONV_ERROR (2284, X'8EC')");
        stringBuilder.append(",EventType: Channel");
        stringBuilder.append(",QMgrName: " + pCFMessage.getStringParameterValue(2015));
        String string = "";
        switch (n) {
            case 2120: {
                string = "MQRC_CONVERTED_MSG_TOO_BIG)";
                break;
            }
            case 2110: {
                string = "MQRC_FORMAT_ERROR)";
                break;
            }
            case 2119: {
                string = "MQRC_NOT_CONVERTED)";
                break;
            }
            case 2111: {
                string = "MQRC_SOURCE_CCSID_ERROR)";
                break;
            }
            case 2113: {
                string = "MQRC_SOURCE_DECIMAL_ENC_ERROR)";
                break;
            }
            case 2114: {
                string = "MQRC_SOURCE_FLOAT_ENC_ERROR)";
                break;
            }
            case 2112: {
                string = "MQRC_SOURCE_INTEGER_ENC_ERROR)";
                break;
            }
            case 2115: {
                string = "MQRC_TARGET_CCSID_ERROR)";
                break;
            }
            case 2117: {
                string = "MQRC_TARGET_DECIMAL_ENC_ERROR)";
                break;
            }
            case 2118: {
                string = "MQRC_TARGET_FLOAT_ENC_ERROR)";
                break;
            }
            case 2116: {
                string = "MQRC_TARGET_INTEGER_ENC_ERROR)";
                break;
            }
            case 2079: {
                string = "MQRC_TRUNCATED_MSG_ACCEPTED)";
                break;
            }
            case 2080: {
                string = "MQRC_TRUNCATED_MSG_FAILED)";
                break;
            }
            default: {
                string = "Unknown!)";
            }
        }
        stringBuilder.append(",ConvReasonCode: " + n + " (" + string);
        stringBuilder.append(",ChannelName: " + pCFMessage.getStringParameterValue(3501));
        stringBuilder.append(",Format: " + pCFMessage.getStringParameterValue(3533));
        stringBuilder.append(",XmitQName: " + pCFMessage.getStringParameterValue(2024));
        stringBuilder.append(",ConnectionName: " + pCFMessage.getStringParameterValue(3506));
        stringBuilder.append("," + this.rtrim(pCFMessage.getStringParameterValue(2015)) + " - " + pCFMessage.getReason() + " - " + WSMQEventBase.pcfReasonToString(pCFMessage.getReason()) + " ==> " + pCFMessage.getStringParameterValue(3501));
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    protected ArrayList displayChannel_SSL_Error(PCFMessage pCFMessage) throws PCFException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        int n = pCFMessage.getIntParameterValue(1020);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ReasonCode: " + pCFMessage.getReason());
        stringBuilder.append(",EventName: Channel SSL Error - MQRC_CHANNEL_SSL_ERROR (2371, X'943')");
        stringBuilder.append(",EventType: SSL");
        stringBuilder.append(",QMgrName: " + pCFMessage.getStringParameterValue(2015));
        String string2 = "";
        switch (n) {
            case 13: {
                string2 = "MQRQ_SSL_HANDSHAKE_ERROR)";
                break;
            }
            case 14: {
                string2 = "MQRQ_SSL_CIPHER_SPEC_ERROR)";
                break;
            }
            case 16: {
                string2 = "MQRQ_SSL_PEER_NAME_ERROR)";
                break;
            }
            case 15: {
                string2 = "MQRQ_SSL_CLIENT_AUTH_ERROR)";
                break;
            }
            default: {
                string2 = "Unknown!)";
            }
        }
        stringBuilder.append(",ReasonQualifier: " + n + " (" + string2);
        try {
            string = pCFMessage.getStringParameterValue(3501);
            stringBuilder.append(",ChannelName: " + string);
        }
        catch (MQException mQException) {
            // empty catch block
        }
        try {
            stringBuilder.append(",XmitQName: " + pCFMessage.getStringParameterValue(2024));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        try {
            stringBuilder.append(",ConnectionName: " + pCFMessage.getStringParameterValue(3506));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        if (n == 13) {
            stringBuilder.append("SSLHandshkStage: " + pCFMessage.getStringParameterValue(3546));
        }
        if (n == 13) {
            stringBuilder.append("SSLReturnCode: " + pCFMessage.getIntParameterValue(1533));
        }
        try {
            stringBuilder.append(",SSLPeerName: " + pCFMessage.getStringParameterValue(3545));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        stringBuilder.append("," + this.rtrim(pCFMessage.getStringParameterValue(2015)) + " - " + pCFMessage.getReason() + " - " + WSMQEventBase.pcfReasonToString(pCFMessage.getReason()) + " ==> " + string);
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    protected ArrayList displayChannel_Stopped(PCFMessage pCFMessage) throws PCFException {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = pCFMessage.getIntParameterValue(1020);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ReasonCode: " + pCFMessage.getReason());
        stringBuilder.append(",EventName: Channel Stopped - MQRC_CHANNEL_STOPPED (2283, X'8EB')");
        stringBuilder.append(",EventType: Channel");
        stringBuilder.append(",QMgrName: " + pCFMessage.getStringParameterValue(2015));
        this.printOut("[displayChannel_Stopped] ");
        String string = "";
        switch (n) {
            case 7: {
                string = "MQRQ_CHANNEL_STOPPED_OK)";
                bl = true;
                break;
            }
            case 8: {
                string = "MQRQ_CHANNEL_STOPPED_ERROR)";
                break;
            }
            case 9: {
                string = "MQRQ_CHANNEL_STOPPED_RETRY)";
                break;
            }
            case 10: {
                string = "MQRQ_CHANNEL_STOPPED_DISABLED)";
                break;
            }
            default: {
                string = "Unknown!)";
            }
        }
        stringBuilder.append(",ReasonQualifier: " + n + " (" + string);
        stringBuilder.append(",ChannelName: " + pCFMessage.getStringParameterValue(3501));
        stringBuilder.append(",ErrorIdentifier: " + pCFMessage.getIntParameterValue(1013));
        stringBuilder.append(",AuxErrDataInt1: " + pCFMessage.getIntParameterValue(1070));
        stringBuilder.append(",AuxErrDataInt2: " + pCFMessage.getIntParameterValue(1071));
        stringBuilder.append(",AuxErrDataStr1: " + pCFMessage.getStringParameterValue(3026));
        stringBuilder.append(",AuxErrDataStr2: " + pCFMessage.getStringParameterValue(3027));
        stringBuilder.append(",AuxErrDataStr3: " + pCFMessage.getStringParameterValue(3028));
        try {
            stringBuilder.append(",XmitQName: " + pCFMessage.getStringParameterValue(2024));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        try {
            stringBuilder.append(",ConnectionName: " + pCFMessage.getStringParameterValue(3506));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        stringBuilder.append("," + this.rtrim(pCFMessage.getStringParameterValue(2015)) + " - " + pCFMessage.getReason() + " - " + WSMQEventBase.pcfReasonToString(pCFMessage.getReason()) + " ==> " + pCFMessage.getStringParameterValue(3501));
        if (bl) {
            this.printOut("[displayChannel_Stopped]  isStoppedOK   flag :" + bl + "   , So no need to add event list " + arrayList.add(stringBuilder.toString()));
            arrayList = new ArrayList();
        } else {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    protected ArrayList displayDefault_Transmission_Queue_Type_Error(PCFMessage pCFMessage) throws PCFException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = pCFMessage.getIntParameterValue(20);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ReasonCode: " + pCFMessage.getReason());
        stringBuilder.append(",EventName: Default Transmission Queue Type Error - MQRC_DEF_XMIT_Q_TYPE_ERROR (2198, X'896')");
        stringBuilder.append(",EventType: Remote");
        stringBuilder.append(",QMgrName: " + pCFMessage.getStringParameterValue(2015));
        stringBuilder.append(",QName: " + pCFMessage.getStringParameterValue(2016));
        stringBuilder.append(",XmitQName: " + pCFMessage.getStringParameterValue(2024));
        String string = "";
        switch (n) {
            case 3: {
                string = "MQQT_ALIAS)";
                break;
            }
            case 6: {
                string = "MQQT_REMOTE)";
                break;
            }
            default: {
                string = "Unknown!)";
            }
        }
        stringBuilder.append(",QType: " + n + " (" + string);
        stringBuilder.append(",ApplType: " + pCFMessage.getIntParameterValue(1) + " (" + this.applTypeToString(pCFMessage.getIntParameterValue(1)) + ")");
        stringBuilder.append(",ApplName: " + pCFMessage.getStringParameterValue(3024));
        try {
            stringBuilder.append(",ObjectQMgrName: " + pCFMessage.getStringParameterValue(3023));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        try {
            stringBuilder.append(",ConnName: " + pCFMessage.getStringParameterValue(3506));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        try {
            stringBuilder.append(",ChannelName: " + pCFMessage.getStringParameterValue(3501));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        stringBuilder.append("," + this.rtrim(pCFMessage.getStringParameterValue(2015)) + " - " + pCFMessage.getReason() + " - " + WSMQEventBase.pcfReasonToString(pCFMessage.getReason()) + " ==> " + pCFMessage.getStringParameterValue(2016));
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    protected ArrayList displayDefault_Transmission_Queue_Usage_Error(PCFMessage pCFMessage) throws PCFException {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ReasonCode: " + pCFMessage.getReason());
        stringBuilder.append(",EventName: Default Transmission Queue Usage Error - MQRC_DEF_XMIT_Q_USAGE_ERROR (2199, X'897')");
        stringBuilder.append(",EventType: Remote");
        stringBuilder.append(",QMgrName: " + pCFMessage.getStringParameterValue(2015));
        stringBuilder.append(",QName: " + pCFMessage.getStringParameterValue(2016));
        stringBuilder.append(",XmitQName: " + pCFMessage.getStringParameterValue(2024));
        stringBuilder.append(",ApplType: " + pCFMessage.getIntParameterValue(1) + " (" + this.applTypeToString(pCFMessage.getIntParameterValue(1)) + ")");
        stringBuilder.append(",ApplName: " + pCFMessage.getStringParameterValue(3024));
        try {
            stringBuilder.append(",ObjectQMgrName: " + pCFMessage.getStringParameterValue(3023));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        try {
            stringBuilder.append(",ConnName: " + pCFMessage.getStringParameterValue(3506));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        try {
            stringBuilder.append(",ChannelName: " + pCFMessage.getStringParameterValue(3501));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        stringBuilder.append("," + this.rtrim(pCFMessage.getStringParameterValue(2015)) + " - " + pCFMessage.getReason() + " - " + WSMQEventBase.pcfReasonToString(pCFMessage.getReason()) + " ==> " + pCFMessage.getStringParameterValue(2016));
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    protected ArrayList displayGet_Inhibited(PCFMessage pCFMessage) throws PCFException {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ReasonCode: " + pCFMessage.getReason());
        stringBuilder.append(",EventName: Get Inhibited - MQRC_GET_INHIBITED (2016, X'7E0')");
        stringBuilder.append(",EventType: Inhibit");
        stringBuilder.append(",QMgrName: " + pCFMessage.getStringParameterValue(2015));
        stringBuilder.append(",QName: " + pCFMessage.getStringParameterValue(2016));
        stringBuilder.append(",ApplType: " + pCFMessage.getIntParameterValue(1) + " (" + this.applTypeToString(pCFMessage.getIntParameterValue(1)) + ")");
        stringBuilder.append(",ApplName: " + pCFMessage.getStringParameterValue(3024));
        try {
            stringBuilder.append(",ConnName: " + pCFMessage.getStringParameterValue(3506));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        try {
            stringBuilder.append(",ChannelName: " + pCFMessage.getStringParameterValue(3501));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        stringBuilder.append("," + this.rtrim(pCFMessage.getStringParameterValue(2015)) + " - " + pCFMessage.getReason() + " - " + WSMQEventBase.pcfReasonToString(pCFMessage.getReason()) + " ==> " + pCFMessage.getStringParameterValue(2016));
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    protected ArrayList displayPut_Inhibited(PCFMessage pCFMessage) throws PCFException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ReasonCode: " + pCFMessage.getReason());
        stringBuilder.append(",EventName: Put Inhibited - MQRC_PUT_INHIBITED (2051, X'803')");
        stringBuilder.append(",EventType: Inhibit");
        stringBuilder.append(",QMgrName: " + pCFMessage.getStringParameterValue(2015));
        try {
            stringBuilder.append(",QName: " + pCFMessage.getStringParameterValue(2016));
            string = pCFMessage.getStringParameterValue(2016);
        }
        catch (MQException mQException) {
            // empty catch block
        }
        stringBuilder.append(",ApplType: " + pCFMessage.getIntParameterValue(1) + " (" + this.applTypeToString(pCFMessage.getIntParameterValue(1)) + ")");
        stringBuilder.append(",ApplName: " + pCFMessage.getStringParameterValue(3024));
        try {
            stringBuilder.append(",ObjectQMgrName: " + pCFMessage.getStringParameterValue(3023));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        try {
            stringBuilder.append(",TopicString: " + pCFMessage.getStringParameterValue(2094));
            string = pCFMessage.getStringParameterValue(2094);
        }
        catch (MQException mQException) {
            // empty catch block
        }
        try {
            stringBuilder.append(",ConnName: " + pCFMessage.getStringParameterValue(3506));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        try {
            stringBuilder.append(",ChannelName: " + pCFMessage.getStringParameterValue(3501));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        stringBuilder.append("," + this.rtrim(pCFMessage.getStringParameterValue(2015)) + " - " + pCFMessage.getReason() + " - " + WSMQEventBase.pcfReasonToString(pCFMessage.getReason()) + " ==> " + string);
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    protected ArrayList displayQueue_Full(PCFMessage pCFMessage) throws PCFException {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ReasonCode: " + pCFMessage.getReason());
        stringBuilder.append(",EventName: Queue Full - MQRC_Q_FULL (2053, X'805')");
        stringBuilder.append(",EventType: Performance");
        stringBuilder.append(",QMgrName: " + pCFMessage.getStringParameterValue(2015));
        stringBuilder.append(",QName: " + pCFMessage.getStringParameterValue(2002));
        stringBuilder.append(",TimeSinceReset: " + pCFMessage.getIntParameterValue(35));
        stringBuilder.append(",HighQDepth: " + pCFMessage.getIntParameterValue(36));
        stringBuilder.append(",MsgEnqCount: " + pCFMessage.getIntParameterValue(37));
        stringBuilder.append(",MsgDeqCount: " + pCFMessage.getIntParameterValue(38));
        stringBuilder.append("," + this.rtrim(pCFMessage.getStringParameterValue(2015)) + " - " + pCFMessage.getReason() + " - " + WSMQEventBase.pcfReasonToString(pCFMessage.getReason()) + " ==> " + pCFMessage.getStringParameterValue(2002));
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    protected ArrayList displayQueue_Manager_Active(PCFMessage pCFMessage) throws PCFException {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ReasonCode: " + pCFMessage.getReason());
        stringBuilder.append(",EventName: Queue Manager Active - MQRC_Q_MGR_ACTIVE (2222, X'8AE')");
        stringBuilder.append(",EventType: Start and Stop");
        stringBuilder.append(",QMgrName: " + pCFMessage.getStringParameterValue(2015));
        stringBuilder.append("," + this.rtrim(pCFMessage.getStringParameterValue(2015)) + " - " + pCFMessage.getReason() + " - " + WSMQEventBase.pcfReasonToString(pCFMessage.getReason()));
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    protected ArrayList displayQueue_Manager_Not_Active(PCFMessage pCFMessage) throws PCFException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = pCFMessage.getIntParameterValue(1020);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ReasonCode: " + pCFMessage.getReason());
        stringBuilder.append(",EventName: Queue Manager Not Active - MQRC_Q_MGR_NOT_ACTIVE (2223, X'8AF')");
        stringBuilder.append(",EventType: Start and Stop");
        stringBuilder.append(",QMgrName: " + pCFMessage.getStringParameterValue(2015));
        String string = "";
        switch (n) {
            case 5: {
                string = "MQRQ_Q_MGR_STOPPING)";
                break;
            }
            case 6: {
                string = "MQRQ_Q_MGR_QUIESCING)";
                break;
            }
            default: {
                string = "Unknown!)";
            }
        }
        stringBuilder.append(",ReasonQualifier: " + n + " (" + string);
        stringBuilder.append("," + this.rtrim(pCFMessage.getStringParameterValue(2015)) + " - " + pCFMessage.getReason() + " - " + WSMQEventBase.pcfReasonToString(pCFMessage.getReason()));
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    protected ArrayList displayQueue_Type_Error(PCFMessage pCFMessage) throws PCFException {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ReasonCode: " + pCFMessage.getReason());
        stringBuilder.append(",EventName: Queue Type Error - MQRC_Q_TYPE_ERROR (2057, X'809')");
        stringBuilder.append(",EventType: Remote");
        stringBuilder.append(",QMgrName: " + pCFMessage.getStringParameterValue(2015));
        stringBuilder.append(",QName: " + pCFMessage.getStringParameterValue(2016));
        stringBuilder.append(",ApplType: " + pCFMessage.getIntParameterValue(1) + " (" + this.applTypeToString(pCFMessage.getIntParameterValue(1)) + ")");
        stringBuilder.append(",ApplName: " + pCFMessage.getStringParameterValue(3024));
        stringBuilder.append(",ObjectQMgrName: " + pCFMessage.getStringParameterValue(3023));
        try {
            stringBuilder.append(",ConnName: " + pCFMessage.getStringParameterValue(3506));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        try {
            stringBuilder.append(",ChannelName: " + pCFMessage.getStringParameterValue(3501));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        stringBuilder.append("," + this.rtrim(pCFMessage.getStringParameterValue(2015)) + " - " + pCFMessage.getReason() + " - " + WSMQEventBase.pcfReasonToString(pCFMessage.getReason()) + " ==> " + pCFMessage.getStringParameterValue(3023));
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    private String toHex(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        for (int i = 0; i < cArray.length; ++i) {
            stringBuffer.append(Integer.toString((cArray[i] & 0xFF) + 256, 16).substring(1));
        }
        return stringBuffer.toString();
    }

    protected ArrayList displayCreate_Object(PCFMessage pCFMessage, int n) throws PCFException {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        int n2 = pCFMessage.getIntParameterValue(1011);
        int n3 = pCFMessage.getIntParameterValue(1016);
        stringBuilder.append("ReasonCode: " + pCFMessage.getReason());
        stringBuilder.append(",EventName: Create Object - MQRC_CONFIG_CREATE_OBJECT (2367, X'93F')");
        stringBuilder.append(",EventType: Configuration");
        stringBuilder.append(",Description: A DEFINE or DEFINE REPLACE command was issued which");
        stringBuilder.append(",successfully created a new object.");
        stringBuilder.append(",EventUserId: " + pCFMessage.getStringParameterValue(3045));
        try {
            stringBuilder.append(",SecurityId: X'" + this.toHex(new String(pCFMessage.getBytesParameterValue(7002))) + "'");
        }
        catch (MQException mQException) {
            // empty catch block
        }
        String string2 = "";
        switch (n2) {
            case 1: {
                string2 = "MQEVO_CONSOLE)";
                break;
            }
            case 2: {
                string2 = "MQEVO_INIT)";
                break;
            }
            case 5: {
                string2 = "MQEVO_INTERNAL)";
                break;
            }
            case 4: {
                string2 = "MQEVO_MQSET)";
                break;
            }
            case 3: {
                string2 = "MQEVO_MSG)";
                break;
            }
            case 0: {
                string2 = "MQEVO_OTHER)";
                break;
            }
            default: {
                string2 = "Unknown!)";
            }
        }
        stringBuilder.append(",EventOrigin: " + n2 + " (" + string2);
        stringBuilder.append(",EventQMgr: " + pCFMessage.getStringParameterValue(3047));
        if (n2 == 3) {
            stringBuilder.append(",EventAccntToken: X'" + this.toHex(new String(pCFMessage.getBytesParameterValue(7001))) + "'");
            stringBuilder.append(",EventApplIdenty: " + pCFMessage.getStringParameterValue(3049));
            stringBuilder.append(",EventApplType: " + pCFMessage.getIntParameterValue(1010) + " (" + this.applTypeToString(pCFMessage.getIntParameterValue(1010)) + ")");
            stringBuilder.append(",EventApplName: " + pCFMessage.getStringParameterValue(3050));
            stringBuilder.append(",EventApplOrigin: " + pCFMessage.getStringParameterValue(3051));
        }
        String string3 = "";
        switch (n3) {
            case 6: {
                string3 = "MQOT_CHANNEL)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(3501));
                string = "MQOT_CHANNEL ==> " + pCFMessage.getStringParameterValue(3501);
                break;
            }
            case 1016: {
                string3 = "MQOT_CHLAUTH)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(3501));
                string = "MQOT_CHLAUTH ==> " + pCFMessage.getStringParameterValue(3501);
                break;
            }
            case 2: {
                string3 = "MQOT_NAMELIST)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2010));
                string = "MQOT_NAMELIST ==> " + pCFMessage.getStringParameterValue(2010);
                break;
            }
            case 0: {
                string3 = "MQOT_NONE)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: ");
                string = "MQOT_NONE";
                break;
            }
            case 3: {
                string3 = "MQOT_PROCESS)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2012));
                string = "MQOT_PROCESS ==> " + pCFMessage.getStringParameterValue(2012);
                break;
            }
            case 1: {
                string3 = "MQOT_Q)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2016));
                string = "MQOT_Q ==> " + pCFMessage.getStringParameterValue(2016);
                break;
            }
            case 4: {
                string3 = "MQOT_STORAGE_CLASS)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2022));
                string = "MQOT_STORAGE_CLASS ==> " + pCFMessage.getStringParameterValue(2022);
                break;
            }
            case 7: {
                string3 = "MQOT_AUTH_INFO)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2045));
                string = "MQOT_AUTH_INFO ==> " + pCFMessage.getStringParameterValue(2045);
                break;
            }
            case 10: {
                string3 = "MQOT_CF_STRUC)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2039));
                string = "MQOT_CF_STRUC ==> " + pCFMessage.getStringParameterValue(2039);
                break;
            }
            case 8: {
                string3 = "MQOT_TOPIC)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2092));
                string = "MQOT_TOPIC ==> " + pCFMessage.getStringParameterValue(2092);
                break;
            }
            case 9: {
                string3 = "MQOT_COMM_INFO)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2110));
                string = "MQOT_COMM_INFO ==> " + pCFMessage.getStringParameterValue(2110);
                break;
            }
            case 11: {
                string3 = "MQOT_LISTENER)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(3554));
                string = "MQOT_LISTENER ==> " + pCFMessage.getStringParameterValue(3554);
                break;
            }
            case 1019: {
                string3 = "MQOT_PROT_POLICY)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2112));
                string = "MQOT_PROT_POLICY ==> " + pCFMessage.getStringParameterValue(2112);
                break;
            }
            default: {
                string3 = "Unknown!)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
            }
        }
        if (n == 1 && n3 != 5 && n3 != 10) {
            int n4 = pCFMessage.getIntParameterValue(63);
            String string4 = "";
            switch (n4) {
                case 0: {
                    string4 = "MQQSGD_Q_MGR)";
                    break;
                }
                case 2: {
                    string4 = "MQQSGD_SHARED)";
                    break;
                }
                case 3: {
                    string4 = "MQQSGD_GROUP)";
                    break;
                }
                case 1: {
                    string4 = "MQQSGD_COPY)";
                    break;
                }
                default: {
                    string4 = "Unknown!)";
                }
            }
            stringBuilder.append(",Disposition: " + n3 + " (" + string4);
        }
        stringBuilder.append("," + this.rtrim(pCFMessage.getStringParameterValue(3047)) + " - " + pCFMessage.getReason() + " - " + WSMQEventBase.pcfReasonToString(pCFMessage.getReason()) + " - " + string);
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    protected ArrayList displayChange_Object(PCFMessage pCFMessage, int n) throws PCFException {
        String string = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = pCFMessage.getIntParameterValue(1011);
        int n3 = pCFMessage.getIntParameterValue(1016);
        stringBuilder.append("ReasonCode: " + pCFMessage.getReason());
        stringBuilder.append(",EventName: Change Object - MQRC_CONFIG_CHANGE_OBJECT (2368, X'940')");
        stringBuilder.append(",EventType: Configuration");
        stringBuilder.append(",Description: An ALTER or DEFINE REPLACE command or an MQSET call was");
        stringBuilder.append(",issued that successfully changed an existing object.");
        stringBuilder.append(",EventUserId: " + pCFMessage.getStringParameterValue(3045));
        try {
            stringBuilder.append(",SecurityId: X'" + this.toHex(new String(pCFMessage.getBytesParameterValue(7002))) + "'");
        }
        catch (MQException mQException) {
            // empty catch block
        }
        String string2 = "";
        switch (n2) {
            case 1: {
                string2 = "MQEVO_CONSOLE)";
                break;
            }
            case 2: {
                string2 = "MQEVO_INIT)";
                break;
            }
            case 5: {
                string2 = "MQEVO_INTERNAL)";
                break;
            }
            case 4: {
                string2 = "MQEVO_MQSET)";
                break;
            }
            case 3: {
                string2 = "MQEVO_MSG)";
                break;
            }
            case 0: {
                string2 = "MQEVO_OTHER)";
                break;
            }
            default: {
                string2 = "Unknown!)";
            }
        }
        stringBuilder.append(",EventOrigin: " + n2 + " (" + string2);
        stringBuilder.append(",EventQMgr: " + pCFMessage.getStringParameterValue(3047));
        if (n2 == 3) {
            stringBuilder.append(",EventAccntToken: X'" + this.toHex(new String(pCFMessage.getBytesParameterValue(7001))) + "'");
            stringBuilder.append(",EventApplIdenty: " + pCFMessage.getStringParameterValue(3049));
            stringBuilder.append(",EventApplType: " + pCFMessage.getIntParameterValue(1010) + " (" + this.applTypeToString(pCFMessage.getIntParameterValue(1010)) + ")");
            stringBuilder.append(",EventApplName: " + pCFMessage.getStringParameterValue(3050));
            stringBuilder.append(",EventApplOrigin: " + pCFMessage.getStringParameterValue(3051));
        }
        String string3 = "";
        switch (n3) {
            case 6: {
                string3 = "MQOT_CHANNEL)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(3501));
                string = "MQOT_CHANNEL ==> " + pCFMessage.getStringParameterValue(3501);
                break;
            }
            case 1016: {
                string3 = "MQOT_CHLAUTH)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(3501));
                string = "MQOT_CHLAUTH ==> " + pCFMessage.getStringParameterValue(3501);
                break;
            }
            case 2: {
                string3 = "MQOT_NAMELIST)";
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2010));
                string = "MQOT_NAMELIST ==> " + pCFMessage.getStringParameterValue(2010);
                break;
            }
            case 0: {
                string3 = "MQOT_NONE)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: ");
                string = "MQOT_NONE";
                break;
            }
            case 3: {
                string3 = "MQOT_PROCESS)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2012));
                string = "MQOT_PROCESS ==> " + pCFMessage.getStringParameterValue(2012);
                break;
            }
            case 1: {
                string3 = "MQOT_Q)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2016));
                string = "MQOT_Q ==> " + pCFMessage.getStringParameterValue(2016);
                break;
            }
            case 5: {
                string3 = "MQOT_Q_MGR)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2015));
                string = "MQOT_Q_MGR ==> " + pCFMessage.getStringParameterValue(2015);
                break;
            }
            case 4: {
                string3 = "MQOT_STORAGE_CLASS)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2022));
                string = "MQOT_STORAGE_CLASS ==> " + pCFMessage.getStringParameterValue(2022);
                break;
            }
            case 7: {
                string3 = "MQOT_AUTH_INFO)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2045));
                string = "MQOT_AUTH_INFO ==> " + pCFMessage.getStringParameterValue(2045);
                break;
            }
            case 10: {
                string3 = "MQOT_CF_STRUC)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2039));
                string = "MQOT_CF_STRUC ==> " + pCFMessage.getStringParameterValue(2039);
                break;
            }
            case 8: {
                string3 = "MQOT_TOPIC)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2092));
                string = "MQOT_TOPIC ==> " + pCFMessage.getStringParameterValue(2092);
                break;
            }
            case 9: {
                string3 = "MQOT_COMM_INFO)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2110));
                string = "MQOT_COMM_INFO ==> " + pCFMessage.getStringParameterValue(2110);
                break;
            }
            case 11: {
                string3 = "MQOT_LISTENER)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(3554));
                string = "MQOT_LISTENER ==> " + pCFMessage.getStringParameterValue(3554);
                break;
            }
            case 1019: {
                string3 = "MQOT_PROT_POLICY)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2112));
                string = "MQOT_PROT_POLICY ==> " + pCFMessage.getStringParameterValue(2112);
                break;
            }
            default: {
                string3 = "Unknown!)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                string = "Unknown!";
            }
        }
        if (n == 1 && n3 != 5 && n3 != 10) {
            int n4 = pCFMessage.getIntParameterValue(63);
            String string4 = "";
            switch (n4) {
                case 0: {
                    string4 = "MQQSGD_Q_MGR)";
                    break;
                }
                case 2: {
                    string4 = "MQQSGD_SHARED)";
                    break;
                }
                case 3: {
                    string4 = "MQQSGD_GROUP)";
                    break;
                }
                case 1: {
                    string4 = "MQQSGD_COPY)";
                    break;
                }
                default: {
                    string4 = "Unknown!)";
                }
            }
            stringBuilder.append(",Disposition: " + n3 + " (" + string4);
        }
        stringBuilder.append("," + this.rtrim(pCFMessage.getStringParameterValue(3047)) + " - " + pCFMessage.getReason() + " - " + WSMQEventBase.pcfReasonToString(pCFMessage.getReason()) + " - " + string);
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    protected ArrayList displayDelete_Object(PCFMessage pCFMessage, int n) throws PCFException {
        String string = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = pCFMessage.getIntParameterValue(1011);
        int n3 = pCFMessage.getIntParameterValue(1016);
        stringBuilder.append("ReasonCode: " + pCFMessage.getReason());
        stringBuilder.append(",EventName: Delete Object - MQRC_CONFIG_DELETE_OBJECT (2369, X'941')");
        stringBuilder.append(",EventType: Configuration");
        stringBuilder.append(",Description: A DELETE command or MQCLOSE call was issued that");
        stringBuilder.append(" successfully deleted an object.");
        stringBuilder.append(",EventUserId: " + pCFMessage.getStringParameterValue(3045));
        try {
            stringBuilder.append(",SecurityId: X'" + this.toHex(new String(pCFMessage.getBytesParameterValue(7002))) + "'");
        }
        catch (MQException mQException) {
            // empty catch block
        }
        String string2 = "";
        switch (n2) {
            case 1: {
                string2 = "MQEVO_CONSOLE)";
                break;
            }
            case 2: {
                string2 = "MQEVO_INIT)";
                break;
            }
            case 5: {
                string2 = "MQEVO_INTERNAL)";
                break;
            }
            case 3: {
                string2 = "MQEVO_MSG)";
                break;
            }
            case 0: {
                string2 = "MQEVO_OTHER)";
                break;
            }
            default: {
                string2 = "Unknown!)";
            }
        }
        stringBuilder.append(",EventOrigin: " + n2 + " (" + string2);
        stringBuilder.append(",EventQMgr: " + pCFMessage.getStringParameterValue(3047));
        if (n2 == 3) {
            stringBuilder.append(",EventAccntToken: X'" + this.toHex(new String(pCFMessage.getBytesParameterValue(7001))) + "'");
            stringBuilder.append(",EventApplIdenty: " + pCFMessage.getStringParameterValue(3049));
            stringBuilder.append(",EventApplType: " + pCFMessage.getIntParameterValue(1010) + " (" + this.applTypeToString(pCFMessage.getIntParameterValue(1010)) + ")");
            stringBuilder.append(",EventApplName: " + pCFMessage.getStringParameterValue(3050));
            stringBuilder.append(",EventApplOrigin: " + pCFMessage.getStringParameterValue(3051));
        }
        String string3 = "";
        switch (n3) {
            case 6: {
                string3 = "MQOT_CHANNEL)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(3501));
                string = "MQOT_CHANNEL ==> " + pCFMessage.getStringParameterValue(3501);
                break;
            }
            case 2: {
                string3 = "MQOT_NAMELIST)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2010));
                string = "MQOT_NAMELIST ==> " + pCFMessage.getStringParameterValue(2010);
                break;
            }
            case 0: {
                string3 = "MQOT_NONE)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: ");
                string = "MQOT_NONE";
                break;
            }
            case 3: {
                string3 = "MQOT_PROCESS)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2012));
                string = "MQOT_PROCESS ==> " + pCFMessage.getStringParameterValue(2012);
                break;
            }
            case 1: {
                string3 = "MQOT_Q)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2016));
                string = "MQOT_Q ==> " + pCFMessage.getStringParameterValue(2016);
                break;
            }
            case 4: {
                string3 = "MQOT_STORAGE_CLASS)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2022));
                string = "MQOT_STORAGE_CLASS ==> " + pCFMessage.getStringParameterValue(2022);
                break;
            }
            case 7: {
                string3 = "MQOT_AUTH_INFO)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2045));
                string = "MQOT_AUTH_INFO ==> " + pCFMessage.getStringParameterValue(2045);
                break;
            }
            case 10: {
                string3 = "MQOT_CF_STRUC)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2039));
                string = "MQOT_CF_STRUC ==> " + pCFMessage.getStringParameterValue(2039);
                break;
            }
            case 8: {
                string3 = "MQOT_TOPIC)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2092));
                string = "MQOT_TOPIC ==> " + pCFMessage.getStringParameterValue(2092);
                break;
            }
            case 9: {
                string3 = "MQOT_COMM_INFO)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2110));
                string = "MQOT_COMM_INFO ==> " + pCFMessage.getStringParameterValue(2110);
                break;
            }
            case 11: {
                string3 = "MQOT_LISTENER)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(3554));
                string = "MQOT_LISTENER ==> " + pCFMessage.getStringParameterValue(3554);
                break;
            }
            case 1019: {
                string3 = "MQOT_PROT_POLICY)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2112));
                string = "MQOT_PROT_POLICY ==> " + pCFMessage.getStringParameterValue(2112);
                break;
            }
            default: {
                string3 = "Unknown!)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
            }
        }
        if (n == 1 && n3 != 5 && n3 != 10) {
            int n4 = pCFMessage.getIntParameterValue(63);
            String string4 = "";
            switch (n4) {
                case 0: {
                    string4 = "MQQSGD_Q_MGR)";
                    break;
                }
                case 2: {
                    string4 = "MQQSGD_SHARED)";
                    break;
                }
                case 3: {
                    string4 = "MQQSGD_GROUP)";
                    break;
                }
                case 1: {
                    string4 = "MQQSGD_COPY)";
                    break;
                }
                default: {
                    string4 = "Unknown!)";
                }
            }
            stringBuilder.append(",Disposition: " + n3 + " (" + string4);
        }
        stringBuilder.append("," + this.rtrim(pCFMessage.getStringParameterValue(3047)) + " - " + pCFMessage.getReason() + " - " + WSMQEventBase.pcfReasonToString(pCFMessage.getReason()) + " - " + string);
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    protected ArrayList displayRefresh_Object(PCFMessage pCFMessage, int n) throws PCFException {
        String string = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = pCFMessage.getIntParameterValue(1011);
        int n3 = pCFMessage.getIntParameterValue(1016);
        stringBuilder.append("ReasonCode: " + pCFMessage.getReason());
        stringBuilder.append(",EventName: Refresh Object - MQRC_CONFIG_REFRESH_OBJECT (2370, X'942')");
        stringBuilder.append(",EventType: Configuration");
        stringBuilder.append(",Description: A REFRESH QMGR command specifying TYPE (CONFIGEV) was issued.");
        stringBuilder.append(",EventUserId: " + pCFMessage.getStringParameterValue(3045));
        try {
            stringBuilder.append(",SecurityId: X'" + this.toHex(new String(pCFMessage.getBytesParameterValue(7002))) + "'");
        }
        catch (MQException mQException) {
            // empty catch block
        }
        String string2 = "";
        switch (n2) {
            case 1: {
                string2 = "MQEVO_CONSOLE)";
                break;
            }
            case 2: {
                string2 = "MQEVO_INIT)";
                break;
            }
            case 5: {
                string2 = "MQEVO_INTERNAL)";
                break;
            }
            case 3: {
                string2 = "MQEVO_MSG)";
                break;
            }
            case 0: {
                string2 = "MQEVO_OTHER)";
                break;
            }
            default: {
                string2 = "Unknown!)";
            }
        }
        stringBuilder.append(",EventOrigin: " + n2 + " (" + string2);
        stringBuilder.append(",EventQMgr: " + pCFMessage.getStringParameterValue(3047));
        if (n2 == 3) {
            stringBuilder.append(",EventAccntToken: X'" + this.toHex(new String(pCFMessage.getBytesParameterValue(7001))) + "'");
            stringBuilder.append(",EventApplIdenty: " + pCFMessage.getStringParameterValue(3049));
            stringBuilder.append(",EventApplType: " + pCFMessage.getIntParameterValue(1010) + " (" + this.applTypeToString(pCFMessage.getIntParameterValue(1010)) + ")");
            stringBuilder.append(",EventApplName: " + pCFMessage.getStringParameterValue(3050));
            stringBuilder.append(",EventApplOrigin: " + pCFMessage.getStringParameterValue(3051));
        }
        String string3 = "";
        switch (n3) {
            case 6: {
                string3 = "MQOT_CHANNEL)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(3501));
                string = "MQOT_CHANNEL ==> " + pCFMessage.getStringParameterValue(3501);
                break;
            }
            case 1016: {
                string3 = "MQOT_CHLAUTH)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(3501));
                string = "MQOT_CHLAUTH ==> " + pCFMessage.getStringParameterValue(3501);
                break;
            }
            case 11: {
                string3 = "MQOT_LISTENER)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(3554));
                string = "MQOT_LISTENER ==> " + pCFMessage.getStringParameterValue(3554);
                break;
            }
            case 2: {
                string3 = "MQOT_NAMELIST)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2010));
                string = "MQOT_NAMELIST ==> " + pCFMessage.getStringParameterValue(2010);
                break;
            }
            case 0: {
                string3 = "MQOT_NONE)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: ");
                string = "MQOT_NONE";
                break;
            }
            case 3: {
                string3 = "MQOT_PROCESS)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2012));
                string = "MQOT_PROCESS ==> " + pCFMessage.getStringParameterValue(2012);
                break;
            }
            case 1: {
                string3 = "MQOT_Q)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2016));
                string = "MQOT_Q ==> " + pCFMessage.getStringParameterValue(2016);
                break;
            }
            case 5: {
                string3 = "MQOT_Q_MGR)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2015));
                string = "MQOT_Q_MGR ==> " + pCFMessage.getStringParameterValue(2015);
                break;
            }
            case 4: {
                string3 = "MQOT_STORAGE_CLASS)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2022));
                string = "MQOT_STORAGE_CLASS ==> " + pCFMessage.getStringParameterValue(2022);
                break;
            }
            case 7: {
                string3 = "MQOT_AUTH_INFO)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2045));
                string = "MQOT_AUTH_INFO ==> " + pCFMessage.getStringParameterValue(2045);
                break;
            }
            case 10: {
                string3 = "MQOT_CF_STRUC)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2039));
                string = "MQOT_CF_STRUC ==> " + pCFMessage.getStringParameterValue(2039);
                break;
            }
            case 8: {
                string3 = "MQOT_TOPIC)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2092));
                string = "MQOT_TOPIC ==> " + pCFMessage.getStringParameterValue(2092);
                break;
            }
            case 9: {
                string3 = "MQOT_COMM_INFO)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2110));
                string = "MQOT_COMM_INFO ==> " + pCFMessage.getStringParameterValue(2110);
                break;
            }
            case 1019: {
                string3 = "MQOT_PROT_POLICY)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                stringBuilder.append(",ObjectName: " + pCFMessage.getStringParameterValue(2112));
                string = "MQOT_PROT_POLICY ==> " + pCFMessage.getStringParameterValue(2112);
                break;
            }
            default: {
                string3 = "Unknown!)";
                stringBuilder.append(",ObjectType: " + n3 + " (" + string3);
                string = "Unknown!";
            }
        }
        if (n == 1 && n3 != 5 && n3 != 10) {
            int n4 = pCFMessage.getIntParameterValue(63);
            String string4 = "";
            switch (n4) {
                case 0: {
                    string4 = "MQQSGD_Q_MGR)";
                    break;
                }
                case 2: {
                    string4 = "MQQSGD_SHARED)";
                    break;
                }
                case 3: {
                    string4 = "MQQSGD_GROUP)";
                    break;
                }
                case 1: {
                    string4 = "MQQSGD_COPY)";
                    break;
                }
                default: {
                    string4 = "Unknown!)";
                }
            }
            stringBuilder.append(",Disposition: " + n3 + " (" + string4);
        }
        stringBuilder.append("," + this.rtrim(pCFMessage.getStringParameterValue(3047)) + " - " + pCFMessage.getReason() + " - " + WSMQEventBase.pcfReasonToString(pCFMessage.getReason()) + " - " + string);
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    protected ArrayList displayRemote_Queue_Name_Error(PCFMessage pCFMessage) throws PCFException {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ReasonCode: " + pCFMessage.getReason());
        stringBuilder.append(",EventName: Remote Queue Name Error - MQRC_REMOTE_Q_NAME_ERROR (2184, X'888')");
        stringBuilder.append(",EventType: Remote");
        stringBuilder.append(",QMgrName: " + pCFMessage.getStringParameterValue(2015));
        stringBuilder.append(",QName: " + pCFMessage.getStringParameterValue(2016));
        stringBuilder.append(",ApplType: " + pCFMessage.getIntParameterValue(1) + " (" + this.applTypeToString(pCFMessage.getIntParameterValue(1)) + ")");
        stringBuilder.append(",ApplName: " + pCFMessage.getStringParameterValue(3024));
        try {
            stringBuilder.append(",ObjectQMgrName: " + pCFMessage.getStringParameterValue(3023));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        try {
            stringBuilder.append(",ConnName: " + pCFMessage.getStringParameterValue(3506));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        try {
            stringBuilder.append(",ChannelName: " + pCFMessage.getStringParameterValue(3501));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        stringBuilder.append("," + this.rtrim(pCFMessage.getStringParameterValue(2015)) + " - " + pCFMessage.getReason() + " - " + WSMQEventBase.pcfReasonToString(pCFMessage.getReason()) + " ==> " + pCFMessage.getStringParameterValue(2016));
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    protected ArrayList displayTransmission_Queue_Type_Error(PCFMessage pCFMessage) throws PCFException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = pCFMessage.getIntParameterValue(20);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ReasonCode: " + pCFMessage.getReason());
        stringBuilder.append(",EventName: Transmission Queue Type Error - MQRC_XMIT_Q_TYPE_ERROR (2091, X'82B')");
        stringBuilder.append(",EventType: Remote");
        stringBuilder.append(",QMgrName: " + pCFMessage.getStringParameterValue(2015));
        stringBuilder.append(",QName: " + pCFMessage.getStringParameterValue(2016));
        stringBuilder.append(",XmitQName: " + pCFMessage.getStringParameterValue(2024));
        String string = "";
        switch (n) {
            case 3: {
                string = "MQQT_ALIAS)";
                break;
            }
            case 6: {
                string = "MQQT_REMOTE)";
                break;
            }
            default: {
                string = "Unknown!)";
            }
        }
        stringBuilder.append(",QType: " + n + " (" + string);
        stringBuilder.append(",ApplType: " + pCFMessage.getIntParameterValue(1) + " (" + this.applTypeToString(pCFMessage.getIntParameterValue(1)) + ")");
        stringBuilder.append(",ApplName: " + pCFMessage.getStringParameterValue(3024));
        try {
            stringBuilder.append(",ObjectQMgrName: " + pCFMessage.getStringParameterValue(3023));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        try {
            stringBuilder.append(",ConnName: " + pCFMessage.getStringParameterValue(3506));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        try {
            stringBuilder.append(",ChannelName: " + pCFMessage.getStringParameterValue(3501));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        stringBuilder.append("," + this.rtrim(pCFMessage.getStringParameterValue(2015)) + " - " + pCFMessage.getReason() + " - " + WSMQEventBase.pcfReasonToString(pCFMessage.getReason()) + " ==> " + pCFMessage.getStringParameterValue(2016));
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    protected ArrayList displayTransmission_Queue_Usage_Error(PCFMessage pCFMessage) throws PCFException {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ReasonCode: " + pCFMessage.getReason());
        stringBuilder.append(",EventName: Transmission Queue Usage Error - MQRC_XMIT_Q_USAGE_ERROR (2092, X'82C')");
        stringBuilder.append(",EventType: Remote");
        stringBuilder.append(",QMgrName: " + pCFMessage.getStringParameterValue(2015));
        stringBuilder.append(",QName: " + pCFMessage.getStringParameterValue(2016));
        stringBuilder.append(",XmitQName: " + pCFMessage.getStringParameterValue(2024));
        stringBuilder.append(",ApplType: " + pCFMessage.getIntParameterValue(1) + " (" + this.applTypeToString(pCFMessage.getIntParameterValue(1)) + ")");
        stringBuilder.append(",ApplName: " + pCFMessage.getStringParameterValue(3024));
        try {
            stringBuilder.append(",ObjectQMgrName: " + pCFMessage.getStringParameterValue(3023));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        try {
            stringBuilder.append(",ConnName: " + pCFMessage.getStringParameterValue(3506));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        try {
            stringBuilder.append(",ChannelName: " + pCFMessage.getStringParameterValue(3501));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        stringBuilder.append("," + this.rtrim(pCFMessage.getStringParameterValue(2015)) + " - " + pCFMessage.getReason() + " - " + WSMQEventBase.pcfReasonToString(pCFMessage.getReason()) + " ==> " + pCFMessage.getStringParameterValue(2024));
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    protected ArrayList displayUnknown_Alias_Base_Queue(PCFMessage pCFMessage) throws PCFException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = pCFMessage.getIntParameterValue(193);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ReasonCode: " + pCFMessage.getReason());
        stringBuilder.append(",EventName: Unknown Alias Base Queue - MQRC_UNKOWN_ALIAS_BASE_Q (2082, X'822')");
        stringBuilder.append(",EventType: Local");
        stringBuilder.append(",QMgrName: " + pCFMessage.getStringParameterValue(2015));
        stringBuilder.append(",QName: " + pCFMessage.getStringParameterValue(2016));
        stringBuilder.append(",BaseObjectName: " + pCFMessage.getStringParameterValue(2002));
        String string = "";
        switch (n) {
            case 1: {
                string = "MQOT_Q)";
                break;
            }
            case 8: {
                string = "MQOT_TOPIC)";
                break;
            }
            default: {
                string = "Unknown!)";
            }
        }
        stringBuilder.append(",BaseType: " + n + " (" + string);
        stringBuilder.append(",ApplType: " + pCFMessage.getIntParameterValue(1) + " (" + this.applTypeToString(pCFMessage.getIntParameterValue(1)) + ")");
        stringBuilder.append(",ApplName: " + pCFMessage.getStringParameterValue(3024));
        try {
            stringBuilder.append(",ObjectQMgrName: " + pCFMessage.getStringParameterValue(3023));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        try {
            stringBuilder.append(",ConnName: " + pCFMessage.getStringParameterValue(3506));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        try {
            stringBuilder.append(",ChannelName: " + pCFMessage.getStringParameterValue(3501));
        }
        catch (MQException mQException) {
            // empty catch block
        }
        stringBuilder.append("," + this.rtrim(pCFMessage.getStringParameterValue(2015)) + " - " + pCFMessage.getReason() + " - " + WSMQEventBase.pcfReasonToString(pCFMessage.getReason()) + " ==> " + pCFMessage.getStringParameterValue(2002));
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    public void printOut(String string) {
        this.printOut(string, true);
    }

    public void printOut(String string, boolean bl) {
        if (bl) {
            System.out.println(" >> [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + this.MY_SDF.format(new Date()) + " ] : >> " + string);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        this.logToErrorFile("ERROR :", this.reportingName + ":" + this.entity, string);
    }

    public void putInfoMessageToLogfile(String string) {
        this.logToErrorFile("INFO :", this.reportingName + ":" + this.entity, string);
    }

    public void putWarningMessageToLogfile(String string) {
        this.logToErrorFile("WARNING :", this.reportingName + ": " + this.entity, string);
    }

    protected String methodNameTemplate(String string) {
        return "[" + string + "] :";
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.printOut(string2 + string3);
        this.putErrorMessageToLogfile(string2 + string3);
    }
}

