/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgSSL;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.StringTokenizer;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class WebLogicHelperThread
extends Thread {
    private String hostIp;
    private int portNo;
    private Socket s;
    private PrintWriter pw;
    private BufferedReader br;
    public boolean done;
    public int version = 10;
    private boolean isSsl = false;

    public WebLogicHelperThread(String string, int n, boolean bl) {
        this.hostIp = string;
        this.portNo = n;
        this.isSsl = bl;
        this.start();
    }

    public void run() {
        if (this.isSsl) {
            this.discoverSsl();
        } else {
            this.discover();
        }
    }

    public void discoverSsl() {
        String string = null;
        Socket socket = null;
        PrintWriter printWriter = null;
        BufferedReader bufferedReader = null;
        String string2 = null;
        try {
            EgSSL egSSL = EgSSL.getInstance();
            egSSL.enableSSL();
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            Object var8_10 = null;
            MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
            SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
            socket = (SSLSocket)sSLSocketFactory2.createSocket(this.hostIp, this.portNo);
            ((SSLSocket)socket).startHandshake();
            printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())));
            printWriter.println("GET / HTTP/1.0");
            printWriter.println();
            printWriter.flush();
            if (printWriter.checkError()) {
                System.out.println("SSLSocketClient:  java.io.PrintWriter error");
            }
            bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!string2.startsWith("Server:")) continue;
                string = string2;
                break;
            }
            bufferedReader.close();
            printWriter.close();
            socket.close();
            this.getVersion(string);
            this.done = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.done = true;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (printWriter != null) {
                    printWriter.close();
                }
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    public void discover() {
        try {
            this.s = new Socket(this.hostIp, this.portNo);
            this.pw = new PrintWriter(this.s.getOutputStream(), false);
            this.pw.println("GET / HTTP/1.0\r\n\r\n");
            this.pw.flush();
            this.br = new BufferedReader(new InputStreamReader(this.s.getInputStream()));
            String string = null;
            if (this.br != null) {
                String string2 = this.br.readLine();
                while (string2 != null) {
                    if (string2.startsWith("Server:")) {
                        string = string2;
                        break;
                    }
                    string2 = this.br.readLine();
                }
            }
            this.pw.close();
            this.br.close();
            this.s.close();
            this.getVersion(string);
            this.done = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.done = true;
            try {
                if (this.pw != null) {
                    this.pw.close();
                }
                if (this.br != null) {
                    this.br.close();
                }
                if (this.s != null) {
                    this.s.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    public void getVersion(String string) {
        if (string != null) {
            char[] cArray;
            int n = string.indexOf("WebLogic");
            if (n < 0) {
                return;
            }
            String string2 = string.substring(n);
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            if (stringTokenizer.countTokens() < 2) {
                return;
            }
            String string3 = stringTokenizer.nextToken();
            String string4 = "";
            while (!(stringTokenizer.countTokens() <= 0 || (cArray = (string4 = stringTokenizer.nextToken()).toCharArray()) != null && cArray.length != 0 && Character.isDigit(cArray[0]))) {
            }
            int n2 = string4.indexOf(".");
            if (n2 < 0) {
                this.version = 10;
            } else {
                string4 = new String(string4.substring(0, n2));
                try {
                    this.version = Integer.parseInt(string4);
                }
                catch (Exception exception) {
                    this.version = 10;
                }
            }
        }
    }
}

