/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgSSL;
import com.eg.EgURLEncoder;
import com.eg.IPV6Helper;
import com.eg.snmpgetsubtree;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class WebLogicTest
extends EgTest {
    private String mibName = "";
    int timeOut = 10;
    public String community = "public";
    public String username = "none";
    public String authPass = "none";
    public String authType = "none";
    public String snmpVersion = "v1";
    public String encryptType = "none";
    public String encryptPass = "none";
    public boolean isEncryptionEnabled = false;
    private String snmpWalkCmd = "snmpgetsubtree";
    private String uri = "egurkha/egurkhaTest.jsp";
    private String user = "system";
    private String password = "weblogic";
    private int version = 0;
    private String s_useWarFile = "Yes";
    private boolean b_useWarFile = true;
    private String weblogicJarLoc = "";
    private String protocol = "t3";
    private static String wlsServerNameOid = ".1.3.6.1.4.1.140.600.20.1.10";
    private static String wlsServerHeapUsedPctOid = ".1.3.6.1.4.1.140.600.20.1.65";
    private static String wlsServerCurrQLenOid = ".1.3.6.1.4.1.140.600.20.1.70";
    private static String wlsServerTPNameOid = ".1.3.6.1.4.1.140.600.20.1.75";
    private static String listenServerNamesOid = ".1.3.6.1.4.1.140.600.30.1.5";
    private static String listenServerPortsOid = ".1.3.6.1.4.1.140.600.30.1.20";
    private static String listenServerIpsOid = ".1.3.6.1.4.1.140.600.30.1.15";
    private static double MBtoB = 1048576.0;
    private static int throughputIndex = 0;
    private static int pctHeapUsedIndex = 1;
    private static int executeQLenIndex = 2;
    private static int totalHeapIndex = 3;
    private static int heapFreeIndex = 4;
    private String ipAddress = null;
    private int portNumber = 0;
    private long tPut = 0L;
    private long heapUsedPct = 0L;
    private long lenOfExecQ = 0L;
    private String[] lhs;
    private String[] rhs;
    private int reRun = 0;
    private int reDiscoveryCount = 12;
    private String snmpPortNo = "5000";
    private boolean isSsl = false;
    ArrayList serverName;
    ArrayList indexNumber;
    ArrayList throughput;
    ArrayList pctHeapUsed;
    ArrayList currQLength;
    ArrayList listenIndex;
    ArrayList listenNames;
    ArrayList listenPorts;
    ArrayList listenIps;
    long prevRequests = 0L;
    private WebLogicHelperThread sh;
    private long timeout;
    int discCount = 0;
    private boolean isWindowsOS = false;
    private String url = "";
    private String server = "";
    private String str = null;
    private String tempHost = "";
    private Hashtable prevReqMap = new Hashtable();
    boolean useJMX = false;
    protected long jspTimeout;
    boolean useSSLTrustStoreFlag = false;
    String wlSSLTrustKeyStore = null;
    String customTrustKeyStoreFileName = null;
    String customTrustKeyStoreType = null;
    String customTrustKeyStorePassPhrase = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WebLogicTest(String[] stringArray) {
        super(stringArray);
        String string;
        String string2;
        int n;
        int n2;
        this.numOutputFields = 5;
        this.isDynamicInfoTest = true;
        String string3 = null;
        String string4 = "";
        if (stringArray.length < 2 || !stringArray[0].equalsIgnoreCase("-host")) {
            System.err.println("Usage: WebLogicTest -host <targetHost> -port <Port> -snmpPort <snmpPort> -snmpCommunity <community> ");
            return;
        }
        if (this.targetHost == null || this.targetHost.length() <= 0) {
            this.targetHost = new String(stringArray[1]);
        }
        if (stringArray.length > 2) {
            for (n2 = 2; n2 < stringArray.length; ++n2) {
                if (!stringArray[n2].equalsIgnoreCase("-snmpversion")) continue;
                if (++n2 >= stringArray.length) {
                    System.err.println("Usage: EgSnmpTest -host <targetHost> -port <Port> -snmpPort <snmpPort> -snmpCommunity <community>");
                    return;
                }
                this.snmpVersion = new String(stringArray[n2]);
            }
        }
        if (stringArray.length > 2) {
            for (n2 = 2; n2 < stringArray.length; ++n2) {
                if (stringArray[n2].equalsIgnoreCase("-version")) {
                    if (++n2 < stringArray.length && !stringArray[n2].equalsIgnoreCase("none")) {
                        String string5 = stringArray[n2];
                        n = string5.indexOf(".");
                        if (n >= 0) {
                            string5 = string5.substring(0, n);
                        }
                        try {
                            this.version = Integer.parseInt(string5);
                        }
                        catch (Exception exception) {
                            this.version = 0;
                        }
                    }
                } else if (stringArray[n2].equalsIgnoreCase("-jspTimeout")) {
                    if (++n2 >= stringArray.length) {
                        System.err.println("Usage:WebLogicTest -host <targetHost> -port <port> -snmpPort <snmpPort> -snmpCommunity <community> ");
                        return;
                    }
                    string3 = new String(stringArray[n2]);
                } else if (stringArray[n2].equalsIgnoreCase("-port")) {
                    if (++n2 >= stringArray.length) {
                        System.err.println("Usage:WebLogicTest -host <targetHost> -port <port> -snmpPort <snmpPort> -snmpCommunity <community> ");
                        return;
                    }
                    this.portNo = new String(stringArray[n2]);
                } else if (stringArray[n2].equalsIgnoreCase("-snmpPort")) {
                    if (++n2 >= stringArray.length) {
                        System.err.println("Usage:WebLogicTest -host <targetHost> -port <port> -snmpPort <snmpPort> -snmpCommunity <community> ");
                        return;
                    }
                    this.snmpPortNo = new String(stringArray[n2]);
                } else if (stringArray[n2].equalsIgnoreCase("-snmpCommunity")) {
                    if (++n2 >= stringArray.length) {
                        System.err.println("Usage: EgSnmpTest -host <targetHost> -port <Port> -snmpPort <snmpPort> -snmpCommunity <community>");
                        return;
                    }
                    this.community = new String(stringArray[n2]);
                } else if (stringArray[n2].equalsIgnoreCase("-url")) {
                    if (++n2 >= stringArray.length) {
                        System.err.println("Usage:WebLogicTest -host <targetHost> -port <port> -snmpPort <snmpPort> -snmpCommunity <community> ");
                        return;
                    }
                    this.url = new String(stringArray[n2]);
                    this.url = this.transformUrlParam("url", this.url);
                } else if (stringArray[n2].equalsIgnoreCase("-server")) {
                    if (++n2 >= stringArray.length) {
                        System.err.println("Usage:WebLogicTest -host <targetHost> -port <port> -snmpPort <snmpPort> -snmpCommunity <community> ");
                        return;
                    }
                    this.server = new String(stringArray[n2]);
                } else if (stringArray[n2].equalsIgnoreCase("-uri")) {
                    if (++n2 >= stringArray.length) {
                        System.err.println("Usage:WebLogicTest -host <targetHost> -port <port> -snmpPort <snmpPort> -snmpCommunity <community> ");
                        return;
                    }
                    this.uri = new String(stringArray[n2]);
                } else if (stringArray[n2].equalsIgnoreCase("-user")) {
                    if (++n2 >= stringArray.length) {
                        System.err.println("Usage:WebLogicTest -host <targetHost> -port <port> -snmpPort <snmpPort> -snmpCommunity <community> ");
                        return;
                    }
                    this.user = new String(stringArray[n2]);
                } else if (stringArray[n2].equalsIgnoreCase("-password")) {
                    if (++n2 >= stringArray.length) {
                        System.err.println("Usage:WebLogicTest -host <targetHost> -port <port> -snmpPort <snmpPort> -snmpCommunity <community> ");
                        return;
                    }
                    this.password = new String(stringArray[n2]);
                } else if (stringArray[n2].equalsIgnoreCase("-ssl")) {
                    if (++n2 >= stringArray.length) {
                        System.err.println("Usage:WebLogicTest -host <targetHost> -port <port> -snmpPort <snmpPort> -snmpCommunity <community> ");
                        return;
                    }
                    string4 = new String(stringArray[n2]);
                } else if (stringArray[n2].equalsIgnoreCase("-encryptPass")) {
                    if (++n2 >= stringArray.length) {
                        System.err.println("Usage:WebLogicTest -host <targetHost> -port <port> -snmpPort <snmpPort> -snmpCommunity <community> ");
                        return;
                    }
                    this.str = stringArray[n2];
                } else if (stringArray[n2].equalsIgnoreCase("-egMeasHost")) {
                    if (++n2 >= stringArray.length) {
                        System.err.println("Usage:WebLogicTest -host <targetHost> -port <port> -snmpPort <snmpPort> -snmpCommunity <community> ");
                        return;
                    }
                    this.measurementHost = stringArray[n2];
                } else if (stringArray[n2].equalsIgnoreCase("-useWarFile")) {
                    if (++n2 >= stringArray.length) {
                        System.err.println("Usage:WebLogicTest -host <targetHost> -port <port> -snmpPort <snmpPort> -snmpCommunity <community> -useWarFile <Yes/No>");
                        return;
                    }
                    this.s_useWarFile = stringArray[n2];
                    this.b_useWarFile = this.s_useWarFile.equalsIgnoreCase("Yes") || this.s_useWarFile.equalsIgnoreCase("true");
                } else if (stringArray[n2].equalsIgnoreCase("-weblogicJarLocation") && ++n2 < stringArray.length) {
                    this.weblogicJarLoc = stringArray[n2];
                    for (int i = n2 + 1; i < stringArray.length && !stringArray[i].startsWith("-"); ++n2, ++i) {
                        this.weblogicJarLoc = this.weblogicJarLoc + " " + stringArray[i];
                    }
                    if (this.weblogicJarLoc == null || this.weblogicJarLoc.trim().length() == 0) {
                        this.weblogicJarLoc = "";
                    }
                    this.weblogicJarLoc = WLCommandExecute.findAndReplaceString(this.weblogicJarLoc, "\\", "/");
                    this.weblogicJarLoc = this.weblogicJarLoc + "/weblogic.jar";
                }
                if (stringArray[n2].equalsIgnoreCase("-ssl_trust_key_store")) {
                    if (++n2 >= stringArray.length) {
                        System.err.println("Usage:\njava com/eg/snmpgetsubtree -o -w 2 -v 3 -u <username> -a <md5> -A <authpass> -x <encrypttype> -X <encryptpass> targethost oid");
                        return;
                    }
                    this.wlSSLTrustKeyStore = new String(stringArray[n2]);
                    System.out.println(this.reportingName + ":" + this.entity + " :  wlSSLTrustKeyStore is before check  " + this.wlSSLTrustKeyStore);
                    if (this.wlSSLTrustKeyStore == null || this.wlSSLTrustKeyStore.equalsIgnoreCase("none") || this.wlSSLTrustKeyStore.equalsIgnoreCase("null") || this.wlSSLTrustKeyStore.trim().length() == 0) {
                        this.useSSLTrustStoreFlag = false;
                    } else {
                        this.useSSLTrustStoreFlag = true;
                        this.wlSSLTrustKeyStore = this.wlSSLTrustKeyStore.trim();
                        System.out.println(this.reportingName + ":" + this.entity + " :  wlSSLTrustKeyStore is " + this.wlSSLTrustKeyStore);
                    }
                }
                if (stringArray[n2].equalsIgnoreCase("-custom_trust_key_store_file_name")) {
                    if (++n2 >= stringArray.length) {
                        System.err.println("Usage:\njava com/eg/snmpgetsubtree -o -w 2 -v 3 -u <username> -a <md5> -A <authpass> -x <encrypttype> -X <encryptpass> targethost oid");
                        return;
                    }
                    this.customTrustKeyStoreFileName = new String(stringArray[n2]);
                    System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStoreFileName is before check  " + this.customTrustKeyStoreFileName);
                    if (this.customTrustKeyStoreFileName == null || this.customTrustKeyStoreFileName.equalsIgnoreCase("none") || this.customTrustKeyStoreFileName.equalsIgnoreCase("null") || this.customTrustKeyStoreFileName.trim().length() == 0) {
                        System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStoreFileName is null or none   ");
                    } else {
                        this.customTrustKeyStoreFileName = this.customTrustKeyStoreFileName.trim();
                        System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStoreFileName is " + this.customTrustKeyStoreFileName);
                    }
                }
                if (stringArray[n2].equalsIgnoreCase("-custom_trust_key_store_type")) {
                    if (++n2 >= stringArray.length) {
                        System.err.println("Usage:\njava com/eg/snmpgetsubtree -o -w 2 -v 3 -u <username> -a <md5> -A <authpass> -x <encrypttype> -X <encryptpass> targethost oid");
                        return;
                    }
                    this.customTrustKeyStoreType = new String(stringArray[n2]);
                    System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStoreType is before check  " + this.customTrustKeyStoreType);
                    if (this.customTrustKeyStoreType == null || this.customTrustKeyStoreType.equalsIgnoreCase("none") || this.customTrustKeyStoreType.equalsIgnoreCase("null") || this.customTrustKeyStoreType.trim().length() == 0) {
                        System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStoreType is null or none  ");
                    } else {
                        this.customTrustKeyStoreType = this.customTrustKeyStoreType.trim();
                        System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStoreType is " + this.customTrustKeyStoreType);
                    }
                }
                if (stringArray[n2].equalsIgnoreCase("-custom_trust_key_store_pass_phrase")) {
                    if (++n2 >= stringArray.length) {
                        System.err.println("Usage:\njava com/eg/snmpgetsubtree -o -w 2 -v 3 -u <username> -a <md5> -A <authpass> -x <encrypttype> -X <encryptpass> targethost oid");
                        return;
                    }
                    this.customTrustKeyStorePassPhrase = new String(stringArray[n2]);
                    System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStorePassPhrase is before check  " + this.customTrustKeyStorePassPhrase);
                    if (this.customTrustKeyStorePassPhrase == null || this.customTrustKeyStorePassPhrase.equalsIgnoreCase("none") || this.customTrustKeyStorePassPhrase.equalsIgnoreCase("null") || this.customTrustKeyStorePassPhrase.trim().length() == 0) {
                        System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStorePassPhrase is null or none    ");
                        continue;
                    }
                    this.customTrustKeyStorePassPhrase = this.customTrustKeyStorePassPhrase.trim();
                    System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStorePassPhrase is " + this.customTrustKeyStorePassPhrase);
                    continue;
                }
                if (!this.snmpVersion.equalsIgnoreCase("v3")) continue;
                if (stringArray[n2].equalsIgnoreCase("-authuser")) {
                    if (++n2 >= stringArray.length) {
                        System.err.println("Usage:\njava com/eg/snmpgetsubtree -o -w 2 -v 3 -u <username> -a <md5> -A <authpass> -x <encrypttype> -X <encryptpass> targethost oid");
                        return;
                    }
                    this.username = new String(stringArray[n2]);
                }
                if (stringArray[n2].equalsIgnoreCase("-authpass")) {
                    if (++n2 >= stringArray.length) {
                        System.err.println("Usage:\njava com/eg/snmpgetsubtree -o -w 2 -v 3 -u <username> -a <md5> -A <authpass> -x <encrypttype> -X <encryptpass> targethost oid");
                        return;
                    }
                    this.authPass = EgCrypt.decrypt(new String(stringArray[n2]));
                }
                if (stringArray[n2].equalsIgnoreCase("-authtype")) {
                    if (++n2 >= stringArray.length) {
                        System.err.println("Usage:\njava com/eg/snmpgetsubtree -o -w 2 -v 3 -u <username> -a <md5> -A <authpass> -x <encrypttype> -X <encryptpass> targethost oid");
                        return;
                    }
                    this.authType = new String(stringArray[n2]);
                }
                if (stringArray[n2].equalsIgnoreCase("-encryptflag")) {
                    if (++n2 >= stringArray.length) {
                        System.err.println("Usage:\njava com/eg/snmpgetsubtree -o -w 2 -v 3 -u <username> -a <md5> -A <authpass> -x <encrypttype> -X <encryptpass> targethost oid");
                        return;
                    }
                    this.isEncryptionEnabled = new Boolean(stringArray[n2]);
                }
                if (!this.isEncryptionEnabled) continue;
                if (stringArray[n2].equalsIgnoreCase("-encrypttype")) {
                    if (++n2 >= stringArray.length) {
                        System.err.println("Usage:\njava com/eg/snmpgetsubtree -o -w 2 -v 3 -u <username> -a <md5> -A <authpass> -x <encrypttype> -X <encryptpass> targethost oid");
                        return;
                    }
                    this.encryptType = new String(stringArray[n2]);
                }
                if (!stringArray[n2].equalsIgnoreCase("-encryptpassword")) continue;
                if (++n2 >= stringArray.length) {
                    System.err.println("Usage:\njava com/eg/snmpgetsubtree -o -w 2 -v 3 -u <username> -a <md5> -A <authpass> -x <encrypttype> -X <encryptpass> targethost oid");
                    return;
                }
                this.encryptPass = EgCrypt.decrypt(new String(stringArray[n2]));
            }
        }
        if (this.str != null && this.str.equalsIgnoreCase("true")) {
            this.password = EgCrypt.encrypt(this.password, true);
        }
        this.isSsl = string4 != null && (string4.trim().equalsIgnoreCase("true") || string4.trim().equalsIgnoreCase("yes"));
        this.tempHost = IPV6Helper.getValidIPAddress(this.targetHost);
        if (this.url == null || this.url.equals("")) {
            if (this.isSsl) {
                this.url = "https://" + this.tempHost + ":" + this.portNo;
                this.protocol = "t3s";
            } else {
                this.url = "http://" + this.tempHost + ":" + this.portNo;
                this.protocol = "t3";
            }
        } else {
            this.url = this.url.toLowerCase();
            if (this.isSsl) {
                if (this.url.indexOf("https") < 0) {
                    this.url = this.findAndReplaceString(this.url, "http", "https");
                }
                this.protocol = "t3s";
            }
        }
        this.timeOut = 10;
        n2 = 0;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals("-timeout")) continue;
                this.timeOut = Integer.parseInt(stringArray[i + 1]);
                n2 = 1;
                break;
            }
        }
        if (n2 == 0 && (string2 = System.getProperty("SNMPTIMEOUT")) != null) {
            n = 10;
            try {
                n = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.timeOut = n;
        }
        this.snmpWalkCmd = this.snmpWalkCmd + " -t " + this.timeOut + " ";
        if (this.timeout == 0L) {
            this.timeout = 2L * EgConfigInfo.msecPerMin;
        }
        if ((string = System.getProperty("os.name").toLowerCase()).indexOf("win") >= 0) {
            this.isWindowsOS = true;
        }
        long l = this.measurePeriod / 1000L;
        long l2 = l / 3L;
        if (string3 == null || string3.trim().length() == 0 || string3.equalsIgnoreCase("null") || string3.equalsIgnoreCase("none")) {
            this.jspTimeout = l2;
        } else {
            try {
                this.jspTimeout = Long.parseLong(string3);
                if (this.jspTimeout >= l) {
                    this.jspTimeout = l2;
                    System.out.println("[" + this.entity + "] : [" + this.reportingName + "] :  Configured JSP timeout is more than test frequceny, so setting default values " + string3);
                    this.logToErrorFile("Info :", "[" + this.entity + "] : [" + this.reportingName + "] :  Configured JSP timeout is more than test frequceny, so setting default values ", string3);
                }
            }
            catch (Exception exception) {
                this.jspTimeout = l2;
            }
        }
        System.out.println("[" + this.entity + "] : [" + this.reportingName + "] : JSP timeout " + string3);
    }

    public static void main(String[] stringArray) {
        WebLogicTest webLogicTest = new WebLogicTest(stringArray);
        webLogicTest.executeTest();
    }

    public boolean executeTest() {
        try {
            this.initTest();
            if (this.version == 0) {
                this.version = this.discovery();
                if (this.version == 10) {
                    this.version = 9;
                    System.out.println("[WebLogicTest] couldn't find weblogic version hence assuming that weblogic version is 9 or above 9 for host " + this.targetHost);
                    this.logToErrorFile("Info :", "[WebLogicTest] couldn't find weblogic version hence assuming that weblogic version is 9 or above 9 for host ", this.targetHost);
                }
            }
            if (this.version >= 9) {
                this.useJMX = true;
            }
            if (this.useJMX) {
                this.uri = "egurkha/egurkhaTestUsingJMX.jsp";
            }
            if (this.version >= 6) {
                String string = this.siteName + siteAndInfoSeparator + infoFieldSeparator;
                String string2 = this.returnMeasures();
                if (string2 != null && string2.startsWith("eGurkhaNEWPERF")) {
                    string2 = string2.substring("eGurkhaNEWPERF:".length());
                    System.out.println("Values after substring :" + string2);
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                    if (stringTokenizer.countTokens() < 4) {
                        this.prevReqMap = new Hashtable();
                        this.updateAllResultSets();
                        return true;
                    }
                    String string3 = stringTokenizer.nextToken();
                    String string4 = stringTokenizer.nextToken();
                    String string5 = stringTokenizer.nextToken();
                    String string6 = stringTokenizer.nextToken();
                    double d = this.longParse(string5) > 0L ? 100.0 - (double)this.longParse(string6) * 100.0 / (double)this.longParse(string5) : -5.0;
                    this.lenOfExecQ = this.parse(string3);
                    double d2 = 0.0;
                    if (string4.indexOf("#") >= 0) {
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string4, "|");
                        double d3 = 0.0;
                        boolean bl = false;
                        while (stringTokenizer2.hasMoreTokens()) {
                            String string7 = stringTokenizer2.nextToken();
                            int n = string7.indexOf("#");
                            if (n < 0) continue;
                            String string8 = string7.substring(0, n);
                            String string9 = string7.substring(n + 1);
                            long l = -1L;
                            try {
                                l = Long.parseLong(string9);
                            }
                            catch (Exception exception) {
                                continue;
                            }
                            Long l2 = (Long)this.prevReqMap.get(string8);
                            if (l2 == null) {
                                this.prevReqMap.put(string8, new Long(l));
                                continue;
                            }
                            long l3 = l2;
                            long l4 = l - l3;
                            if (l4 >= 0L) {
                                bl = true;
                                d3 += (double)l4;
                            }
                            this.prevReqMap.put(string8, new Long(l));
                        }
                        if (!bl || this.timeSinceLastTest <= 0.0) {
                            d2 = -5.0;
                        } else {
                            d2 = d3 / this.timeSinceLastTest;
                            if (d2 < 0.0) {
                                d2 = -5.0;
                            }
                        }
                    } else {
                        d2 = -5.0;
                    }
                    double d4 = -5.0;
                    double d5 = -5.0;
                    if (this.longParse(string5) >= 0L) {
                        d4 = (double)this.longParse(string5) / MBtoB;
                    }
                    if (this.longParse(string6) >= 0L) {
                        d5 = (double)this.longParse(string6) / MBtoB;
                    }
                    this.addValueToResultSet(string, throughputIndex, d2);
                    this.addValueToResultSet(string, pctHeapUsedIndex, d);
                    this.addValueToResultSet(string, executeQLenIndex, this.lenOfExecQ);
                    this.addValueToResultSet(string, totalHeapIndex, d4);
                    this.addValueToResultSet(string, heapFreeIndex, d5);
                } else if (string2 != null && string2.startsWith("eGurkhaWLPERF")) {
                    string2 = string2.substring("eGurkhaWLPERF:".length());
                    System.out.println("Values after substring :" + string2);
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                    if (stringTokenizer.countTokens() != 4) {
                        this.prevRequests = -1L;
                        this.updateAllResultSets();
                        return true;
                    }
                    String string10 = stringTokenizer.nextToken();
                    String string11 = stringTokenizer.nextToken();
                    String string12 = stringTokenizer.nextToken();
                    String string13 = stringTokenizer.nextToken();
                    double d = this.longParse(string12) > 0L ? 100.0 - (double)this.longParse(string13) * 100.0 / (double)this.longParse(string12) : 0.0;
                    this.lenOfExecQ = this.parse(string10);
                    double d6 = 0.0;
                    d6 = this.timeSinceLastTest == 0.0 || this.timeSinceLastTest == -1.0 || this.prevRequests < 0L ? -1.0 : ((d6 = (double)(this.longParse(string11) - this.prevRequests) / this.timeSinceLastTest) < 0.0 ? -1.0 : d6);
                    double d7 = -5.0;
                    double d8 = -5.0;
                    if (this.longParse(string12) >= 0L) {
                        d7 = (double)this.longParse(string12) / MBtoB;
                    }
                    if (this.longParse(string13) >= 0L) {
                        d8 = (double)this.longParse(string13) / MBtoB;
                    }
                    this.prevRequests = this.longParse(string11);
                    this.addValueToResultSet(string, throughputIndex, d6);
                    this.addValueToResultSet(string, pctHeapUsedIndex, d);
                    this.addValueToResultSet(string, executeQLenIndex, this.lenOfExecQ);
                    this.addValueToResultSet(string, totalHeapIndex, d7);
                    this.addValueToResultSet(string, heapFreeIndex, d8);
                } else {
                    this.prevRequests = -1L;
                }
            } else if (this.version == 5) {
                if (this.reRun == 0) {
                    this.findWlsServers();
                }
                if (this.serverName.size() == 0) {
                    this.updateAllResultSets();
                    this.reRun = 0;
                    return true;
                }
                ++this.reRun;
                if (this.reRun >= this.reDiscoveryCount) {
                    this.reRun = 0;
                }
                this.findWlsServerStats();
                String string = null;
                boolean bl = false;
                for (int i = 0; i < this.serverName.size(); ++i) {
                    for (int j = 0; j < this.listenNames.size(); ++j) {
                        String string14;
                        int n;
                        if (!((String)this.listenNames.get(j)).equals((String)this.serverName.get(i)) || (n = this.parse(this.listenPorts.get(j))) <= 0 || !(string14 = (String)this.listenPorts.get(j)).equals(this.portNo)) continue;
                        string = this.siteName + siteAndInfoSeparator + infoFieldSeparator;
                        this.tPut = this.longParse((String)this.throughput.get(i));
                        this.heapUsedPct = this.longParse((String)this.pctHeapUsed.get(i));
                        this.lenOfExecQ = this.longParse((String)this.currQLength.get(i));
                        this.addValueToResultSet(string, throughputIndex, this.tPut);
                        this.addValueToResultSet(string, pctHeapUsedIndex, this.heapUsedPct);
                        this.addValueToResultSet(string, executeQLenIndex, this.lenOfExecQ);
                        this.addValueToResultSet(string, totalHeapIndex, 0.0);
                        this.addValueToResultSet(string, heapFreeIndex, 0.0);
                    }
                }
            } else {
                System.out.println("WebLogic version number is unknown!");
            }
            this.updateAllResultSets();
            return true;
        }
        catch (Exception exception) {
            this.logToErrorFile("Error", "WebLogicTest===executeTest() methods...", exception.toString());
            return false;
        }
    }

    public void findWlsServers() {
        this.indexNumber = new ArrayList();
        this.serverName = new ArrayList();
        this.listenIndex = new ArrayList();
        this.listenNames = new ArrayList();
        this.listenPorts = new ArrayList();
        this.listenIps = new ArrayList();
        this.runSnmpCmdForOid(wlsServerNameOid);
        this.assignLhsAndRhs(this.indexNumber, this.serverName);
        if (this.serverName.size() > 0) {
            this.findListenEntries();
        }
    }

    public void findWlsServerStats() {
        this.runSnmpCmdForOid(wlsServerTPNameOid);
        this.throughput = new ArrayList();
        this.assignRhs(this.throughput, this.indexNumber);
        this.runSnmpCmdForOid(wlsServerHeapUsedPctOid);
        this.pctHeapUsed = new ArrayList();
        this.assignRhs(this.pctHeapUsed, this.indexNumber);
        this.runSnmpCmdForOid(wlsServerCurrQLenOid);
        this.currQLength = new ArrayList();
        this.assignRhs(this.currQLength, this.indexNumber);
    }

    public void findListenEntries() {
        this.runSnmpCmdForOid(listenServerNamesOid);
        this.assignLhsAndRhs(this.listenIndex, this.listenNames);
        this.runSnmpCmdForOid(listenServerPortsOid);
        this.assignRhs(this.listenPorts, this.listenIndex);
        this.runSnmpCmdForOid(listenServerIpsOid);
        this.assignRhs(this.listenIps, this.listenIndex);
    }

    private int parse(Object object) {
        if ((String)object == null || ((String)object).equals("")) {
            return -1;
        }
        return Integer.parseInt((String)object);
    }

    private long longParse(String string) {
        if (string == null || string.equals("")) {
            return -1L;
        }
        return Long.parseLong(string);
    }

    public void assignRhs(ArrayList arrayList, ArrayList arrayList2) {
        for (int i = 0; i < arrayList2.size(); ++i) {
            boolean bl = false;
            for (int j = 0; j < this.lhs.length; ++j) {
                if (!this.lhs[j].equals((String)arrayList2.get(i))) continue;
                arrayList.add(this.rhs[j]);
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add("");
        }
    }

    public void assignLhsAndRhs(ArrayList arrayList, ArrayList arrayList2) {
        int n;
        for (n = 0; n < this.lhs.length; ++n) {
            arrayList.add(this.lhs[n]);
        }
        for (n = 0; n < this.rhs.length; ++n) {
            arrayList2.add(this.rhs[n]);
        }
    }

    public boolean runSnmpCmdForOid(String string) {
        String[] stringArray = null;
        stringArray = this.snmpVersion.equalsIgnoreCase("v1") || this.snmpVersion.equalsIgnoreCase("v2") ? new String[]{"-p", "" + this.snmpPortNo, "-c", this.community, "-o", "-v", this.snmpVersion.equalsIgnoreCase("v1") ? "1" : "2", this.targetHost, string} : (!this.isEncryptionEnabled ? new String[]{"-o", "-w", "2", "-v", "3", "-p", "" + this.snmpPortNo, "-u", this.username, "-a", this.authType, "-A", this.authPass, this.targetHost, string} : new String[]{"-o", "-w", "2", "-v", "3", "-p", "" + this.snmpPortNo, "-u", this.username, "-a", this.authType, "-A", this.authPass, "-x", this.encryptType, "-X", this.encryptPass, this.targetHost, string});
        snmpgetsubtree snmpgetsubtree2 = new snmpgetsubtree(stringArray, this.timeOut);
        ArrayList arrayList = snmpgetsubtree2.getSubTree();
        this.lhs = null;
        this.rhs = null;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        this.mibName = string;
        if (arrayList != null && arrayList.size() > 0) {
            int n;
            int n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                int n3;
                String string2 = ((String)arrayList.get(n)).trim();
                if (!string2.startsWith(string) || (n3 = string2.indexOf(61)) < 0) continue;
                String string3 = string2.substring(0, n3);
                String string4 = string2.substring(n3 + 1);
                String string5 = this.replace(string3, string, "");
                if (string5.length() > 0) {
                    string5 = new String(string5.substring(1));
                }
                if (string4.startsWith("\"")) {
                    String string6;
                    int n4 = string4.lastIndexOf("\"");
                    while (n4 <= 0 && ++n < n2 && (string6 = (String)arrayList.get(n)) != null) {
                        string4 = string4 + " " + string6;
                        n4 = string4.lastIndexOf("\"");
                    }
                    string4 = new String(string4.substring(1, n4));
                }
                arrayList2.add(string4);
                arrayList3.add(string5);
            }
            Object[] objectArray = arrayList2.toArray();
            this.rhs = new String[objectArray.length];
            for (n = 0; n < objectArray.length; ++n) {
                this.rhs[n] = objectArray[n].toString();
            }
            objectArray = arrayList3.toArray();
            this.lhs = new String[objectArray.length];
            for (n = 0; n < objectArray.length; ++n) {
                this.lhs[n] = objectArray[n].toString();
            }
            return this.lhs.length > 0;
        }
        this.errorMsg = new String("Failed to run " + this.snmpWalkCmd + " for " + this.reportingName + " with community " + this.community + " and MIB=" + this.mibName);
        System.out.println("From EgSnmpTest :" + this.errorMsg);
        return false;
    }

    private String replace(String string, String string2, String string3) {
        int n;
        do {
            if ((n = string.indexOf(string2)) == -1) continue;
            String string4 = string.substring(0, n);
            string4 = string4 + string3;
            string = string4 = string4 + string.substring(n + string2.length());
        } while (n != -1);
        return string;
    }

    private String returnMeasures() {
        try {
            if (!this.b_useWarFile) {
                if (this.targetHost == null || this.targetHost.trim().length() == 0 || this.portNo == null || this.portNo.trim().length() == 0 || this.server == null || this.server.trim().length() == 0 || this.user == null || this.user.trim().length() == 0 || this.password == null) {
                    this.logToErrorFile("Error", "WebLogicTest", "Invalid arguments " + this.targetHost + " " + this.portNo + " " + this.server + " " + this.user);
                    return new String();
                }
                if (this.version == 0) {
                    this.version = 9;
                }
                WLCommandExecute wLCommandExecute = new WLCommandExecute();
                if (this.useSSLTrustStoreFlag) {
                    wLCommandExecute.setWebLogicSSLTrustKeyStore(this.wlSSLTrustKeyStore, this.customTrustKeyStoreFileName, this.customTrustKeyStoreType, this.customTrustKeyStorePassPhrase);
                    System.out.println(this.reportingName + ":" + this.entity + " : Calling the method with SSL Truststore and  wlSSLTrustKeyStore is " + this.wlSSLTrustKeyStore);
                }
                ArrayList arrayList = new ArrayList();
                arrayList = wLCommandExecute.executeProgram(this.weblogicJarLoc, this.targetHost, this.portNo, this.user, this.password, this.server, this.protocol, "getWeblogicTestStats", this.version);
                String string = "";
                if (arrayList == null || arrayList.size() == 0) {
                    return string;
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string2 = (String)arrayList.get(i);
                    if (!string2.startsWith("eGurkhaWLPERF") && !string2.startsWith("eGurkhaNEWPERF")) continue;
                    string = new String(string2);
                    break;
                }
                return string;
            }
            String string = "";
            HttpURLConnection httpURLConnection = null;
            Object var3_7 = null;
            Object var4_9 = null;
            URL uRL = null;
            System.out.println(this.entity + ":" + this.reportingName + " version : " + this.version + " URI : " + this.uri);
            if (this.isSsl) {
                String string3 = this.url + "/" + this.uri + "?name=egurkha&name1=monitoring&user=" + this.user + "&password=" + EgURLEncoder.encode(this.password, "UTF-8") + "&host=" + this.targetHost + "&port=" + this.portNo;
                String string4 = this.url + "/" + this.uri + "?name=egurkha&name1=monitoring&user=" + this.user + "&password=********&host=" + this.targetHost + "&port=" + this.portNo;
                if (!this.server.equals("")) {
                    string3 = string3 + "&server=" + this.server + "&timeout=" + this.jspTimeout;
                    string4 = string4 + "&server=" + this.server + "&timeout=" + this.jspTimeout;
                }
                System.out.println("[" + this.reportingName + ":" + this.entity + "]  measureUri : " + string4);
                EgSSL egSSL = EgSSL.getInstance();
                egSSL.enableSSL();
                SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                Object var10_21 = null;
                try {
                    MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                    KeyManager[] keyManagerArray = null;
                    TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
                    SSLContext sSLContext = SSLContext.getInstance("SSL");
                    sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                    SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
                    HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
                    HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
                    uRL = new URL(string3);
                    httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection.connect();
                    ConnectionThread connectionThread = new ConnectionThread(httpURLConnection, false);
                    ArrayList arrayList = null;
                    int n = 0;
                    boolean bl = this.checkForTimeout(connectionThread);
                    if (bl) {
                        n = connectionThread.code;
                        arrayList = connectionThread.data;
                    }
                    connectionThread = null;
                    httpURLConnection.disconnect();
                    httpURLConnection = null;
                    if (!bl || n != 200) {
                        return null;
                    }
                    if (arrayList == null || arrayList.size() == 0) {
                        return null;
                    }
                    for (int i = 0; i < arrayList.size(); ++i) {
                        String string5 = (String)arrayList.get(i);
                        if (!string5.startsWith("eGurkhaWLPERF") && !string5.startsWith("eGurkhaNEWPERF")) continue;
                        string = new String(string5);
                    }
                }
                catch (Exception exception) {
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                    return null;
                }
            } else {
                String string6 = this.url + "/" + this.uri + "?name=egurkha&name1=monitoring&user=" + this.user + "&password=" + EgURLEncoder.encode(this.password, "UTF-8") + "&host=" + this.targetHost + "&port=" + this.portNo;
                String string7 = this.url + "/" + this.uri + "?name=egurkha&name1=monitoring&user=" + this.user + "&password=********&host=" + this.targetHost + "&port=" + this.portNo;
                if (!this.server.equals("")) {
                    string6 = string6 + "&server=" + this.server + "&timeout=" + this.jspTimeout;
                    string7 = string7 + "&server=" + this.server + "&timeout=" + this.jspTimeout;
                }
                System.out.println("[" + this.reportingName + ":" + this.entity + "]  measureUri : " + string7);
                try {
                    uRL = new URL(string6);
                    httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection.connect();
                    ConnectionThread connectionThread = new ConnectionThread(httpURLConnection, false);
                    ArrayList arrayList = null;
                    int n = 0;
                    boolean bl = this.checkForTimeout(connectionThread);
                    if (bl) {
                        n = connectionThread.code;
                        arrayList = connectionThread.data;
                    }
                    connectionThread = null;
                    httpURLConnection.disconnect();
                    httpURLConnection = null;
                    if (!bl || n != 200) {
                        return null;
                    }
                    if (arrayList == null || arrayList.size() == 0) {
                        return null;
                    }
                    for (int i = 0; i < arrayList.size(); ++i) {
                        String string8 = (String)arrayList.get(i);
                        if (!string8.startsWith("eGurkhaWLPERF") && !string8.startsWith("eGurkhaNEWPERF")) continue;
                        string = new String(string8);
                        break;
                    }
                }
                catch (Exception exception) {
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                    return null;
                }
            }
            return string;
        }
        catch (Exception exception) {
            this.logToErrorFile("Error", "WebLogicTest===returnMeasures() methods...", exception.toString());
            return null;
        }
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        do {
            if (l3 < EgAgentCommon.minimumSleep) {
                l3 = EgAgentCommon.minimumSleep;
            }
            this.suspendForPeriod(l3);
            if (connectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= this.timeout) {
                connectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                connectionThread.stop();
                return false;
            }
            l = l3;
            if (this.timeout - l2 >= l) continue;
            l = this.timeout - l2;
        } while ((l3 = l) > 0L);
        connectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        connectionThread.stop();
        return false;
    }

    public int discovery() {
        long l;
        this.sh = new WebLogicHelperThread(this.targetHost, Integer.parseInt(this.portNo), this.isSsl);
        long l2 = 0L;
        long l3 = 5L;
        do {
            if (this.sh.done) {
                return this.sh.version;
            }
            this.suspendForPeriod(l3);
            if ((l2 += l3) >= this.timeout) {
                this.sh.stop();
                this.sh = null;
                return 0;
            }
            l = l3 * 2L;
            if (this.timeout - l2 >= l) continue;
            l = this.timeout - l2;
        } while ((l3 = l) > 0L);
        this.sh.stop();
        this.sh = null;
        return 0;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    private String findAndReplaceString(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        while (string.indexOf(string2) > -1) {
            stringBuffer.append(string.substring(0, string.indexOf(string2)) + string3);
            string = string.substring(string.indexOf(string2) + string2.length(), string.length());
        }
        if (string.length() > 0) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

