/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;

public class ZoneMonitor
extends Thread {
    public ZoneHelper znh = ZoneHelper.getInstance();
    public static ZoneMonitor zoneMon = null;
    private static ArrayList zoneNames = null;
    private static String sync = new String("sync");
    private boolean _bThreadStarted = false;
    long lastUpdateTime = 0L;
    long lastGlobalZoneCheckTime = 0L;
    private String prefix = "sudo";

    private ZoneMonitor(String string) {
        this.prefix = string;
        System.out.println("[ZoneMonitor] this.prefix is " + this.prefix + " prefix is " + string);
        this.start();
    }

    public static synchronized ZoneMonitor getInstance(String string) {
        if (zoneMon == null) {
            zoneMon = new ZoneMonitor(string);
        }
        zoneMon.resetPrefix(string);
        return zoneMon;
    }

    private void resetPrefix(String string) {
        this.prefix = string;
    }

    public boolean isUpdated(ArrayList arrayList) {
        if (zoneNames == null) {
            return false;
        }
        return arrayList != this.getAllZoneList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getAllZoneList() {
        String string = sync;
        synchronized (string) {
            return zoneNames;
        }
    }

    public void run() {
        this._bThreadStarted = true;
        while (true) {
            try {
                long l = System.currentTimeMillis();
                if ((double)(l - this.lastGlobalZoneCheckTime) > (double)(ZoneCommands.CACHE_PERIOD * EgConfigInfo.msecPerMin) / 2.0) {
                    System.out.println("[ZoneMonitor] calling isValid method at " + new Date());
                    this.lastGlobalZoneCheckTime = l;
                    if (!this.isValid()) {
                        return;
                    }
                }
                if (l - this.lastUpdateTime > ZoneCommands.CACHE_PERIOD * EgConfigInfo.msecPerMin) {
                    this.findZoneNames();
                    this.lastUpdateTime = l;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                Thread.sleep(10000L);
            }
            catch (Exception exception) {
            }
        }
    }

    public static String[] split(String string, String string2) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringArray[n] = stringTokenizer.nextElement().toString();
            ++n;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findZoneNames() {
        int n = 1;
        String[] stringArray = null;
        Object var3_3 = null;
        String string = ZoneCommands.getZoneInfo();
        ArrayList arrayList = ZoneHelper.getCommandOutput(string);
        if (arrayList == null || arrayList.size() <= 0) {
            System.out.println("[ZoneMonitor] output of " + string + " is null");
            return;
        }
        ArrayList<Zones> arrayList2 = new ArrayList<Zones>();
        for (int i = n; i < arrayList.size(); ++i) {
            String string2 = arrayList.get(i).toString().trim();
            stringArray = ZoneMonitor.split(string2, ":");
            Zones zones = new Zones();
            if (stringArray == null || stringArray.length < 2) continue;
            zones.setZoneName(stringArray[1]);
            zones.setStatus(stringArray[2]);
            string = ZoneCommands.getZoneIpaddress(stringArray[1], this.prefix);
            ArrayList arrayList3 = ZoneHelper.getCommandOutput(string);
            if (arrayList3 == null || arrayList3.size() <= 0) {
                zones.setIpAddress("-");
            } else {
                zones.setIpAddress(arrayList3.get(0) + "");
            }
            string = ZoneCommands.getZoneTestCommands(zones, 6, this.prefix);
            ArrayList arrayList4 = ZoneHelper.getCommandOutput(string);
            if (arrayList4 == null || arrayList4.size() <= 0) {
                zones.setOsName("-");
            } else {
                zones.setOsName(arrayList4.get(0) + "");
            }
            string = ZoneCommands.getZoneNWInterface(stringArray[1]);
            ArrayList arrayList5 = ZoneHelper.getCommandOutput(string);
            if (arrayList5 == null || arrayList5.size() <= 0) {
                zones.setNtInterface("-");
            } else {
                zones.setNtInterface(arrayList5.get(0) + "");
            }
            arrayList2.add(zones);
        }
        String string3 = sync;
        synchronized (string3) {
            zoneNames = arrayList2;
        }
    }

    public boolean isValid() {
        boolean bl = true;
        String string = ZoneCommands.checkForValidOs();
        ArrayList arrayList = ZoneHelper.getCommandOutput(string);
        if (arrayList == null || arrayList.size() == 0) {
            System.out.println("[ZoneMonitor] output of " + arrayList + " is null");
            return false;
        }
        String string2 = arrayList.get(0).toString().trim();
        if (string2 != null && string2.equals("global")) {
            bl = true;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        ZoneMonitor zoneMonitor = ZoneMonitor.getInstance("sudo");
        try {
            ZoneMonitor.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList arrayList = zoneMonitor.getAllZoneList();
        for (int i = 0; i < arrayList.size(); ++i) {
            Zones zones = (Zones)arrayList.get(i);
        }
    }
}

