/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class ZoneTcpTest
extends GenericTest {
    ZoneHelper znh = ZoneHelper.getInstance();
    ZoneMonitor zoneMon = null;
    public String prefix = "sudo";

    public ZoneTcpTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(1);
        String string = this.getValueForParam("connect_using");
        if (string != null && string.length() > 0) {
            this.prefix = string;
        }
        this.zoneMon = ZoneMonitor.getInstance(this.prefix);
    }

    public void computeMeasures(Hashtable hashtable) {
        Object var2_2 = null;
        ArrayList arrayList = null;
        arrayList = this.zoneMon.getAllZoneList();
        this.parse(arrayList);
    }

    public void parse(ArrayList arrayList) {
        String string = null;
        ArrayList arrayList2 = null;
        if (arrayList == null || arrayList.size() <= 0) {
            System.out.println("[ZoneTcpTest] failed to get zone names on server!");
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            int n;
            Double d = new Double(0.0);
            Zones zones = (Zones)arrayList.get(i);
            string = ZoneCommands.getZoneTestCommands(zones, 3, this.prefix);
            arrayList2 = ZoneHelper.getCommandOutput(string);
            int n2 = n = arrayList2 != null && arrayList2.size() > 0 ? arrayList2.size() : 0;
            if (n == 0) {
                System.out.println("[ZoneTcpTest] No output for zoneName: " + zones.getZoneName() + "'s command - " + string);
                continue;
            }
            for (int j = 0; j < n; ++j) {
                String string2 = (String)arrayList2.get(j);
                d = new Double(string2.substring(string2.indexOf("=") + 1, string2.indexOf("tcpOutSegs")).trim());
                String string3 = zones.getZoneName();
                ArrayList<Double> arrayList3 = new ArrayList<Double>();
                arrayList3.add(d);
                this.addNewMeasure(string3, arrayList3);
            }
        }
    }

    public static void main(String[] stringArray) {
        ZoneTcpTest zoneTcpTest = new ZoneTcpTest(stringArray);
        try {
            while (true) {
                zoneTcpTest.computeMeasures(new Hashtable());
                Thread.currentThread();
                Thread.sleep(10000L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Exceptione ==>" + exception);
            return;
        }
    }
}

