/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ZoneUptimeTest
extends GenericTest {
    private static final double DAY = 86400.0;
    private static final double HOUR = 3600.0;
    private static final double MINUTES = 60.0;
    private double currSysuptime = 0.0;
    private double prevSysuptime = 0.0;
    private Hashtable uptimeList = null;
    private String tempFileName = EgInstallInfo.getInstallDir() + "/lib/sysUptime_" + this.reportingName + ".properties";
    private File fileName = null;
    ZoneHelper znh = ZoneHelper.getInstance();
    ZoneMonitor zoneMon = null;
    public String prefix = "sudo";

    public ZoneUptimeTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(3);
        if (new File(this.tempFileName).exists()) {
            new File(this.tempFileName).delete();
        }
        this.fileName = new File(this.tempFileName);
        this.fixedTestPeriod = true;
        String string = this.getValueForParam("connect_using");
        if (string != null && string.length() > 0) {
            this.prefix = string;
        }
        this.zoneMon = ZoneMonitor.getInstance(this.prefix);
    }

    void debug(String string) {
        this.logToErrorFile("ZoneUptimeTest", "INFO", new Date() + " " + string);
    }

    public void computeMeasures(Hashtable hashtable) {
        Object var2_2 = null;
        ArrayList arrayList = null;
        arrayList = this.zoneMon.getAllZoneList();
        this.parse(arrayList);
        this.znh.writeDoubleToFile(this.uptimeList, this.fileName);
    }

    public void parse(ArrayList arrayList) {
        Object object;
        Object object2;
        Object object3;
        int n;
        Hashtable<Object, Double> hashtable = new Hashtable<Object, Double>();
        String string = null;
        ArrayList arrayList2 = null;
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        if (arrayList == null || arrayList.size() == 0) {
            System.out.println("[ZoneUptimeTest] output of  out object is null");
            this.debug("output of  out object is null");
            return;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object3 = (Zones)arrayList.get(n);
            object2 = ((Zones)object3).getZoneName();
            object = ((Zones)object3).getStatus().trim();
            string = ZoneCommands.getZoneTestCommands((Zones)object3, 8, this.prefix);
            arrayList2 = ZoneHelper.getCommandOutput(string);
            System.out.println("ZoneUptimeTest - For zone " + ((Zones)arrayList.get(n)).getZoneName() + " status " + (String)object + " command " + string + " out " + arrayList2);
            if (object != null && ((String)object).equals("running")) {
                hashtable.put(object2, new Double(this.getZoneUptime(arrayList2)));
                continue;
            }
            if (object == null || !((String)object).equals("installed")) continue;
            hashtable.put(object2, new Double(-0.5));
        }
        this.uptimeList = (Hashtable)hashtable.clone();
        if (hashtable == null || hashtable.size() == 0 || !this.fileName.exists()) {
            for (n = 0; n < arrayList.size(); ++n) {
                object3 = (Zones)arrayList.get(n);
                object2 = ((Zones)object3).getStatus().trim();
                if (object2 == null || !((String)object2).equals("running")) continue;
                arrayList3 = new ArrayList();
                arrayList3.add(new Double(-5.0));
                arrayList3.add(new Double(-5.0));
                arrayList3.add(new Double(-5.0));
                object = ((Zones)object3).getZoneName();
                this.addNewMeasure((String)object, arrayList3);
            }
            return;
        }
        if (hashtable == null || hashtable.size() == 0) {
            System.out.println("[ZoneUptimeTest] output of  uptimeVal is null");
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2;
            object3 = (String)enumeration.nextElement();
            object2 = (Double)hashtable.get(object3);
            if (object2 != null) {
                this.currSysuptime = (Double)object2;
            }
            if ((object = this.znh.readDoubleFromFile(this.fileName)) != null && ((Hashtable)object).containsKey(object3) && (string2 = (String)((Hashtable)object).get(object3)) != null) {
                try {
                    this.prevSysuptime = Double.parseDouble(string2);
                }
                catch (Exception exception) {
                    this.prevSysuptime = -5.0;
                }
            }
            arrayList3 = new ArrayList();
            if (this.currSysuptime == -0.5) continue;
            if (this.currSysuptime == -0.1) {
                arrayList3.add(new Double(-1.0));
                arrayList3.add(new Double(-1.0));
                arrayList3.add(new Double(-1.0));
                this.debug("output of  uptimeVal is null for" + (String)object3 + "====>" + arrayList3);
            } else if (this.currSysuptime < this.prevSysuptime) {
                arrayList3.add(new Double(1.0));
                arrayList3.add(new Double(this.currSysuptime));
                double d = this.currSysuptime / 60.0;
                arrayList3.add(new Double(d));
            } else if (this.currSysuptime > 0.0) {
                if (this.prevSysuptime == -0.5) {
                    arrayList3.add(new Double(1.0));
                    arrayList3.add(new Double(this.currSysuptime));
                    double d = this.currSysuptime / 60.0;
                    arrayList3.add(new Double(d));
                    this.debug((String)object3 + "is rebooted" + arrayList3);
                } else if (this.prevSysuptime == -0.1) {
                    arrayList3.add(new Double(-5.0));
                    arrayList3.add(new Double(-5.0));
                    double d = this.currSysuptime / 60.0;
                    arrayList3.add(new Double(d));
                    this.debug((String)object3 + "command is running successfully" + arrayList3);
                } else {
                    arrayList3.add(new Double(0.0));
                    double d = 0.0;
                    d = this.currSysuptime - this.prevSysuptime;
                    arrayList3.add(new Double(d));
                    double d2 = this.currSysuptime / 60.0;
                    arrayList3.add(new Double(d2));
                }
            }
            this.prevSysuptime = this.currSysuptime;
            this.addNewMeasure((String)object3, arrayList3);
        }
    }

    public double getZoneUptime(ArrayList arrayList) {
        double[] dArray;
        block9: {
            int n;
            String string;
            dArray = null;
            ArrayList arrayList2 = new ArrayList();
            if (arrayList == null || arrayList.size() == 0) {
                System.out.println("[ZoneUptimeTest] getZoneUptime out object is null");
                this.debug("getZoneUptime out object is null");
                return -0.1;
            }
            System.out.println("ZoneUptimeTest ... to get uptime for " + arrayList);
            int n2 = 0;
            if (n2 >= arrayList.size()) break block9;
            String string2 = "0";
            String string3 = "0";
            String string4 = "";
            String string5 = arrayList.get(n2).toString().trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string5);
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            if (string5.indexOf("day") >= 0) {
                string2 = stringTokenizer.nextToken();
                stringTokenizer.nextToken();
            }
            if (string5.indexOf("hr") >= 0) {
                string3 = stringTokenizer.nextToken();
                stringTokenizer.nextToken();
            }
            if ((string = stringTokenizer.nextToken()).endsWith(",")) {
                string = string.substring(0, string.length() - 1);
            }
            if ((n = string.indexOf(":")) < 0) {
                if (string != null && string.length() > 0) {
                    string4 = string;
                }
            } else {
                string3 = string.substring(0, n);
                string4 = string.substring(n + 1);
            }
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            try {
                d = Double.parseDouble(string2);
                d2 = Double.parseDouble(string3);
                d3 = Double.parseDouble(string4);
            }
            catch (Exception exception) {
                System.out.println("[ZoneUptimeTest] getZoneUptime Exception ===>" + exception);
            }
            dArray = new double[2];
            dArray[0] = d * 86400.0 + d2 * 3600.0 + d3 * 60.0;
        }
        return (double)dArray[0];
    }

    public static void main(String[] stringArray) {
        ZoneUptimeTest zoneUptimeTest = new ZoneUptimeTest(stringArray);
        try {
            while (true) {
                zoneUptimeTest.computeMeasures(new Hashtable());
                Thread.currentThread();
                Thread.sleep(10000L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Exceptione ==>" + exception);
            return;
        }
    }
}

