/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.X509TrustManager;

public class CompositeX509TrustManager
implements X509TrustManager {
    private final List<X509TrustManager> trustManagers;

    public CompositeX509TrustManager(List list) {
        this.trustManagers = ImmutableList.copyOf((Collection)list);
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        for (X509TrustManager x509TrustManager : this.trustManagers) {
            try {
                x509TrustManager.checkClientTrusted(x509CertificateArray, string);
                return;
            }
            catch (CertificateException certificateException) {
            }
        }
        throw new CertificateException("None of the TrustManagers trust this certificate chain");
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        for (X509TrustManager x509TrustManager : this.trustManagers) {
            try {
                x509TrustManager.checkServerTrusted(x509CertificateArray, string);
                return;
            }
            catch (CertificateException certificateException) {
            }
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (X509TrustManager x509TrustManager : this.trustManagers) {
            builder.add((Object[])x509TrustManager.getAcceptedIssuers());
        }
        return (X509Certificate[])Iterables.toArray((Iterable)builder.build(), X509Certificate.class);
    }
}

