/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.IniHelper;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.EgApmFilesSync;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.time.DurationFormatUtils;

public class APMCleanUpUtils {
    private static final String loggerDispStr = "[APMCleanUpUtils] [INI-Cleanup]";
    private static final String JAVA_UNIQUE_GUID_MAPPING = "JAVA_UNIQUE_GUID_MAPPING";
    private static final String JAVA_SERVER_DETAILS_HTTP_CALL_DONE = "JAVA_SERVER_DETAILS_HTTP_CALL_DONE";
    private static final String COLON = ":";
    private static final String CAP = "^";
    private static final String AUTO_DELETE_FILEPATH = File.separator + "tmp" + File.separator + "java_apm_temp" + File.separator;
    private static final String APMDISCOVERY = File.separator + "agent" + File.separator + "config" + File.separator + "eg_apmdiscovery.ini";
    private static long apmDiscoveryStartTimeStamp = -1L;
    private static long apmDiscoveryExecutionTime = -1L;
    private static long apmDiscoveryIniCleanUpTime = 6L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAgentAPMIniEntry(String string, List list) {
        APMDiscoveryLogger.discoveryLogger.debug("{} Delete from {}  : {}", new Object[]{loggerDispStr, string, list});
        IniFile iniFile = null;
        try {
            iniFile = EgApmFilesSync.getInstance(string, true);
            if (list != null && list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    IniHelper iniHelper = (IniHelper)list.get(i);
                    String string2 = iniHelper.getSubject();
                    String string3 = iniHelper.getVariable();
                    iniFile.deleteValue(string2, string3);
                }
                iniFile.deleteSubject(JAVA_SERVER_DETAILS_HTTP_CALL_DONE);
            }
            list.clear();
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.error("{} Unable to delete entries ", (Object)loggerDispStr, (Object)exception);
        }
        finally {
            if (iniFile != null) {
                iniFile.saveFile();
                EgApmFilesSync.releaseInstance(iniFile);
            }
        }
    }

    public static String getTrashFileName() {
        String string = "trash_" + new SimpleDateFormat("MMMMyyyy").format(new Date()).toLowerCase() + ".ini";
        try {
            File file;
            if (ApmConfigManager.getInstance().isSaveDetailsOnTempFile() && !(file = new File(EgInstallInfo.getInstallDir() + AUTO_DELETE_FILEPATH)).exists()) {
                file.mkdir();
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.error("{} Unable create directory ", (Object)loggerDispStr, (Object)exception);
        }
        return EgInstallInfo.getInstallDir() + AUTO_DELETE_FILEPATH + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToTempDebugIni(ArrayList arrayList) {
        String string;
        APMDiscoveryLogger.discoveryLogger.debug("{} Add to trash.ini : {}", (Object)loggerDispStr, (Object)arrayList);
        if (ApmConfigManager.getInstance().isSaveDetailsOnTempFile() && (string = APMCleanUpUtils.getTrashFileName()) != null) {
            IniFile iniFile = null;
            try {
                iniFile = EgApmFilesSync.getInstance(string, true);
                if (arrayList != null && arrayList.size() > 0) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        IniHelper iniHelper = (IniHelper)arrayList.get(i);
                        String string2 = iniHelper.getSubject();
                        String string3 = iniHelper.getVariable();
                        String string4 = iniHelper.getValue();
                        iniFile.setValue(string2, string3, string4);
                        String string5 = iniHelper.getAction();
                        if (string5 == null || string5 == "") continue;
                        iniFile.setValue("UNMANAGED_COMPONENT_DELETED_TIME", string5, new Date().toString());
                    }
                }
                arrayList.clear();
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.error("{} Unable to delete entries ", (Object)loggerDispStr, (Object)exception);
            }
            finally {
                if (iniFile != null) {
                    iniFile.saveFile();
                    EgApmFilesSync.releaseInstance(iniFile);
                }
            }
        }
    }

    private IniHelper getIniHelper(final String string, final String string2) {
        IniHelper iniHelper = new IniHelper(string, string2){

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string);
                stringBuilder.append("  ");
                stringBuilder.append(string2);
                return stringBuilder.toString();
            }
        };
        return iniHelper;
    }

    private IniHelper getIniHelper(final String string, final String string2, final String string3, final String string4) {
        IniHelper iniHelper = new IniHelper(string, string2, string3, string4){

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string);
                stringBuilder.append("  ");
                stringBuilder.append(string2);
                stringBuilder.append("  ");
                stringBuilder.append(string3);
                stringBuilder.append("=");
                stringBuilder.append(string4);
                return stringBuilder.toString();
            }
        };
        return iniHelper;
    }

    private long getDeleteDurationForContainerApps() {
        boolean bl = ApmConfigManager.getInstance().isUnitHH();
        long l = ApmConfigManager.getInstance().getDeleteDurationContainerApps();
        long l2 = ApmConfigManager.getInstance().getUnManagedDeleteThresholdContainerApps();
        if (bl) {
            l2 *= 60L;
        }
        long l3 = l + l2;
        return l3;
    }

    private long getDeleteDurationForNonContainerApps() {
        boolean bl = ApmConfigManager.getInstance().isUnitHH();
        long l = ApmConfigManager.getInstance().getDeleteDurationNonContainerApps();
        long l2 = ApmConfigManager.getInstance().getUnManagedDeleteThresholdNonContainerApps();
        if (bl) {
            l2 *= 60L;
        }
        long l3 = l + l2;
        return l3;
    }

    public void updateApmDiscoveryIniForNotManagedComponent(String string) {
        try {
            String string2 = EgInstallInfo.getInstallDir() + APMDISCOVERY;
            IniFile iniFile = new IniFile(string2);
            HashMap hashMap = this.getIniMapBySubject(iniFile, "JAVA_SERVER_DETAILS_DISCOVERD_TIME");
            if (hashMap.size() > 0) {
                Object object;
                HashMap hashMap2 = this.getIniMapBySubject(iniFile, "JAVA_SERVER_DETAILS_CONTAINER_BASED");
                HashMap hashMap3 = this.getIniMapBySubject(iniFile, "JAVA_SERVER_DETAILS");
                HashMap hashMap4 = this.getManagedGuidMapWithoutNick(iniFile, "NEWLY_DISCOVERD_DETAILS_CONTAINER_BASED");
                HashMap hashMap5 = this.getManagedGuidMapWithoutNick(iniFile, "NEWLY_DISCOVERD_DETAILS");
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList arrayList2 = new ArrayList();
                long l = this.getDeleteDurationForContainerApps();
                long l2 = this.getDeleteDurationForNonContainerApps();
                for (Object object2 : hashMap.keySet()) {
                    if (hashMap2 != null && hashMap2.size() > 0) {
                        object = (String)hashMap2.get(object2);
                        if (object == null) continue;
                        arrayList.add("JAVA_SERVER_DETAILS_CONTAINER_BASED");
                        arrayList2.addAll(this.getNotManagedComponents(string2, hashMap, l, (String)object2, hashMap4));
                        continue;
                    }
                    if (hashMap3 == null || hashMap3.size() <= 0 || (object = (String)hashMap3.get(object2)) == null) continue;
                    arrayList.add("JAVA_SERVER_DETAILS");
                    arrayList2.addAll(this.getNotManagedComponents(string2, hashMap, l2, (String)object2, hashMap5));
                }
                APMDiscoveryLogger.discoveryLogger.trace("{} Not Managed - notManagedCompList - {}", (Object)loggerDispStr, arrayList2);
                if (arrayList2.size() > 0) {
                    Object object2;
                    object2 = new ArrayList();
                    object = new ArrayList();
                    arrayList.add("JAVA_SERVER_DETAILS_DISCOVERD_TIME");
                    arrayList.add("APPFLOW_SERVICE_AUTO_NAME_MAPPING");
                    arrayList.add(JAVA_UNIQUE_GUID_MAPPING);
                    APMDiscoveryLogger.discoveryLogger.trace("{} Not Managed - subjectList {}", (Object)loggerDispStr, arrayList);
                    this.updateIniFile(arrayList, arrayList2, (List)object, (List)object2, string2);
                    if (((ArrayList)object).size() > 0) {
                        this.addToTempDebugIni((ArrayList)object);
                    }
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.error("{} Unable to get {} details {}", new Object[]{loggerDispStr, "APM_DISCOVERY_AUTO_DELETE", exception});
        }
    }

    private HashMap getManagedGuidMapWithoutNick(IniFile iniFile, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            String[] stringArray = iniFile.getLinesUnderSubject(string);
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    int n = string2.indexOf("=");
                    if (n <= 0) continue;
                    String string3 = string2.substring(0, n);
                    String string4 = string2.substring(n + 1);
                    String[] stringArray2 = string3.split(COLON);
                    String string5 = stringArray2[0] + COLON + stringArray2[1] + COLON + stringArray2[2];
                    hashMap.put(string5, string4);
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.error("{} Unable to get {} details {}", new Object[]{loggerDispStr, string, exception});
        }
        return hashMap;
    }

    private List getNotManagedComponents(String string, HashMap hashMap, long l, String string2, HashMap hashMap2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string3 = (String)hashMap.get(string2);
            if (string3 != null && string3.length() > 0) {
                long l2;
                long l3 = Long.parseLong(string3);
                long l4 = System.currentTimeMillis();
                long l5 = l4 - l3;
                String string4 = DurationFormatUtils.formatDuration((long)l5, (String)ApmConfigManager.getInstance().getCleanupSymbol());
                if (string4 != null && string4.length() > 0 && (l2 = Long.parseLong(string4)) >= l && !hashMap2.containsKey(string2)) {
                    arrayList.add(string2);
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.error("{} Unable to get {} details {}", new Object[]{loggerDispStr, "NEWLY_DISCOVERD_DETAILS", exception});
        }
        return arrayList;
    }

    private void updateIniFile(List list, List list2, List list3, List list4, String string) {
        try {
            IniFile iniFile = new IniFile(string);
            for (int i = 0; i < list2.size(); ++i) {
                String string2 = (String)list2.get(i);
                this.addDeleteComponent(list, string2, list3, list4, iniFile);
            }
            if (list4.size() > 0) {
                this.addThisListToBySubject(iniFile, JAVA_SERVER_DETAILS_HTTP_CALL_DONE, list3);
                this.deleteAgentAPMIniEntry(string, list4);
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.error("{} Unable to get eg_agent.ini details for {}", (Object)loggerDispStr, (Object)exception);
        }
    }

    private void addDeleteComponent(List list, String string, List list2, List list3, IniFile iniFile) {
        try {
            for (int i = 0; i < list.size(); ++i) {
                String string2 = (String)list.get(i);
                String string3 = iniFile.getValue(string2, string);
                list3.add(this.getIniHelper(string2, string));
                list2.add(this.getIniHelper(string, string2, string, string3));
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.error("{} Unable to get details for {}", (Object)loggerDispStr, (Object)exception);
        }
    }

    private HashMap getIniMapBySubject(IniFile iniFile, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            String[] stringArray = iniFile.getLinesUnderSubject(string);
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    int n = string2.indexOf("=");
                    if (n <= 0) continue;
                    String string3 = string2.substring(0, n);
                    String string4 = string2.substring(n + 1);
                    hashMap.put(string3, string4);
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.error("{} Unable to get details: ", (Object)loggerDispStr, (Object)exception);
        }
        return hashMap;
    }

    private void addThisListToBySubject(IniFile iniFile, String string, List list) {
        try {
            String[] stringArray = iniFile.getLinesUnderSubject(string);
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    int n = string2.indexOf("=");
                    if (n <= 0) continue;
                    String string3 = string2.substring(0, n);
                    String string4 = string2.substring(n + 1);
                    list.add(this.getIniHelper("", string, string3, string4));
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.error("{} Unable to get details : ", (Object)loggerDispStr, (Object)exception);
        }
    }

    public void initCleanUpProcess(boolean bl) {
        try {
            long l;
            if (bl || apmDiscoveryStartTimeStamp == -1L) {
                boolean bl2;
                l = ApmConfigManager.getInstance().getCleanUpInterval();
                if (l > 0L) {
                    apmDiscoveryIniCleanUpTime = l;
                }
                if (bl2 = ApmConfigManager.getInstance().isUnitHH()) {
                    apmDiscoveryIniCleanUpTime *= 60L;
                }
            }
            APMDiscoveryLogger.discoveryLogger.trace("{} apmDiscoveryExecutionTime : {} - apmDiscoveryIniCleanUpTime : {}", new Object[]{loggerDispStr, apmDiscoveryExecutionTime, apmDiscoveryIniCleanUpTime});
            if (apmDiscoveryStartTimeStamp == -1L || apmDiscoveryExecutionTime >= apmDiscoveryIniCleanUpTime) {
                apmDiscoveryStartTimeStamp = System.currentTimeMillis();
                APMDiscoveryLogger.discoveryLogger.info("{} process initiated...", (Object)loggerDispStr);
                this.updateApmDiscoveryIniForNotManagedComponent("agent");
            }
            l = System.currentTimeMillis();
            apmDiscoveryExecutionTime = Long.parseLong(DurationFormatUtils.formatDuration((long)(l - apmDiscoveryStartTimeStamp), (String)ApmConfigManager.getInstance().getCleanupSymbol()));
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do ini clean up process {}", (Object)loggerDispStr, (Object)exception);
        }
    }
}

