/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgConfigFilesSync;
import com.eg.EgConfigInfo;
import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.APMFileOperations;
import com.eg.apm.APMLanguage;
import com.eg.apm.EgApmFilesSync;
import com.eg.apm.JavaAPMComponent;
import com.eg.apm.NodeAPMComponent;
import com.eg.jtm.BTMConstants;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Properties;

public class APMConfigUtils {
    private static APMConfigUtils instance = null;
    private static final String currentTimeMillis = "currentTimeMillis";
    APMFileOperations apmfileOperation = new APMFileOperations();

    public void processApmConfigIni(String deleteGuidValue, boolean deleteGuidPros, String subject, String confdir, String entity) {
        block8: {
            EgConfigInfo configInfo = new EgConfigInfo(entity);
            IniFile apmConfigFile = EgApmFilesSync.getInstance(configInfo.getApmConfigFile());
            try {
                try {
                    String[] arrayOfString;
                    if (subject.equalsIgnoreCase("delete_all")) {
                        arrayOfString = apmConfigFile.getSubjects();
                        this.doProcessIni(apmConfigFile, deleteGuidValue, arrayOfString);
                    } else {
                        arrayOfString = new String[]{subject};
                        this.doProcessIni(apmConfigFile, deleteGuidValue, arrayOfString);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    apmConfigFile.saveFile();
                    EgApmFilesSync.releaseInstance(apmConfigFile);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                apmConfigFile.saveFile();
                EgApmFilesSync.releaseInstance(apmConfigFile);
                throw throwable;
            }
            apmConfigFile.saveFile();
            EgApmFilesSync.releaseInstance(apmConfigFile);
        }
        if (deleteGuidPros) {
            String guidFilePathName = new StringBuffer().append(confdir).append(deleteGuidValue.replaceAll(":", "_")).append(".props").toString();
            this.apmfileOperation.deleteFile(guidFilePathName);
        }
    }

    public void processApmConfigIni(String deleteGuidValue, boolean deleteGuidPros, String subject, APMLanguage language, String entity) {
        String confDir = BTMConstants.BTM_CONFIG_DIR_PATH;
        if (language == APMLanguage.NODEJS) {
            confDir = BTMConstants.NODEJS_CONFIG_DIR_PATH;
        }
        this.processApmConfigIni(deleteGuidValue, deleteGuidPros, subject, confDir, entity);
    }

    private boolean isCommonGUIDExists(String absoluteFileName, long lastUpdateTime, String componentID, APMLanguage language) {
        boolean exists = false;
        try {
            long lastModified;
            File guidFile = new File(absoluteFileName);
            boolean valid = guidFile.exists();
            if (valid && (lastModified = guidFile.lastModified()) > lastUpdateTime) {
                NodeAPMComponent nodeAPMComponent;
                exists = true;
                if (language == APMLanguage.JAVA) {
                    JavaAPMComponent javaAPMComponent = (JavaAPMComponent)APMComponentIDRepository.getRepository().getAPMComponent(componentID);
                    if (javaAPMComponent != null) {
                        javaAPMComponent.setLastUpdatedTimeOfCommonFile(lastModified);
                    }
                } else if (language == APMLanguage.NODEJS && (nodeAPMComponent = (NodeAPMComponent)APMComponentIDRepository.getRepository().getAPMComponent(componentID)) != null) {
                    nodeAPMComponent.setLastUpdatedTimeOfCommonFile(lastModified);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return exists;
    }

    private Properties getCommonGUIDProperties(String fileName) {
        Properties props;
        block12: {
            props = new Properties();
            FileInputStream inputStream = null;
            try {
                try {
                    inputStream = new FileInputStream(fileName);
                    props.load(inputStream);
                }
                catch (Exception e) {
                    System.out.println("[APMConfigUtils] - Exception during reading common GUID properties from file :" + fileName);
                    e.printStackTrace();
                    if (inputStream == null) break block12;
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return props;
    }

    public HashMap getCommonGUIDProps(String componentID, long lastUpdateTime, APMLanguage language) {
        HashMap<Object, Object> result = null;
        if (componentID != null && componentID.length() > 0) {
            String fileName = null;
            fileName = language != null && language == APMLanguage.JAVA ? new StringBuffer().append(BTMConstants.BTM_CONFIG_DIR_PATH).append(componentID.replaceAll(":", "_")).append(".props").toString() : new StringBuffer().append(BTMConstants.NODEJS_CONFIG_DIR_PATH).append(componentID.replaceAll(":", "_")).append(".props").toString();
            boolean isExists = this.isCommonGUIDExists(fileName, lastUpdateTime, componentID, language);
            if (isExists) {
                result = new HashMap<Object, Object>();
                Properties commonProperties = this.getCommonGUIDProperties(fileName);
                result.putAll(commonProperties);
                result.put("common_GUID_props", "common_GUID_props");
            }
        }
        return result;
    }

    private void doProcessIni(IniFile apmConfigFile, String deleteGuidValue, String[] arrayOfString) {
        try {
            String[] stringArray = arrayOfString;
            int n = arrayOfString.length;
            int n2 = 0;
            while (n2 < n) {
                String subjectTitle = stringArray[n2];
                String[] lines = apmConfigFile.getLinesUnderSubject(subjectTitle);
                if (lines != null && lines.length > 0) {
                    int j = 0;
                    while (j < lines.length) {
                        int equalIndex;
                        String line = lines[j];
                        int compIndex = line.indexOf(deleteGuidValue);
                        if (compIndex > -1 && (equalIndex = line.indexOf("=")) > 0) {
                            String variable = line.substring(0, equalIndex);
                            apmConfigFile.deleteValue(subjectTitle, variable);
                        }
                        ++j;
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void apmConfigSendToCleanUp() {
        String apmConfigToSendFilePath = String.valueOf(EgInstallInfo.getInstallDir()) + "/manager/config/eg_apmconfig_tosend.ini";
        IniFile apmConfigToSendIni = EgConfigFilesSync.getInstance(apmConfigToSendFilePath);
        try {
            try {
                String[] arrayOfString;
                String[] stringArray = arrayOfString = apmConfigToSendIni.getSubjects();
                int n = arrayOfString.length;
                int n2 = 0;
                while (n2 < n) {
                    String subjectTitle = stringArray[n2];
                    String guidTime = apmConfigToSendIni.getValue(subjectTitle, currentTimeMillis);
                    if (guidTime != null && guidTime != "") {
                        long startTime = Long.parseLong(guidTime) * 1000L;
                        long endTime = System.currentTimeMillis();
                        long difference = endTime - startTime;
                        if (difference > 900000L) {
                            apmConfigToSendIni.deleteSubject(subjectTitle);
                            System.out.println("[APMConfigUtils] - more than 15 minutes update entry is not processed by agent so entry being deleted");
                        }
                    }
                    ++n2;
                }
                apmConfigToSendIni.saveFile();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (apmConfigToSendIni != null) {
                    EgConfigFilesSync.releaseInstance(apmConfigToSendIni);
                }
            }
        }
        finally {
            if (apmConfigToSendIni != null) {
                EgConfigFilesSync.releaseInstance(apmConfigToSendIni);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static APMConfigUtils getInstance() {
        if (instance != null) return instance;
        Class<APMConfigUtils> clazz = APMConfigUtils.class;
        synchronized (APMConfigUtils.class) {
            if (instance != null) return instance;
            instance = new APMConfigUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

