/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.IniHelper;
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.APMUtils;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.Container;
import com.eg.apm.ContainerInstanceFactory;
import com.eg.apm.ContainersService;
import com.eg.apm.EgApmFilesSync;
import com.eg.apm.FinalizedContainerInfo;
import com.eg.jtm.BTMConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APMDiscoveryHelper {
    protected static final String loggerDispStr = "[APMDiscoveryHelper]";
    private static final String apmSync = new String("apmSync");
    private static HashMap customPortForDiscoveredComponents = new HashMap();
    private static int lastUsedCustomPort = 7011;
    private static final TreeSet fullyDiscoveredContainerIds = new TreeSet();
    private static final String separatorString = "#~#";
    private static final String EG_APM_DISCOVERY_INI = String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.APM_DISCOVERY_FILEPATH;
    private static final HashMap<String, String> CONTAINER_NAME_MAPPINGS = new HashMap();

    static {
        CONTAINER_NAME_MAPPINGS.put("Tomcat_server", "Tomcat_server");
        CONTAINER_NAME_MAPPINGS.put("JBoss_server", "JBoss_server");
        CONTAINER_NAME_MAPPINGS.put("JBoss_AS_server", "JBoss_AS_server");
        CONTAINER_NAME_MAPPINGS.put("WildFly", "WildFly");
        CONTAINER_NAME_MAPPINGS.put("WebLogic_server", "WebLogic_server");
        CONTAINER_NAME_MAPPINGS.put("WebSphere_server", "WebSphere_server");
        CONTAINER_NAME_MAPPINGS.put("GlassFish_server", "GlassFish_server");
        CONTAINER_NAME_MAPPINGS.put("IBMWLP", "IBMWLP");
        CONTAINER_NAME_MAPPINGS.put("Java_virtual_machine", "Java_virtual_machine");
        CONTAINER_NAME_MAPPINGS.put("Atlassian_Confluence", "Atlassian_Confluence");
        CONTAINER_NAME_MAPPINGS.put("eG_Manager", "eG_Manager");
        CONTAINER_NAME_MAPPINGS.put("Jetty_server", "Jetty_server");
        CONTAINER_NAME_MAPPINGS.put("NodeJS", "NodeJS");
        APMDiscoveryHelper.readCustomPortsFromIni();
    }

    private static void readCustomPortsFromIni() {
        try {
            IniFile apmPort;
            int cusPort;
            IniFile customIni = new IniFile(String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.APM_DISCOVERY_CUSTOM);
            String[] guidLines = customIni.getLinesUnderSubject("CUSTOM_PORTS_USED_FOR_DISCOVERY");
            customPortForDiscoveredComponents = APMDiscoveryHelper.getLinesAsMap(guidLines);
            int port = APMDiscoveryHelper.getPort(customIni, "LAST_CUSTOM_PORTS_USED_FOR_DISCOVERY", "Port");
            lastUsedCustomPort = port > 0 ? port : ((cusPort = APMDiscoveryHelper.getPort(apmPort = new IniFile(String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.AGENT_APM_FILEPATH), "APM_DISCOVERY", "Custom_Port_For_AutoManage")) > 0 ? cusPort : 7011);
            APMDiscoveryLogger.discoveryLogger.info("{} customPortForDiscoveredComponents - {} ", (Object)loggerDispStr, (Object)customPortForDiscoveredComponents);
            APMDiscoveryLogger.discoveryLogger.info("{} lastUsedCustomPort - {} ", (Object)loggerDispStr, (Object)lastUsedCustomPort);
        }
        catch (Exception e) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while retriving custom port data !!...{} ", (Object)loggerDispStr, (Object)e);
        }
    }

    public static HashMap getLinesAsMap(String[] lines) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            if (lines != null && lines.length > 0) {
                int i = 0;
                while (i < lines.length) {
                    String dataLine = lines[i];
                    int index = dataLine.indexOf("=");
                    if (index >= 0) {
                        String var = dataLine.substring(0, index);
                        String value = dataLine.substring(index + 1);
                        map.put(var.trim(), value.trim());
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            APMDiscoveryLogger.discoveryLogger.error("{} Exception occured due to {} ", (Object)loggerDispStr, (Object)e);
        }
        return map;
    }

    private static int getPort(IniFile file, String sub, String var) {
        try {
            String lastPortUsed = file.getValue(sub, var);
            if (lastPortUsed != null && lastPortUsed.length() > 0) {
                int port = Integer.parseInt(lastPortUsed);
                return port;
            }
        }
        catch (NumberFormatException e) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while retriving port from ini!!...{} ", (Object)loggerDispStr, (Object)e);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String updateCustomPortDiscovery(String thisNodeJvmGuid, String serverIp, String egServerTypeFormat) {
        int serverPorts = 0;
        String infoKey = null;
        String string = apmSync;
        synchronized (string) {
            if (customPortForDiscoveredComponents.containsKey(thisNodeJvmGuid)) {
                try {
                    serverPorts = Integer.parseInt((String)customPortForDiscoveredComponents.get(thisNodeJvmGuid));
                }
                catch (NumberFormatException e) {
                    serverPorts = lastUsedCustomPort + 1;
                    APMDiscoveryLogger.discoveryLogger.warn("[APMDiscoveryHelper] Unable to parse port: ", (Throwable)e);
                }
            } else {
                serverPorts = lastUsedCustomPort + 1;
            }
            if (serverPorts == 7077) {
                ++serverPorts;
            }
            if (serverPorts != 0) {
                ArrayList<IniHelper> addThis = new ArrayList<IniHelper>();
                try {
                    StringBuilder infoBuilder = new StringBuilder();
                    infoBuilder.append(serverIp).append(":").append(serverPorts).append(":").append(egServerTypeFormat);
                    infoKey = infoBuilder.toString();
                    customPortForDiscoveredComponents.put(thisNodeJvmGuid, serverPorts);
                    lastUsedCustomPort = serverPorts;
                    addThis.add(APMUtils.getIniHelper("CUSTOM_PORTS_USED_FOR_DISCOVERY", thisNodeJvmGuid, String.valueOf(serverPorts)));
                    addThis.add(APMUtils.getIniHelper("LAST_CUSTOM_PORTS_USED_FOR_DISCOVERY", "Port", String.valueOf(lastUsedCustomPort)));
                    String ininame = String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.APM_DISCOVERY_CUSTOM;
                    APMDiscoveryHelper.saveToIni(ininame, addThis, null);
                }
                catch (Exception e) {
                    APMDiscoveryLogger.discoveryLogger.warn("[APMDiscoveryHelper] Unable to store custom port details: ", (Throwable)e);
                }
            }
        }
        return infoKey;
    }

    private static boolean isAlreadyDiscovered(String thisNodeJvmGuid, String infoKey, boolean isNonDockerBased, String containerJmxPort) {
        boolean discovered = false;
        if (APMDiscoveryHelper.isInDiscoverdList(thisNodeJvmGuid)) {
            APMDiscoveryLogger.discoveryLogger.warn("{} - JVM is already discovered as {}, Skipping the entry [{}]", new Object[]{loggerDispStr, thisNodeJvmGuid, infoKey});
            if (isNonDockerBased) {
                APMDiscoveryHelper.storeJmxPortDetails(infoKey, containerJmxPort, "", "");
            }
            APMDiscoveryHelper.updateIfManagedAlready(thisNodeJvmGuid, infoKey);
            discovered = true;
        }
        return discovered;
    }

    private static void updateIfManagedAlready(String thisNodeComponentGuid, String infoKey) {
        APMComponentIDRepository componentIDRepository = APMComponentIDRepository.getRepository();
        if (componentIDRepository.isThisManaged(infoKey)) {
            String componentGuid = componentIDRepository.getComponentGuidFromTemp(infoKey);
            componentIDRepository.addToTempComponentRepository(componentGuid, thisNodeComponentGuid);
            componentIDRepository.addToTempComponentRepository(thisNodeComponentGuid, componentGuid);
            APMDiscoveryLogger.discoveryLogger.info("{} - This Request discovery data[{}] is already discovered and auto-managed with {}:{}, registering temporary id into repo", new Object[]{loggerDispStr, thisNodeComponentGuid, infoKey, componentGuid});
        }
    }

    private static void updateStatusForBtmDiscovery(String thisNodeComponentGuid, String infoKey, boolean isNonDockerBased, boolean storeForPortFinding) {
        APMComponentIDRepository componentIDRepository = APMComponentIDRepository.getRepository();
        componentIDRepository.setStatusForBtmDiscovery(thisNodeComponentGuid, false);
        if (isNonDockerBased) {
            componentIDRepository.setStatusForBtmDiscovery(thisNodeComponentGuid, true);
            fullyDiscoveredContainerIds.add(thisNodeComponentGuid);
        }
        if (!isNonDockerBased && !storeForPortFinding) {
            fullyDiscoveredContainerIds.add(thisNodeComponentGuid);
            APMDiscoveryHelper.updateIfManagedAlready(thisNodeComponentGuid, infoKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void storeBtmComponentDetails(String egServerTypeFormat, String serverIp, int serverPorts, String serverScheme, String containerJmxPort, String orignalServerName, String nodeID, String thisNodeJvmGuid, String dockerContainerName, String appTierName, String podNameAndNspace) {
        if (egServerTypeFormat.equals("-") || serverIp.equals("-") || serverScheme.equals("-") || serverIp.equalsIgnoreCase("NONE")) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Some details getting empty {} {} {} , So returning without storing details !!!", new Object[]{loggerDispStr, egServerTypeFormat, serverIp, serverScheme});
            return;
        }
        boolean isNonDockerBased = false;
        boolean isDockerBased = false;
        boolean isValidDockerContainerName = APMDiscoveryHelper.isValidName(dockerContainerName);
        StringBuilder infoBuilder = new StringBuilder();
        if (isValidDockerContainerName) {
            infoBuilder.append(dockerContainerName).append(":").append(serverPorts).append(":").append(egServerTypeFormat);
            isDockerBased = true;
        } else {
            infoBuilder.append(serverIp).append(":").append(serverPorts).append(":").append(egServerTypeFormat);
            isNonDockerBased = true;
        }
        String infoKey = infoBuilder.toString();
        if (isNonDockerBased) {
            if (serverPorts == 0) {
                if (!ApmConfigManager.getInstance().isManageByCustomPort()) {
                    APMDiscoveryLogger.discoveryLogger.warn("{} Unable to discover port for {}, So, Skipping the auto manage. Component type :{} , IP :{}  , Port :{} , Scheme : {} , Server Name : {}, appTierName : {},  Podname&NameSpace : {}", new Object[]{loggerDispStr, thisNodeJvmGuid, egServerTypeFormat, serverIp, serverPorts, serverScheme, orignalServerName, appTierName, podNameAndNspace});
                    return;
                }
                String resultInfoString = APMDiscoveryHelper.updateCustomPortDiscovery(thisNodeJvmGuid, serverIp, egServerTypeFormat);
                if (resultInfoString != null) {
                    infoKey = resultInfoString;
                }
            } else {
                ArrayList portDetails = APMDiscoveryHelper.getManagedPortForThis(serverPorts, egServerTypeFormat);
                APMDiscoveryLogger.discoveryLogger.trace("{} Existing port Details {}", (Object)loggerDispStr, (Object)portDetails);
                if (portDetails.size() == 3) {
                    try {
                        String managedJVMGuid = (String)portDetails.get(0);
                        int newlyDiscoveredPort = serverPorts;
                        int managedPort = serverPorts = ((Integer)portDetails.get(1)).intValue();
                        String portList = (String)portDetails.get(2);
                        infoKey = String.valueOf(serverIp) + ":" + serverPorts + ":" + egServerTypeFormat;
                        APMDiscoveryLogger.discoveryLogger.info("{} Newly discovered port {} belongs to already managed component of  {}, So using managed port {} for repository update, Available port list {} ", new Object[]{loggerDispStr, newlyDiscoveredPort, managedJVMGuid, managedPort, portList});
                    }
                    catch (Exception e) {
                        APMDiscoveryLogger.discoveryLogger.warn("{} Unable to check history ports: ", (Object)loggerDispStr, (Object)e);
                    }
                }
            }
        }
        APMComponentIDRepository.getRepository().addToTempComponentDiscoveryRepository(infoKey, String.valueOf(System.currentTimeMillis()));
        boolean isDiscoveredAlready = APMDiscoveryHelper.isAlreadyDiscovered(thisNodeJvmGuid, infoKey, isNonDockerBased, containerJmxPort);
        if (isDiscoveredAlready) {
            return;
        }
        StringBuilder valueTemp = new StringBuilder();
        valueTemp.append(orignalServerName).append(separatorString);
        valueTemp.append(serverScheme).append(separatorString);
        valueTemp.append(serverIp).append(separatorString);
        valueTemp.append(serverPorts).append(separatorString);
        valueTemp.append(new Date());
        String valueString = valueTemp.toString();
        boolean storeForPortFinding = false;
        if (isDockerBased && serverPorts == 0) {
            storeForPortFinding = true;
        }
        IniFile inifile = new IniFile(EG_APM_DISCOVERY_INI);
        ArrayList<IniHelper> resultList = null;
        try {
            try {
                resultList = APMDiscoveryHelper.prepareINIEntires(inifile, thisNodeJvmGuid, infoKey, valueString, appTierName, isDockerBased, isNonDockerBased, storeForPortFinding, serverPorts);
                APMDiscoveryHelper.updateJmxMapping(inifile, infoKey, containerJmxPort, resultList);
                if (isDockerBased) {
                    APMDiscoveryHelper.updateK8ServiceNames(dockerContainerName, podNameAndNspace, serverIp, resultList);
                }
            }
            catch (Exception e) {
                APMDiscoveryLogger.discoveryLogger.error("{} Unable to update {} {} ", new Object[]{loggerDispStr, BTMConstants.APM_DISCOVERY_FILEPATH, e});
                isDiscoveredAlready = APMDiscoveryHelper.isAlreadyDiscovered(thisNodeJvmGuid, infoKey, isNonDockerBased, containerJmxPort);
                if (isDiscoveredAlready) {
                    return;
                }
                if (resultList == null) return;
                if (resultList.size() <= 0) return;
                String string = apmSync;
                synchronized (string) {
                    if (!APMDiscoveryHelper.storeToIni(resultList, null)) return;
                    APMDiscoveryHelper.updateStatusForBtmDiscovery(thisNodeJvmGuid, infoKey, isNonDockerBased, storeForPortFinding);
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            isDiscoveredAlready = APMDiscoveryHelper.isAlreadyDiscovered(thisNodeJvmGuid, infoKey, isNonDockerBased, containerJmxPort);
            if (isDiscoveredAlready) {
                return;
            }
            if (resultList == null) throw throwable;
            if (resultList.size() <= 0) throw throwable;
            String string = apmSync;
            synchronized (string) {
                if (!APMDiscoveryHelper.storeToIni(resultList, null)) throw throwable;
                APMDiscoveryHelper.updateStatusForBtmDiscovery(thisNodeJvmGuid, infoKey, isNonDockerBased, storeForPortFinding);
                throw throwable;
            }
        }
        isDiscoveredAlready = APMDiscoveryHelper.isAlreadyDiscovered(thisNodeJvmGuid, infoKey, isNonDockerBased, containerJmxPort);
        if (isDiscoveredAlready) {
            return;
        }
        if (resultList == null) return;
        if (resultList.size() <= 0) return;
        String string = apmSync;
        synchronized (string) {
            if (!APMDiscoveryHelper.storeToIni(resultList, null)) return;
            APMDiscoveryHelper.updateStatusForBtmDiscovery(thisNodeJvmGuid, infoKey, isNonDockerBased, storeForPortFinding);
            return;
        }
    }

    private static void updateJmxMapping(IniFile inifile, String infoKey, String containerJmxPort, ArrayList<IniHelper> addThis) {
        if (APMDiscoveryHelper.isValidJmxPort(containerJmxPort)) {
            String jmxNameSubject = "JAVA_SERVER_JMX_MAPPING";
            if (APMUtils.isDetailsAvailableInFile(inifile, infoKey, containerJmxPort, jmxNameSubject)) {
                APMDiscoveryLogger.discoveryLogger.trace("{} Jmx Port For Component :{} with value :{} is already available under [{}] subject...", new Object[]{loggerDispStr, infoKey, containerJmxPort, jmxNameSubject});
            } else {
                addThis.add(APMUtils.getIniHelper(jmxNameSubject, infoKey, containerJmxPort));
                APMDiscoveryLogger.discoveryLogger.info("{} Adding Jmx Port For Component {}={} details under subject [{}]", new Object[]{loggerDispStr, infoKey, containerJmxPort, jmxNameSubject});
            }
        }
    }

    private static void updateK8ServiceNames(String dockerContainerName, String podNameAndNspace, String serverIp, ArrayList<IniHelper> addThis) {
        String podnameSub = "KUBERNETES_DETAILS_TEMP";
        if (ApmConfigManager.getInstance().isK8ServiceNameDiscoveryEnabled()) {
            addThis.add(APMUtils.getIniHelper(podnameSub, dockerContainerName, podNameAndNspace));
            APMDiscoveryLogger.discoveryLogger.info("{} Adding {} = {} under subject [{}]", new Object[]{loggerDispStr, podnameSub, serverIp, podNameAndNspace});
        } else {
            APMDiscoveryLogger.discoveryLogger.info("{} Kubernetes service discovery DISABLED, So Skipping, Ini entry add {} = {} under subject [{}]", new Object[]{loggerDispStr, podnameSub, serverIp, podNameAndNspace});
        }
    }

    private static ArrayList<IniHelper> prepareINIEntires(IniFile inifile, String thisNodeJvmGuid, String infoKey, String valueString, String appTierName, boolean isDockerBased, boolean isNonDockerBased, boolean storeForPortFinding, int serverPorts) {
        String discoverySub = "JAVA_SERVER_DETAILS";
        String guidSub = "JAVA_UNIQUE_GUID_MAPPING";
        String appNameSub = "APPFLOW_SERVICE_AUTO_NAME_MAPPING";
        if (isDockerBased) {
            discoverySub = "JAVA_SERVER_DETAILS_CONTAINER_BASED";
        }
        if (storeForPortFinding) {
            discoverySub = String.valueOf(discoverySub) + "_TEMP";
            guidSub = String.valueOf(guidSub) + "_TEMP";
            appNameSub = String.valueOf(appNameSub) + "_TEMP";
        }
        APMDiscoveryLogger.discoveryLogger.info("{} - storeForPortFinding : {} , isDockerBased: {} , isNonDockerBased : {} ", new Object[]{loggerDispStr, storeForPortFinding, isDockerBased, isNonDockerBased});
        ArrayList<IniHelper> resultList = new ArrayList<IniHelper>();
        boolean isAvailable = APMUtils.isDetailsAvailableInFile(inifile, infoKey, valueString, discoverySub);
        if (isAvailable) {
            APMDiscoveryLogger.discoveryLogger.trace("{} Component Details for :{} with value :{} is already available under [{}] subject...", new Object[]{loggerDispStr, infoKey, valueString, discoverySub});
        } else {
            resultList.add(APMUtils.getIniHelper(discoverySub, infoKey, valueString));
            APMDiscoveryLogger.discoveryLogger.info("{} Adding Component {}={} details under subject [{}]", new Object[]{loggerDispStr, infoKey, valueString, discoverySub});
        }
        if (APMUtils.isDetailsAvailableInFile(inifile, infoKey, thisNodeJvmGuid, guidSub)) {
            APMDiscoveryLogger.discoveryLogger.trace("{} java unique guid details {}  with value {} already available...", new Object[]{loggerDispStr, infoKey, thisNodeJvmGuid});
        } else {
            resultList.add(APMUtils.getIniHelper(guidSub, infoKey, thisNodeJvmGuid));
            APMDiscoveryLogger.discoveryLogger.info("{} Adding {}={} under subject [{}]", new Object[]{loggerDispStr, infoKey, thisNodeJvmGuid, guidSub});
        }
        if (APMUtils.isDetailsAvailableInFile(inifile, infoKey, appTierName, appNameSub)) {
            APMDiscoveryLogger.discoveryLogger.trace("{} App name details {}  with value {} already available...", new Object[]{loggerDispStr, infoKey, appTierName});
        } else {
            resultList.add(APMUtils.getIniHelper(appNameSub, infoKey, appTierName));
            APMDiscoveryLogger.discoveryLogger.info("{} Adding {}={} under subject [{}]", new Object[]{loggerDispStr, infoKey, appTierName, guidSub});
        }
        if (!storeForPortFinding) {
            resultList.add(APMUtils.getIniHelper("JAVA_SERVER_DETAILS_DISCOVERD_TIME", infoKey, String.valueOf(System.currentTimeMillis())));
        }
        return resultList;
    }

    private static String limitHostName(String hostName) {
        if (hostName != null && hostName.length() > 32) {
            hostName = hostName.substring(0, 32);
        }
        return hostName;
    }

    public static void storeAutoDiscoveryDetails(Map discoveryData, String nodeID) {
        String appName;
        Hashtable doHttpReq = (Hashtable)discoveryData.get("DO_HTTP_REQ");
        if (doHttpReq != null) {
            if (ApmConfigManager.getInstance().isManualHttpInvocationEnabled()) {
                APMDiscoveryHelper.storeBtmDetailsForManualReq(nodeID, doHttpReq);
            } else {
                APMDiscoveryLogger.discoveryLogger.debug("{} Discovery data received with 'HTTP invocation request from eG Agent [DO_HTTP_REQ]', but HTTP invocation is disabled, Hence discarding the discovered details for {}, discovered data - {} ", new Object[]{loggerDispStr, nodeID, discoveryData});
            }
            return;
        }
        Hashtable startupDetails = (Hashtable)discoveryData.get("STARTUP_DISCOVERY_DETAILS");
        Hashtable reqDetails = (Hashtable)discoveryData.get("REQUEST_DISCOVERY_DETAILS");
        APMDiscoveryLogger.discoveryLogger.debug("{} {} discoveryData - {} ", new Object[]{loggerDispStr, nodeID, discoveryData});
        APMDiscoveryLogger.discoveryLogger.debug("{} {} STARTUP_DISCOVERY_DETAILS - {} ", new Object[]{loggerDispStr, nodeID, startupDetails});
        APMDiscoveryLogger.discoveryLogger.debug("{} {} REQUEST_DISCOVERY_DETAILS - {} ", new Object[]{loggerDispStr, nodeID, reqDetails});
        if (startupDetails == null) {
            startupDetails = new Hashtable();
        }
        if (reqDetails == null) {
            reqDetails = new Hashtable();
        }
        appName = (appName = (String)discoveryData.remove("appName")) == null || appName.length() <= 0 ? "MyApp" : appName;
        String tierName = (String)discoveryData.remove("tierName");
        tierName = tierName == null || tierName.length() <= 0 ? "MyTier" : tierName;
        String podName = APMDiscoveryHelper.getDetails("POD_NAME", reqDetails, startupDetails, "NONE");
        podName = podName == null || podName.length() <= 0 ? "NONE" : podName;
        String nameSpace = APMDiscoveryHelper.getDetails("POD_NAME_SPACE", reqDetails, startupDetails, "NONE");
        nameSpace = nameSpace == null || nameSpace.length() <= 0 ? "NONE" : nameSpace;
        String dockerContainerName = APMDiscoveryHelper.getDetails("CONTAINER_NAME", reqDetails, startupDetails, "NONE");
        String containerServerName = APMDiscoveryHelper.getDetails("CONTAINER_SERVER_NAME", reqDetails, startupDetails, "NONE");
        String containerIP = APMDiscoveryHelper.getDetails("CONTAINER_IP", reqDetails, startupDetails, "NONE");
        String port = APMDiscoveryHelper.getDetails("CONTAINER_PORT", reqDetails, startupDetails, "0");
        String containerScheme = APMDiscoveryHelper.getDetails("CONTAINER_SCHEME", reqDetails, startupDetails, "NONE");
        String containerJmxPort = APMDiscoveryHelper.getDetails("CONTAINER_JMX_PORT", reqDetails, startupDetails, "0");
        containerIP = APMDiscoveryHelper.limitHostName(containerIP);
        if (port == null) {
            port = "0000";
        }
        try {
            String egServerTypeFormat;
            int containerPort = Integer.parseInt(port);
            if (containerServerName != null && containerServerName.indexOf("Payara") > -1) {
                containerServerName = "GlassFish_server";
            }
            if (containerServerName != null && containerServerName.indexOf("NODEJS") > -1) {
                containerServerName = "NodeJS";
            }
            if ((egServerTypeFormat = CONTAINER_NAME_MAPPINGS.get(containerServerName)) != null && egServerTypeFormat.length() > 0 && !egServerTypeFormat.equalsIgnoreCase("Java_virtual_machine")) {
                APMDiscoveryLogger.discoveryLogger.info("{} Successfully identified the COMPONENT TYPE via startup discovery.  DISCOVERY RESULT - Component Type :{} , IP :{}  , Port :{} , Scheme : {} , Server Name : {}, Node ID : {}  & JvmGUID : {}", new Object[]{loggerDispStr, egServerTypeFormat, containerIP, containerPort, containerScheme, containerServerName, nodeID});
            }
            if (egServerTypeFormat == null || egServerTypeFormat.equalsIgnoreCase("Java_virtual_machine")) {
                egServerTypeFormat = APMUtils.getServerType(containerServerName);
                if (egServerTypeFormat != null) {
                    APMDiscoveryLogger.discoveryLogger.info("{} Successfully identified the COMPONENT TYPE via request discovery - DISCOVERY RESULT - Type :{} , IP :{}  , Port :{} , Scheme : {} , Server Name : {}, Node ID : {}  & JvmGUID : {}", new Object[]{loggerDispStr, egServerTypeFormat, containerIP, containerPort, containerScheme, containerServerName, nodeID});
                }
                if (containerServerName.equalsIgnoreCase("JBoss_AS_server")) {
                    egServerTypeFormat = "JBoss_AS_server";
                } else if (containerServerName.equalsIgnoreCase("JBoss_server")) {
                    egServerTypeFormat = "JBoss_server";
                }
            }
            if (egServerTypeFormat == null || egServerTypeFormat.length() == 0) {
                egServerTypeFormat = "Java_virtual_machine";
            }
            String thisNodeJvmGuid = null;
            if (APMUtils.isDetailsAvailable(discoveryData, "JvmGUID")) {
                thisNodeJvmGuid = (String)discoveryData.get("JvmGUID");
            }
            String appTierName = String.valueOf(appName) + ":" + tierName;
            String podNameAndNspace = String.valueOf(podName) + ":" + nameSpace;
            APMDiscoveryLogger.discoveryLogger.info("{} DISCOVERY RESULT - Type :{} , IP :{}  , Port :{} , Scheme : {} , Server Name : {}, Node ID : {}  & JvmGUID : {} , appTierName : {},  Podname&NameSpace : {}", new Object[]{loggerDispStr, egServerTypeFormat, containerIP, containerPort, containerScheme, containerServerName, nodeID, thisNodeJvmGuid, appTierName, podNameAndNspace});
            APMDiscoveryHelper.storeBtmComponentDetails(egServerTypeFormat, containerIP, containerPort, containerScheme, containerJmxPort, containerServerName, nodeID, thisNodeJvmGuid, dockerContainerName, appTierName, podNameAndNspace);
        }
        catch (Exception e) {
            APMDiscoveryLogger.discoveryLogger.error("{} Exception while getting server details !!.. so set the default value...{} ", (Object)loggerDispStr, (Object)e);
        }
    }

    private static void storeBtmDetailsForManualReq(String thisNodeJvmGuid, Hashtable doHttpReq) {
        block10: {
            String serverIp;
            APMDiscoveryLogger.discoveryLogger.debug("{} {} discoveryData of manual http request - {} ", new Object[]{loggerDispStr, thisNodeJvmGuid, doHttpReq});
            APMDiscoveryLogger.discoveryLogger.debug("[APMDiscoveryHelper] fullyDiscoveredContainerIds {} ", (Object)fullyDiscoveredContainerIds);
            String pid = (String)doHttpReq.remove("CONTAINER_PID");
            String infoKey = serverIp = (String)doHttpReq.get("CONTAINER_IP");
            String dockerContainerName = (String)doHttpReq.remove("CONTAINER_NAME");
            if (APMDiscoveryHelper.isInDiscoverdList(thisNodeJvmGuid)) {
                APMDiscoveryLogger.discoveryLogger.warn("[APMDiscoveryHelper] {} Already discovered, so skipping HTTP Request entry to ini [{}] ", (Object)thisNodeJvmGuid, (Object)infoKey);
                return;
            }
            ArrayList<IniHelper> addThis = new ArrayList<IniHelper>();
            IniFile inifile = new IniFile(String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.APM_DISCOVERY_FILEPATH);
            try {
                try {
                    String discoverySub = "JAVA_SERVER_DETAILS";
                    if (APMDiscoveryHelper.isValidName(dockerContainerName)) {
                        discoverySub = "JAVA_SERVER_DETAILS_CONTAINER_BASED";
                    }
                    StringBuilder valueTemp = new StringBuilder();
                    valueTemp.append(pid).append(separatorString);
                    valueTemp.append(thisNodeJvmGuid).append(separatorString);
                    valueTemp.append(new Date());
                    discoverySub = String.valueOf(discoverySub) + "_DO_HTTP_REQ";
                    String valueString = valueTemp.toString();
                    infoKey = String.valueOf(pid) + "@" + serverIp;
                    boolean isAvailable = APMUtils.isDetailsAvailableInFile(inifile, infoKey, valueString, discoverySub);
                    if (isAvailable) {
                        APMDiscoveryLogger.discoveryLogger.trace("{} Component Details for :{} with value :{} is already available under [{}] subject...", new Object[]{loggerDispStr, infoKey, valueString, discoverySub});
                        break block10;
                    }
                    addThis.add(APMUtils.getIniHelper(discoverySub, infoKey, valueString));
                    APMDiscoveryLogger.discoveryLogger.info("{} Adding Component {}={} details under subject [{}]", new Object[]{loggerDispStr, infoKey, valueString, discoverySub});
                }
                catch (Exception e) {
                    APMDiscoveryLogger.discoveryLogger.error("{} Unable to update {} {} ", new Object[]{loggerDispStr, BTMConstants.APM_DISCOVERY_FILEPATH, e});
                    if (addThis.size() > 0) {
                        APMDiscoveryHelper.storeToIni(addThis, null);
                    }
                }
            }
            finally {
                if (addThis.size() > 0) {
                    APMDiscoveryHelper.storeToIni(addThis, null);
                }
            }
        }
    }

    private static boolean isValidName(String str) {
        return str != null && !str.equalsIgnoreCase("NONE") && !str.equalsIgnoreCase("-") && str.length() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveToIni(String fileName, ArrayList addThis, ArrayList deleteThis) {
        String string = apmSync;
        synchronized (string) {
            boolean result;
            block12: {
                IniFile inifile = EgApmFilesSync.getInstance(fileName, true);
                result = false;
                try {
                    try {
                        String val;
                        String var;
                        String sub;
                        IniHelper helper;
                        int a;
                        if (addThis != null && addThis.size() > 0) {
                            a = 0;
                            while (a < addThis.size()) {
                                helper = (IniHelper)addThis.get(a);
                                sub = helper.getSubject();
                                var = helper.getVariable();
                                val = helper.getValue();
                                inifile.setValue(sub, var, val);
                                APMDiscoveryLogger.discoveryLogger.info("{} {} : Adding Component {}={} details under subject [{}]", new Object[]{loggerDispStr, fileName, var, val, sub});
                                ++a;
                            }
                        }
                        if (deleteThis != null && deleteThis.size() > 0) {
                            a = 0;
                            while (a < deleteThis.size()) {
                                helper = (IniHelper)deleteThis.get(a);
                                sub = helper.getSubject();
                                var = helper.getVariable();
                                val = helper.getValue();
                                inifile.deleteValue(sub, var);
                                APMDiscoveryLogger.discoveryLogger.info("{} {}: Deleting Component {}={} details under subject [{}]", new Object[]{loggerDispStr, fileName, var, val, sub});
                                ++a;
                            }
                        }
                        result = true;
                    }
                    catch (Exception e) {
                        APMDiscoveryLogger.discoveryLogger.error("{} Unable to update {} {} ", new Object[]{loggerDispStr, fileName, e});
                        result = false;
                        inifile.saveFile();
                        EgApmFilesSync.releaseInstance(inifile);
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    inifile.saveFile();
                    EgApmFilesSync.releaseInstance(inifile);
                    throw throwable;
                }
                inifile.saveFile();
                EgApmFilesSync.releaseInstance(inifile);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean storeToIni(ArrayList addThis, ArrayList deleteThis) {
        String string = apmSync;
        synchronized (string) {
            boolean result;
            block12: {
                IniFile inifile = EgApmFilesSync.getInstance(EG_APM_DISCOVERY_INI, true);
                result = false;
                try {
                    try {
                        String val;
                        String var;
                        String sub;
                        IniHelper helper;
                        int a;
                        if (addThis != null && addThis.size() > 0) {
                            a = 0;
                            while (a < addThis.size()) {
                                helper = (IniHelper)addThis.get(a);
                                sub = helper.getSubject();
                                var = helper.getVariable();
                                val = helper.getValue();
                                inifile.setValue(sub, var, val);
                                APMDiscoveryLogger.discoveryLogger.info("{} StoreToIni() Adding Component {}={} details under subject [{}]", new Object[]{loggerDispStr, var, val, sub});
                                ++a;
                            }
                        }
                        if (deleteThis != null && deleteThis.size() > 0) {
                            a = 0;
                            while (a < deleteThis.size()) {
                                helper = (IniHelper)deleteThis.get(a);
                                sub = helper.getSubject();
                                var = helper.getVariable();
                                val = helper.getValue();
                                inifile.deleteValue(sub, var);
                                APMDiscoveryLogger.discoveryLogger.info("{}  StoreToIni() Deleting Component {}={} details under subject [{}]", new Object[]{loggerDispStr, var, val, sub});
                                ++a;
                            }
                        }
                        result = true;
                    }
                    catch (Exception e) {
                        APMDiscoveryLogger.discoveryLogger.error("{} Unable to update {} {} ", new Object[]{loggerDispStr, BTMConstants.APM_DISCOVERY_FILEPATH, e});
                        result = false;
                        inifile.saveFile();
                        EgApmFilesSync.releaseInstance(inifile);
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    inifile.saveFile();
                    EgApmFilesSync.releaseInstance(inifile);
                    throw throwable;
                }
                inifile.saveFile();
                EgApmFilesSync.releaseInstance(inifile);
            }
            return result;
        }
    }

    private static String getDetails(String keyString, Hashtable reqDetails, Hashtable startupDetails, String defaultValue) {
        String containerDetails = null;
        Hashtable finalDetails = null;
        Container containerInstance = ContainerInstanceFactory.getInstance().getContainerInstance();
        boolean isContainerBased = false;
        if (containerInstance != null && containerInstance.isContainerZ()) {
            isContainerBased = true;
        }
        String msg = "";
        if (isContainerBased) {
            msg = "[Container-Env] ";
            if (ApmConfigManager.getInstance().isUseStartupMbeanBasedDiscovery() && startupDetails != null) {
                finalDetails = startupDetails;
                msg = String.valueOf(msg) + "STARTUP_BASED_DETAILS_USED";
            } else if (ApmConfigManager.getInstance().isUseRequestBasedDiscovery()) {
                finalDetails = reqDetails;
                msg = String.valueOf(msg) + "REQ_BASED_DETAILS_USED";
            }
        } else {
            msg = "[Non-Container-Env] ";
            if (ApmConfigManager.getInstance().isUseRequestBasedDiscovery() && reqDetails != null) {
                finalDetails = reqDetails;
                msg = String.valueOf(msg) + "STARTUP_BASED_DETAILS_USED";
            } else if (ApmConfigManager.getInstance().isUseStartupMbeanBasedDiscovery()) {
                finalDetails = startupDetails;
                msg = String.valueOf(msg) + "REQ_BASED_DETAILS_USED";
            }
        }
        containerDetails = (String)finalDetails.remove(keyString);
        if (APMDiscoveryHelper.isValid(containerDetails)) {
            APMDiscoveryLogger.discoveryLogger.info("{} {} key :{}, value {}", new Object[]{loggerDispStr, msg, keyString, containerDetails});
            return containerDetails;
        }
        msg = String.valueOf(msg) + " DEFAULT_VALUE_USED";
        containerDetails = defaultValue;
        APMDiscoveryLogger.discoveryLogger.info("{} {} key :{}, value {}", new Object[]{loggerDispStr, msg, keyString, containerDetails});
        return containerDetails;
    }

    private static boolean isValid(String value) {
        return value != null && !value.equalsIgnoreCase("NONE") && value.length() != 0 && !value.equalsIgnoreCase("0000");
    }

    public static void addToDiscoveredList(String tempid) {
        if (tempid != null) {
            fullyDiscoveredContainerIds.add(tempid);
        }
    }

    public static void addToDiscoveredList(ArrayList tempIdList) {
        if (tempIdList != null) {
            fullyDiscoveredContainerIds.add(tempIdList);
        }
    }

    public static boolean isInDiscoverdList(String tempid) {
        return fullyDiscoveredContainerIds.contains(tempid);
    }

    public static TreeSet getDiscoveredList() {
        return fullyDiscoveredContainerIds;
    }

    public static void removeEntriesFromApmDiscoveryIni(String componentID, String serverDetails, boolean saveIntoDeletedCompDetails, boolean deleteFully) {
        if (serverDetails == null) {
            return;
        }
        ArrayList<IniHelper> addEntries = null;
        ArrayList<IniHelper> deleteEntries = null;
        IniFile apmDiscoveryINI = new IniFile(String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.APM_DISCOVERY_FILEPATH);
        try {
            try {
                String appServerDetails = apmDiscoveryINI.getValue("JAVA_SERVER_DETAILS", serverDetails);
                if (deleteFully) {
                    deleteEntries = new ArrayList<IniHelper>();
                    deleteEntries.add(APMUtils.getIniHelper("JAVA_SERVER_DETAILS", serverDetails, "DeleteME"));
                    deleteEntries.add(APMUtils.getIniHelper("LAST_HEART_BEAT_CHECK_TIME", componentID, "DeleteME"));
                }
                if (saveIntoDeletedCompDetails) {
                    addEntries = new ArrayList<IniHelper>();
                    addEntries.add(APMUtils.getIniHelper("AUTO_DELETED_JAVA_SERVER_DETAILS", serverDetails, String.valueOf(appServerDetails) + separatorString + System.currentTimeMillis()));
                }
                APMDiscoveryLogger.discoveryLogger.debug("{} {} - related INI Entries are deleted from {} ", new Object[]{loggerDispStr, componentID, BTMConstants.APM_DISCOVERY_FILEPATH});
            }
            catch (Exception e) {
                APMDiscoveryLogger.discoveryLogger.error("{} {}, Unable to delete INI Entries from {} ", new Object[]{loggerDispStr, componentID, BTMConstants.APM_DISCOVERY_FILEPATH});
                APMDiscoveryHelper.storeToIni(addEntries, deleteEntries);
            }
        }
        finally {
            APMDiscoveryHelper.storeToIni(addEntries, deleteEntries);
        }
    }

    public static String getDiscoveredJmxPort(String nick, String targetHost, String portNo, String serverType, String jmxPort) {
        try {
            APMDiscoveryLogger.discoveryLogger.trace("{} ApmConfigManager.isApmMonitoringEnabled(): {}, nick: {}, targetHost: {} , portNo: {} , serverType: {}, jmxPort: {} ", new Object[]{loggerDispStr, ApmConfigManager.getInstance().isAPMMonitoringEnabled(), nick, targetHost, portNo, serverType, jmxPort});
            if (ApmConfigManager.getInstance().isAPMMonitoringEnabled() && portNo != null) {
                String newJmxPort = "";
                IniFile ini = new IniFile(String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.APM_DISCOVERY_FILEPATH);
                String key = String.valueOf(targetHost) + ":" + portNo + ":" + serverType;
                newJmxPort = ini.getValue("JAVA_SERVER_JMX_MAPPING", key);
                APMDiscoveryLogger.discoveryLogger.info("{} APM discovered JMX port reading key : {}, value : {} ", new Object[]{loggerDispStr, key, newJmxPort});
                if (newJmxPort != null && newJmxPort.length() == 0) {
                    key = String.valueOf(nick) + ":" + portNo + ":" + serverType;
                    newJmxPort = ini.getValue("JAVA_SERVER_JMX_MAPPING", key);
                }
                APMDiscoveryLogger.discoveryLogger.info("{} APM discovered JMX port reading key : {}, value : {} ", new Object[]{loggerDispStr, key, newJmxPort});
                if (newJmxPort != null && newJmxPort.length() > 0) {
                    return newJmxPort;
                }
            }
        }
        catch (Exception e) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to get discovered JMX port for container metrics - {}", (Object)loggerDispStr, (Object)e);
        }
        return jmxPort;
    }

    private static ArrayList getManagedPortForThis(int serverPorts, String egServerTypeFormat) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            IniFile discoveryIni = new IniFile(String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.APM_DISCOVERY_FILEPATH);
            HashMap map = APMUtils.getLinesAsTreeSetMap(discoveryIni, "JAVA_SERVER_HTTP_PORT_LIST", APMDiscoveryLogger.discoveryLogger);
            APMDiscoveryLogger.discoveryLogger.trace("{} Existing http port details - {}", (Object)loggerDispStr, (Object)map);
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                try {
                    int portNo;
                    String[] arrStr;
                    Map.Entry entry = it.next();
                    String key = (String)entry.getKey();
                    TreeSet value = (TreeSet)entry.getValue();
                    if (!value.contains(String.valueOf(serverPorts)) || (arrStr = key.split(":")).length != 5) continue;
                    String portStr = arrStr[1];
                    String serverType = arrStr[2];
                    String guid = String.valueOf(arrStr[3]) + ":" + arrStr[4];
                    if (portStr == null || (portNo = Integer.parseInt(portStr)) <= 0 || !serverType.equalsIgnoreCase(egServerTypeFormat)) continue;
                    list.add(guid);
                    list.add(portNo);
                    list.add(String.valueOf(key) + ":" + value);
                    break;
                }
                catch (NumberFormatException e) {
                    APMDiscoveryLogger.discoveryLogger.warn("{} Unable to check history ports: ", (Object)loggerDispStr, (Object)e);
                }
            }
        }
        catch (Exception e) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to check history ports: ", (Object)loggerDispStr, (Object)e);
        }
        return list;
    }

    private static boolean isValidJmxPort(String containerJmxPort) {
        return containerJmxPort != null && containerJmxPort.length() > 1 && !containerJmxPort.equalsIgnoreCase("0");
    }

    public static void storeJmxPortDetails(String infoKey, String containerJmxPort, String containerHttpPortList, String jvmGuid) {
        try {
            if (infoKey != null && infoKey.length() > 0) {
                ArrayList<IniHelper> addThis = new ArrayList<IniHelper>();
                IniFile inifile = new IniFile(EG_APM_DISCOVERY_INI);
                APMDiscoveryHelper.updateJmxMapping(inifile, infoKey, containerJmxPort, addThis);
                if (containerHttpPortList != null && containerHttpPortList.startsWith("[") && containerHttpPortList.endsWith("]")) {
                    containerHttpPortList = containerHttpPortList.substring(1, containerHttpPortList.indexOf("]"));
                }
                if (APMDiscoveryHelper.isValidJmxPort(containerHttpPortList)) {
                    containerHttpPortList = containerHttpPortList.replace(" ", "");
                    String key = String.valueOf(infoKey) + ":" + jvmGuid;
                    if (APMUtils.isDetailsAvailableInFile(inifile, key, containerHttpPortList, "JAVA_SERVER_HTTP_PORT_LIST")) {
                        APMDiscoveryLogger.discoveryLogger.trace("{} Http Port List For Component :{} with value :{} is already available under [{}] subject...", new Object[]{loggerDispStr, key, containerHttpPortList, "JAVA_SERVER_HTTP_PORT_LIST"});
                    } else {
                        addThis.add(APMUtils.getIniHelper("JAVA_SERVER_HTTP_PORT_LIST", key, containerHttpPortList));
                        APMDiscoveryLogger.discoveryLogger.info("{} Adding Discovered HTTP Port List For Component {}={} details under subject [{}]", new Object[]{loggerDispStr, key, containerHttpPortList, "JAVA_SERVER_HTTP_PORT_LIST"});
                    }
                }
                if (addThis.size() > 0) {
                    APMDiscoveryHelper.storeToIni(addThis, null);
                }
            }
        }
        catch (Exception e) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while storing JMX|HTTP port details to ini {} ", (Object)loggerDispStr, (Object)e);
        }
    }

    public static Hashtable<String, ArrayList> getBTMDiscoverySubjectsWithLines() {
        Hashtable<String, ArrayList> discoveryDetails = new Hashtable<String, ArrayList>();
        IniFile apmdiscovery = new IniFile(APMDiscoveryHelper.getApmDiscoveryIniFileName());
        try {
            Vector btmAPMSubjects = apmdiscovery.getAllValues("AVAILABLE_APM_DISCOVERY_SECTION");
            if (btmAPMSubjects != null && btmAPMSubjects.size() > 0) {
                int i = 0;
                while (i < btmAPMSubjects.size()) {
                    String[] btmSubjectsArray;
                    String btmSubjects = (String)btmAPMSubjects.get(i);
                    if (btmSubjects != null && btmSubjects.length() > 0 && (btmSubjectsArray = btmSubjects.split(",")) != null && btmSubjectsArray.length > 0) {
                        int eg = 0;
                        while (eg < btmSubjectsArray.length) {
                            String[] serverLines;
                            String sub = btmSubjectsArray[eg];
                            if (sub != null && sub.length() > 0 && (serverLines = apmdiscovery.getLinesUnderSubject(sub.trim())) != null && serverLines.length > 0) {
                                discoveryDetails.put(sub.trim(), new ArrayList<String>(Arrays.asList(serverLines)));
                            }
                            ++eg;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception in discoverBTMComponents() {} ", (Object)loggerDispStr, (Object)e);
        }
        APMDiscoveryLogger.discoveryLogger.debug("{} eg_apmdiscovery.ini - discoveryDetails : {} ", (Object)loggerDispStr, discoveryDetails);
        return discoveryDetails;
    }

    private static String getApmDiscoveryIniFileName() {
        String offload_apmdiscovery_path = String.valueOf(EgInstallInfo.getInstallDir()) + "/agent/config/eg_apmdiscovery.ini";
        return offload_apmdiscovery_path;
    }

    public static ArrayList discoverBTMComponents(String hostName, ArrayList selectedServerTypeList) {
        ArrayList<String> discoverList = new ArrayList<String>();
        IniFile apmdiscovery = new IniFile(APMDiscoveryHelper.getApmDiscoveryIniFileName());
        try {
            Hashtable<String, ArrayList> discoveryDetails = APMDiscoveryHelper.getBTMDiscoverySubjectsWithLines();
            if (discoveryDetails != null && discoveryDetails.size() > 0) {
                Set<String> subject = discoveryDetails.keySet();
                for (String techName : subject) {
                    ArrayList lineList;
                    if (techName == null || techName.endsWith("_CONTAINER_BASED") || (lineList = discoveryDetails.get(techName.trim())) == null || lineList.size() <= 0) continue;
                    int line = 0;
                    while (line < lineList.size()) {
                        String lineString = (String)lineList.get(line);
                        if (lineString != null && lineString.indexOf("=") >= 0) {
                            String temp_str = lineString.substring(0, lineString.indexOf("="));
                            StringTokenizer sf_tok = new StringTokenizer(temp_str, ":");
                            String comp_Type = "";
                            String compIp = "";
                            String compHostname = "";
                            String port = "";
                            int count_tok = sf_tok.countTokens();
                            if (count_tok >= 3) {
                                compIp = sf_tok.nextToken();
                                port = sf_tok.nextToken();
                                comp_Type = sf_tok.nextToken();
                                if (hostName.contains(compIp)) {
                                    compIp = hostName;
                                }
                                String fullString = String.valueOf(comp_Type) + ":" + compIp + ":" + port + "=" + comp_Type + "," + compIp + "," + compIp + "," + port + ",no";
                                discoverList.add(fullString);
                            }
                        }
                        ++line;
                    }
                }
            }
        }
        catch (Exception e) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception in discoverBTMComponents() {} ", (Object)loggerDispStr, (Object)e);
        }
        return discoverList;
    }

    public static HashMap<String, FinalizedContainerInfo> getBTMDiscoveredContainerComponents() {
        HashMap<String, FinalizedContainerInfo> btmData = new HashMap<String, FinalizedContainerInfo>();
        try {
            Hashtable<String, ArrayList> discoveryDetails = APMDiscoveryHelper.getBTMDiscoverySubjectsWithLines();
            if (discoveryDetails != null && discoveryDetails.size() > 0) {
                Set<String> subject = discoveryDetails.keySet();
                for (String techName : subject) {
                    ArrayList lineList;
                    if (techName == null || !techName.endsWith("_CONTAINER_BASED") || (lineList = discoveryDetails.get(techName.trim())) == null || lineList.size() <= 0) continue;
                    int line = 0;
                    while (line < lineList.size()) {
                        String lineString = (String)lineList.get(line);
                        if (lineString != null && lineString.indexOf("=") >= 0) {
                            String temp_str = lineString.substring(0, lineString.indexOf("="));
                            StringTokenizer sf_tok = new StringTokenizer(temp_str, ":");
                            String comp_Type = "";
                            String compIp = "";
                            String compHostname = "";
                            String port = "";
                            int count_tok = sf_tok.countTokens();
                            if (count_tok >= 3) {
                                compIp = sf_tok.nextToken();
                                port = sf_tok.nextToken();
                                comp_Type = sf_tok.nextToken();
                                FinalizedContainerInfo cInfo = new FinalizedContainerInfo(compIp);
                                cInfo.setServerType(comp_Type);
                                cInfo.setFinalizedPortNo(port);
                                btmData.put(compIp, cInfo);
                            }
                        }
                        ++line;
                    }
                }
            }
        }
        catch (Exception e) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception in getBTMContainerComponents() {} ", (Object)loggerDispStr, (Object)e);
        }
        return btmData;
    }

    public static boolean isProcessAndTransmitBTMDiscoveryDataViaAgentDiscovery() {
        if (ContainersService.getInstance().isContainerZ()) {
            return false;
        }
        return ApmConfigManager.getInstance().isTransmitBTMDiscoveryDataViaAgentDiscovery();
    }

    public static boolean isProcessAndTransmitBTMDiscoveryDataViaEgApmBtmDiscovery() {
        if (ContainersService.getInstance().isContainerZ()) {
            return ApmConfigManager.getInstance().isTransmitContBTMDiscoveryDataViaEgApmBtmDiscovery();
        }
        return ApmConfigManager.getInstance().isTransmitBTMDiscoveryDataViaEgApmBtmDiscovery();
    }

    public static boolean isProcessAndTransmitContBTMDiscoveryDataViaContainerDDTest() {
        if (ContainersService.getInstance().isContainerZ()) {
            return ApmConfigManager.getInstance().isTransmitContBTMDiscoveryDataViaContainerDDTest();
        }
        return false;
    }

    public static void printConfigs() {
        APMDiscoveryLogger.discoveryLogger.info(" {} isContainerZ : {}, isProcessAndTransmitBTMDiscoveryDataViaAgentDiscovery : {}, isProcessAndTransmitBTMDiscoveryDataViaEgApmBtmDiscovery : {}, isProcessAndTransmitContBTMDiscoveryDataViaContainerDDTest : {}", new Object[]{"[EG_APM]", ContainersService.getInstance().isContainerZ(), APMDiscoveryHelper.isProcessAndTransmitBTMDiscoveryDataViaAgentDiscovery(), APMDiscoveryHelper.isProcessAndTransmitBTMDiscoveryDataViaEgApmBtmDiscovery(), APMDiscoveryHelper.isProcessAndTransmitContBTMDiscoveryDataViaContainerDDTest()});
    }

    public static HashMap getBTMDiscoveredServiceNamesForBTM() {
        String offload_apmdiscovery_path = String.valueOf(EgInstallInfo.getInstallDir()) + "/agent/config/eg_apmdiscovery.ini";
        IniFile apmdiscovery = new IniFile(offload_apmdiscovery_path);
        return APMUtils.getLinesAsMap(apmdiscovery, "KUBERNETES_DETAILS", APMDiscoveryLogger.discoveryLogger);
    }
}

