/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMLanguage;
import com.eg.apm.AgentSocketServer;
import com.eg.apm.AgentStartupLogger;
import com.eg.apm.BTMOffloadAPMSocketConfiguration;
import com.eg.jtm.sampling.SamplingController;

public final class AgentJavaSocketServer
extends AgentSocketServer {
    private static AgentJavaSocketServer instance = null;
    private static final String logPrefix = " [AgentJavaSocketServer] Java - ";

    private AgentJavaSocketServer() {
    }

    public void startServer(BTMOffloadAPMSocketConfiguration configuration, boolean isContainerZHost) {
        block17: {
            boolean isServerSocketCreated = false;
            try {
                try {
                    String[] offloadPorts;
                    int offloadPort;
                    if (!this.isServerSocketCreated() && !(isServerSocketCreated = this.createServerSocket(configuration, offloadPort = configuration.getOffloadJavaServerSocketPort(), isContainerZHost, APMLanguage.JAVA)) && (offloadPorts = configuration.getOffloadJavaPortList()) != null && offloadPorts.length > 0) {
                        int i = 0;
                        while (i < offloadPorts.length) {
                            String portString = offloadPorts[i];
                            int port_no = this.getPortNo(portString);
                            if (port_no != -1 && !isServerSocketCreated) {
                                isServerSocketCreated = this.doReattempt(configuration, port_no, isContainerZHost, APMLanguage.JAVA);
                            }
                            ++i;
                        }
                    }
                }
                catch (Exception e) {
                    AgentStartupLogger.logger.error("{} Unable to create server socket due to {} ... ", (Object)logPrefix, (Object)e);
                    if (isServerSocketCreated) {
                        AgentStartupLogger.logger.info("{} Agent Server Socket has been created successfully !!! ", (Object)logPrefix);
                        int workers = configuration.getOffloadWorkers();
                        int queueSize = configuration.getQueueSize();
                        this.initializePoolsAndListeners(workers, queueSize, APMLanguage.JAVA);
                        try {
                            SamplingController.getInstance();
                            AgentStartupLogger.logger.debug("{} SamplingController has been created successfully !!!", (Object)logPrefix);
                        }
                        catch (Exception e2) {
                            AgentStartupLogger.logger.error("{} Exception when creating SamplingController", (Object)logPrefix, (Object)e2);
                        }
                        AgentStartupLogger.logger.debug("{} Server Socket instance is handed off to ClientSocketListener !!!", (Object)logPrefix);
                        break block17;
                    }
                    AgentStartupLogger.logger.error("{} Unable to create agent server socket, returning without socket creation ... ", (Object)logPrefix);
                }
            }
            finally {
                if (isServerSocketCreated) {
                    AgentStartupLogger.logger.info("{} Agent Server Socket has been created successfully !!! ", (Object)logPrefix);
                    int workers = configuration.getOffloadWorkers();
                    int queueSize = configuration.getQueueSize();
                    this.initializePoolsAndListeners(workers, queueSize, APMLanguage.JAVA);
                    try {
                        SamplingController.getInstance();
                        AgentStartupLogger.logger.debug("{} SamplingController has been created successfully !!!", (Object)logPrefix);
                    }
                    catch (Exception e) {
                        AgentStartupLogger.logger.error("{} Exception when creating SamplingController", (Object)logPrefix, (Object)e);
                    }
                    AgentStartupLogger.logger.debug("{} Server Socket instance is handed off to ClientSocketListener !!!", (Object)logPrefix);
                } else {
                    AgentStartupLogger.logger.error("{} Unable to create agent server socket, returning without socket creation ... ", (Object)logPrefix);
                }
            }
        }
    }

    public boolean isSocketServerStarted() {
        return instance != null && instance.isServerSocketCreated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AgentJavaSocketServer getInstance() {
        if (instance != null) return instance;
        Class<AgentJavaSocketServer> clazz = AgentJavaSocketServer.class;
        synchronized (AgentJavaSocketServer.class) {
            if (instance != null) return instance;
            instance = new AgentJavaSocketServer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void closeServerSocket() {
        super.closeServerSocket();
        if (instance != null) {
            instance = null;
        }
    }
}

