/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMLanguage;
import com.eg.apm.AgentSocketServer;
import com.eg.apm.AgentStartupLogger;
import com.eg.apm.BTMOffloadAPMSocketConfiguration;

public final class AgentNodeSocketServer
extends AgentSocketServer {
    private static AgentNodeSocketServer instance;
    private static final String logPrefix = " [AgentNodeSocketServer] Node.js - ";

    private AgentNodeSocketServer() {
    }

    public void startServer(BTMOffloadAPMSocketConfiguration configuration, boolean isContainerZHost) {
        block14: {
            boolean isServerSocketCreated = false;
            try {
                try {
                    String[] offloadPorts;
                    int offloadPort;
                    if (!this.isServerSocketCreated() && !(isServerSocketCreated = this.createServerSocket(configuration, offloadPort = configuration.getOffloadNodeServerSocketPort(), isContainerZHost, APMLanguage.NODEJS)) && (offloadPorts = configuration.getOffloadNodePortList()) != null && offloadPorts.length > 0) {
                        int i = 0;
                        while (i < offloadPorts.length) {
                            String portString = offloadPorts[i];
                            int port_no = this.getPortNo(portString);
                            if (port_no != -1 && !isServerSocketCreated) {
                                isServerSocketCreated = this.doReattempt(configuration, port_no, isContainerZHost, APMLanguage.NODEJS);
                            }
                            ++i;
                        }
                    }
                }
                catch (Exception e) {
                    AgentStartupLogger.logger.error("{} Unable to create server socket due to {} ... {} ", new Object[]{logPrefix, e.getMessage(), e});
                    if (isServerSocketCreated) {
                        AgentStartupLogger.logger.info("{} Agent Server Socket has been created successfully", (Object)logPrefix);
                        int workers = configuration.getOffloadWorkers();
                        int queueSize = configuration.getQueueSize();
                        this.initializePoolsAndListeners(workers, queueSize, APMLanguage.NODEJS);
                        AgentStartupLogger.logger.debug("{} Server Socket instance is handed off to NodeJS ClientSocketListener !!!", (Object)logPrefix);
                    } else {
                        AgentStartupLogger.logger.error("{} Unable to create agent server socket, returning without NodeJS BTM Server Socket creation ... ", (Object)logPrefix);
                        AgentStartupLogger.logger.error("{} Please specify available port to \"{}\" in (manager)eg_tests.ini under [{}] section, & restart eG Agent.", new Object[]{logPrefix, "NodeJSAgentServerSocketPortOrder", "AGENT_SOCKET_SETTINGS"});
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (isServerSocketCreated) {
                    AgentStartupLogger.logger.info("{} Agent Server Socket has been created successfully", (Object)logPrefix);
                    int workers = configuration.getOffloadWorkers();
                    int queueSize = configuration.getQueueSize();
                    this.initializePoolsAndListeners(workers, queueSize, APMLanguage.NODEJS);
                    AgentStartupLogger.logger.debug("{} Server Socket instance is handed off to NodeJS ClientSocketListener !!!", (Object)logPrefix);
                } else {
                    AgentStartupLogger.logger.error("{} Unable to create agent server socket, returning without NodeJS BTM Server Socket creation ... ", (Object)logPrefix);
                    AgentStartupLogger.logger.error("{} Please specify available port to \"{}\" in (manager)eg_tests.ini under [{}] section, & restart eG Agent.", new Object[]{logPrefix, "NodeJSAgentServerSocketPortOrder", "AGENT_SOCKET_SETTINGS"});
                }
                throw throwable;
            }
            if (isServerSocketCreated) {
                AgentStartupLogger.logger.info("{} Agent Server Socket has been created successfully", (Object)logPrefix);
                int workers = configuration.getOffloadWorkers();
                int queueSize = configuration.getQueueSize();
                this.initializePoolsAndListeners(workers, queueSize, APMLanguage.NODEJS);
                AgentStartupLogger.logger.debug("{} Server Socket instance is handed off to NodeJS ClientSocketListener !!!", (Object)logPrefix);
            } else {
                AgentStartupLogger.logger.error("{} Unable to create agent server socket, returning without NodeJS BTM Server Socket creation ... ", (Object)logPrefix);
                AgentStartupLogger.logger.error("{} Please specify available port to \"{}\" in (manager)eg_tests.ini under [{}] section, & restart eG Agent.", new Object[]{logPrefix, "NodeJSAgentServerSocketPortOrder", "AGENT_SOCKET_SETTINGS"});
            }
        }
    }

    public boolean isSocketServerStarted() {
        return instance != null && instance.isServerSocketCreated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AgentNodeSocketServer getInstance() {
        if (instance != null) return instance;
        Class<AgentNodeSocketServer> clazz = AgentNodeSocketServer.class;
        synchronized (AgentNodeSocketServer.class) {
            if (instance != null) return instance;
            instance = new AgentNodeSocketServer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void closeServerSocket() {
        super.closeServerSocket();
        if (instance != null) {
            instance = null;
        }
    }
}

