/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.apm.APMComponent;
import com.eg.apm.ComponentIDRepository;
import com.eg.apm.EgApmFilesSync;
import com.eg.apm.JavaBTMOffloadLogger;
import com.eg.apm.Status;
import com.eg.jtm.BTMConstants;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BaseComponentIDRepository
implements ComponentIDRepository {
    protected static final ConcurrentHashMap<String, APMComponent> componentRepository = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> tempComponentRepository = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> tempDisocoveredPingTimeRepository = new ConcurrentHashMap();
    private HashMap guidNickMap = new HashMap();
    private HashMap nickGuidMap = new HashMap();
    private static final String loggerDispStr = "[BaseComponentIDRepository]";

    @Override
    public String getGUID(String nodeID) {
        return (String)this.nickGuidMap.get(nodeID);
    }

    @Override
    public String getNick(String jvmID) {
        return (String)this.guidNickMap.get(jvmID);
    }

    @Override
    public HashMap getGuidNickMap() {
        return this.guidNickMap;
    }

    @Override
    public void setGuidNickMap(HashMap guidNickMapNew) {
        if (guidNickMapNew != null && guidNickMapNew.size() > 0) {
            this.guidNickMap = guidNickMapNew;
        }
    }

    @Override
    public HashMap getNickguidMap() {
        return this.nickGuidMap;
    }

    @Override
    public void setNickguidMap(HashMap nickguidMapNew) {
        if (nickguidMapNew != null && nickguidMapNew.size() > 0) {
            this.nickGuidMap = nickguidMapNew;
        }
    }

    @Override
    public void registerStatusAsManagedOffload(String componentID) {
        APMComponent component = componentRepository.get(componentID);
        if (component != null) {
            component.setStatus(Status.MANAGED_OFFLOAD);
            JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} ComponentID:{} is registered as {} ", new Object[]{loggerDispStr, componentID, Status.MANAGED_OFFLOAD});
        } else {
            JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} ComponentID:{} is not registered {} ", new Object[]{loggerDispStr, componentID, component});
        }
    }

    @Override
    public boolean isNonOffloadComponentID(String componentID) {
        APMComponent component = componentRepository.get(componentID);
        return component != null && component.getStatus() == Status.MANAGED_NON_OFFLOAD;
    }

    @Override
    public ConcurrentHashMap<String, APMComponent> getComponentRepository() {
        return componentRepository;
    }

    @Override
    public boolean isSiteIdAvailable(String componentID) {
        return componentRepository.containsKey(componentID);
    }

    @Override
    public boolean isOffloadComponentID(String componentID) {
        APMComponent component = componentRepository.get(componentID);
        return component != null && component.getStatus() == Status.MANAGED_OFFLOAD;
    }

    @Override
    public APMComponent getAPMComponent(String componentID) {
        return componentRepository.get(componentID);
    }

    @Override
    public void setStatusForBtmDiscovery(String jvmGuid, boolean finalized) {
        APMComponent component = this.getAPMComponent(jvmGuid);
        if (component != null && component.isNewlyDiscoverd()) {
            if (finalized) {
                component.setDiscoveredDetailsFinalized(true);
                JavaBTMOffloadLogger.btmOffLoadLogger.info("{} Discovery details stored for {} and discovery finalized ACK added to APMComponent ", (Object)loggerDispStr, (Object)jvmGuid);
            } else {
                component.setDiscoveredDetailsStored(true);
                JavaBTMOffloadLogger.btmOffLoadLogger.info("{} Discovery details stored for {} and discovery stored ACK added to APMComponent ", (Object)loggerDispStr, (Object)jvmGuid);
            }
        }
    }

    protected void addEntryIntoAutoDeleteIni(String subject, String variable, String value) {
        IniFile inifile = EgApmFilesSync.getInstance(String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.AUTO_DELETE_FILEPATH, true);
        try {
            try {
                inifile.setValue(subject, variable, value);
                inifile.saveFile();
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{}  Add entry to eg_agentAutoDelete.ini :-  {} = {} ", new Object[]{loggerDispStr, variable, value});
            }
            catch (Exception e) {
                JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Unable to add entry to eg_agentAutoDelete.ini :-  {} = {}", new Object[]{loggerDispStr, variable, value});
                EgApmFilesSync.releaseInstance(inifile);
            }
        }
        finally {
            EgApmFilesSync.releaseInstance(inifile);
        }
    }

    @Override
    public ConcurrentHashMap<String, String> getTempComponentIDTable() {
        return this.tempComponentRepository;
    }

    @Override
    public void addToTempComponentRepository(String key, String value) {
        if (key != null && value != null) {
            this.tempComponentRepository.put(key, value);
        }
    }

    @Override
    public String getComponentGuidFromTemp(String key) {
        return this.tempComponentRepository.get(key);
    }

    @Override
    public boolean removeFromTempComponentRepository(String key, boolean removeDependecy) {
        this.tempComponentRepository.remove(key);
        return true;
    }

    @Override
    public boolean isThisManaged(String componentID) {
        return this.tempComponentRepository.containsKey(componentID);
    }

    @Override
    public ConcurrentHashMap<String, String> getDiscoveryPingTimeTable() {
        return this.tempDisocoveredPingTimeRepository;
    }

    @Override
    public void addToTempComponentDiscoveryRepository(String key, String value) {
        if (key != null && value != null) {
            this.tempDisocoveredPingTimeRepository.put(key, value);
        }
    }

    @Override
    public String getLastPingTimeFromDiscoveryTemp(String key) {
        return this.tempDisocoveredPingTimeRepository.get(key);
    }

    @Override
    public boolean removeFromTempComponentDiscoveryRepository(String key, boolean removeDependecy) {
        this.tempDisocoveredPingTimeRepository.remove(key);
        return true;
    }

    @Override
    public boolean isThisAvailableInDiscoveryPingTime(String componentID) {
        return this.tempDisocoveredPingTimeRepository.containsKey(componentID);
    }
}

