/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.Container;
import com.eg.apm.ContainerCategory;
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.Hashtable;

public abstract class ContainerImpl
implements Container {
    protected Hashtable ht_runningContainerIpMap = new Hashtable();
    protected Hashtable ht_containerIdAndPodName = new Hashtable();
    protected Hashtable ht_containerIdAndPort = new Hashtable();
    protected Hashtable ht_NotRunningContainers = new Hashtable();
    protected Hashtable ht_containerIdAndNameSpace = new Hashtable();
    protected static final String CRIO_CMD = "crictl ";
    protected long lastUpdatedTime = 0L;
    private ContainerCategory containerCategory;
    private static final String loggerDispStr = "";
    private static String contSync = new String("contSync");

    public ContainerImpl(ContainerCategory containerCategory) {
        this.containerCategory = containerCategory;
    }

    public boolean isDockerContainer() {
        return this.containerCategory.isDocker();
    }

    public boolean isCrioContainer() {
        return this.containerCategory.isCrio();
    }

    public boolean isPodmanContainer() {
        return this.containerCategory.isPodman();
    }

    public boolean isContainerNotinRuningState(String string) {
        boolean bl = false;
        if (this.ht_NotRunningContainers != null && this.ht_NotRunningContainers.containsKey(string)) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRunningContainerIpDetails(boolean bl) {
        long l = System.currentTimeMillis();
        if (l - this.lastUpdatedTime > 600000L || bl && l - this.lastUpdatedTime > 10000L) {
            String string = contSync;
            synchronized (string) {
                APMDiscoveryLogger.discoveryLogger.info("{} Doing Container IP Update, isToForce : {}", (Object)loggerDispStr, (Object)bl);
                this.ht_runningContainerIpMap = this.getRunningContainerIpDetails();
            }
            this.lastUpdatedTime = l;
        }
    }

    public String getContainerIp(String string) {
        return this.getContainerIp(string, false);
    }

    public String getContainerIp(String string, boolean bl) {
        this.updateRunningContainerIpDetails(bl);
        String string2 = loggerDispStr;
        if (this.ht_runningContainerIpMap != null && this.ht_runningContainerIpMap.containsKey(string)) {
            string2 = (String)this.ht_runningContainerIpMap.get(string);
        }
        APMDiscoveryLogger.discoveryLogger.trace("{} strContainerId : {}, strContIpAddr : {}, ht_runningContainerIpMap : {}", new Object[]{loggerDispStr, string, string2, this.ht_runningContainerIpMap});
        return string2;
    }

    public String getPodName(String string) {
        this.updateRunningContainerIpDetails(false);
        String string2 = loggerDispStr;
        if (this.ht_containerIdAndPodName != null && this.ht_containerIdAndPodName.containsKey(string)) {
            string2 = (String)this.ht_containerIdAndPodName.get(string);
        } else {
            this.updateRunningContainerIpDetails(true);
            if (this.ht_containerIdAndPodName != null && this.ht_containerIdAndPodName.containsKey(string)) {
                string2 = (String)this.ht_containerIdAndPodName.get(string);
            }
        }
        APMDiscoveryLogger.discoveryLogger.trace("{} strContainerId : {}, strPodName : {}, ht_containerIdAndPodName : {}", new Object[]{loggerDispStr, string, string2, this.ht_containerIdAndPodName});
        return string2;
    }

    public String getPodNameSpaceName(String string) {
        String string2 = loggerDispStr;
        return string2;
    }

    public Hashtable getContainerPortDetails() {
        return this.ht_containerIdAndPort;
    }

    public ArrayList executeCommand(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ArrayList arrayList = null;
        ArrayList arrayList2 = new ArrayList();
        try {
            EgUtilities egUtilities = EgUtilities.createInstance();
            arrayList2 = egUtilities.getExecOutputLines(string);
            if (arrayList2 != null && arrayList2.size() >= 2) {
                arrayList = (ArrayList)arrayList2.get(0);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception  occured in DockerContainers while calling executeCommand " + string + " \tdata =" + arrayList2);
            exception.printStackTrace();
        }
        return arrayList;
    }

    public ArrayList egTokenizer(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        int n = string2.length();
        int n2 = 0;
        int n3 = string.indexOf(string2);
        while (n3 >= 0) {
            string3 = string.substring(n2, n3);
            arrayList.add(string3);
            n2 = n3 + n;
            n3 = string.indexOf(string2, n2);
        }
        string3 = string.substring(n2);
        arrayList.add(string3);
        return arrayList;
    }

    public abstract Hashtable geRunningContainerDetails();

    public abstract Hashtable getRunningContainerIpDetails();

    public abstract void updateRepo();
}

