/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgCrypt;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.ApmDemoInfo;
import com.eg.apm.ContainerEnvironment;
import com.eg.apm.ContainerType;
import com.eg.apm.ContainerUtils;
import com.egurkha.util.EgUtilities;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContainersService {
    private boolean isWindows = false;
    private boolean isDaemonSetAgent = false;
    private boolean isHybridEnv = false;
    private boolean ssl = false;
    private String serviceToken = "";
    private String containerIP = "127.0.0.1";
    private String containerID = "";
    private String nameSpaceName = "";
    private String podName = "";
    private String ip = "127.0.0.1";
    private int port = 443;
    private String mountPath = "/opt/egbtm/";
    private static ContainersService instance = null;
    private static final String EG_MANAGER = "EG_MANAGER";
    private static final String KUBERNETES_SERVICE_HOST = "KUBERNETES_SERVICE_HOST";
    private static final String EG_CONTAINER_RT_ORCH_ENABLED = "EG_CONTAINER_RT_ORCH_ENABLED";
    private static final String EG_BTM_MOUNT_PATH = "EG_BTM_MOUNT_PATH";
    private static final String EG_CONTAINER_RT_ENABLED = "EG_CONTAINER_RT_ENABLED";
    private static final String HOSTNAME_FILENAME = "/etc/hostname";
    private static final String NAMESPACE_FILENAME = "/var/run/secrets/kubernetes.io/serviceaccount/namespace";
    private static final String logPrefix = "[ContainersService] ";

    private ContainersService() {
        this.initContainerClusterEnvDiscovery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContainersService getInstance() {
        if (instance != null) return instance;
        Class<ContainersService> clazz = ContainersService.class;
        synchronized (ContainersService.class) {
            if (instance != null) return instance;
            instance = new ContainersService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean isContainerZ() {
        ContainerEnvironment containerEnvironment = ContainerEnvironment.getInstance();
        return containerEnvironment.getContainerType().isContainerZ();
    }

    public boolean isContainerClusterEnvZ() {
        ContainerEnvironment containerEnvironment = ContainerEnvironment.getInstance();
        return containerEnvironment.getContainerType().isCluster();
    }

    public boolean isDaemonSet() {
        return this.isDaemonSetAgent;
    }

    public boolean isValidForMountPath() {
        return this.isDaemonSetAgent || this.isContainerZ();
    }

    public boolean isKubernetes() {
        ContainerEnvironment containerEnvironment = ContainerEnvironment.getInstance();
        return containerEnvironment.getContainerType().isK8Pod();
    }

    public String getMountPath() {
        return this.mountPath;
    }

    public String getServiceToken() {
        if (this.serviceToken != null) {
            return this.serviceToken;
        }
        return "";
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSSL() {
        return this.ssl;
    }

    private void initContainerClusterEnvDiscovery() {
        try {
            Object object;
            ContainerEnvironment containerEnvironment = ContainerEnvironment.getInstance();
            this.readManualConfigs(containerEnvironment);
            if (!containerEnvironment.isLinuxContainer()) {
                return;
            }
            String string = System.getenv(KUBERNETES_SERVICE_HOST);
            if (string == null) {
                string = "";
            }
            this.discoverAgentRunningMode(string);
            if (ApmDemoInfo.isKubernetesDemoMode()) {
                try {
                    containerEnvironment.setContainerTypeByManualOption(ContainerType.DOCKER_K8);
                    object = ApmDemoInfo.getKubernetesDemo();
                    this.ip = (String)((HashMap)object).get("IP");
                    this.port = Integer.parseInt((String)((HashMap)object).get("Port"));
                    this.serviceToken = (String)((HashMap)object).get("Token");
                    this.ssl = Boolean.parseBoolean((String)((HashMap)object).get("Ssl"));
                    APMDiscoveryLogger.discoveryLogger.info("{} Activating Kubernetes service discovery in DEMO mode", (Object)logPrefix);
                }
                catch (Exception exception) {
                    APMDiscoveryLogger.discoveryLogger.warn("{} Exception while processing isThisAgentRunningAsADaemonSet() : {}", (Object)logPrefix, (Object)exception);
                }
            } else if (this.isDaemonSetAgent) {
                this.findContainerClusterEnv(string);
                this.findIpAndPort(string);
                this.findKubeServiceToken();
                if (this.isKubernetes() && ApmConfigManager.getInstance().isK8ServiceNameDiscoveryEnabled()) {
                    APMDiscoveryLogger.discoveryLogger.warn("{} [EG_EVENT_INFO] Activating Kubernetes service discovery in DAEMONSET mode", (Object)logPrefix);
                }
            }
            object = containerEnvironment.getContainerType();
            this.discoverContainerRunTimeEnv((ContainerType)((Object)object));
            this.discoverHybridEnv();
            this.printDetails((ContainerType)((Object)object));
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while processing isThisAgentRunningAsADaemonSet() : {}", (Object)logPrefix, (Object)exception);
        }
    }

    private void discoverContainerRunTimeEnv(ContainerType containerType) {
        APMDiscoveryLogger.discoveryLogger.warn("{} [EG_EVENT_INFO] Is eG Agent Running on CONTAINER inside of POD? {}, Is this CONTAINER : {}, CONTAINER type : {} ", new Object[]{logPrefix, containerType.isK8Pod(), containerType.isContainerZ(), containerType.toString()});
        this.containerID = this.getContainerID();
        this.containerIP = this.getContainerIp();
    }

    private void discoverAgentRunningMode(String string) {
        try {
            this.discoverK8ServiceHost(string);
            APMDiscoveryLogger.discoveryLogger.warn("{} [EG_EVENT_INFO] eG Agent running as a DAEMON-SET: {} ", (Object)logPrefix, (Object)this.isDaemonSetAgent);
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while finding eG Agent Running Mode. {}", (Object)logPrefix, (Object)exception);
        }
    }

    private void readManualConfigs(ContainerEnvironment containerEnvironment) {
        try {
            String string;
            String string2 = System.getenv(EG_MANAGER);
            String string3 = System.getenv(EG_CONTAINER_RT_ORCH_ENABLED);
            if (string3 != null && string3.length() > 0 && string3.equalsIgnoreCase("true")) {
                this.isDaemonSetAgent = true;
            }
            String string4 = System.getenv(EG_BTM_MOUNT_PATH);
            if (string3 != null && string3.length() > 2) {
                this.mountPath = string4.trim();
            }
            if ((string = System.getenv(EG_CONTAINER_RT_ENABLED)) == null || string.length() <= 0 || string.trim().equalsIgnoreCase("true")) {
                // empty if block
            }
            APMDiscoveryLogger.discoveryLogger.warn("{} [EG_EVENT_INFO] eG Agent running as a DAEMON-SET: {}, eG Manager URL: {}, {}: {}, {}: {}, {}: {}", new Object[]{logPrefix, this.isDaemonSetAgent, string2, EG_CONTAINER_RT_ORCH_ENABLED, string3, EG_BTM_MOUNT_PATH, string4, EG_CONTAINER_RT_ENABLED, string});
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while finding eG Agent Running Mode. {}", (Object)logPrefix, (Object)exception);
        }
    }

    private void discoverK8ServiceHost(String string) {
        if (string != null && string.length() > 0) {
            this.isDaemonSetAgent = true;
        }
    }

    private void findContainerClusterEnv(String string) {
        String string2;
        this.discoverK8ServiceHost(string);
        String string3 = this.getDockerContainerIdOrPodName();
        if (string3 != null && string3.length() > 0) {
            this.podName = string3.trim();
        }
        if ((string2 = this.getKubernetesNameSpaceName()) != null && string2.length() > 0) {
            this.nameSpaceName = string2.trim();
        }
    }

    private void printDetails(ContainerType containerType) {
        if (APMDiscoveryLogger.discoveryLogger.isWarnEnabled()) {
            APMDiscoveryLogger.discoveryLogger.warn("{} [EG_EVENT_INFO] Container run time details:- Container RT: {}, Container Cluster Env: {}, IP: {}, Container ID : {}, Pod Name : {}, Name Space Name : {}", new Object[]{logPrefix, containerType.toString(), containerType.isCluster(), this.containerIP, this.containerID, this.podName, this.nameSpaceName});
            APMDiscoveryLogger.discoveryLogger.warn("{} [EG_EVENT_INFO] Container Cluster Master IP : {}, Port : {}, SSL : {}", new Object[]{logPrefix, this.ip, this.port, this.ssl});
            if (this.serviceToken != null) {
                APMDiscoveryLogger.discoveryLogger.warn("{} [EG_EVENT_INFO] Container Cluster Master Token Length: {}, masked token: {}", new Object[]{logPrefix, this.serviceToken.length(), EgCrypt.encrypt(this.serviceToken)});
            }
            APMDiscoveryLogger.discoveryLogger.warn("{} [EG_EVENT_INFO] is Kubernetes Demo Mode : {}", (Object)logPrefix, (Object)ApmDemoInfo.isKubernetesDemoMode());
            APMDiscoveryLogger.discoveryLogger.warn("{} [EG_EVENT_INFO] eG Agent System Properties : {}, ", (Object)logPrefix, (Object)System.getProperties());
            APMDiscoveryLogger.discoveryLogger.warn("{} [EG_EVENT_INFO] eG Agent System Env Variables : {}, ", (Object)logPrefix, System.getenv());
        }
    }

    private void findIpAndPort(String string) {
        try {
            if (string != null && string.length() > 0) {
                this.ip = string.trim();
            } else {
                APMDiscoveryLogger.discoveryLogger.info("{} Unable to get data for KUBERNETES_SERVICE_HOST: ", (Object)logPrefix, (Object)string);
            }
            String string2 = System.getenv("KUBERNETES_PORT_443_TCP_PORT");
            if (string2 != null && string2.length() > 0) {
                this.port = Integer.parseInt(string2.trim());
            } else {
                APMDiscoveryLogger.discoveryLogger.info("{} Unable to get data for KUBERNETES_PORT_443_TCP_PORT: ", (Object)logPrefix, (Object)string2);
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while processing findIpAndPort() : {}", (Object)logPrefix, (Object)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFileContentAsString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2).append("\n");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (!this.isWindows) {
                APMDiscoveryLogger.discoveryLogger.warn("{} {} - File Not found exception : ", (Object)logPrefix, (Object)string);
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while processing readFileContentAsString() : {}", (Object)logPrefix, (Object)exception);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
        return stringBuilder.toString().trim();
    }

    private void findKubeServiceToken() {
        String string;
        if (!this.isWindows && (string = this.readFileContentAsString("/var/run/secrets/kubernetes.io/serviceaccount/token")) != null && string.length() > 0) {
            this.serviceToken = string.trim();
            this.ssl = true;
        }
    }

    private String getKubernetesNameSpaceName() {
        return this.readFileContentAsString(NAMESPACE_FILENAME);
    }

    public boolean isDocker() {
        ContainerEnvironment containerEnvironment = ContainerEnvironment.getInstance();
        return containerEnvironment.getContainerType().isDocker();
    }

    public boolean isCrio() {
        ContainerEnvironment containerEnvironment = ContainerEnvironment.getInstance();
        return containerEnvironment.getContainerType().isCrio();
    }

    private String getDockerContainerIdOrPodName() {
        return this.readFileContentAsString(HOSTNAME_FILENAME);
    }

    private String getContainerIDUsingMultiCmds() {
        String string = "";
        String string2 = "cat /proc/self/cgroup | grep -e \"cpu\" | grep -o  -e \"docker-.*.scope\" | head -n 1 | sed \"s/docker-\\(.*\\).scope/\\\\1/\"";
        string = this.findContainerId(string2, "DOCKER");
        if (string.length() == 0) {
            string2 = "cat /proc/self/cgroup | grep -e \"cpu\" | grep -o  -e \"crio-.*\" | head -n 1 | sed \"s/crio-\\(.*\\)/\\\\1/\"";
            string = this.findContainerId(string2, "CRI-O_K8S");
        }
        if (string.length() == 0) {
            string2 = "cat /proc/self/cgroup | grep -e \"cpu\" | grep -o  -e \"crio-.*.scope\" | head -n 1 | sed \"s/crio-\\(.*\\).scope/\\\\1/\"";
            string = this.findContainerId(string2, "CRI-O");
        }
        if (string.length() == 0) {
            string2 = "cat /proc/self/cgroup  | grep -e \"cpu\" | awk -F\"/\" '{print $NF}' | head -n 1";
            string = this.findContainerId(string2, "AWS-EKS-ECS");
        }
        if (string.length() == 0) {
            string2 = "cat /proc/self/cgroup | head -1";
            this.findContainerId(string2, "CONTAINER");
        }
        return string;
    }

    private String getContainerID() {
        ContainerEnvironment containerEnvironment = ContainerEnvironment.getInstance();
        String string = containerEnvironment.getContainerType().getCommandForContainerID();
        String string2 = "";
        if (string != null) {
            string2 = this.findContainerId(string, containerEnvironment.getContainerType().toString());
            if (string2 == null || string2.length() == 0) {
                string2 = this.getContainerIDUsingMultiCmds();
            }
            if (string2 != null && string2.length() > 0) {
                if ((string2 = string2.trim()).length() >= 64) {
                    string2 = string2.trim().substring(0, 12);
                }
                containerEnvironment.setContainerName(string2);
            }
        }
        return string2;
    }

    private String findContainerId(String string, String string2) {
        String string3 = "";
        try {
            String string4;
            EgUtilities egUtilities = EgUtilities.createInstance();
            ArrayList arrayList = egUtilities.getCommandOutputLines(string);
            APMDiscoveryLogger.discoveryLogger.info("{} {}:- container ID by using {} & output : {}", new Object[]{logPrefix, string2, string, arrayList});
            if (arrayList != null && arrayList.size() > 0 && (string4 = arrayList.get(0).toString()) != null && string4.length() > 0) {
                string3 = string4;
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} {}:- Unable to get output for : {}", new Object[]{logPrefix, string2, string});
        }
        return string3;
    }

    private String getContainerIp() {
        String string = "";
        try {
            String string2;
            String string3 = "hostname -i";
            EgUtilities egUtilities = EgUtilities.createInstance();
            ArrayList arrayList = egUtilities.getCommandOutputLines(string3);
            APMDiscoveryLogger.discoveryLogger.info("{} DOCKER Container IP by using [{}] , output is {}", new Object[]{logPrefix, string3, arrayList});
            if (arrayList != null && arrayList.size() > 0) {
                string2 = arrayList.get(0).toString();
                string = this.getValidIp(string2);
            }
            if (string.length() == 0) {
                string3 = "awk 'END{print $1}' /etc/hosts";
                arrayList = egUtilities.getCommandOutputLines(string3);
                APMDiscoveryLogger.discoveryLogger.info("{} 2nd attempt: Container IP by using [{}] , output is {}", new Object[]{logPrefix, string3, arrayList});
                if (arrayList != null && arrayList.size() > 0) {
                    string2 = arrayList.get(0).toString();
                    string = this.getValidIp(string2);
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to get container IP", (Object)logPrefix, (Object)exception);
        }
        return string;
    }

    private String getValidIp(String string) {
        try {
            if (string != null && string.length() > 0) {
                if ((string = string.trim()).contains(" ")) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        if (!ContainersService.isValidIPv4Address(string2)) continue;
                        return string2;
                    }
                } else if (ContainersService.isValidIPv4Address(string)) {
                    return string;
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to validate given IP string : {}", new Object[]{logPrefix, string, exception});
        }
        return "";
    }

    private static boolean isValidIPv4Address(String string) {
        if (string == null) {
            return false;
        }
        String string2 = "^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    private void discoverHybridEnv() {
        if (!this.isContainerZ()) {
            ContainerUtils containerUtils = new ContainerUtils();
            if (containerUtils.isDockerDaemonRunning()) {
                this.isHybridEnv = true;
                APMDiscoveryLogger.discoveryLogger.warn("{} [EG_EVENT_INFO] DOCKER daemon detected, eG Agent running in HOST OS  [HYBRID ENV : Linux & DOCKER] ", (Object)logPrefix);
            } else if (containerUtils.isCrioDaemonRunning()) {
                this.isHybridEnv = true;
                APMDiscoveryLogger.discoveryLogger.warn("{} [EG_EVENT_INFO] CRIO daemon detected, eG Agent running in HOST OS [HYBRID ENV : Linux & CRIO] ", (Object)logPrefix);
            }
        }
    }

    public boolean isHybridEnv() {
        return this.isHybridEnv;
    }
}

