/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.APMUtils;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.Discovery;
import com.eg.apm.DiscoveryMode;
import com.eg.apm.DiscoveryModes;
import com.eg.apm.EgDiscoveryUtils;
import com.eg.apm.JavaDiscoveryRepository;
import com.eg.apm.JavaProcessDiscoveryHelper;
import com.eg.apm.Process;
import com.eg.apm.ProcessPatternMatcher;
import com.eg.apm.ServerTypePatternMatcher;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProcessDiscoveryController
implements Discovery {
    private static final JavaProcessDiscoveryController INSTANCE = new JavaProcessDiscoveryController();
    private static final String loggerDispStr = "[JavaProcessDiscoveryController]";
    private String ipAddress = null;
    private JavaDiscoveryRepository javaProcessRepository = null;
    private JavaDiscoveryRepository blockedJavaProcessRepository = null;
    private HashMap currentMD5Hash = null;
    private ServerTypePatternMatcher serverTypePatterenMatcher = null;
    private ProcessPatternMatcher processPatternMatcher = null;
    private DiscoveryModes discoveryModes = null;
    private boolean firstRun = false;

    private JavaProcessDiscoveryController() {
        this.initDiscovery();
    }

    public static JavaProcessDiscoveryController getController() {
        return INSTANCE;
    }

    @Override
    public void initDiscovery() {
        this.processPatternMatcher = new ProcessPatternMatcher();
        this.serverTypePatterenMatcher = new ServerTypePatternMatcher();
        this.javaProcessRepository = JavaDiscoveryRepository.build();
        this.blockedJavaProcessRepository = JavaDiscoveryRepository.build();
        this.firstRun = true;
        this.ipAddress = APMUtils.getAgentIpAddress();
        EgDiscoveryUtils.setAgentIpAddress(this.ipAddress);
    }

    @Override
    public void loadSettings() {
        this.discoveryModes = new DiscoveryModes();
        try {
            APMDiscoveryLogger.discoveryLogger.debug("{} Configs getting loaded ", (Object)loggerDispStr);
            ApmConfigManager apmConfigManager = ApmConfigManager.getInstance();
            if (!apmConfigManager.checkForUpdate()) {
                apmConfigManager.updateConfiguration(true);
            }
            HashMap hashMap = null;
            if (this.firstRun) {
                hashMap = new HashMap();
                this.firstRun = false;
            } else {
                hashMap = this.getConfigHashInfo();
            }
            this.processPatternMatcher.getConfigurations();
            this.serverTypePatterenMatcher.getConfigurations();
            this.currentMD5Hash = this.getConfigHashInfo();
            this.updateDiscoveryModes();
            if (!hashMap.isEmpty() && this.isConfigurationUpdated(hashMap)) {
                this.clearData();
            }
            APMDiscoveryLogger.discoveryLogger.debug("{} Current configs:-  IpAddress : {}, Discovery discoveryModes : {}, Server type mapper : {}, process pattern mapper : {} , currentMD5Hash : {}, previousMD5Hash : {}", new Object[]{loggerDispStr, this.ipAddress, this.discoveryModes, this.serverTypePatterenMatcher, this.processPatternMatcher, this.currentMD5Hash, hashMap});
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to load settings", (Object)loggerDispStr, (Object)exception);
        }
    }

    private void updateDiscoveryModes() {
        if (ApmConfigManager.getInstance().isJavaProcessHandleDiscoveryEnabled()) {
            this.discoveryModes.add(DiscoveryMode.JAVA_PROCESS_HANDLE_API);
        }
    }

    private HashMap getConfigHashInfo() {
        HashMap hashMap = new HashMap();
        hashMap.putAll(this.serverTypePatterenMatcher.getConfigHash());
        hashMap.putAll(this.processPatternMatcher.getConfigHash());
        return hashMap;
    }

    private boolean isConfigurationUpdated(HashMap hashMap) {
        HashMap hashMap2 = APMUtils.getModifiedData(this.currentMD5Hash, hashMap, APMDiscoveryLogger.discoveryLogger);
        if (hashMap2.size() > 0) {
            APMDiscoveryLogger.discoveryLogger.info("{} - {} - Configuration Updated & resetting discovery repository with new config !!! ", (Object)loggerDispStr, hashMap2.keySet());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void startDiscovery() {
        try {
            try {
                if (this.isUnSupportedEnvironment()) {
                    APMDiscoveryLogger.discoveryLogger.debug("{} JAVA Process Discovery not supported in {}", (Object)loggerDispStr, (Object)ApmConfigManager.getInstance().getOsType());
                    Object var7_1 = null;
                    this.terminateHangingExecProcesses();
                    return;
                }
                APMDiscoveryLogger.discoveryLogger.info("{} JAVA Process Discovery started.!!!", (Object)loggerDispStr);
                JavaProcessDiscoveryHelper javaProcessDiscoveryHelper = new JavaProcessDiscoveryHelper(this.processPatternMatcher, this.serverTypePatterenMatcher);
                ArrayList<HashMap<String, Process>> arrayList = javaProcessDiscoveryHelper.doActivity(this.javaProcessRepository, this.blockedJavaProcessRepository, this.discoveryModes, this.ipAddress);
                boolean bl = false;
                if (arrayList != null && arrayList.size() == 2) {
                    HashMap<String, Process> hashMap = arrayList.get(0);
                    HashMap<String, Process> hashMap2 = arrayList.get(1);
                    this.updateToRepository(hashMap, hashMap2);
                    if (!hashMap.isEmpty() || !hashMap2.isEmpty()) {
                        bl = true;
                    }
                    if (APMDiscoveryLogger.discoveryLogger.isInfoEnabled() && bl) {
                        APMDiscoveryLogger.discoveryLogger.info("{} Newly discovered java processes : {} ", (Object)loggerDispStr, hashMap);
                        APMDiscoveryLogger.discoveryLogger.info("{} Newly blocked java processes : {} ", (Object)loggerDispStr, hashMap2);
                        APMDiscoveryLogger.discoveryLogger.info("{} Used configurations : {} ", (Object)loggerDispStr, (Object)javaProcessDiscoveryHelper);
                    }
                }
                if (APMDiscoveryLogger.discoveryLogger.isDebugEnabled() || bl) {
                    APMDiscoveryLogger.discoveryLogger.info("{} JAVA Process from MASTER repository : {} ", (Object)loggerDispStr, (Object)this.javaProcessRepository);
                    APMDiscoveryLogger.discoveryLogger.info("{} Blocked JAVA Process from MASTER repository : {} ", (Object)loggerDispStr, (Object)this.blockedJavaProcessRepository);
                }
                APMDiscoveryLogger.discoveryLogger.info("{} JAVA Process Discovery completed.!!!", (Object)loggerDispStr);
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do discovery ", (Object)loggerDispStr);
                Object var7_3 = null;
                this.terminateHangingExecProcesses();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_4 = null;
            this.terminateHangingExecProcesses();
            throw throwable;
        }
        Object var7_2 = null;
        this.terminateHangingExecProcesses();
    }

    private boolean isUnSupportedEnvironment() {
        return APMUtils.isAix() || APMUtils.isHpux() || APMUtils.isSolaris();
    }

    private void terminateHangingExecProcesses() {
        try {
            EgDiscoveryUtils egDiscoveryUtils = new EgDiscoveryUtils();
            egDiscoveryUtils.terminateOrphanProcesses();
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to verify and kill jcmd left-over processes  ", (Object)loggerDispStr, (Object)exception);
        }
    }

    @Override
    public void resetSettings() {
        try {
            APMDiscoveryLogger.discoveryLogger.debug("{} Configs getting reset ", (Object)loggerDispStr);
            this.discoveryModes = null;
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to reset ", (Object)loggerDispStr, (Object)exception);
        }
    }

    private void updateToRepository(HashMap<String, Process> hashMap, HashMap<String, Process> hashMap2) {
        if (hashMap != null && hashMap.size() > 0) {
            this.javaProcessRepository.getDiscoveredProcessData().addAll(hashMap);
        }
        if (hashMap2 != null && hashMap2.size() > 0) {
            this.blockedJavaProcessRepository.getDiscoveredProcessData().addAll(hashMap2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearData() {
        try {
            block7: {
                try {
                    boolean bl = false;
                    if (this.javaProcessRepository != null && !this.javaProcessRepository.getDiscoveredProcessData().isEmpty()) {
                        APMDiscoveryLogger.discoveryLogger.info("{} Current repository : {} ", (Object)loggerDispStr, (Object)this.javaProcessRepository);
                        this.javaProcessRepository.clear();
                        bl = true;
                    }
                    if (this.blockedJavaProcessRepository != null && !this.blockedJavaProcessRepository.getDiscoveredProcessData().isEmpty()) {
                        APMDiscoveryLogger.discoveryLogger.info("{} Current block listed repository : {} ", (Object)loggerDispStr, (Object)this.blockedJavaProcessRepository);
                        this.blockedJavaProcessRepository.clear();
                        bl = true;
                    }
                    if (this.currentMD5Hash != null && !this.currentMD5Hash.isEmpty()) {
                        APMDiscoveryLogger.discoveryLogger.info("{} Current MD5 hash config repository : {} ", (Object)loggerDispStr, (Object)this.currentMD5Hash);
                        this.currentMD5Hash.clear();
                        bl = true;
                    }
                    if (!bl) break block7;
                    APMDiscoveryLogger.discoveryLogger.info("{} Cleared MASTER Repository ", (Object)loggerDispStr);
                }
                catch (Exception exception) {
                    APMDiscoveryLogger.discoveryLogger.warn("{} Unable to clear MASTER repository", (Object)loggerDispStr, (Object)exception);
                    Object var3_4 = null;
                    this.terminateHangingExecProcesses();
                }
            }
            Object var3_3 = null;
            this.terminateHangingExecProcesses();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.terminateHangingExecProcesses();
            throw throwable;
        }
    }
}

