/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgInstallInfo;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.APMUtils;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.ContainerProcessUtils;
import com.eg.apm.ContainerRunTimeProcess;
import com.eg.apm.ContainersService;
import com.eg.apm.DiscoveryMode;
import com.eg.apm.DiscoveryModes;
import com.eg.apm.DiscoveryProtocol;
import com.eg.apm.EgDiscoveryHelper;
import com.eg.apm.EgDiscoveryUtils;
import com.eg.apm.JavaDiscoveryRepository;
import com.eg.apm.JavaProcess;
import com.eg.apm.JavaProcessList;
import com.eg.apm.JcmdUtils;
import com.eg.apm.NetstatUtils;
import com.eg.apm.Process;
import com.eg.apm.ProcessPatternMatcher;
import com.eg.apm.ServerTypePatternMatcher;
import com.eg.apm.TAG;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProcessDiscoveryHelper {
    private ServerTypePatternMatcher serverTypePatterenMatcher = null;
    private ProcessPatternMatcher processPatternMatcher = null;
    private static final String loggerDispStr = "[JavaProcessDiscoveryHelper]";

    public JavaProcessDiscoveryHelper(ProcessPatternMatcher processPatternMatcher, ServerTypePatternMatcher serverTypePatternMatcher) {
        this.processPatternMatcher = processPatternMatcher;
        this.serverTypePatterenMatcher = serverTypePatternMatcher;
    }

    private String getJavaProcHandleExecCmd() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("sudo");
        stringBuilder.append(" ");
        stringBuilder.append(EgInstallInfo.getInstallDir() + "/jre/bin/java");
        stringBuilder.append(" ");
        stringBuilder.append("-classpath");
        stringBuilder.append(" ");
        stringBuilder.append(EgInstallInfo.getInstallDir() + "/lib/eg_agent.jar:");
        stringBuilder.append(EgInstallInfo.getInstallDir() + "/lib/eg_util.jar:");
        stringBuilder.append(EgInstallInfo.getInstallDir() + "/lib/commons-codec.jar");
        stringBuilder.append(" ");
        stringBuilder.append("-Xmx200m -XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null -XX:-CreateCoredumpOnCrash");
        stringBuilder.append(" ");
        stringBuilder.append("com.eg.apm.ProcessInfo --java-filter --debug-off");
        return stringBuilder.toString();
    }

    public ArrayList<HashMap<String, Process>> doActivity(JavaDiscoveryRepository javaDiscoveryRepository, JavaDiscoveryRepository javaDiscoveryRepository2, DiscoveryModes discoveryModes, String string) {
        HashMap<String, Process> hashMap;
        HashMap<String, Process> hashMap2 = this.getLiveRunningJavaProcess(discoveryModes);
        if (javaDiscoveryRepository != null) {
            this.removeStoppedProcesses(javaDiscoveryRepository, hashMap2, true);
        }
        if (javaDiscoveryRepository2 != null) {
            this.removeStoppedProcesses(javaDiscoveryRepository2, hashMap2, false);
        }
        HashMap<String, Process> hashMap3 = this.getRecentJavaProcesses(javaDiscoveryRepository, javaDiscoveryRepository2, hashMap2);
        if (javaDiscoveryRepository != null && (hashMap = this.loadPartiallyDiscovered(javaDiscoveryRepository)).size() > 0) {
            hashMap3.putAll(hashMap);
        }
        hashMap = this.blockListContaineRtProcesses(hashMap3);
        if (this.isNewProcessFound(hashMap3)) {
            this.discoverCommandLineDetails(hashMap3, hashMap);
            if (this.isNewProcessFound(hashMap3)) {
                this.discoverPortDetails(hashMap3);
                this.discoverSystemProperties(hashMap3, hashMap);
                if (this.isNewProcessFound(hashMap3)) {
                    this.discoverServerTypes(hashMap3);
                    this.removeProcessOfExcludedPort(hashMap3, hashMap);
                    APMDiscoveryLogger.discoveryLogger.debug("{} Java Process Auto Attach is disabled, So, Saving discovery details into file for data transfer to eG manager", (Object)loggerDispStr);
                    EgDiscoveryUtils.saveToIni(EgDiscoveryUtils.constructDiscoveryDataObject(hashMap3, false));
                } else {
                    APMDiscoveryLogger.discoveryLogger.info("{} No new processes for further discovery after system property filtered by patterens ... ", (Object)loggerDispStr);
                }
            } else {
                APMDiscoveryLogger.discoveryLogger.info("{} No new processes for further discovery after command lines filtered by patterens ... ", (Object)loggerDispStr);
            }
        } else {
            APMDiscoveryLogger.discoveryLogger.info("{} No new processes... ", (Object)loggerDispStr);
        }
        ArrayList<HashMap<String, Process>> arrayList = new ArrayList<HashMap<String, Process>>();
        arrayList.add(hashMap3);
        arrayList.add(hashMap);
        return arrayList;
    }

    private HashMap<String, Process> getLiveRunningJavaProcess(DiscoveryModes discoveryModes) {
        ArrayList<DiscoveryMode> arrayList = discoveryModes.getAllModes();
        HashMap<String, Process> hashMap = new HashMap<String, Process>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string;
            EgDiscoveryHelper egDiscoveryHelper;
            ArrayList<Process> arrayList2;
            DiscoveryMode discoveryMode = arrayList.get(i);
            DiscoveryProtocol discoveryProtocol = EgDiscoveryHelper.getDiscoveryProtocol(discoveryMode);
            if (discoveryProtocol == null || (arrayList2 = (egDiscoveryHelper = new EgDiscoveryHelper(string = this.getJavaProcHandleExecCmd(), this.processPatternMatcher, discoveryProtocol)).getProcessList()) == null || arrayList2.size() <= 0) continue;
            Map<String, Process> map = this.getAsMap(arrayList2);
            hashMap.putAll(map);
        }
        return hashMap;
    }

    private void removeStoppedProcesses(JavaDiscoveryRepository javaDiscoveryRepository, HashMap<String, Process> hashMap, boolean bl) {
        try {
            if (hashMap != null) {
                Map map = javaDiscoveryRepository.getDiscoveredProcessData().getProcesses();
                Iterator iterator = ((HashMap)map).entrySet().iterator();
                if (bl) {
                    while (iterator.hasNext()) {
                        JavaProcess javaProcess = (JavaProcess)iterator.next().getValue();
                        String string = javaProcess.getPid();
                        if (hashMap.containsKey(string)) continue;
                        iterator.remove();
                        APMDiscoveryLogger.discoveryLogger.warn("{} PID {} is not alive, removing it from LIVE process : {}", new Object[]{loggerDispStr, string, javaProcess});
                    }
                } else {
                    while (iterator.hasNext()) {
                        JavaProcess javaProcess = (JavaProcess)iterator.next().getValue();
                        String string = javaProcess.getPid();
                        if (hashMap.containsKey(string)) continue;
                        iterator.remove();
                        APMDiscoveryLogger.discoveryLogger.warn("{} PID {} is not alive, removing it from BLOCKED process : {}", new Object[]{loggerDispStr, string, javaProcess});
                    }
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to verify running processes  ", (Object)loggerDispStr, (Object)exception);
        }
    }

    private void filterIncludeExcludeProcess(HashMap<String, Process> hashMap, HashMap<String, Process> hashMap2) {
        if (this.processPatternMatcher.isIncludeCmdLineAvailable()) {
            this.validateProcessBasedOnCommandLineConfigured(hashMap);
        }
        this.removeIgnoredJVMProcesses(hashMap, hashMap2);
    }

    private void validateProcessBasedOnCommandLineConfigured(HashMap<String, Process> hashMap) {
        APMDiscoveryLogger.discoveryLogger.info("{} Validate process based on configured COMMAND LINE.!!! ", (Object)loggerDispStr);
        if (hashMap != null && hashMap.size() > 0) {
            try {
                Iterator<Map.Entry<String, Process>> iterator = hashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    JavaProcess javaProcess = (JavaProcess)iterator.next().getValue();
                    String string = javaProcess.getPid();
                    String string2 = javaProcess.getCommand();
                    try {
                        if (this.processPatternMatcher.isCmdLineMatched(string2)) continue;
                        APMDiscoveryLogger.discoveryLogger.info("{} Discarding the process - {} - as the COMMAND LINE - {} - is not matched.!!!", new Object[]{loggerDispStr, string, string2});
                        iterator.remove();
                    }
                    catch (Exception exception) {
                        APMDiscoveryLogger.discoveryLogger.warn("{} Exception while matching COMMAND LINE for the process {} ", new Object[]{loggerDispStr, string, exception});
                    }
                }
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} filterNewProcessOnly() Unable to parse process details ", (Object)loggerDispStr, (Object)exception);
            }
        }
    }

    private void removeIgnoredJVMProcesses(HashMap<String, Process> hashMap, HashMap<String, Process> hashMap2) {
        APMDiscoveryLogger.discoveryLogger.trace("{} Trying to remove blocked processes ", (Object)loggerDispStr);
        if (hashMap != null && hashMap.size() > 0) {
            try {
                Iterator<Map.Entry<String, Process>> iterator = hashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    JavaProcess javaProcess = (JavaProcess)iterator.next().getValue();
                    String string = javaProcess.getPid();
                    try {
                        if (!this.processPatternMatcher.isIgnoredJvm(javaProcess)) continue;
                        APMDiscoveryLogger.discoveryLogger.trace("{} Block listed {} : {} - {}  ", new Object[]{loggerDispStr, string, javaProcess.getCommand(), javaProcess.getExecutable()});
                        javaProcess.setStatus((Object)TAG.BLOCK_LISTED);
                        iterator.remove();
                        if (javaProcess.getCommand().contains("com.eg.apm.ProcessInfo")) continue;
                        hashMap2.put(string, javaProcess);
                    }
                    catch (Exception exception) {
                        APMDiscoveryLogger.discoveryLogger.warn("{} Unable to validate pid - {} ", new Object[]{loggerDispStr, string, exception});
                    }
                }
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} filterNewProcessOnly() Unable to parse process details ", (Object)loggerDispStr, (Object)exception);
            }
        }
    }

    private HashMap<String, Process> loadPartiallyDiscovered(JavaDiscoveryRepository javaDiscoveryRepository) {
        APMDiscoveryLogger.discoveryLogger.trace("{} Trying to get partially discovered process details from existing repo", (Object)loggerDispStr);
        JavaProcessList javaProcessList = javaDiscoveryRepository.getDiscoveredProcessData();
        HashMap<String, Process> hashMap = new HashMap<String, Process>();
        if (javaProcessList != null) {
            Map map = javaProcessList.getProcesses();
            Iterator iterator = ((HashMap)map).entrySet().iterator();
            while (iterator.hasNext()) {
                String string;
                JavaProcess javaProcess = (JavaProcess)iterator.next().getValue();
                boolean bl = this.isRetry(javaProcess, string = javaProcess.getPid());
                if (!bl) continue;
                hashMap.put(string, javaProcess);
            }
        }
        return hashMap;
    }

    private boolean isRetry(JavaProcess javaProcess, String string) {
        boolean bl = false;
        try {
            if (!(javaProcess.isPortDiscovered() && javaProcess.isServerTypeDiscovered() || javaProcess.isBlockListed() || javaProcess.isMaxRetryAttemptReached())) {
                javaProcess.updateRetryAttempt();
                APMDiscoveryLogger.discoveryLogger.trace("{}  {} is a partially discovered process, Adding to retry list. {}", new Object[]{loggerDispStr, string, javaProcess});
                bl = true;
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do parse pid - {} ", new Object[]{loggerDispStr, string, exception});
        }
        return bl;
    }

    private HashMap<String, Process> blockListContaineRtProcesses(HashMap<String, Process> hashMap) {
        if (!ContainersService.getInstance().isContainerZ() || !APMUtils.isLinux()) {
            APMDiscoveryLogger.discoveryLogger.trace("{} Due to unsupported env. checking of java process which are running inside CONTAINER is skipped.!!!", (Object)loggerDispStr);
            return new HashMap<String, Process>();
        }
        APMDiscoveryLogger.discoveryLogger.trace("{} Due to Hybrid env. checking & removing of java process which are running inside CONTAINER.!!!", (Object)loggerDispStr);
        HashMap<String, Process> hashMap2 = new HashMap<String, Process>();
        try {
            if (hashMap != null && hashMap.size() > 0) {
                Iterator<Map.Entry<String, Process>> iterator = hashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    JavaProcess javaProcess = (JavaProcess)iterator.next().getValue();
                    String string = javaProcess.getPid();
                    try {
                        ContainerRunTimeProcess containerRunTimeProcess = ContainerProcessUtils.getContainerRtProcess(javaProcess);
                        if (containerRunTimeProcess == null) continue;
                        APMDiscoveryLogger.discoveryLogger.trace("{} Block listed due to CONTAINER Runtime process {} : {} - {}  ", new Object[]{loggerDispStr, string, javaProcess.getCommand(), javaProcess.getExecutable()});
                        containerRunTimeProcess.setMsg("CONTAINTER_RUN_TIME_PROCESS_FOUND");
                        containerRunTimeProcess.setStatus((Object)TAG.BLOCK_LISTED);
                        hashMap2.put(string, containerRunTimeProcess);
                        iterator.remove();
                    }
                    catch (Exception exception) {
                        APMDiscoveryLogger.discoveryLogger.warn("{} Unable to validate pid - {} ", new Object[]{loggerDispStr, string, exception});
                    }
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} blockListContaineRtProcesses() Unable to parse process details ", (Object)loggerDispStr, (Object)exception);
        }
        return hashMap2;
    }

    private HashMap<String, Process> getRecentJavaProcesses(JavaDiscoveryRepository javaDiscoveryRepository, JavaDiscoveryRepository javaDiscoveryRepository2, HashMap<String, Process> hashMap) {
        HashMap<String, Process> hashMap2 = new HashMap<String, Process>();
        try {
            APMDiscoveryLogger.discoveryLogger.trace("{} Trying to get recently started java process. !!!", (Object)loggerDispStr);
            Iterator<Map.Entry<String, Process>> iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                JavaProcess javaProcess = (JavaProcess)iterator.next().getValue();
                if (javaProcess == null) continue;
                String string = javaProcess.getPid();
                try {
                    long l = javaProcess.getUptime();
                    if (!this.isAlreadyDiscovered(javaDiscoveryRepository, string, l) && !this.isAlreadyBlockListed(javaDiscoveryRepository2, string, l)) {
                        APMDiscoveryLogger.discoveryLogger.trace("{}  {} : {} is a new process ", new Object[]{loggerDispStr, string, l});
                        hashMap2.put(string, javaProcess);
                        continue;
                    }
                    APMDiscoveryLogger.discoveryLogger.trace("{}  {} : {} Already handled,Skipping... ", new Object[]{loggerDispStr, string, l});
                }
                catch (Exception exception) {
                    APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do parse pid - {} ", new Object[]{loggerDispStr, string, exception});
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} filterNewProcessOnly() Unable to parse process details ", (Object)loggerDispStr, (Object)exception);
        }
        return hashMap2;
    }

    private void discoverCommandLineDetails(HashMap<String, Process> hashMap, HashMap<String, Process> hashMap2) {
        APMDiscoveryLogger.discoveryLogger.trace("{} Discovering COMMAND LINE details by using jcmd command.!!!", (Object)loggerDispStr);
        if (APMUtils.isWindows()) {
            this.discoveryCommandLineDetailsForWindows(hashMap);
        } else {
            this.discoverCommandLineDetailsForUnix(hashMap);
        }
        this.filterIncludeExcludeProcess(hashMap, hashMap2);
    }

    private void discoveryCommandLineDetailsForWindows(HashMap<String, Process> hashMap) {
        try {
            if (hashMap != null && hashMap.size() > 0) {
                Iterator<Map.Entry<String, Process>> iterator = hashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    JavaProcess javaProcess = (JavaProcess)iterator.next().getValue();
                    try {
                        if (javaProcess.isCmdLineDiscovered()) continue;
                        String string = JcmdUtils.getInstance().getCommandLine(javaProcess.getPid(), "");
                        if (string.length() > 1) {
                            javaProcess.setCommand(string);
                        }
                        APMDiscoveryLogger.discoveryLogger.trace("{} COMMAND LINE found for PID {} : {}", new Object[]{loggerDispStr, javaProcess.getPid(), string});
                    }
                    catch (Exception exception) {
                        APMDiscoveryLogger.discoveryLogger.warn("{} COMMAND LINE not found for PID {} due to {} ", new Object[]{loggerDispStr, javaProcess.getPid(), exception});
                    }
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while invoking COMMAND LINE details.", (Object)loggerDispStr, (Object)exception);
        }
    }

    private void discoverCommandLineDetailsForUnix(HashMap<String, Process> hashMap) {
        try {
            if (hashMap != null && hashMap.size() > 0) {
                Iterator<Map.Entry<String, Process>> iterator = hashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    JavaProcess javaProcess = (JavaProcess)iterator.next().getValue();
                    try {
                        if (javaProcess.isCmdLineDiscovered()) continue;
                        String string = javaProcess.getCommand();
                        if (string == null || string.trim().length() <= 1) {
                            String string2 = JcmdUtils.getInstance().getCommandLine(javaProcess.getPid(), "sudo");
                            if (string2.length() > 1) {
                                javaProcess.setCommand(string2);
                            }
                            APMDiscoveryLogger.discoveryLogger.trace("{} COMMAND LINE found for PID {} : {}", new Object[]{loggerDispStr, javaProcess.getPid(), string2});
                            continue;
                        }
                        javaProcess.setCommandStatus();
                    }
                    catch (Exception exception) {
                        APMDiscoveryLogger.discoveryLogger.warn("{} COMMAND LINE not found for PID {} due to {} ", new Object[]{loggerDispStr, javaProcess.getPid(), exception});
                    }
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while invoking COMMAND LINE details.", (Object)loggerDispStr, (Object)exception);
        }
    }

    private void discoverPortDetails(HashMap<String, Process> hashMap) {
        APMDiscoveryLogger.discoveryLogger.trace("{} Discovering LISTEN ports using netstat ", (Object)loggerDispStr);
        try {
            if (hashMap != null && !hashMap.isEmpty()) {
                HashMap<String, TreeSet<Integer>> hashMap2 = NetstatUtils.getListenPorts();
                APMDiscoveryLogger.discoveryLogger.trace("{} Listening ports with PID : {} ", (Object)loggerDispStr, hashMap2);
                Iterator<Map.Entry<String, Process>> iterator = hashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    JavaProcess javaProcess = (JavaProcess)iterator.next().getValue();
                    try {
                        String string;
                        TreeSet<Integer> treeSet;
                        if (javaProcess.isPortDiscovered() || javaProcess.isBlockListed() || (treeSet = hashMap2.get(string = javaProcess.getPid())) == null) continue;
                        javaProcess.setListeningPort(treeSet);
                    }
                    catch (Exception exception) {
                        APMDiscoveryLogger.discoveryLogger.warn("{} Unable to assign LISTEN port for the PID - {} ", new Object[]{loggerDispStr, javaProcess.getPid(), exception});
                    }
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while assigning LISTEN ports", (Object)loggerDispStr, (Object)exception);
        }
    }

    private void discoverSystemProperties(HashMap<String, Process> hashMap, HashMap<String, Process> hashMap2) {
        APMDiscoveryLogger.discoveryLogger.trace("{} Discovering SYSTEM.PROPERTIES by using jcmd command.!!!", (Object)loggerDispStr);
        try {
            if (hashMap != null && !hashMap.isEmpty()) {
                String string = "";
                if (!APMUtils.isWindows()) {
                    string = "sudo";
                }
                Iterator<Map.Entry<String, Process>> iterator = hashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    JavaProcess javaProcess = (JavaProcess)iterator.next().getValue();
                    try {
                        ArrayList arrayList;
                        if (javaProcess.isSystemProperyDiscovered() || javaProcess.isBlockListed() || (arrayList = JcmdUtils.getInstance().getSystemProperties(javaProcess.getPid(), string, javaProcess.getUser())) == null) continue;
                        javaProcess.setSystemProperties(arrayList);
                    }
                    catch (Exception exception) {
                        APMDiscoveryLogger.discoveryLogger.warn("{} Unable to assign SYSTEM.PROPERTIES for pid - {}", new Object[]{loggerDispStr, javaProcess.getPid(), exception});
                    }
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while assigning SYSTEM.PROPERTIES.", (Object)loggerDispStr, (Object)exception);
        }
        this.filterIncludeExcludeProcess(hashMap, hashMap2);
    }

    private void discoverServerTypes(HashMap<String, Process> hashMap) {
        APMDiscoveryLogger.discoveryLogger.trace("{} Discovering SERVER TYPES !!!", (Object)loggerDispStr);
        try {
            if (hashMap != null && !hashMap.isEmpty()) {
                Iterator<Map.Entry<String, Process>> iterator = hashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    JavaProcess javaProcess = (JavaProcess)iterator.next().getValue();
                    try {
                        if (javaProcess.isServerTypeDiscovered() || javaProcess.isBlockListed()) continue;
                        String string = this.serverTypePatterenMatcher.getComponentType(javaProcess.getCommand(), javaProcess);
                        if (string != null && string.length() > 0 && !string.equalsIgnoreCase("none")) {
                            javaProcess.setServerType(string);
                            javaProcess.setServerTypeStatus(TAG.SERVER_TYPE_FOUND_IN_CMDLINE);
                            continue;
                        }
                        string = this.serverTypePatterenMatcher.getComponentTypeFromExecutable(javaProcess.getExecutable(), javaProcess);
                        if (string != null && string.length() > 0 && !string.equalsIgnoreCase("none")) {
                            javaProcess.setServerType(string);
                            javaProcess.setServerTypeStatus(TAG.SERVER_TYPE_FOUND_IN_EXECUTABLE);
                            continue;
                        }
                        string = this.serverTypePatterenMatcher.getComponentTypeFromSystemProperty(javaProcess.getSystemPropertiesAsString(), javaProcess);
                        if (string == null || string.length() <= 0 || string.equalsIgnoreCase("none")) continue;
                        javaProcess.setServerType(string);
                        javaProcess.setServerTypeStatus(TAG.SERVER_TYPE_FOUND_IN_SYSTEM_PROPERTIES);
                    }
                    catch (Exception exception) {
                        APMDiscoveryLogger.discoveryLogger.warn("{} Unable to assign SERVER TYPE for pid - {}", new Object[]{loggerDispStr, javaProcess.getPid(), exception});
                    }
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while assigning SERVER TYPE", (Object)loggerDispStr, (Object)exception);
        }
    }

    private Map<String, Process> getAsMap(ArrayList<Process> arrayList) {
        HashMap<String, Process> hashMap = new HashMap<String, Process>();
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Process process = arrayList.get(i);
                String string = process.getPid();
                try {
                    hashMap.put(string, process);
                    continue;
                }
                catch (Exception exception) {
                    APMDiscoveryLogger.discoveryLogger.warn("{} Unable to store data to repo  - {} ", new Object[]{loggerDispStr, string, exception});
                }
            }
        }
        APMDiscoveryLogger.discoveryLogger.trace("{} javaProcessList  - {} ", (Object)loggerDispStr, hashMap);
        return hashMap;
    }

    private boolean isAlreadyDiscovered(JavaDiscoveryRepository javaDiscoveryRepository, String string, long l) {
        if (javaDiscoveryRepository != null) {
            return javaDiscoveryRepository.getDiscoveredProcessData().isAlreadyDiscovered(string, l);
        }
        return false;
    }

    private boolean isAlreadyBlockListed(JavaDiscoveryRepository javaDiscoveryRepository, String string, long l) {
        if (javaDiscoveryRepository != null) {
            return javaDiscoveryRepository.getDiscoveredProcessData().isAlreadyDiscovered(string, l);
        }
        return false;
    }

    private boolean isNewProcessFound(HashMap<String, Process> hashMap) {
        int n;
        return hashMap != null && (n = hashMap.size()) > 0;
    }

    private void removeProcessOfExcludedPort(HashMap<String, Process> hashMap, HashMap<String, Process> hashMap2) {
        APMDiscoveryLogger.discoveryLogger.trace("{} Trying to remove processes which has blocked ports[port available in excluded port range]", (Object)loggerDispStr);
        if (hashMap != null && hashMap.size() > 0) {
            try {
                Iterator<Map.Entry<String, Process>> iterator = hashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    JavaProcess javaProcess = (JavaProcess)iterator.next().getValue();
                    String string = javaProcess.getPid();
                    javaProcess.getPort();
                    try {
                        if (!javaProcess.isExcludedPortFound()) continue;
                        APMDiscoveryLogger.discoveryLogger.trace("{} Block listed {} : {} - {}  ", new Object[]{loggerDispStr, string, javaProcess.getCommand(), javaProcess.getExecutable()});
                        javaProcess.setStatus((Object)TAG.BLOCK_LISTED);
                        iterator.remove();
                        hashMap2.put(string, javaProcess);
                    }
                    catch (Exception exception) {
                        APMDiscoveryLogger.discoveryLogger.warn("{} Unable to validate pid - {} ", new Object[]{loggerDispStr, string, exception});
                    }
                }
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} filterNewProcessOnly() Unable to parse process details ", (Object)loggerDispStr, (Object)exception);
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" JavaProcessDiscoveryHelper={");
        stringBuilder.append("OS=").append((Object)ApmConfigManager.getInstance().getOsType());
        stringBuilder.append(", Java=").append(ApmConfigManager.getInstance().getJavaInfo());
        stringBuilder.append(", ").append(this.serverTypePatterenMatcher);
        stringBuilder.append(", ").append(this.processPatternMatcher);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

